/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.xml;

import io.ballerina.lib.data.xmldata.io.BallerinaByteBlockInputStream;
import io.ballerina.lib.data.xmldata.utils.DataReader;
import io.ballerina.lib.data.xmldata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.xmldata.utils.DiagnosticLog;
import io.ballerina.lib.data.xmldata.xml.XSDValidator;
import io.ballerina.lib.data.xmldata.xml.XmlParser;
import io.ballerina.lib.data.xmldata.xml.XmlTraversal;
import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import java.io.ByteArrayInputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;

public class Native {
    public static Object parseAsType(BXml xml, BMap<BString, Object> options, BTypedesc typed) {
        try {
            return XmlTraversal.traverse(xml, options, typed);
        }
        catch (Exception e) {
            return DiagnosticLog.createXmlError(e.getMessage());
        }
    }

    public static Object parseString(BString xml, BMap<BString, Object> options, BTypedesc typed) {
        try {
            return XmlParser.parse((Reader)new StringReader(xml.getValue()), options, typed);
        }
        catch (Exception e) {
            return DiagnosticLog.error(DiagnosticErrorCode.XML_PARSE_ERROR, e.getMessage());
        }
    }

    public static Object parseBytes(BArray xml, BMap<BString, Object> options, BTypedesc typed) {
        try {
            return XmlParser.parse((Reader)new InputStreamReader(new ByteArrayInputStream(xml.getBytes())), options, typed);
        }
        catch (Exception e) {
            return DiagnosticLog.error(DiagnosticErrorCode.XML_PARSE_ERROR, e.getMessage());
        }
    }

    public static Object parseStream(Environment env, BStream xml, BMap<BString, Object> options, BTypedesc typed) {
        try {
            BObject iteratorObj = xml.getIteratorObj();
            BallerinaByteBlockInputStream byteBlockSteam = new BallerinaByteBlockInputStream(env, iteratorObj, DataReader.resolveNextMethod(iteratorObj), DataReader.resolveCloseMethod(iteratorObj));
            Object result = XmlParser.parse((Reader)new InputStreamReader(byteBlockSteam), options, typed);
            if (byteBlockSteam.getError() != null) {
                return byteBlockSteam.getError();
            }
            return result;
        }
        catch (Exception e) {
            return DiagnosticLog.error(DiagnosticErrorCode.XML_PARSE_ERROR, e.getMessage());
        }
    }

    public static Object validate(BXml xml, Object xsd) {
        try {
            return XSDValidator.validate(xml, xsd);
        }
        catch (Exception e) {
            return DiagnosticLog.error(DiagnosticErrorCode.INVALID_XML, e.getMessage());
        }
    }
}

