/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.xml;

import io.ballerina.lib.data.xmldata.utils.Constants;
import io.ballerina.lib.data.xmldata.utils.DataUtils;
import io.ballerina.lib.data.xmldata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.xmldata.utils.DiagnosticLog;
import io.ballerina.lib.data.xmldata.utils.XsdUtils;
import io.ballerina.lib.data.xmldata.xml.QualifiedName;
import io.ballerina.lib.data.xmldata.xml.QualifiedNameFactory;
import io.ballerina.lib.data.xmldata.xml.QualifiedNameMap;
import io.ballerina.lib.data.xmldata.xml.xsd.ModelGroupInfo;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MapType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.TypeTags;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.types.XmlNodeType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.runtime.api.values.BXml;
import io.ballerina.runtime.api.values.BXmlItem;
import io.ballerina.runtime.api.values.BXmlSequence;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.namespace.QName;
import org.ballerinalang.langlib.xml.Concat;

public class XmlTraversal {
    private static final ThreadLocal<XmlTree> tlXmlTree = ThreadLocal.withInitial(XmlTree::new);

    public static Object traverse(BXml xml, BMap<BString, Object> options, BTypedesc typed) {
        Object convertedValue = XmlTraversal.traverse(xml, options, typed.getDescribingType());
        if (convertedValue instanceof BError) {
            return convertedValue;
        }
        return DataUtils.validateConstraints(convertedValue, typed, (Boolean)options.get((Object)Constants.ENABLE_CONSTRAINT_VALIDATION));
    }

    public static Object traverse(BXml xml, BMap<BString, Object> options, Type type) {
        XmlTree xmlTree = tlXmlTree.get();
        return xmlTree.traverseXml(xml, options, type);
    }

    static class XmlTree {
        XmlTree() {
        }

        public Object traverseXml(BXml xml, BMap<BString, Object> options, Type type) {
            DataUtils.XmlAnalyzerData analyzerData = new DataUtils.XmlAnalyzerData();
            DataUtils.updateOptions(options, analyzerData);
            this.traverseXml(xml, analyzerData, type);
            XsdUtils.validateElementInfoStack(analyzerData);
            XsdUtils.validateModelGroupInfoStack(analyzerData);
            return analyzerData.currentNode;
        }

        public Object traverseXml(BXml xml, DataUtils.XmlAnalyzerData analyzerData, Type type) {
            Type referredType = TypeUtils.getReferredType((Type)type);
            switch (referredType.getTag()) {
                case 24: {
                    return this.traverseXmlWithRecordAsExpectedType(xml, analyzerData, (RecordType)referredType);
                }
                case 27: {
                    return this.traverseXmlWithMapAsExpectedType(xml, (MapType)referredType, analyzerData);
                }
                case 33: {
                    return this.traverseXmlToUnion(xml, analyzerData, (UnionType)referredType);
                }
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, "record or map", type);
        }

        private Object traverseXmlWithRecordAsExpectedType(BXml xml, DataUtils.XmlAnalyzerData analyzerData, RecordType recordType) {
            analyzerData.currentNode = recordType.getPackage() == null ? ValueCreator.createRecordValue((RecordType)recordType) : ValueCreator.createRecordValue((Module)recordType.getPackage(), (String)recordType.getName());
            BXml nextXml = this.validateRootElement(xml, recordType, analyzerData);
            Object resultRecordValue = this.traverseXml(nextXml, (Type)recordType, analyzerData);
            this.validateModelGroupStackForRootElement(analyzerData);
            XsdUtils.validateCurrentElementInfo(analyzerData);
            DataUtils.validateRequiredFields(analyzerData, (BMap<BString, Object>)analyzerData.currentNode);
            return resultRecordValue;
        }

        private Object traverseXmlWithMapAsExpectedType(BXml xml, MapType mapType, DataUtils.XmlAnalyzerData analyzerData) {
            RecordType anonRecType = TypeCreator.createRecordType((String)"$anonType$", (Module)mapType.getPackage(), (long)0L, new HashMap(), (Type)mapType.getConstrainedType(), (boolean)false, (int)0);
            return this.traverseXml(xml, analyzerData, (Type)anonRecType);
        }

        private Object traverseXmlToUnion(BXml xml, DataUtils.XmlAnalyzerData options, UnionType unionType) {
            DataUtils.XmlAnalyzerData clonedAnalyzerData = DataUtils.XmlAnalyzerData.copy(options);
            for (Type memberType : unionType.getMemberTypes()) {
                memberType = TypeUtils.getReferredType((Type)memberType);
                try {
                    if (memberType.getTag() == 42) continue;
                    return this.traverseXml(xml, options, memberType);
                }
                catch (Exception ex) {
                    options.resetFrom(clonedAnalyzerData);
                }
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.CANNOT_CONVERT_SOURCE_INTO_EXP_TYPE, unionType);
        }

        private Object traverseXml(BXml xml, Type type, DataUtils.XmlAnalyzerData analyzerData) {
            switch (xml.getNodeType()) {
                case ELEMENT: {
                    if (!DataUtils.isXMLArrayType(type) && !TypeTags.isXMLTypeTag((int)type.getTag())) {
                        this.convertElement((BXmlItem)xml, analyzerData);
                        break;
                    }
                    this.convertXml(xml, type.getTag(), analyzerData);
                    break;
                }
                case SEQUENCE: {
                    this.convertSequence((BXmlSequence)xml, type, analyzerData);
                    break;
                }
                case TEXT: {
                    this.convertXml(xml, 5, analyzerData);
                }
            }
            return analyzerData.currentNode;
        }

        private void convertXml(BXml xml, int typeTag, DataUtils.XmlAnalyzerData analyzerData) {
            Field currentField = analyzerData.currentField;
            BMap mapValue = analyzerData.currentNode;
            boolean isText = typeTag == 5;
            String textFieldName = analyzerData.textFieldName;
            if (currentField == null) {
                QualifiedName contentQName = QualifiedNameFactory.createQualifiedName("", textFieldName, "", analyzerData.useSemanticEquality);
                if (((QualifiedNameMap)analyzerData.fieldHierarchy.peek()).contains(contentQName)) {
                    currentField = (Field)((QualifiedNameMap)analyzerData.fieldHierarchy.peek()).remove(contentQName);
                } else if (((QualifiedNameMap)analyzerData.visitedFieldHierarchy.peek()).contains(contentQName)) {
                    currentField = (Field)((QualifiedNameMap)analyzerData.visitedFieldHierarchy.peek()).get(contentQName);
                } else if (analyzerData.restTypes.peek() != null) {
                    currentField = TypeCreator.createField((Type)((Type)analyzerData.restTypes.peek()), (String)analyzerData.textFieldName, (long)256L);
                } else {
                    if (!analyzerData.allowDataProjection) {
                        throw DiagnosticLog.error(DiagnosticErrorCode.UNDEFINED_FIELD, textFieldName, analyzerData.rootRecord);
                    }
                    return;
                }
            }
            Type fieldType = currentField.getFieldType();
            Object convertedValue = null;
            if (DataUtils.isRegExpType(fieldType)) {
                throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, new Object[0]);
            }
            fieldType = TypeUtils.getReferredType((Type)fieldType);
            BString fieldName = StringUtils.fromString((String)currentField.getFieldName());
            Object value = mapValue.get((Object)fieldName);
            if (fieldType.getTag() == 33) {
                DataUtils.XmlAnalyzerData clonedAnalyzerData = DataUtils.XmlAnalyzerData.copy(analyzerData);
                for (Type memberType : ((UnionType)fieldType).getMemberTypes()) {
                    try {
                        if (!(value instanceof BArray) && memberType.getTag() == 32) continue;
                        convertedValue = isText ? DataUtils.convertStringToExpType(StringUtils.fromString((String)xml.toString()), memberType) : xml.copy(new HashMap());
                        fieldType = memberType;
                        break;
                    }
                    catch (Exception ex) {
                        analyzerData.resetFrom(clonedAnalyzerData);
                    }
                }
                if (convertedValue == null) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.FIELD_CANNOT_CAST_INTO_TYPE, fieldName, fieldType);
                }
            } else {
                Object object = convertedValue = isText ? DataUtils.convertStringToExpType(StringUtils.fromString((String)xml.toString()), fieldType) : xml.copy(new HashMap());
            }
            if (value instanceof BArray) {
                if (fieldName.getValue().equals(textFieldName)) {
                    mapValue.put((Object)fieldName, convertedValue);
                    return;
                }
                if (DataUtils.isAnydataOrJson(fieldType.getTag())) {
                    ((BArray)value).append(convertedValue);
                    return;
                }
                ArrayType arrayType = (ArrayType)fieldType;
                Type elementType = TypeUtils.getReferredType((Type)arrayType.getElementType());
                int currentIndex = (Integer)((HashMap)analyzerData.arrayIndexes.peek()).get(fieldName.getValue());
                if (arrayType.getState() == ArrayType.ArrayState.CLOSED && arrayType.getSize() <= currentIndex) {
                    DataUtils.logArrayMismatchErrorIfProjectionNotAllowed(analyzerData.allowDataProjection);
                    return;
                }
                if (elementType.getTag() == 21 && xml.getType().getTag() == 18) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.CANNOT_CONVERT_TO_EXPECTED_TYPE, PredefinedTypes.TYPE_XML_TEXT_SEQUENCE.getName(), xml, fieldType);
                }
                ((BArray)value).add((long)currentIndex, convertedValue);
            } else {
                if (fieldType.getTag() == 32) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.CANNOT_CONVERT_TO_EXPECTED_TYPE, PredefinedTypes.TYPE_STRING.getName(), xml, fieldType);
                }
                mapValue.put((Object)fieldName, convertedValue);
            }
        }

        private void convertElement(BXmlItem xmlItem, DataUtils.XmlAnalyzerData analyzerData) {
            Field currentField;
            QualifiedName elementQName = DataUtils.getElementName(xmlItem.getQName(), analyzerData.useSemanticEquality);
            XsdUtils.updateElementOccurrence(analyzerData, elementQName);
            XsdUtils.validateModelGroupStack(analyzerData, elementQName, true);
            QualifiedNameMap fieldsMap = (QualifiedNameMap)analyzerData.fieldHierarchy.peek();
            if (((QualifiedNameMap)analyzerData.visitedFieldHierarchy.peek()).contains(elementQName)) {
                currentField = (Field)((QualifiedNameMap)analyzerData.visitedFieldHierarchy.peek()).get(elementQName);
                Type fieldType = TypeUtils.getReferredType((Type)currentField.getFieldType());
                String fieldName = currentField.getFieldName();
                if (!analyzerData.modelGroupStack.isEmpty()) {
                    ModelGroupInfo modelGroup = (ModelGroupInfo)analyzerData.modelGroupStack.peek();
                    if (fieldType.getTag() != 32 && modelGroup == null) {
                        throw DiagnosticLog.error(DiagnosticErrorCode.FOUND_ARRAY_FOR_NON_ARRAY_TYPE, fieldType, fieldName);
                    }
                } else if (!DataUtils.isArrayValueAssignable(fieldType)) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.FOUND_ARRAY_FOR_NON_ARRAY_TYPE, fieldType, fieldName);
                }
            } else {
                currentField = (Field)fieldsMap.get(elementQName);
                if (currentField != null && TypeUtils.getReferredType((Type)currentField.getFieldType()).getTag() != 32) {
                    fieldsMap.remove(elementQName);
                }
            }
            analyzerData.currentField = currentField;
            if (currentField == null) {
                HashMap modelGroupInfo = null;
                if (!analyzerData.xsdModelGroupInfo.isEmpty()) {
                    modelGroupInfo = (HashMap)analyzerData.xsdModelGroupInfo.peek();
                }
                if (modelGroupInfo != null && !modelGroupInfo.isEmpty()) {
                    this.validateElementInXsdSequenceOrElement(elementQName, modelGroupInfo, xmlItem, analyzerData, (QualifiedNameMap)analyzerData.visitedFieldHierarchy.peek(), fieldsMap);
                    return;
                }
                Type restType = (Type)analyzerData.restTypes.peek();
                String elementName = elementQName.getLocalPart();
                if (restType != null) {
                    if (fieldsMap.contains(elementName)) {
                        throw DiagnosticLog.error(DiagnosticErrorCode.UNDEFINED_FIELD, elementName, analyzerData.rootRecord);
                    }
                    this.convertToRestType(xmlItem, restType, analyzerData);
                } else if (!analyzerData.allowDataProjection) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.UNDEFINED_FIELD, elementName, analyzerData.rootRecord);
                }
                return;
            }
            ((QualifiedNameMap)analyzerData.visitedFieldHierarchy.peek()).put(elementQName, currentField);
            Type currentFieldType = currentField.getFieldType();
            if (!DataUtils.isSupportedType(currentFieldType)) {
                throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, currentFieldType);
            }
            if (DataUtils.isRegExpType(currentFieldType)) {
                throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, new Object[0]);
            }
            this.convertToFieldType(xmlItem, currentField, currentField.getFieldName(), currentFieldType, (BMap<BString, Object>)analyzerData.currentNode, analyzerData);
            XsdUtils.validateModelGroupStack(analyzerData, elementQName, false);
        }

        private void convertToFieldType(BXmlItem xmlItem, Field currentField, String fieldName, Type currentFieldType, BMap<BString, Object> mapValue, DataUtils.XmlAnalyzerData analyzerData) {
            switch (currentFieldType.getTag()) {
                case 24: {
                    this.convertToRecordType(xmlItem, currentFieldType, fieldName, (RecordType)currentFieldType, mapValue, analyzerData);
                    break;
                }
                case 32: {
                    this.convertToArrayType(xmlItem, currentField, mapValue, StringUtils.fromString((String)fieldName), (ArrayType)currentFieldType, analyzerData);
                    break;
                }
                case 27: {
                    this.convertToMapType(xmlItem, currentFieldType, currentFieldType, fieldName, mapValue, analyzerData);
                    break;
                }
                case 15: 
                case 23: {
                    this.updateNextMap(currentFieldType, analyzerData);
                    analyzerData.arrayIndexes.push(new HashMap());
                    this.convertToRestType(xmlItem, currentFieldType, analyzerData);
                    XsdUtils.validateCurrentElementInfo(analyzerData);
                    DataUtils.popExpectedTypeStacks(analyzerData);
                    break;
                }
                case 53: {
                    this.convertToFieldType(xmlItem, currentField, fieldName, TypeUtils.getReferredType((Type)currentFieldType), mapValue, analyzerData);
                    break;
                }
                case 33: {
                    this.convertFieldTypeToUnion(xmlItem, currentField, fieldName, currentFieldType, mapValue, analyzerData);
                    break;
                }
                default: {
                    if (TypeTags.isXMLTypeTag((int)currentFieldType.getTag())) {
                        this.traverseXml((BXml)xmlItem, currentFieldType, analyzerData);
                        break;
                    }
                    this.traverseXml((BXml)xmlItem.getChildrenSeq(), currentFieldType, analyzerData);
                }
            }
        }

        private void convertFieldTypeToUnion(BXmlItem xmlItem, Field currentField, String fieldName, Type currentFieldType, BMap<BString, Object> mapValue, DataUtils.XmlAnalyzerData analyzerData) {
            DataUtils.XmlAnalyzerData clonedAnalyzerData = DataUtils.XmlAnalyzerData.copy(analyzerData);
            for (Type memberType : ((UnionType)currentFieldType).getMemberTypes()) {
                memberType = TypeUtils.getReferredType((Type)memberType);
                try {
                    if (memberType.getTag() == 42) continue;
                    this.convertToFieldType(xmlItem, currentField, fieldName, memberType, mapValue, analyzerData);
                    return;
                }
                catch (Exception ex) {
                    analyzerData.resetFrom(clonedAnalyzerData);
                    mapValue.put((Object)StringUtils.fromString((String)fieldName), null);
                }
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.FIELD_CANNOT_CAST_INTO_TYPE, fieldName, currentFieldType);
        }

        private void convertToArrayType(BXmlItem xmlItem, Field field, BMap<BString, Object> mapValue, BString bCurrentFieldName, ArrayType arrayType, DataUtils.XmlAnalyzerData analyzerData) {
            Object temp = mapValue.get((Object)bCurrentFieldName);
            Type elementType = arrayType.getElementType();
            if (DataUtils.isRegExpType(elementType)) {
                throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, new Object[0]);
            }
            String fieldName = field.getFieldName();
            int referredElementTypeTag = TypeUtils.getReferredType((Type)elementType).getTag();
            if (referredElementTypeTag == 15 || referredElementTypeTag == 23) {
                this.convertToRestType(xmlItem, (Type)arrayType, analyzerData);
                return;
            }
            if (temp == null) {
                ((HashMap)analyzerData.arrayIndexes.peek()).put(fieldName, 0);
                mapValue.put((Object)bCurrentFieldName, (Object)DataUtils.createArrayValue((Type)arrayType));
            } else {
                HashMap indexes = (HashMap)analyzerData.arrayIndexes.peek();
                indexes.put(fieldName, (Integer)indexes.get(fieldName) + 1);
            }
            this.convertToArrayMemberType(xmlItem, fieldName, arrayType, elementType, mapValue, analyzerData);
        }

        private void convertToArrayMemberType(BXmlItem xmlItem, String fieldName, ArrayType fieldType, Type elementType, BMap<BString, Object> mapValue, DataUtils.XmlAnalyzerData analyzerData) {
            switch (elementType.getTag()) {
                case 24: {
                    this.convertToRecordType(xmlItem, (Type)fieldType, fieldName, (RecordType)elementType, mapValue, analyzerData);
                    break;
                }
                case 27: {
                    this.convertToMapType(xmlItem, (Type)fieldType, elementType, fieldName, mapValue, analyzerData);
                    break;
                }
                case 53: {
                    this.convertToArrayMemberType(xmlItem, fieldName, fieldType, TypeUtils.getReferredType((Type)elementType), mapValue, analyzerData);
                    break;
                }
                case 33: {
                    this.convertToUnionMemberType(xmlItem, fieldName, fieldType, elementType, mapValue, analyzerData);
                    break;
                }
                case 16: 
                case 18: 
                case 21: {
                    this.traverseXml((BXml)xmlItem, (Type)fieldType, analyzerData);
                    break;
                }
                default: {
                    this.traverseXml((BXml)xmlItem.getChildrenSeq(), (Type)fieldType, analyzerData);
                }
            }
        }

        private void convertToUnionMemberType(BXmlItem xmlItem, String fieldName, ArrayType fieldType, Type elementType, BMap<BString, Object> mapValue, DataUtils.XmlAnalyzerData analyzerData) {
            DataUtils.XmlAnalyzerData clonedAnalyzerData = DataUtils.XmlAnalyzerData.copy(analyzerData);
            for (Type memberType : ((UnionType)elementType).getMemberTypes()) {
                if ((memberType = TypeUtils.getReferredType((Type)memberType)).getTag() == 42) continue;
                try {
                    this.convertToArrayMemberType(xmlItem, fieldName, fieldType, memberType, mapValue, analyzerData);
                    return;
                }
                catch (Exception ex) {
                    analyzerData.resetFrom(clonedAnalyzerData);
                }
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.FIELD_CANNOT_CAST_INTO_TYPE, fieldName, fieldType);
        }

        private void convertToRecordType(BXmlItem xmlItem, Type currentFieldType, String fieldName, RecordType elementType, BMap<BString, Object> mapValue, DataUtils.XmlAnalyzerData analyzerData) {
            analyzerData.currentNode = this.updateNextRecord(xmlItem, elementType, fieldName, currentFieldType, mapValue, analyzerData);
            RecordType prevRecord = analyzerData.rootRecord;
            analyzerData.rootRecord = elementType;
            this.traverseXml((BXml)xmlItem.getChildrenSeq(), currentFieldType, analyzerData);
            XsdUtils.validateCurrentElementInfo(analyzerData);
            DataUtils.validateRequiredFields(analyzerData, (BMap<BString, Object>)analyzerData.currentNode);
            DataUtils.popExpectedTypeStacks(analyzerData);
            analyzerData.rootRecord = prevRecord;
            analyzerData.currentNode = (BMap)analyzerData.nodesStack.pop();
        }

        private void convertToMapType(BXmlItem xmlItem, Type fieldType, Type elementType, String fieldName, BMap<BString, Object> mapValue, DataUtils.XmlAnalyzerData analyzerData) {
            this.updateNextMap(elementType, analyzerData);
            analyzerData.currentNode = this.updateNextMappingValue(elementType, fieldName, fieldType, mapValue, analyzerData);
            this.traverseXml((BXml)xmlItem.getChildrenSeq(), fieldType, analyzerData);
            XsdUtils.validateCurrentElementInfo(analyzerData);
            DataUtils.validateRequiredFields(analyzerData, (BMap<BString, Object>)analyzerData.currentNode);
            DataUtils.popExpectedTypeStacks(analyzerData);
            analyzerData.currentNode = (BMap)analyzerData.nodesStack.pop();
        }

        private void updateNextMap(Type fieldType, DataUtils.XmlAnalyzerData analyzerData) {
            if (fieldType.getTag() == 27) {
                analyzerData.restTypes.push(((MapType)fieldType).getConstrainedType());
            } else {
                analyzerData.restTypes.push(fieldType);
            }
            analyzerData.fieldHierarchy.push(new QualifiedNameMap(new HashMap()));
            analyzerData.visitedFieldHierarchy.push(new QualifiedNameMap(new HashMap()));
            analyzerData.attributeHierarchy.push(new QualifiedNameMap(new HashMap()));
            analyzerData.xsdModelGroupInfo.push(new HashMap());
            analyzerData.xmlElementInfo.push(new HashMap());
        }

        private BMap<BString, Object> updateNextRecord(BXmlItem xmlItem, RecordType recordType, String fieldName, Type fieldType, BMap<BString, Object> currentMapValue, DataUtils.XmlAnalyzerData analyzerData) {
            DataUtils.updateExpectedTypeStacks(recordType, analyzerData);
            XsdUtils.initializeXsdInformation(recordType, analyzerData);
            BMap<BString, Object> nextValue = this.updateNextMappingValue((Type)recordType, fieldName, fieldType, currentMapValue, analyzerData);
            QName qName = xmlItem.getQName();
            DataUtils.validateTypeNamespaceForNextRecord(qName.getPrefix(), qName.getNamespaceURI(), recordType, analyzerData.rootRecord, fieldName);
            this.handleAttributes(xmlItem, nextValue, analyzerData);
            return nextValue;
        }

        private BMap<BString, Object> updateNextMappingValue(Type type, String fieldName, Type fieldType, BMap<BString, Object> currentMapValue, DataUtils.XmlAnalyzerData analyzerData) {
            analyzerData.currentField = null;
            BMap nextValue = switch (type.getTag()) {
                case 24 -> {
                    RecordType recordType = (RecordType)type;
                    yield ValueCreator.createRecordValue((Module)recordType.getPackage(), (String)recordType.getName());
                }
                case 27 -> ValueCreator.createMapValue((MapType)((MapType)type));
                case 15, 23 -> ValueCreator.createMapValue((MapType)TypeCreator.createMapType((Type)type));
                default -> throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, type);
            };
            Object temp = currentMapValue.get((Object)StringUtils.fromString((String)fieldName));
            if (temp instanceof BArray) {
                BArray tempArray = (BArray)temp;
                ArrayType arrayType = (ArrayType)fieldType;
                int currentIndex = (Integer)((HashMap)analyzerData.arrayIndexes.peek()).get(fieldName);
                if (arrayType.getState() == ArrayType.ArrayState.OPEN || currentIndex < arrayType.getSize()) {
                    tempArray.add((long)currentIndex, (Object)nextValue);
                } else {
                    DataUtils.logArrayMismatchErrorIfProjectionNotAllowed(analyzerData.allowDataProjection);
                }
            } else {
                currentMapValue.put((Object)StringUtils.fromString((String)fieldName), (Object)nextValue);
            }
            analyzerData.nodesStack.push(currentMapValue);
            analyzerData.arrayIndexes.push(new HashMap());
            return nextValue;
        }

        private void convertToRestType(BXmlItem xmlItem, Type restType, DataUtils.XmlAnalyzerData analyzerData) {
            String elemName = xmlItem.getQName().getLocalPart();
            analyzerData.currentField = TypeCreator.createField((Type)restType, (String)elemName, (long)1L);
            BMap mapValue = analyzerData.currentNode;
            this.checkRestTypeAndConvert(xmlItem, elemName, restType, restType, (BMap<BString, Object>)mapValue, analyzerData);
        }

        private void checkRestTypeAndConvert(BXmlItem xmlItem, String elemName, Type restType, Type elementType, BMap<BString, Object> mapValue, DataUtils.XmlAnalyzerData analyzerData) {
            switch (elementType.getTag()) {
                case 24: {
                    this.convertToRecordType(xmlItem, restType, elemName, (RecordType)elementType, mapValue, analyzerData);
                    break;
                }
                case 32: {
                    HashMap indexes = (HashMap)analyzerData.arrayIndexes.peek();
                    if (!indexes.containsKey(elemName)) {
                        indexes.put(elemName, 0);
                        mapValue.put((Object)StringUtils.fromString((String)elemName), (Object)DataUtils.createArrayValue(restType));
                    } else {
                        indexes.put(elemName, (Integer)indexes.get(elemName) + 1);
                    }
                    this.checkRestTypeAndConvert(xmlItem, elemName, restType, ((ArrayType)restType).getElementType(), mapValue, analyzerData);
                    break;
                }
                case 33: {
                    this.checkRestTypeAndConvertForUnionTypes(xmlItem, elemName, restType, elementType, mapValue, analyzerData);
                    break;
                }
                default: {
                    BString bElementName = StringUtils.fromString((String)elemName);
                    if (mapValue.containsKey((Object)bElementName) && mapValue.get((Object)bElementName) != null) {
                        this.handleArrayValueForRestType(xmlItem, elemName, restType, mapValue, analyzerData);
                        return;
                    }
                    if (this.isNextElementContent(xmlItem)) {
                        this.convertContentToRestType(xmlItem, bElementName, restType, mapValue, analyzerData);
                        return;
                    }
                    if (restType.getTag() != 23 && restType.getTag() != 15) {
                        throw DiagnosticLog.error(DiagnosticErrorCode.EXPECTED_ANYDATA_OR_JSON, new Object[0]);
                    }
                    this.convertToJsonOrAnydataAsRestType(xmlItem, bElementName, restType, mapValue, analyzerData);
                }
            }
        }

        private void checkRestTypeAndConvertForUnionTypes(BXmlItem xmlItem, String elemName, Type restType, Type elementType, BMap<BString, Object> mapValue, DataUtils.XmlAnalyzerData analyzerData) {
            boolean isRestTypeUnion = restType.getTag() == 33;
            DataUtils.XmlAnalyzerData clonedAnalyzerData = DataUtils.XmlAnalyzerData.copy(analyzerData);
            for (Type memberType : ((UnionType)elementType).getMemberTypes()) {
                if ((memberType = TypeUtils.getReferredType((Type)memberType)).getTag() == 42) continue;
                try {
                    this.checkRestTypeAndConvert(xmlItem, elemName, isRestTypeUnion ? memberType : restType, memberType, mapValue, analyzerData);
                    return;
                }
                catch (Exception ex) {
                    analyzerData.resetFrom(clonedAnalyzerData);
                    if (restType.getTag() == 32) continue;
                    mapValue.put((Object)StringUtils.fromString((String)elemName), null);
                }
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.FIELD_CANNOT_CAST_INTO_TYPE, elemName, elementType);
        }

        private void handleArrayValueForRestType(BXmlItem xmlItem, String elemName, Type restType, BMap<BString, Object> mapValue, DataUtils.XmlAnalyzerData analyzerData) {
            BArray arrayValue;
            BString bElementName = StringUtils.fromString((String)elemName);
            Object currentElement = mapValue.get((Object)bElementName);
            boolean useSemanticEquality = analyzerData.useSemanticEquality;
            if (!(currentElement instanceof BArray)) {
                if (!DataUtils.isArrayValueAssignable(restType)) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.FOUND_ARRAY_FOR_NON_ARRAY_TYPE, restType, elemName);
                }
                arrayValue = DataUtils.createArrayValue(restType);
                arrayValue.append(currentElement);
                mapValue.put((Object)bElementName, (Object)arrayValue);
            } else {
                arrayValue = (BArray)currentElement;
            }
            if (this.isNextElementContent(xmlItem)) {
                if (this.isElementHasAttributes(xmlItem)) {
                    BMap nextValue = ValueCreator.createMapValue((MapType)DataUtils.getMapTypeFromConstraintType(restType));
                    this.handleAttributesRest(xmlItem, (BMap<BString, Object>)nextValue, restType, useSemanticEquality);
                    if (!nextValue.isEmpty()) {
                        arrayValue.append((Object)nextValue);
                        analyzerData.currentField = TypeCreator.createField((Type)restType, (String)analyzerData.textFieldName, (long)256L);
                        analyzerData.nodesStack.push(analyzerData.currentNode);
                        analyzerData.currentNode = nextValue;
                        this.traverseXml((BXml)xmlItem.getChildrenSeq(), restType, analyzerData);
                        analyzerData.currentNode = (BMap)analyzerData.nodesStack.pop();
                        return;
                    }
                }
                this.traverseXml((BXml)xmlItem.getChildrenSeq(), restType, analyzerData);
                return;
            }
            BMap nextValue = ValueCreator.createMapValue((MapType)DataUtils.getMapTypeFromConstraintType(restType));
            if (DataUtils.isAnydataOrJson(restType.getTag())) {
                arrayValue.append((Object)nextValue);
            } else {
                ArrayType arrayType = (ArrayType)restType;
                int currentIndex = (Integer)((HashMap)analyzerData.arrayIndexes.peek()).get(elemName);
                if (arrayType.getState() == ArrayType.ArrayState.CLOSED && arrayType.getSize() <= currentIndex) {
                    DataUtils.logArrayMismatchErrorIfProjectionNotAllowed(analyzerData.allowDataProjection);
                } else {
                    arrayValue.add((long)currentIndex, (Object)nextValue);
                }
            }
            analyzerData.nodesStack.push(analyzerData.currentNode);
            analyzerData.currentNode = nextValue;
            this.handleAttributesRest(xmlItem, (BMap<BString, Object>)nextValue, restType, useSemanticEquality);
            analyzerData.fieldHierarchy.push(new QualifiedNameMap(new HashMap()));
            analyzerData.visitedFieldHierarchy.push(new QualifiedNameMap(new HashMap()));
            analyzerData.xsdModelGroupInfo.push(new HashMap());
            analyzerData.xmlElementInfo.push(new HashMap());
            analyzerData.arrayIndexes.push(new HashMap());
            if (restType.getTag() == 32) {
                Type memberType = ((ArrayType)restType).getElementType();
                analyzerData.restTypes.push(memberType);
                this.traverseXml((BXml)xmlItem.getChildrenSeq(), memberType, analyzerData);
            } else {
                analyzerData.restTypes.push(restType);
                this.traverseXml((BXml)xmlItem.getChildrenSeq(), restType, analyzerData);
            }
            analyzerData.fieldHierarchy.pop();
            analyzerData.visitedFieldHierarchy.pop();
            analyzerData.restTypes.pop();
            analyzerData.arrayIndexes.pop();
            analyzerData.currentNode = (BMap)analyzerData.nodesStack.pop();
        }

        private void convertContentToRestType(BXmlItem xmlItem, BString bElementName, Type restType, BMap<BString, Object> mapValue, DataUtils.XmlAnalyzerData analyzerData) {
            if (this.isElementHasAttributes(xmlItem)) {
                BMap nextValue = ValueCreator.createMapValue((MapType)DataUtils.getMapTypeFromConstraintType(restType));
                this.handleAttributesRest(xmlItem, (BMap<BString, Object>)nextValue, restType, analyzerData.useSemanticEquality);
                if (!nextValue.isEmpty()) {
                    mapValue.put((Object)bElementName, (Object)nextValue);
                    analyzerData.currentField = TypeCreator.createField((Type)restType, (String)analyzerData.textFieldName, (long)256L);
                    analyzerData.nodesStack.push(analyzerData.currentNode);
                    analyzerData.currentNode = nextValue;
                    this.traverseXml((BXml)xmlItem.getChildrenSeq(), restType, analyzerData);
                    analyzerData.currentNode = (BMap)analyzerData.nodesStack.pop();
                    return;
                }
            }
            this.traverseXml((BXml)xmlItem.getChildrenSeq(), restType, analyzerData);
        }

        private void convertToJsonOrAnydataAsRestType(BXmlItem xmlItem, BString bElementName, Type restType, BMap<BString, Object> mapValue, DataUtils.XmlAnalyzerData analyzerData) {
            BMap nextValue = ValueCreator.createMapValue((MapType)DataUtils.getMapTypeFromConstraintType(restType));
            mapValue.put((Object)bElementName, (Object)nextValue);
            analyzerData.nodesStack.push(analyzerData.currentNode);
            analyzerData.currentNode = nextValue;
            this.handleAttributesRest(xmlItem, (BMap<BString, Object>)nextValue, restType, analyzerData.useSemanticEquality);
            this.traverseXml((BXml)xmlItem.getChildrenSeq(), restType, analyzerData);
            analyzerData.currentNode = (BMap)analyzerData.nodesStack.pop();
        }

        private boolean isElementHasAttributes(BXmlItem xmlItem) {
            return !xmlItem.getAttributesMap().isEmpty();
        }

        private boolean isNextElementContent(BXmlItem xml) {
            for (BXml bXml : xml.getChildrenSeq().getChildrenList()) {
                String textValue = bXml.toString();
                if (XmlTree.isCommentOrPi(bXml) || textValue.trim().isEmpty() || bXml.getNodeType() != XmlNodeType.TEXT) continue;
                return true;
            }
            return false;
        }

        private List<BXml> filterEmptyValuesOrCommentOrPi(List<BXml> sequence) {
            ArrayList<BXml> newSequence = new ArrayList<BXml>();
            for (BXml value : sequence) {
                String textValue;
                if (XmlTree.isCommentOrPi(value) || !(textValue = value.toString()).isEmpty() && textValue.trim().isEmpty()) continue;
                newSequence.add(value);
            }
            return newSequence;
        }

        private void convertSequence(BXmlSequence xmlSequence, Type type, DataUtils.XmlAnalyzerData analyzerData) {
            List<BXml> newSequence = this.filterEmptyValuesOrCommentOrPi(xmlSequence.getChildrenList());
            if (newSequence.isEmpty()) {
                return;
            }
            if (newSequence.size() == 1) {
                analyzerData.currentNode = (BMap)this.traverseXml(newSequence.get(0), type, analyzerData);
                return;
            }
            analyzerData.currentNode = (BMap)this.convertHeterogeneousSequence(newSequence, type, analyzerData);
        }

        private Object convertHeterogeneousSequence(List<BXml> sequence, Type type, DataUtils.XmlAnalyzerData analyzerData) {
            if (this.isAllChildrenText(sequence)) {
                return this.handleCommentInMiddleOfText(sequence, type, analyzerData);
            }
            for (BXml bXml : sequence) {
                if (XmlTree.isCommentOrPi(bXml)) continue;
                this.traverseXml(bXml, type, analyzerData);
            }
            return analyzerData.currentNode;
        }

        private boolean isAllChildrenText(List<BXml> sequence) {
            for (BXml bXml : sequence) {
                if (bXml.getNodeType() == XmlNodeType.TEXT) continue;
                return false;
            }
            return true;
        }

        private Object handleCommentInMiddleOfText(List<BXml> sequence, Type type, DataUtils.XmlAnalyzerData analyzerData) {
            if (!DataUtils.isStringValueAssignable(type.getTag())) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_TYPE, type, PredefinedTypes.TYPE_STRING);
            }
            this.convertXml(Concat.concat((Object[])sequence.toArray()), 5, analyzerData);
            return analyzerData.currentNode;
        }

        private static boolean isCommentOrPi(BXml bxml) {
            return bxml.getNodeType() == XmlNodeType.COMMENT || bxml.getNodeType() == XmlNodeType.PI;
        }

        private BXml validateRootElement(BXml xml, RecordType recordType, DataUtils.XmlAnalyzerData analyzerData) {
            if (xml.getNodeType() == XmlNodeType.SEQUENCE) {
                List<BXml> newSequence = this.filterEmptyValuesOrCommentOrPi(((BXmlSequence)xml).getChildrenList());
                if (newSequence.size() == 1) {
                    return this.validateRootElement(newSequence.get(0), recordType, analyzerData);
                }
                throw DiagnosticLog.error(DiagnosticErrorCode.XML_ROOT_MISSING, new Object[0]);
            }
            if (xml.getNodeType() == XmlNodeType.TEXT) {
                throw DiagnosticLog.error(DiagnosticErrorCode.XML_ROOT_MISSING, new Object[0]);
            }
            BXmlItem xmlItem = (BXmlItem)xml;
            analyzerData.rootRecord = recordType;
            boolean useSemanticEquality = analyzerData.useSemanticEquality;
            QualifiedName elementQName = DataUtils.getElementName(xmlItem.getQName(), useSemanticEquality);
            DataUtils.validateAndGetXmlNameFromRecordAnnotation(recordType, recordType.getName(), elementQName, useSemanticEquality);
            DataUtils.validateTypeNamespace(elementQName.getPrefix(), elementQName.getNamespaceURI(), recordType);
            DataUtils.updateExpectedTypeStacks(recordType, analyzerData);
            XsdUtils.initializeXsdInformation(recordType, analyzerData);
            this.handleAttributes(xmlItem, (BMap<BString, Object>)analyzerData.currentNode, analyzerData);
            analyzerData.arrayIndexes.push(new HashMap());
            return xmlItem.getChildrenSeq();
        }

        private void handleAttributes(BXmlItem xmlItem, BMap<BString, Object> currentNode, DataUtils.XmlAnalyzerData analyzerData) {
            HashSet<String> innerElements = this.findAllInnerElement(xmlItem);
            BMap attributeMap = xmlItem.getAttributesMap();
            ConcurrentHashMap<String, String> nsPrefixMap = this.getNamespacePrefixes((BMap<BString, BString>)attributeMap);
            for (Map.Entry entry : attributeMap.entrySet()) {
                if (this.isNamespacePrefixEntry(entry)) continue;
                BString key = (BString)entry.getKey();
                QualifiedName attribute = this.getAttributePreservingNamespace(nsPrefixMap, key.getValue(), analyzerData.attributePrefix, analyzerData.useSemanticEquality);
                Field field = (Field)((QualifiedNameMap)analyzerData.attributeHierarchy.peek()).remove(attribute);
                if (field == null) {
                    if (innerElements.contains(attribute.getLocalPart())) continue;
                    if (((QualifiedNameMap)analyzerData.visitedFieldHierarchy.peek()).contains(attribute)) {
                        field = (Field)((QualifiedNameMap)analyzerData.visitedFieldHierarchy.peek()).get(attribute);
                    } else {
                        field = (Field)((QualifiedNameMap)analyzerData.fieldHierarchy.peek()).remove(attribute);
                        ((QualifiedNameMap)analyzerData.visitedFieldHierarchy.peek()).put(attribute, field);
                    }
                }
                if (field == null) {
                    if (analyzerData.allowDataProjection) continue;
                    throw DiagnosticLog.error(DiagnosticErrorCode.UNDEFINED_FIELD, attribute.getLocalPart(), analyzerData.rootRecord);
                }
                Type fieldType = field.getFieldType();
                if (DataUtils.isRegExpType(fieldType)) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.UNSUPPORTED_TYPE, new Object[0]);
                }
                if (!DataUtils.isSupportedTypeForAttributes(TypeUtils.getReferredType((Type)fieldType))) {
                    throw DiagnosticLog.error(DiagnosticErrorCode.CANNOT_CONVERT_ATTRIBUTE_TO_ARRAY_TYPE, field.getFieldName(), fieldType);
                }
                try {
                    currentNode.put((Object)StringUtils.fromString((String)field.getFieldName()), DataUtils.convertStringToExpType((BString)attributeMap.get((Object)key), fieldType));
                }
                catch (Exception exception) {}
            }
        }

        private void handleAttributesRest(BXmlItem xmlItem, BMap<BString, Object> currentNode, Type restType, boolean useSemanticEquality) {
            HashSet<String> innerElements = this.findAllInnerElement(xmlItem);
            BMap attributeMap = xmlItem.getAttributesMap();
            ConcurrentHashMap<String, String> nsPrefixMap = this.getNamespacePrefixes((BMap<BString, BString>)attributeMap);
            for (Map.Entry entry : attributeMap.entrySet()) {
                BString key;
                QualifiedName attribute;
                if (this.isNamespacePrefixEntry(entry) || innerElements.contains((attribute = this.getAttributePreservingNamespace(nsPrefixMap, (key = (BString)entry.getKey()).getValue(), "", useSemanticEquality)).getLocalPart())) continue;
                try {
                    currentNode.put((Object)StringUtils.fromString((String)attribute.getLocalPart()), DataUtils.convertStringToExpType((BString)attributeMap.get((Object)key), restType));
                }
                catch (Exception exception) {}
            }
        }

        private ConcurrentHashMap<String, String> getNamespacePrefixes(BMap<BString, BString> xmlAttributeMap) {
            ConcurrentHashMap<String, String> nsPrefixMap = new ConcurrentHashMap<String, String>();
            for (Map.Entry entry : xmlAttributeMap.entrySet()) {
                if (!this.isNamespacePrefixEntry(entry)) continue;
                String prefix = ((BString)entry.getKey()).getValue().substring(Constants.NS_PREFIX_BEGIN_INDEX);
                String ns = ((BString)entry.getValue()).getValue();
                nsPrefixMap.put(ns, prefix);
            }
            return nsPrefixMap;
        }

        private boolean isNamespacePrefixEntry(Map.Entry<BString, BString> entry) {
            return entry.getKey().getValue().startsWith("{http://www.w3.org/2000/xmlns/}");
        }

        private QualifiedName getAttributePreservingNamespace(Map<String, String> nsPrefixMap, String attributeKey, String attributePrefix, boolean useSemanticEquality) {
            int nsEndIndex = attributeKey.lastIndexOf(125);
            if (nsEndIndex > 0) {
                String ns = attributeKey.substring(1, nsEndIndex);
                String local = attributeKey.substring(nsEndIndex + 1);
                String nsPrefix = nsPrefixMap.get(ns);
                if (nsPrefix == null) {
                    nsPrefix = "";
                }
                return QualifiedNameFactory.createQualifiedName(ns, attributePrefix + local, nsPrefix, useSemanticEquality);
            }
            return QualifiedNameFactory.createQualifiedName("", attributePrefix + attributeKey, "", useSemanticEquality);
        }

        private HashSet<String> findAllInnerElement(BXmlItem xmlItem) {
            HashSet<String> elements = new HashSet<String>();
            for (BXml xmlElem : xmlItem.getChildrenSeq().getChildrenList()) {
                elements.add(xmlElem.getElementName());
            }
            return elements;
        }

        private void validateElementInXsdSequenceOrElement(QualifiedName elemQName, HashMap<String, ModelGroupInfo> modelGroupInfo, BXmlItem xmlItem, DataUtils.XmlAnalyzerData xmlAnalyzerData, QualifiedNameMap<Field> visitedFields, QualifiedNameMap<Field> fieldMap) {
            if (modelGroupInfo != null) {
                for (Map.Entry<String, ModelGroupInfo> entry : modelGroupInfo.entrySet()) {
                    ModelGroupInfo modelGroupValue = entry.getValue();
                    String key = entry.getKey();
                    QualifiedName qualifiedName = QualifiedNameFactory.createQualifiedName("", key, "", xmlAnalyzerData.useSemanticEquality);
                    if (!modelGroupValue.isElementContains(elemQName.getLocalPart())) continue;
                    Object temp = null;
                    Field field = (Field)xmlAnalyzerData.rootRecord.getFields().get(key);
                    if (visitedFields.contains(qualifiedName)) {
                        temp = xmlAnalyzerData.currentNode.get((Object)StringUtils.fromString((String)key));
                    }
                    xmlAnalyzerData.modelGroupStack.push(modelGroupValue);
                    visitedFields.put(qualifiedName, field);
                    fieldMap.remove(qualifiedName);
                    Type referredType = TypeUtils.getReferredType((Type)field.getFieldType());
                    this.updateNextRecordForXsd(xmlAnalyzerData, key, referredType, temp, xmlAnalyzerData.currentNode);
                    this.convertElement(xmlItem, xmlAnalyzerData);
                    return;
                }
            }
        }

        private void updateNextRecordForXsd(DataUtils.XmlAnalyzerData xmlAnalyzerData, String fieldName, Type fieldType, Object temp, Object currentNode) {
            if (fieldType.getTag() == 24) {
                RecordType recType = (RecordType)fieldType;
                DataUtils.updateExpectedTypeStacks((RecordType)fieldType, xmlAnalyzerData);
                XsdUtils.initializeXsdInformation(recType, xmlAnalyzerData);
                xmlAnalyzerData.currentNode = this.updateNextMappingValue((Type)recType, fieldName, fieldType, (BMap<BString, Object>)((BMap)currentNode), xmlAnalyzerData);
                xmlAnalyzerData.recordTypeStack.push(xmlAnalyzerData.rootRecord);
                xmlAnalyzerData.rootRecord = recType;
                return;
            }
            if (fieldType.getTag() == 32) {
                Type elementType = TypeUtils.getReferredType((Type)((ArrayType)fieldType).getElementType());
                if (temp == null) {
                    ((HashMap)xmlAnalyzerData.arrayIndexes.peek()).put(fieldName, 0);
                    ((BMap)currentNode).put((Object)StringUtils.fromString((String)fieldName), (Object)ValueCreator.createArrayValue((ArrayType)((ArrayType)fieldType)));
                } else {
                    HashMap indexes = (HashMap)xmlAnalyzerData.arrayIndexes.peek();
                    indexes.put(fieldName, (Integer)indexes.get(fieldName) + 1);
                }
                if (elementType.getTag() == 24) {
                    RecordType recType = (RecordType)elementType;
                    DataUtils.updateExpectedTypeStacks((RecordType)elementType, xmlAnalyzerData);
                    XsdUtils.initializeXsdInformation(recType, xmlAnalyzerData);
                    xmlAnalyzerData.recordTypeStack.push(xmlAnalyzerData.rootRecord);
                    xmlAnalyzerData.rootRecord = recType;
                    xmlAnalyzerData.currentNode = this.updateNextMappingValue((Type)recType, fieldName, fieldType, (BMap<BString, Object>)((BMap)currentNode), xmlAnalyzerData);
                    return;
                }
            }
            throw DiagnosticLog.error(DiagnosticErrorCode.INVALID_XSD_ANNOTATION, fieldName, fieldType);
        }

        private void validateModelGroupStackForRootElement(DataUtils.XmlAnalyzerData analyzerData) {
            XsdUtils.validateModelGroupStack(analyzerData, QualifiedNameFactory.createQualifiedName("", "", "", analyzerData.useSemanticEquality), false);
        }
    }
}

