/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.xml.xsd;

import io.ballerina.lib.data.xmldata.utils.Constants;
import io.ballerina.lib.data.xmldata.utils.DataUtils;
import io.ballerina.lib.data.xmldata.utils.DiagnosticErrorCode;
import io.ballerina.lib.data.xmldata.utils.DiagnosticLog;
import io.ballerina.lib.data.xmldata.xml.xsd.ElementInfo;
import io.ballerina.lib.data.xmldata.xml.xsd.ModelGroupInfo;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class SequenceInfo
implements ModelGroupInfo {
    public String fieldName;
    public long minOccurs;
    public long maxOccurs;
    public int occurrences;
    private final Map<String, Integer> remainingElementCount = new HashMap<String, Integer>();
    private final Map<String, Integer> minimumElementCount = new HashMap<String, Integer>();
    private final Map<String, Integer> maxElementCount = new HashMap<String, Integer>();
    private final Map<String, Boolean> elementOptionality = new HashMap<String, Boolean>();
    private final List<String> allElements = new ArrayList<String>();
    int currentIndex = 0;
    int elementCount;
    String lastElement = "";
    private boolean isCompleted = false;
    private boolean isMiddleOfElement = false;
    private final Stack<HashMap<String, ElementInfo>> xmlElementInfo;
    private HashMap<String, String> xmlElementNameMap = new HashMap();

    public SequenceInfo(String fieldName, BMap<BString, Object> element, RecordType fieldType, Stack<HashMap<String, ElementInfo>> xmlElementInfo) {
        this.fieldName = fieldName;
        this.minOccurs = element.containsKey((Object)Constants.MIN_OCCURS) ? element.getIntValue(Constants.MIN_OCCURS) : 1L;
        this.maxOccurs = element.containsKey((Object)Constants.MAX_OCCURS) ? element.getIntValue(Constants.MAX_OCCURS) : Math.max(this.minOccurs, 1L);
        this.occurrences = 0;
        this.xmlElementInfo = xmlElementInfo;
        this.updateUnvisitedElementsBasedOnPriorityOrder(fieldType);
        this.xmlElementNameMap = DataUtils.getXmlElementNameMap(fieldType);
        this.reOrderElementNamesBasedOnTheNameAnnotation();
        this.elementCount = this.allElements.size();
    }

    public void updateOccurrences() {
        ++this.occurrences;
        if ((long)this.occurrences > this.maxOccurs) {
            throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_MORE_THAN_MAX_ALLOWED_TIMES, this.fieldName);
        }
    }

    @Override
    public void validateMinOccurrences() {
        if ((long)this.occurrences < this.minOccurs) {
            throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_LESS_THAN_MIN_REQUIRED_TIMES, this.fieldName);
        }
    }

    @Override
    public void validate() {
        this.generateElementOptionalityMapIfNotPresent();
        this.validateCompletedSequences();
        this.reset();
    }

    private void reset() {
        this.isCompleted = false;
        this.isMiddleOfElement = false;
        this.currentIndex = 0;
        this.remainingElementCount.putAll(this.maxElementCount);
        this.lastElement = "";
    }

    @Override
    public void visit(String element, boolean isStartElement) {
        this.generateElementOptionalityMapIfNotPresent();
        if (this.isMiddleOfElement && isStartElement) {
            return;
        }
        this.isMiddleOfElement = isStartElement;
        if (isStartElement) {
            this.isCompleted = false;
            return;
        }
        this.checkElementOrderAndUpdateElementOccurences(element);
    }

    @Override
    public boolean isElementContains(String elementName) {
        return this.allElements.contains(elementName);
    }

    @Override
    public boolean isMiddleOfModelGroup() {
        return this.isMiddleOfElement;
    }

    @Override
    public boolean predictStartNewModelGroup(String element) {
        this.generateElementOptionalityMapIfNotPresent();
        if (!this.isElementContains(element)) {
            return false;
        }
        boolean isFirstElement = element.equals(this.allElements.get(0));
        if (isFirstElement && this.currentIndex == 0 && this.remainingElementCount.get(this.allElements.get(0)) > 0) {
            return false;
        }
        return !(this.isMiddleOfElement || !isFirstElement || !this.isCompleted && !this.containsAllOptionalElements() || this.lastElement.equals(element) && this.remainingElementCount.get(element) > 0);
    }

    private void validateCompletedSequences() {
        if (!this.isCompleted && !this.containsAllOptionalElements()) {
            throw DiagnosticLog.error(DiagnosticErrorCode.REQUIRED_ELEMENT_NOT_FOUND, this.getUnvisitedElements(), this.fieldName);
        }
        this.updateOccurrences();
    }

    private boolean containsAllOptionalElements() {
        for (int i = this.currentIndex; i < this.elementCount; ++i) {
            if (this.elementOptionality.get(this.allElements.get(i)).booleanValue()) continue;
            return false;
        }
        return true;
    }

    private void checkElementOrderAndUpdateElementOccurences(String element) {
        String nextElement;
        boolean isLastElement = false;
        if (element.equals(this.lastElement)) {
            nextElement = this.lastElement;
            isLastElement = true;
        } else {
            nextElement = this.allElements.get(this.currentIndex == this.elementCount ? this.currentIndex - 1 : this.currentIndex);
        }
        while (!nextElement.equals(element)) {
            if (!this.elementOptionality.get(nextElement).booleanValue()) {
                throw DiagnosticLog.error(DiagnosticErrorCode.INCORRECT_ELEMENT_ORDER, this.xmlElementNameMap.get(element), this.fieldName);
            }
            ++this.currentIndex;
            nextElement = this.allElements.get(this.currentIndex);
            if (this.currentIndex != this.elementCount) continue;
            throw DiagnosticLog.error(DiagnosticErrorCode.INCORRECT_ELEMENT_ORDER, this.xmlElementNameMap.get(element), this.fieldName);
        }
        if (this.remainingElementCount.get(nextElement) == 0) {
            throw DiagnosticLog.error(DiagnosticErrorCode.ELEMENT_OCCURS_MORE_THAN_MAX_ALLOWED_TIMES_IN_SEQUENCES, this.xmlElementNameMap.get(nextElement), this.fieldName);
        }
        this.remainingElementCount.put(element, this.remainingElementCount.get(nextElement) - 1);
        int elementCount = this.maxElementCount.get(element) - this.remainingElementCount.get(element);
        if (elementCount >= this.minimumElementCount.get(element) && !isLastElement && this.currentIndex != this.elementCount) {
            ++this.currentIndex;
        } else if (elementCount == 1) {
            ++this.currentIndex;
        }
        if (this.currentIndex == this.elementCount && elementCount >= this.minimumElementCount.get(element)) {
            this.isCompleted = true;
        }
        this.lastElement = nextElement;
    }

    private String getUnvisitedElements() {
        StringBuilder unvisitedElementsStr = new StringBuilder();
        this.allElements.subList(this.currentIndex, this.elementCount).forEach(element -> {
            if (!this.elementOptionality.get(element).booleanValue()) {
                unvisitedElementsStr.append(this.xmlElementNameMap.get(element)).append(", ");
            }
        });
        String result = unvisitedElementsStr.toString();
        result = result.substring(0, result.length() - 2);
        return result;
    }

    private void updateUnvisitedElementsBasedOnPriorityOrder(RecordType fieldType) {
        this.allElements.addAll(DataUtils.getXsdSequencePriorityOrder((Type)fieldType, true).entrySet().stream().sorted(Map.Entry.comparingByValue()).map(Map.Entry::getKey).toList());
        this.currentIndex = 0;
    }

    private void generateElementOptionalityMapIfNotPresent() {
        if (this.elementOptionality.isEmpty()) {
            if (!this.xmlElementInfo.isEmpty()) {
                this.allElements.forEach(element -> {
                    HashMap<String, ElementInfo> elementInfo = this.xmlElementInfo.peek();
                    if (elementInfo.containsKey(element)) {
                        ElementInfo info = elementInfo.get(element);
                        this.elementOptionality.put((String)element, info.minOccurs == 0L);
                        this.remainingElementCount.put((String)element, (int)info.maxOccurs);
                        this.maxElementCount.put((String)element, (int)info.maxOccurs);
                        this.minimumElementCount.put((String)element, (int)info.minOccurs);
                    } else {
                        this.elementOptionality.put((String)element, false);
                        this.remainingElementCount.put((String)element, 1);
                        this.maxElementCount.put((String)element, 1);
                        this.minimumElementCount.put((String)element, 1);
                    }
                });
            } else {
                this.allElements.forEach(element -> {
                    this.elementOptionality.put((String)element, false);
                    this.remainingElementCount.put((String)element, 1);
                    this.maxElementCount.put((String)element, 1);
                    this.minimumElementCount.put((String)element, 1);
                });
            }
        }
    }

    private void reOrderElementNamesBasedOnTheNameAnnotation() {
        this.xmlElementNameMap.forEach((key, value) -> {
            if (this.allElements.contains(value)) {
                this.allElements.set(this.allElements.indexOf(value), (String)key);
            }
        });
        this.allElements.forEach(element -> {
            if (!this.xmlElementNameMap.containsKey(element)) {
                this.xmlElementNameMap.put((String)element, (String)element);
            }
        });
    }

    @Override
    public long getMinOccurs() {
        return this.minOccurs;
    }

    @Override
    public long getMaxOccurs() {
        return this.maxOccurs;
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }
}

