/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.ChildNodeList;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.graphql.compiler.Utils;
import io.ballerina.stdlib.graphql.compiler.diagnostics.CompilationDiagnostic;
import io.ballerina.stdlib.graphql.compiler.service.validator.ValidatorUtils;
import io.ballerina.tools.diagnostics.Location;
import java.util.Iterator;
import java.util.List;

public class AnnotationAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private static final String ID_ANNOTATION = "ID";

    public void perform(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        AnnotationSymbol annotationSymbol;
        AnnotationNode annotationNode = (AnnotationNode)syntaxNodeAnalysisContext.node();
        SemanticModel semanticModel = syntaxNodeAnalysisContext.semanticModel();
        if (semanticModel.symbol((Node)annotationNode).isPresent() && this.isIdAnnotation(annotationSymbol = (AnnotationSymbol)semanticModel.symbol((Node)annotationNode).get())) {
            if (annotationNode.parent().kind() == SyntaxKind.REQUIRED_PARAM && !this.validateRequiredParameterNode(annotationNode, semanticModel)) {
                ValidatorUtils.updateContext(syntaxNodeAnalysisContext, CompilationDiagnostic.INVALID_USE_OF_ID_ANNOTATION, (Location)annotationNode.location());
            } else if (annotationNode.parent().kind() == SyntaxKind.RETURN_TYPE_DESCRIPTOR && !this.validateReturnTypeDescriptorNode(annotationNode, semanticModel)) {
                ValidatorUtils.updateContext(syntaxNodeAnalysisContext, CompilationDiagnostic.INVALID_USE_OF_ID_ANNOTATION, (Location)annotationNode.location());
            } else if (annotationNode.parent().kind() == SyntaxKind.METADATA && !this.validateMetadataNode(annotationNode, semanticModel)) {
                ValidatorUtils.updateContext(syntaxNodeAnalysisContext, CompilationDiagnostic.INVALID_USE_OF_ID_ANNOTATION, (Location)annotationNode.location());
            }
        }
    }

    private boolean validateMetadataNode(AnnotationNode annotationNode, SemanticModel semanticModel) {
        RecordFieldNode recordFieldNode;
        MetadataNode metadataNode = (MetadataNode)annotationNode.parent();
        if (metadataNode.parent().kind() == SyntaxKind.RECORD_FIELD && semanticModel.symbol((Node)(recordFieldNode = (RecordFieldNode)metadataNode.parent())).isPresent()) {
            RecordFieldSymbol recordFieldSymbol = (RecordFieldSymbol)semanticModel.symbol((Node)recordFieldNode).get();
            return this.checkTypeForValidation(recordFieldSymbol.typeDescriptor());
        }
        return true;
    }

    private boolean isIdAnnotation(AnnotationSymbol annotationSymbol) {
        return annotationSymbol.getModule().isPresent() && io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlModuleSymbol((Symbol)((Symbol)annotationSymbol.getModule().get())) && annotationSymbol.getName().isPresent() && ((String)annotationSymbol.getName().get()).equals(ID_ANNOTATION);
    }

    private boolean validateReturnTypeDescriptorNode(AnnotationNode annotationNode, SemanticModel semanticModel) {
        ArrayTypeDescriptorNode arrayTypeDescriptorNode;
        ChildNodeList childNodeList;
        boolean isValid = false;
        ReturnTypeDescriptorNode returnTypeDescriptorNode = (ReturnTypeDescriptorNode)annotationNode.parent();
        if (semanticModel.symbol(returnTypeDescriptorNode.type()).isPresent()) {
            TypeSymbol typeSymbol = (TypeSymbol)semanticModel.symbol(returnTypeDescriptorNode.type()).get();
            if (this.checkTypeForValidation(typeSymbol)) {
                isValid = true;
            }
        } else if (returnTypeDescriptorNode.type().kind() == SyntaxKind.UNION_TYPE_DESC) {
            UnionTypeDescriptorNode unionTypeDescNode = (UnionTypeDescriptorNode)returnTypeDescriptorNode.type();
            ChildNodeList childNodeList2 = unionTypeDescNode.children();
            if (this.validateChildNodes(childNodeList2, semanticModel)) {
                isValid = true;
            }
        } else if (returnTypeDescriptorNode.type().kind() == SyntaxKind.OPTIONAL_TYPE_DESC) {
            OptionalTypeDescriptorNode optionalTypeDescriptorNode = (OptionalTypeDescriptorNode)returnTypeDescriptorNode.type();
            ChildNodeList childNodeList3 = optionalTypeDescriptorNode.children();
            if (this.validateChildNodes(childNodeList3, semanticModel)) {
                isValid = true;
            }
        } else if (returnTypeDescriptorNode.type().kind() == SyntaxKind.ARRAY_TYPE_DESC && this.validateChildNodes(childNodeList = (arrayTypeDescriptorNode = (ArrayTypeDescriptorNode)returnTypeDescriptorNode.type()).children(), semanticModel)) {
            isValid = true;
        }
        return isValid;
    }

    private boolean validateRequiredParameterNode(AnnotationNode annotationNode, SemanticModel semanticModel) {
        RequiredParameterNode requiredParameterNode = (RequiredParameterNode)annotationNode.parent();
        if (semanticModel.symbol((Node)requiredParameterNode).isPresent()) {
            ParameterSymbol parameterSymbol = (ParameterSymbol)semanticModel.symbol((Node)requiredParameterNode).get();
            return this.checkTypeForValidation(parameterSymbol.typeDescriptor());
        }
        return false;
    }

    private boolean validateChildNodes(ChildNodeList childNodeList, SemanticModel semanticModel) {
        boolean isValid = true;
        for (int i = 0; i < childNodeList.size(); ++i) {
            if (childNodeList.get(i).kind() == SyntaxKind.ERROR_TYPE_DESC || childNodeList.get(i).kind() == SyntaxKind.NIL_TYPE_DESC || childNodeList.get(i).kind() == SyntaxKind.PIPE_TOKEN || childNodeList.get(i).kind() == SyntaxKind.ARRAY_DIMENSION || childNodeList.get(i).kind() == SyntaxKind.QUESTION_MARK_TOKEN) continue;
            if (semanticModel.symbol(childNodeList.get(i)).isPresent()) {
                TypeSymbol typeSymbol = (TypeSymbol)semanticModel.symbol(childNodeList.get(i)).get();
                if (this.checkTypeForValidation(typeSymbol)) continue;
                isValid = false;
                continue;
            }
            if (childNodeList.get(i).kind() == SyntaxKind.OPTIONAL_TYPE_DESC) {
                OptionalTypeDescriptorNode optionalTypeDescriptorNode = (OptionalTypeDescriptorNode)childNodeList.get(i);
                isValid = this.validateChildNodes(optionalTypeDescriptorNode.children(), semanticModel);
                continue;
            }
            if (childNodeList.get(i).kind() != SyntaxKind.ARRAY_TYPE_DESC) continue;
            ArrayTypeDescriptorNode arrayTypeDescriptorNode = (ArrayTypeDescriptorNode)childNodeList.get(i);
            isValid = this.validateChildNodes(arrayTypeDescriptorNode.children(), semanticModel);
        }
        return isValid;
    }

    private boolean isValidIdTypeRefType(TypeReferenceTypeSymbol typeDescriptor) {
        return typeDescriptor.definition().getModule().isPresent() && Utils.isValidUuidModule((ModuleSymbol)typeDescriptor.definition().getModule().get()) && typeDescriptor.definition().getName().isPresent() && ((String)typeDescriptor.definition().getName().get()).equals("Uuid");
    }

    private boolean isValidIdUnionType(UnionTypeSymbol typeDescriptor) {
        TypeSymbol memberType;
        boolean isValid = true;
        List memberTypes = typeDescriptor.memberTypeDescriptors();
        Iterator iterator = memberTypes.iterator();
        while (iterator.hasNext() && ((memberType = (TypeSymbol)iterator.next()).typeKind() == TypeDescKind.NIL || memberType.typeKind() == TypeDescKind.ERROR || (isValid = this.checkTypeForValidation(memberType)))) {
        }
        return isValid;
    }

    private boolean isValidIdType(TypeSymbol memberTypeDescriptor) {
        return memberTypeDescriptor.typeKind() == TypeDescKind.STRING || memberTypeDescriptor.typeKind() == TypeDescKind.INT || memberTypeDescriptor.typeKind() == TypeDescKind.FLOAT || memberTypeDescriptor.typeKind() == TypeDescKind.DECIMAL;
    }

    private boolean checkTypeForValidation(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.ARRAY) {
            return this.checkTypeForValidation(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor());
        }
        if (typeSymbol.typeKind() == TypeDescKind.UNION) {
            return this.isValidIdUnionType((UnionTypeSymbol)typeSymbol);
        }
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return this.isValidIdTypeRefType((TypeReferenceTypeSymbol)typeSymbol);
        }
        return this.isValidIdType(typeSymbol);
    }
}

