/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.graphql.compiler.schema.generator;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportOrgNameNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.ObjectFieldNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.plugins.ModifierTask;
import io.ballerina.projects.plugins.SourceModifierContext;
import io.ballerina.stdlib.graphql.commons.types.Schema;
import io.ballerina.stdlib.graphql.commons.types.Type;
import io.ballerina.stdlib.graphql.compiler.CacheConfigContext;
import io.ballerina.stdlib.graphql.compiler.Utils;
import io.ballerina.stdlib.graphql.compiler.diagnostics.CompilationDiagnostic;
import io.ballerina.stdlib.graphql.compiler.schema.generator.GraphqlModifierContext;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.Location;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextRange;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;

public class GraphqlSourceModifier
implements ModifierTask<SourceModifierContext> {
    private static final String ENTITY = "__Entity";
    public static final String MAP_DEFINITION_PLACEHOLDER = "mapDef";
    private static final String SUBGRAPH_MODULE_PLACEHOLDER = "subgraph";
    private final Map<DocumentId, GraphqlModifierContext> modifierContextMap;
    private final Map<Node, String> entityTypeNamesMap;
    private String subgraphModulePrefix;
    private SourceModifierContext context;
    private int entityUnionSuffix = 0;
    private String entityUnionTypeName;
    private List<String> entities;
    private boolean isSubgraph = false;

    public GraphqlSourceModifier(Map<DocumentId, GraphqlModifierContext> modifierContextMap) {
        this.modifierContextMap = modifierContextMap;
        this.entityTypeNamesMap = new HashMap<Node, String>();
    }

    public void modify(SourceModifierContext sourceModifierContext) {
        this.context = sourceModifierContext;
        for (Map.Entry<DocumentId, GraphqlModifierContext> entry : this.modifierContextMap.entrySet()) {
            DocumentId documentId = entry.getKey();
            GraphqlModifierContext modifierContext = entry.getValue();
            Module module = sourceModifierContext.currentPackage().module(documentId.moduleId());
            ModulePartNode rootNode = (ModulePartNode)module.document(documentId).syntaxTree().rootNode();
            ModulePartNode updatedRootNode = this.modifyDocument(sourceModifierContext, rootNode, modifierContext);
            updatedRootNode = this.addImportsIfMissing(updatedRootNode);
            SyntaxTree syntaxTree = module.document(documentId).syntaxTree().modifyWith((Node)updatedRootNode);
            TextDocument textDocument = syntaxTree.textDocument();
            if (module.documentIds().contains(documentId)) {
                sourceModifierContext.modifySourceFile(textDocument, documentId);
                continue;
            }
            sourceModifierContext.modifyTestSourceFile(textDocument, documentId);
        }
    }

    private ModulePartNode modifyDocument(SourceModifierContext context, ModulePartNode rootNode, GraphqlModifierContext modifierContext) {
        this.subgraphModulePrefix = this.getSubgraphModulePrefix(rootNode);
        HashMap<NonTerminalNode, NonTerminalNode> modifiedNodes = new HashMap<NonTerminalNode, NonTerminalNode>();
        Map<Node, Schema> nodeSchemaMap = modifierContext.getNodeSchemaMap();
        for (Map.Entry<Node, Schema> entry : nodeSchemaMap.entrySet()) {
            Schema schema = entry.getValue();
            this.isSubgraph = schema.isSubgraph();
            this.entities = schema.getEntities().stream().map(Type::getName).collect(Collectors.toList());
            String prefix = io.ballerina.stdlib.graphql.commons.utils.Utils.getGraphqlModulePrefix((ModulePartNode)rootNode);
            this.entityUnionTypeName = ENTITY + this.entityUnionSuffix;
            try {
                ModuleVariableDeclarationNode updatedNode;
                ModuleVariableDeclarationNode graphqlServiceVariableDeclaration;
                String schemaString = this.getSchemaAsEncodedString(schema);
                Node targetNode = entry.getKey();
                CacheConfigContext cacheConfigContext = modifierContext.getNodeCacheConfigMap().get(targetNode);
                if (targetNode.kind() == SyntaxKind.SERVICE_DECLARATION) {
                    ServiceDeclarationNode updatedNode2 = this.modifyServiceDeclarationNode((ServiceDeclarationNode)targetNode, schemaString, cacheConfigContext, prefix);
                    modifiedNodes.put((NonTerminalNode)targetNode, (NonTerminalNode)updatedNode2);
                    this.entityTypeNamesMap.put(targetNode, this.entityUnionTypeName);
                    ++this.entityUnionSuffix;
                    continue;
                }
                if (targetNode.kind() == SyntaxKind.MODULE_VAR_DECL) {
                    graphqlServiceVariableDeclaration = (ModuleVariableDeclarationNode)targetNode;
                    updatedNode = this.modifyModuleLevelServiceDeclarationNode(schemaString, graphqlServiceVariableDeclaration, cacheConfigContext, prefix);
                    modifiedNodes.put((NonTerminalNode)targetNode, (NonTerminalNode)updatedNode);
                    this.entityTypeNamesMap.put(targetNode, this.entityUnionTypeName);
                    ++this.entityUnionSuffix;
                    continue;
                }
                if (targetNode.kind() == SyntaxKind.LOCAL_VAR_DECL) {
                    graphqlServiceVariableDeclaration = (VariableDeclarationNode)targetNode;
                    updatedNode = this.modifyVariableServiceDeclarationNode(schemaString, (VariableDeclarationNode)graphqlServiceVariableDeclaration, cacheConfigContext, prefix);
                    modifiedNodes.put((NonTerminalNode)targetNode, (NonTerminalNode)updatedNode);
                    this.entityTypeNamesMap.put(targetNode, this.entityUnionTypeName);
                    ++this.entityUnionSuffix;
                    continue;
                }
                if (targetNode.kind() != SyntaxKind.OBJECT_FIELD) continue;
                ObjectFieldNode graphqlServiceFieldDeclaration = (ObjectFieldNode)targetNode;
                updatedNode = this.modifyObjectFieldServiceDeclarationNode(schemaString, graphqlServiceFieldDeclaration, cacheConfigContext, prefix);
                modifiedNodes.put((NonTerminalNode)targetNode, (NonTerminalNode)updatedNode);
                this.entityTypeNamesMap.put(targetNode, this.entityUnionTypeName);
                ++this.entityUnionSuffix;
            }
            catch (IOException e) {
                this.updateContext(context, (Location)entry.getKey().location(), CompilationDiagnostic.SCHEMA_GENERATION_FAILED, e.getMessage());
            }
        }
        ArrayList<NonTerminalNode> nodesToBeModified = new ArrayList<NonTerminalNode>(modifiedNodes.keySet());
        nodesToBeModified.sort(Comparator.comparingInt(n -> n.textRange().startOffset()));
        List<ModuleMemberDeclarationNode> entities = this.getEntityTypeDefinitions(nodeSchemaMap, nodesToBeModified);
        ModulePartNode modifiedRootNode = this.addServiceDeclarationAnnotations(rootNode, nodesToBeModified, modifiedNodes);
        NodeList modifiedMembers = modifiedRootNode.members().addAll(entities);
        return modifiedRootNode.modify(modifiedRootNode.imports(), modifiedMembers, modifiedRootNode.eofToken());
    }

    private String getSubgraphModulePrefix(ModulePartNode rootNode) {
        List imports = rootNode.imports().stream().collect(Collectors.toList());
        if (imports.isEmpty()) {
            return null;
        }
        for (ImportDeclarationNode importDeclarationNode : imports) {
            if (!importDeclarationNode.prefix().isPresent() || !importDeclarationNode.moduleName().stream().map(Token::text).collect(Collectors.joining(".")).equals("graphql.subgraph")) continue;
            return ((ImportPrefixNode)importDeclarationNode.prefix().get()).prefix().text();
        }
        return null;
    }

    private NodeList<ModuleMemberDeclarationNode> addEntityTypeDefinition(NodeList<ModuleMemberDeclarationNode> moduleMembers) {
        if (!this.isSubgraph) {
            return moduleMembers;
        }
        ModuleMemberDeclarationNode typeDefinition = this.getEntityTypeDefinition();
        return moduleMembers.add((Node)typeDefinition);
    }

    private ModulePartNode addServiceDeclarationAnnotations(ModulePartNode rootNode, ArrayList<NonTerminalNode> nodesToBeModified, Map<NonTerminalNode, NonTerminalNode> modifiedNodes) {
        int prevModifiedNodeLength = 0;
        int prevOriginalNodeLength = 0;
        for (NonTerminalNode originalNode : nodesToBeModified) {
            int originalNodeStartOffset = originalNode.textRangeWithMinutiae().startOffset() + prevModifiedNodeLength - prevOriginalNodeLength;
            int originalNodeLength = originalNode.textRangeWithMinutiae().length();
            NonTerminalNode replacingNode = rootNode.findNode(TextRange.from((int)originalNodeStartOffset, (int)originalNodeLength), true);
            rootNode = (ModulePartNode)rootNode.replace((Node)replacingNode, (Node)modifiedNodes.get(originalNode));
            prevModifiedNodeLength += modifiedNodes.get(originalNode).textRangeWithMinutiae().length();
            prevOriginalNodeLength += originalNode.textRangeWithMinutiae().length();
        }
        return rootNode;
    }

    private List<ModuleMemberDeclarationNode> getEntityTypeDefinitions(Map<Node, Schema> nodeSchemaMap, ArrayList<NonTerminalNode> serviceNodes) {
        NodeList<ModuleMemberDeclarationNode> entities = NodeFactory.createNodeList((Node[])new ModuleMemberDeclarationNode[0]);
        for (NonTerminalNode serviceNode : serviceNodes) {
            this.entityUnionTypeName = this.entityTypeNamesMap.get(serviceNode);
            Schema schema = nodeSchemaMap.get(serviceNode);
            this.isSubgraph = schema.isSubgraph();
            if (schema.getEntities().size() <= 0) continue;
            this.entities = schema.getEntities().stream().map(Type::getName).collect(Collectors.toList());
            entities = this.addEntityTypeDefinition(entities);
        }
        return entities.stream().toList();
    }

    private ModuleMemberDeclarationNode getEntityTypeDefinition() {
        String unionOfEntities = String.join((CharSequence)"|", this.entities);
        return NodeParser.parseModuleMemberDeclaration((String)("type " + this.entityUnionTypeName + " " + unionOfEntities + ";"));
    }

    private ModuleVariableDeclarationNode modifyModuleLevelServiceDeclarationNode(String schemaString, ModuleVariableDeclarationNode node, CacheConfigContext cacheConfigContext, String prefix) {
        ObjectConstructorExpressionNode graphqlServiceObject = (ObjectConstructorExpressionNode)node.initializer().get();
        ObjectConstructorExpressionNode updatedGraphqlServiceObject = this.modifyServiceObjectNode(graphqlServiceObject, schemaString, cacheConfigContext, prefix);
        return node.modify().withInitializer((ExpressionNode)updatedGraphqlServiceObject).apply();
    }

    private VariableDeclarationNode modifyVariableServiceDeclarationNode(String schemaString, VariableDeclarationNode node, CacheConfigContext cacheConfigContext, String prefix) {
        ObjectConstructorExpressionNode graphqlServiceObject = (ObjectConstructorExpressionNode)node.initializer().get();
        ObjectConstructorExpressionNode updatedGraphqlServiceObject = this.modifyServiceObjectNode(graphqlServiceObject, schemaString, cacheConfigContext, prefix);
        return node.modify().withInitializer((ExpressionNode)updatedGraphqlServiceObject).apply();
    }

    private ObjectFieldNode modifyObjectFieldServiceDeclarationNode(String schemaString, ObjectFieldNode node, CacheConfigContext cacheConfigContext, String prefix) {
        ObjectConstructorExpressionNode graphqlServiceObject = (ObjectConstructorExpressionNode)node.expression().get();
        ObjectConstructorExpressionNode updatedGraphqlServiceObject = this.modifyServiceObjectNode(graphqlServiceObject, schemaString, cacheConfigContext, prefix);
        return node.modify().withExpression((ExpressionNode)updatedGraphqlServiceObject).apply();
    }

    private ObjectConstructorExpressionNode modifyServiceObjectNode(ObjectConstructorExpressionNode node, String schemaString, CacheConfigContext cacheConfigContext, String prefix) {
        NodeList annotations = NodeFactory.createNodeList((Node[])new AnnotationNode[0]);
        if (node.annotations().isEmpty()) {
            Iterator annotationNode = this.getServiceAnnotation(schemaString, cacheConfigContext, prefix);
            annotations = annotations.add((Node)annotationNode);
        } else {
            for (AnnotationNode annotationNode : node.annotations()) {
                annotationNode = this.updateAnnotationNode(annotationNode, schemaString, cacheConfigContext, prefix);
                annotations = annotations.add((Node)annotationNode);
            }
        }
        ObjectConstructorExpressionNode.ObjectConstructorExpressionNodeModifier modifier = node.modify();
        modifier = modifier.withAnnotations(annotations);
        NodeList<Node> members = node.members();
        if (this.isSubgraph) {
            members = this.addServiceResourceResolverToMembers(members, (Location)node.location());
            if (this.entities.size() > 0) {
                members = this.addEntityResourceResolverToMembers(members, (Location)node.location());
            }
        }
        modifier = modifier.withMembers((NodeList)members);
        return modifier.apply();
    }

    private ServiceDeclarationNode modifyServiceDeclarationNode(ServiceDeclarationNode node, String schemaString, CacheConfigContext cacheConfigContext, String prefix) {
        MetadataNode metadataNode = this.getMetadataNode(node, schemaString, cacheConfigContext, prefix);
        ServiceDeclarationNode.ServiceDeclarationNodeModifier modifier = node.modify();
        modifier = modifier.withMetadata(metadataNode);
        NodeList<Node> members = node.members();
        if (this.isSubgraph) {
            members = this.addServiceResourceResolverToMembers(members, (Location)node.location());
            if (this.entities.size() > 0) {
                members = this.addEntityResourceResolverToMembers(members, (Location)node.location());
            }
        }
        modifier = modifier.withMembers((NodeList)members);
        return modifier.apply();
    }

    private NodeList<Node> addEntityResourceResolverToMembers(NodeList<Node> serviceMembers, Location location) {
        FunctionDefinitionNode entityResolver = this.getEntityResolver(location);
        return serviceMembers.add((Node)entityResolver);
    }

    private NodeList<Node> addServiceResourceResolverToMembers(NodeList<Node> serviceMembers, Location location) {
        FunctionDefinitionNode serviceResolver = this.getServiceResolver(location);
        return serviceMembers.add((Node)serviceResolver);
    }

    private FunctionDefinitionNode getEntityResolver(Location location) {
        try {
            String mapDef = this.getEntityTypedescMapInitializer();
            Class<GraphqlSourceModifier> currentClass = GraphqlSourceModifier.class;
            InputStream inputStream = currentClass.getResourceAsStream("/entity_resolver.bal.partial");
            String entityResolver = this.readFromInputStream(inputStream);
            Objects.requireNonNull(inputStream).close();
            entityResolver = entityResolver.replaceAll(ENTITY, this.entityUnionTypeName);
            entityResolver = entityResolver.replaceAll(MAP_DEFINITION_PLACEHOLDER, mapDef);
            if (this.subgraphModulePrefix != null) {
                entityResolver = entityResolver.replaceAll(SUBGRAPH_MODULE_PLACEHOLDER, this.subgraphModulePrefix);
            }
            return (FunctionDefinitionNode)NodeParser.parseObjectMember((String)entityResolver);
        }
        catch (IOException | NullPointerException e) {
            this.updateContext(this.context, location, CompilationDiagnostic.FAILED_TO_ADD_ENTITY_RESOLVER, e.getMessage());
            return null;
        }
    }

    private String readFromInputStream(InputStream inputStream) throws IOException {
        StringBuilder resultStringBuilder = new StringBuilder();
        InputStreamReader streamReader = new InputStreamReader(inputStream, StandardCharsets.UTF_8);
        try (BufferedReader bufferedReader = new BufferedReader(streamReader);){
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        return resultStringBuilder.toString();
    }

    private FunctionDefinitionNode getServiceResolver(Location location) {
        try {
            String mapDef = this.getEntityTypedescMapInitializer();
            Class<GraphqlSourceModifier> currentClass = GraphqlSourceModifier.class;
            InputStream inputStream = currentClass.getResourceAsStream("/service_resolver.bal.partial");
            String serviceResolver = this.readFromInputStream(inputStream);
            Objects.requireNonNull(inputStream).close();
            serviceResolver = serviceResolver.replaceAll(MAP_DEFINITION_PLACEHOLDER, mapDef);
            if (this.subgraphModulePrefix != null) {
                serviceResolver = serviceResolver.replaceAll(SUBGRAPH_MODULE_PLACEHOLDER, this.subgraphModulePrefix);
            }
            return (FunctionDefinitionNode)NodeParser.parseObjectMember((String)serviceResolver);
        }
        catch (IOException | NullPointerException e) {
            this.updateContext(this.context, location, CompilationDiagnostic.FAILED_TO_ADD_SERVICE_RESOLVER, e.getMessage());
            return null;
        }
    }

    private String getEntityTypedescMapInitializer() {
        List mapFields = this.entities.stream().map(entity -> "\"" + entity + "\":" + entity).collect(Collectors.toList());
        return "{" + String.join((CharSequence)", ", mapFields) + "}";
    }

    private MetadataNode getMetadataNode(ServiceDeclarationNode node, String schemaString, CacheConfigContext cacheConfigContext, String prefix) {
        if (node.metadata().isPresent()) {
            return this.getMetadataNodeFromExistingMetadata((MetadataNode)node.metadata().get(), schemaString, cacheConfigContext, prefix);
        }
        return this.getNewMetadataNode(schemaString, cacheConfigContext, prefix);
    }

    private MetadataNode getMetadataNodeFromExistingMetadata(MetadataNode metadataNode, String schemaString, CacheConfigContext cacheConfigContext, String prefix) {
        NodeList annotationNodes = NodeFactory.createNodeList((Node[])new AnnotationNode[0]);
        if (metadataNode.annotations().isEmpty()) {
            AnnotationNode annotationNode = this.getServiceAnnotation(schemaString, cacheConfigContext, prefix);
            annotationNodes = annotationNodes.add((Node)annotationNode);
        } else {
            boolean isAnnotationFound = false;
            for (AnnotationNode annotationNode : metadataNode.annotations()) {
                if (Utils.isGraphqlServiceConfig(annotationNode, prefix)) {
                    isAnnotationFound = true;
                    annotationNode = this.updateAnnotationNode(annotationNode, schemaString, cacheConfigContext, prefix);
                }
                annotationNodes = annotationNodes.add((Node)annotationNode);
            }
            if (!isAnnotationFound) {
                AnnotationNode annotationNode = this.getServiceAnnotation(schemaString, cacheConfigContext, prefix);
                annotationNodes = annotationNodes.add((Node)annotationNode);
            }
        }
        return NodeFactory.createMetadataNode((Node)metadataNode.documentationString().orElse(null), (NodeList)annotationNodes);
    }

    private AnnotationNode updateAnnotationNode(AnnotationNode annotationNode, String schemaString, CacheConfigContext cacheConfigContext, String prefix) {
        if (annotationNode.annotValue().isPresent()) {
            SeparatedNodeList<MappingFieldNode> updatedFields = this.getUpdatedFields((MappingConstructorExpressionNode)annotationNode.annotValue().get(), schemaString, cacheConfigContext);
            MappingConstructorExpressionNode node = ((MappingConstructorExpressionNode)annotationNode.annotValue().get()).modify().withFields(updatedFields).apply();
            return annotationNode.modify().withAnnotValue(node).apply();
        }
        return this.getServiceAnnotation(schemaString, cacheConfigContext, prefix);
    }

    private SeparatedNodeList<MappingFieldNode> getUpdatedFields(MappingConstructorExpressionNode annotationValue, String schemaString, CacheConfigContext cacheConfigContext) {
        ArrayList<Object> fields = new ArrayList<Object>();
        SeparatedNodeList existingFields = annotationValue.fields();
        Token separator = NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN);
        int fieldCount = existingFields.size();
        for (int i = 0; i < fieldCount; ++i) {
            fields.add(existingFields.get(i));
            if (fieldCount <= 1 || i >= fieldCount - 1) continue;
            fields.add(existingFields.getSeparator(i));
        }
        if (fieldCount > 0) {
            fields.add(separator);
        }
        fields.add(this.getSchemaStringFieldNode(schemaString));
        fields.add(separator);
        fields.add(this.getFieldCacheConfigNode(cacheConfigContext));
        return NodeFactory.createSeparatedNodeList(fields);
    }

    private MetadataNode getNewMetadataNode(String schemaString, CacheConfigContext cacheConfigContext, String prefix) {
        NodeList annotationNodes = NodeFactory.createNodeList((Node[])new AnnotationNode[]{this.getServiceAnnotation(schemaString, cacheConfigContext, prefix)});
        return NodeFactory.createMetadataNode(null, (NodeList)annotationNodes);
    }

    private AnnotationNode getServiceAnnotation(String schemaString, CacheConfigContext cacheConfigContext, String prefix) {
        String configIdentifierString = prefix + SyntaxKind.COLON_TOKEN.stringValue() + "ServiceConfig";
        IdentifierToken identifierToken = NodeFactory.createIdentifierToken((String)configIdentifierString);
        Token atToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN);
        SimpleNameReferenceNode nameReferenceNode = NodeFactory.createSimpleNameReferenceNode((Token)identifierToken);
        MappingConstructorExpressionNode annotValue = this.getAnnotationExpression(schemaString, cacheConfigContext);
        return NodeFactory.createAnnotationNode((Token)atToken, (Node)nameReferenceNode, (MappingConstructorExpressionNode)annotValue);
    }

    private MappingConstructorExpressionNode getAnnotationExpression(String schemaString, CacheConfigContext cacheConfigContext) {
        Token openBraceToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN);
        Token closeBraceToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN);
        ArrayList<Object> fields = new ArrayList<Object>();
        SpecificFieldNode schemaFieldNode = this.getSchemaStringFieldNode(schemaString);
        Token separator = NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN);
        fields.add(schemaFieldNode);
        fields.add(separator);
        SpecificFieldNode cacheFieldNode = this.getFieldCacheConfigNode(cacheConfigContext);
        fields.add(cacheFieldNode);
        SeparatedNodeList separatedNodeList = NodeFactory.createSeparatedNodeList(fields);
        return NodeFactory.createMappingConstructorExpressionNode((Token)openBraceToken, (SeparatedNodeList)separatedNodeList, (Token)closeBraceToken);
    }

    private SpecificFieldNode getSchemaStringFieldNode(String schemaString) {
        IdentifierToken fieldName = NodeFactory.createIdentifierToken((String)"schemaString");
        Token colon = NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
        String expression = "\"" + schemaString + "\"";
        ExpressionNode fieldValue = NodeParser.parseExpression((String)expression);
        return NodeFactory.createSpecificFieldNode(null, (Node)fieldName, (Token)colon, (ExpressionNode)fieldValue);
    }

    private SpecificFieldNode getFieldCacheConfigNode(CacheConfigContext cacheConfigContext) {
        IdentifierToken fieldName = NodeFactory.createIdentifierToken((String)"fieldCacheConfig");
        Token colon = NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
        MappingConstructorExpressionNode fieldCacheValue = this.getFieldCacheConfigValueNode(cacheConfigContext);
        return NodeFactory.createSpecificFieldNode(null, (Node)fieldName, (Token)colon, (ExpressionNode)fieldCacheValue);
    }

    private MappingConstructorExpressionNode getFieldCacheConfigValueNode(CacheConfigContext cacheConfigContext) {
        Token openBraceToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN);
        Token closeBraceToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN);
        ArrayList<Object> fields = new ArrayList<Object>();
        Token separator = NodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN);
        SpecificFieldNode cacheEnabledFieldNode = this.getEnabledFieldNode(cacheConfigContext.getEnabled());
        fields.add(cacheEnabledFieldNode);
        fields.add(separator);
        SpecificFieldNode cacheMaxSizeFieldNode = this.getMaxSizeFieldNode(cacheConfigContext.getMaxSize());
        fields.add(cacheMaxSizeFieldNode);
        SeparatedNodeList separatedNodeList = NodeFactory.createSeparatedNodeList(fields);
        return NodeFactory.createMappingConstructorExpressionNode((Token)openBraceToken, (SeparatedNodeList)separatedNodeList, (Token)closeBraceToken);
    }

    private SpecificFieldNode getEnabledFieldNode(boolean enabledFieldCache) {
        IdentifierToken fieldName = NodeFactory.createIdentifierToken((String)"enabled");
        Token colon = NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
        ExpressionNode fieldValue = NodeParser.parseExpression((String)String.valueOf(enabledFieldCache));
        return NodeFactory.createSpecificFieldNode(null, (Node)fieldName, (Token)colon, (ExpressionNode)fieldValue);
    }

    private SpecificFieldNode getMaxSizeFieldNode(int maxSize) {
        IdentifierToken fieldName = NodeFactory.createIdentifierToken((String)"maxSize");
        Token colon = NodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN);
        ExpressionNode fieldValue = NodeParser.parseExpression((String)String.valueOf(maxSize));
        return NodeFactory.createSpecificFieldNode(null, (Node)fieldName, (Token)colon, (ExpressionNode)fieldValue);
    }

    private String getSchemaAsEncodedString(Schema schema) throws IOException {
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        ObjectOutputStream objectOutputStream = new ObjectOutputStream(outputStream);
        objectOutputStream.writeObject(schema);
        objectOutputStream.flush();
        objectOutputStream.close();
        return new String(Base64.getEncoder().encode(outputStream.toByteArray()), StandardCharsets.UTF_8);
    }

    private void updateContext(SourceModifierContext context, Location location, CompilationDiagnostic compilerDiagnostic, String errorMessage) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(compilerDiagnostic.getDiagnosticCode(), compilerDiagnostic.getDiagnostic(), compilerDiagnostic.getDiagnosticSeverity());
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])new Object[]{errorMessage});
        context.reportDiagnostic(diagnostic);
    }

    private ModulePartNode addImportsIfMissing(ModulePartNode rootNode) {
        if (rootNode.imports().isEmpty()) {
            ImportDeclarationNode importDeclarationNode = this.getGraphqlImportNode();
            NodeList importNodes = NodeFactory.createNodeList((Node[])new ImportDeclarationNode[]{importDeclarationNode});
            return rootNode.modify().withImports(importNodes).apply();
        }
        boolean foundGraphqlImport = false;
        for (ImportDeclarationNode importNode : rootNode.imports()) {
            if (!io.ballerina.stdlib.graphql.commons.utils.Utils.isGraphqlImportNode((ImportDeclarationNode)importNode)) continue;
            foundGraphqlImport = true;
            break;
        }
        if (!foundGraphqlImport) {
            ImportDeclarationNode importDeclarationNode = this.getGraphqlImportNode();
            NodeList importNodes = rootNode.imports().add((Node)importDeclarationNode);
            return rootNode.modify().withImports(importNodes).apply();
        }
        return rootNode;
    }

    private ImportDeclarationNode getGraphqlImportNode() {
        Token importKeyword = NodeFactory.createToken((SyntaxKind)SyntaxKind.IMPORT_KEYWORD, (MinutiaeList)NodeFactory.createEmptyMinutiaeList(), (MinutiaeList)NodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{NodeFactory.createWhitespaceMinutiae((String)" ")}));
        IdentifierToken orgNameToken = NodeFactory.createIdentifierToken((String)"ballerina");
        Token slashToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.SLASH_TOKEN);
        ImportOrgNameNode importOrgNameToken = NodeFactory.createImportOrgNameNode((Token)orgNameToken, (Token)slashToken);
        IdentifierToken moduleNameNode = NodeFactory.createIdentifierToken((String)"graphql");
        SeparatedNodeList moduleName = NodeFactory.createSeparatedNodeList((Node[])new Node[]{moduleNameNode});
        Token semicolonToken = NodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN);
        return NodeFactory.createImportDeclarationNode((Token)importKeyword, (ImportOrgNameNode)importOrgNameToken, (SeparatedNodeList)moduleName, null, (Token)semicolonToken);
    }
}

