/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websocket.plugin;

import io.ballerina.compiler.api.symbols.ClassSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.MethodSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.NewExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websocket.plugin.PluginConstants;
import io.ballerina.stdlib.websocket.plugin.ReturnStatementNodeVisitor;
import io.ballerina.stdlib.websocket.plugin.Utils;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;

public class WebSocketUpgradeServiceValidator {
    private SyntaxNodeAnalysisContext ctx;
    private FunctionDefinitionNode resourceNode;
    private String modulePrefix;

    WebSocketUpgradeServiceValidator(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext, String modulePrefix) {
        this.ctx = syntaxNodeAnalysisContext;
        this.modulePrefix = modulePrefix;
    }

    void validate(boolean customDispatchingEnabled) {
        int numResources;
        ServiceDeclarationNode serviceDeclarationNode = (ServiceDeclarationNode)this.ctx.node();
        boolean hasRemoteService = serviceDeclarationNode.members().stream().anyMatch(child -> child.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION);
        if (serviceDeclarationNode.members().isEmpty() || !hasRemoteService) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(PluginConstants.CompilationErrors.TEMPLATE_CODE_GENERATION_HINT.getErrorCode(), PluginConstants.CompilationErrors.TEMPLATE_CODE_GENERATION_HINT.getError(), DiagnosticSeverity.INTERNAL);
            this.ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)serviceDeclarationNode.location(), (Object[])new Object[0]));
        }
        if (serviceDeclarationNode.members().size() > 1 && (numResources = (int)serviceDeclarationNode.members().stream().filter(child -> child.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION).count()) > 1) {
            Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.INVALID_RESOURCE_ERROR, serviceDeclarationNode.location(), new Object[0]);
        }
        serviceDeclarationNode.members().stream().filter(child -> child.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION || child.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION).forEach(node -> {
            FunctionDefinitionNode functionDefinitionNode = (FunctionDefinitionNode)node;
            String functionName = functionDefinitionNode.functionName().toString().split(" ")[0];
            NodeList qualifierList = functionDefinitionNode.qualifierList();
            if (qualifierList.isEmpty()) {
                return;
            }
            if (functionName.compareTo("get") == 0 && functionDefinitionNode.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
                this.resourceNode = functionDefinitionNode;
            } else if (((Token)qualifierList.get(0)).text().equals(Qualifier.REMOTE.getValue()) || functionDefinitionNode.kind() == SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) {
                this.reportInvalidFunction(functionDefinitionNode);
            }
        });
        if (this.resourceNode != null) {
            this.validateResourceReturnTypes(this.resourceNode);
            if (customDispatchingEnabled) {
                return;
            }
            ReturnStatementNodeVisitor returnStatementNodeVisitor = new ReturnStatementNodeVisitor();
            this.resourceNode.accept((NodeVisitor)returnStatementNodeVisitor);
            for (ReturnStatementNode returnStatementNode : returnStatementNodeVisitor.getReturnStatementNodes()) {
                ExpressionNode expressionNode = (ExpressionNode)returnStatementNode.expression().get();
                if (!(expressionNode instanceof NewExpressionNode)) continue;
                TypeSymbol typeSymbol = (TypeSymbol)this.ctx.semanticModel().type((Node)expressionNode).get();
                if (typeSymbol.typeKind() != TypeDescKind.TYPE_REFERENCE) {
                    return;
                }
                TypeReferenceTypeSymbol definition = (TypeReferenceTypeSymbol)typeSymbol;
                ClassSymbol classSymbol = (ClassSymbol)definition.typeDescriptor();
                MethodSymbol[] methodSymbols = classSymbol.methods().values().toArray(new MethodSymbol[0]);
                List typeInclusions = classSymbol.typeInclusions();
                if (!typeInclusions.isEmpty()) continue;
                block17: for (MethodSymbol symbol : methodSymbols) {
                    String functionName;
                    if (!symbol.qualifiers().contains(Qualifier.REMOTE)) continue;
                    switch (functionName = (String)symbol.getName().get()) {
                        case "onOpen": {
                            Utils.validateOnOpenFunction(symbol.typeDescriptor(), this.ctx, this.resourceNode);
                            continue block17;
                        }
                        case "onClose": {
                            Utils.validateOnCloseFunction(symbol.typeDescriptor(), this.ctx, this.resourceNode);
                            continue block17;
                        }
                        case "onIdleTimeout": {
                            Utils.validateOnIdleTimeoutFunction(symbol.typeDescriptor(), this.ctx, this.resourceNode);
                            continue block17;
                        }
                        case "onError": {
                            Utils.validateOnErrorFunction(symbol.typeDescriptor(), this.ctx, this.resourceNode);
                            continue block17;
                        }
                        case "onTextMessage": {
                            Utils.validateOnTextMessageFunction(symbol.typeDescriptor(), this.ctx, this.resourceNode);
                            continue block17;
                        }
                        case "onBinaryMessage": {
                            Utils.validateOnBinaryMessageFunction(symbol.typeDescriptor(), this.ctx, this.resourceNode);
                            continue block17;
                        }
                        default: {
                            this.reportInvalidFunction(this.resourceNode);
                        }
                    }
                }
            }
        }
    }

    private void validateResourceReturnTypes(FunctionDefinitionNode resourceNode) {
        if (resourceNode != null) {
            FunctionTypeSymbol functionTypeSymbol = ((MethodSymbol)this.ctx.semanticModel().symbol((Node)resourceNode).get()).typeDescriptor();
            TypeSymbol returnTypeSymbol = (TypeSymbol)functionTypeSymbol.returnTypeDescriptor().get();
            if (returnTypeSymbol.typeKind() == TypeDescKind.UNION) {
                for (TypeSymbol symbol : ((UnionTypeSymbol)returnTypeSymbol).memberTypeDescriptors()) {
                    if (symbol.typeKind() == TypeDescKind.TYPE_REFERENCE && ((String)symbol.getName().get()).equals("Service") && symbol.getModule().map(ModuleSymbol::id).get().orgName().equals("ballerina") && "websocket".equals(symbol.getModule().map(ModuleSymbol::id).get().modulePrefix()) || symbol.typeKind() == TypeDescKind.ERROR || symbol.typeKind() == TypeDescKind.TYPE_REFERENCE && ((TypeReferenceTypeSymbol)symbol).typeDescriptor().typeKind() == TypeDescKind.ERROR) continue;
                    Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.INVALID_RETURN_TYPES_IN_RESOURCE, resourceNode.location(), symbol.typeKind().getName(), resourceNode.functionName(), this.modulePrefix + "Service|" + this.modulePrefix + "UpgradeError");
                }
            } else if (returnTypeSymbol.typeKind() == TypeDescKind.NIL) {
                Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.INVALID_RETURN_TYPES_IN_RESOURCE, resourceNode.location(), TypeDescKind.NIL.getName(), resourceNode.functionName(), this.modulePrefix + "Service|" + this.modulePrefix + "UpgradeError");
            }
        }
    }

    private void reportInvalidFunction(FunctionDefinitionNode functionDefinitionNode) {
        Utils.reportDiagnostics(this.ctx, PluginConstants.CompilationErrors.FUNCTION_NOT_ACCEPTED_BY_THE_SERVICE, functionDefinitionNode.location(), functionDefinitionNode.functionName().toString());
    }
}

