/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.diagramutil.connector.generator;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ClassDefinitionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MarkdownCodeBlockNode;
import io.ballerina.compiler.syntax.tree.MarkdownCodeLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.ReturnTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.ballerinalang.diagramutil.connector.generator.GeneratorUtils;
import org.ballerinalang.diagramutil.connector.models.connector.Connector;
import org.ballerinalang.diagramutil.connector.models.connector.Function;
import org.ballerinalang.diagramutil.connector.models.connector.Type;
import org.ballerinalang.diagramutil.connector.models.connector.types.PathParamType;
import org.ballerinalang.docgen.Generator;
import org.ballerinalang.docgen.docs.BallerinaDocGenerator;
import org.ballerinalang.docgen.generator.model.ModuleDoc;

public final class ConnectorGenerator {
    private ConnectorGenerator() {
    }

    public static List<Connector> getProjectConnectors(Project project, boolean detailed, String query) {
        ArrayList<Connector> connectorsList = new ArrayList<Connector>();
        Package currentPackage = project.currentPackage();
        String packageName = currentPackage.packageName().toString();
        String version = currentPackage.packageVersion().toString();
        String orgName = currentPackage.packageOrg().toString();
        currentPackage.modules().forEach(module -> module.documentIds().forEach(documentId -> {
            SyntaxTree syntaxTree = module.document(documentId).syntaxTree();
            SemanticModel semanticModel = module.getCompilation().getSemanticModel();
            String moduleName = module.moduleName().toString();
            if (!syntaxTree.containsModulePart()) {
                return;
            }
            ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
            for (Node node : modulePartNode.members()) {
                if (node.kind() != SyntaxKind.CLASS_DEFINITION) {
                    return;
                }
                ClassDefinitionNode classDefinition = (ClassDefinitionNode)node;
                if (!classDefinition.visibilityQualifier().isPresent() || !((Token)classDefinition.visibilityQualifier().get()).kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD) || !Generator.containsToken((NodeList)classDefinition.classTypeQualifiers(), (SyntaxKind)SyntaxKind.CLIENT_KEYWORD)) continue;
                String connectorName = classDefinition.className().text();
                String description = ConnectorGenerator.getDocFromMetadata(classDefinition.metadata());
                Map<String, String> connectorAnnotation = ConnectorGenerator.getDisplayAnnotationFromMetadataNode(classDefinition.metadata());
                if (detailed) {
                    List<Function> functions = ConnectorGenerator.getConnectorFunctions(semanticModel, classDefinition);
                    connectorsList.add(new Connector(orgName, moduleName, packageName, version, connectorName, description, connectorAnnotation, functions));
                    continue;
                }
                if (!query.isEmpty() && !orgName.toLowerCase(Locale.ROOT).contains(query) && !moduleName.toLowerCase(Locale.ROOT).contains(query) && !connectorName.toLowerCase(Locale.ROOT).contains(query) && (connectorAnnotation.get("label") == null || !connectorAnnotation.get("label").toLowerCase(Locale.ROOT).contains(query))) continue;
                connectorsList.add(new Connector(orgName, moduleName, packageName, version, connectorName, description, connectorAnnotation));
            }
        }));
        return connectorsList;
    }

    public static List<Connector> generateConnectorModel(Project project) throws IOException {
        ArrayList<Connector> connectors = new ArrayList<Connector>();
        Map moduleDocMap = BallerinaDocGenerator.generateModuleDocMap((Project)project);
        for (Map.Entry moduleDoc : moduleDocMap.entrySet()) {
            SemanticModel model = ((ModuleDoc)moduleDoc.getValue()).semanticModel;
            for (Map.Entry syntaxTreeMapEntry : ((ModuleDoc)moduleDoc.getValue()).syntaxTreeMap.entrySet()) {
                connectors.addAll(ConnectorGenerator.getConnectorModelFromSyntaxTree((SyntaxTree)syntaxTreeMapEntry.getValue(), model, project.currentPackage().packageOrg().value(), project.currentPackage().packageName().value(), project.currentPackage().packageVersion().toString(), (String)moduleDoc.getKey()));
            }
        }
        return connectors;
    }

    public static List<Connector> getConnectorModelFromSyntaxTree(SyntaxTree syntaxTree, SemanticModel semanticModel, String orgName, String packageName, String version, String moduleName) {
        Type.clearVisitedTypeMap();
        ArrayList<Connector> connectorsList = new ArrayList<Connector>();
        if (!syntaxTree.containsModulePart()) {
            return connectorsList;
        }
        ModulePartNode modulePartNode = (ModulePartNode)syntaxTree.rootNode();
        for (Node node : modulePartNode.members()) {
            ClassDefinitionNode classDefinition;
            if (node.kind() != SyntaxKind.CLASS_DEFINITION || (classDefinition = (ClassDefinitionNode)node).visibilityQualifier().isEmpty() || !((Token)classDefinition.visibilityQualifier().get()).kind().equals((Object)SyntaxKind.PUBLIC_KEYWORD) || !Generator.containsToken((NodeList)classDefinition.classTypeQualifiers(), (SyntaxKind)SyntaxKind.CLIENT_KEYWORD)) continue;
            String connectorName = classDefinition.className().text();
            String description = GeneratorUtils.getDocFromMetadata(classDefinition.metadata());
            Map<String, String> connectorAnnotation = GeneratorUtils.getDisplayAnnotationFromMetadataNode(classDefinition.metadata());
            if (!connectorAnnotation.isEmpty() && connectorAnnotation.containsKey("label") && !connectorAnnotation.get("label").isEmpty()) {
                connectorName = connectorAnnotation.get("label");
            }
            List<Function> functions = ConnectorGenerator.getConnectorFunctions(semanticModel, classDefinition);
            connectorsList.add(new Connector(orgName, moduleName, packageName, version, connectorName, description, connectorAnnotation, functions));
        }
        return connectorsList;
    }

    private static List<Function> getConnectorFunctions(SemanticModel semanticModel, ClassDefinitionNode classDefinition) {
        ArrayList<Function> functions = new ArrayList<Function>();
        for (Node member : classDefinition.members()) {
            FunctionDefinitionNode functionDefinition;
            NodeList qualifierList;
            if (!(member instanceof FunctionDefinitionNode) || !Generator.containsToken((NodeList)(qualifierList = (functionDefinition = (FunctionDefinitionNode)member).qualifierList()), (SyntaxKind)SyntaxKind.PUBLIC_KEYWORD) && !Generator.containsToken((NodeList)qualifierList, (SyntaxKind)SyntaxKind.REMOTE_KEYWORD) && !Generator.containsToken((NodeList)qualifierList, (SyntaxKind)SyntaxKind.RESOURCE_KEYWORD)) continue;
            String functionName = functionDefinition.functionName().text();
            Map<String, String> funcAnnotation = GeneratorUtils.getDisplayAnnotationFromMetadataNode(functionDefinition.metadata());
            FunctionSignatureNode functionSignature = functionDefinition.functionSignature();
            ArrayList<PathParamType> pathParams = new ArrayList<PathParamType>(GeneratorUtils.getPathParameters((NodeList<Node>)functionDefinition.relativeResourcePath()));
            ArrayList<Type> queryParams = new ArrayList<Type>(GeneratorUtils.getFunctionParameters((SeparatedNodeList<ParameterNode>)functionSignature.parameters(), functionDefinition.metadata(), semanticModel));
            Type returnParam = null;
            if (functionSignature.returnTypeDesc().isPresent()) {
                returnParam = GeneratorUtils.getReturnParameter((ReturnTypeDescriptorNode)functionSignature.returnTypeDesc().get(), functionDefinition.metadata(), semanticModel);
            }
            String[] qualifierArr = new String[qualifierList.size()];
            for (int i = 0; i < qualifierList.size(); ++i) {
                qualifierArr[i] = ((Token)qualifierList.get(i)).toString().trim();
            }
            functions.add(new Function(functionName, pathParams, queryParams, returnParam, funcAnnotation, qualifierArr, GeneratorUtils.getDocFromMetadata(functionDefinition.metadata())));
        }
        return functions;
    }

    public static Map<String, String> getDisplayAnnotationFromAnnotationsList(NodeList<AnnotationNode> annotations) {
        HashMap<String, String> displayAnnotation = new HashMap<String, String>();
        Optional<AnnotationNode> optDisplayAnnotation = annotations.stream().filter(annotationNode -> annotationNode.annotReference().toString().equals("display ")).findAny();
        if (!optDisplayAnnotation.isPresent() || !optDisplayAnnotation.get().annotValue().isPresent()) {
            return displayAnnotation;
        }
        ((MappingConstructorExpressionNode)optDisplayAnnotation.get().annotValue().get()).fields().forEach(mappingFieldNode -> {
            if (mappingFieldNode.kind() == SyntaxKind.SPECIFIC_FIELD) {
                SpecificFieldNode fieldNode = (SpecificFieldNode)mappingFieldNode;
                if (fieldNode.fieldName().toString().equals("label") || fieldNode.fieldName().toString().equals("iconPath")) {
                    displayAnnotation.put(fieldNode.fieldName().toString(), fieldNode.valueExpr().isPresent() ? ((ExpressionNode)fieldNode.valueExpr().get()).toSourceCode().replace("\"", "") : "");
                } else {
                    displayAnnotation.put(fieldNode.fieldName().toString(), fieldNode.valueExpr().isPresent() ? ((ExpressionNode)fieldNode.valueExpr().get()).toSourceCode() : "");
                }
            }
        });
        return displayAnnotation;
    }

    public static Map<String, String> getDisplayAnnotationFromMetadataNode(Optional<MetadataNode> optionalMetadataNode) {
        Map<String, String> result = Collections.emptyMap();
        if (optionalMetadataNode.isPresent()) {
            result = ConnectorGenerator.getDisplayAnnotationFromAnnotationsList((NodeList<AnnotationNode>)optionalMetadataNode.get().annotations());
        }
        return result;
    }

    private static String getDocFromMetadata(Optional<MetadataNode> optionalMetadataNode) {
        String result;
        if (optionalMetadataNode.isEmpty()) {
            result = "";
        } else {
            StringBuilder doc = new StringBuilder();
            Optional docLines = optionalMetadataNode.get().documentationString();
            if (docLines.isEmpty()) {
                result = doc.toString();
            } else {
                for (Node docLine : ((MarkdownDocumentationNode)docLines.get()).documentationLines()) {
                    if (docLine.kind() == SyntaxKind.MARKDOWN_DOCUMENTATION_LINE) {
                        String mdLine = !((MarkdownDocumentationLineNode)docLine).documentElements().isEmpty() ? ConnectorGenerator.getDocLineString((NodeList<Node>)((MarkdownDocumentationLineNode)docLine).documentElements()) : "\n";
                        doc.append(mdLine);
                        continue;
                    }
                    if (docLine.kind() != SyntaxKind.MARKDOWN_CODE_BLOCK) break;
                    doc.append(ConnectorGenerator.getDocCodeBlockString((MarkdownCodeBlockNode)docLine));
                }
                result = doc.toString();
            }
        }
        return result;
    }

    private static String getDocLineString(NodeList<Node> documentElements) {
        if (documentElements.isEmpty()) {
            return "";
        }
        StringBuilder doc = new StringBuilder();
        for (Node docNode : documentElements) {
            doc.append(docNode.toString());
        }
        return doc.toString();
    }

    private static String getDocCodeBlockString(MarkdownCodeBlockNode markdownCodeBlockNode) {
        StringBuilder doc = new StringBuilder();
        doc.append(markdownCodeBlockNode.startBacktick().toString());
        markdownCodeBlockNode.langAttribute().ifPresent(doc::append);
        for (MarkdownCodeLineNode codeLineNode : markdownCodeBlockNode.codeLines()) {
            doc.append(codeLineNode.codeDescription().toString());
        }
        doc.append(markdownCodeBlockNode.endBacktick().toString());
        return doc.toString();
    }
}

