/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.diagramutil.connector.models.connector;

import com.google.gson.annotations.Expose;
import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.Documentation;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.MapTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ObjectTypeSymbol;
import io.ballerina.compiler.api.symbols.ParameterKind;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.StreamTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TableTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.IntersectionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MapTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.StreamTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.StreamTypeParamsNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TableTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.UnionTypeDescriptorNode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import org.ballerinalang.diagramutil.connector.models.connector.TypeInfo;
import org.ballerinalang.diagramutil.connector.models.connector.VisitedType;
import org.ballerinalang.diagramutil.connector.models.connector.types.ArrayType;
import org.ballerinalang.diagramutil.connector.models.connector.types.EnumType;
import org.ballerinalang.diagramutil.connector.models.connector.types.ErrorType;
import org.ballerinalang.diagramutil.connector.models.connector.types.InclusionType;
import org.ballerinalang.diagramutil.connector.models.connector.types.IntersectionType;
import org.ballerinalang.diagramutil.connector.models.connector.types.MapType;
import org.ballerinalang.diagramutil.connector.models.connector.types.ObjectType;
import org.ballerinalang.diagramutil.connector.models.connector.types.PrimitiveType;
import org.ballerinalang.diagramutil.connector.models.connector.types.RecordType;
import org.ballerinalang.diagramutil.connector.models.connector.types.StreamType;
import org.ballerinalang.diagramutil.connector.models.connector.types.TableType;
import org.ballerinalang.diagramutil.connector.models.connector.types.UnionType;

public class Type {
    private static final Map<String, VisitedType> visitedTypeMap = new HashMap<String, VisitedType>();
    @Expose
    public String name;
    @Expose
    public String typeName;
    @Expose
    public boolean optional;
    @Expose
    public TypeInfo typeInfo;
    @Expose
    public boolean defaultable;
    @Expose
    public String defaultValue;
    @Expose
    public Map<String, String> displayAnnotation;
    @Expose
    public String documentation;
    @Expose
    public boolean isRestType;
    @Expose
    public String value;
    @Expose
    public boolean selected = false;

    public Type() {
    }

    public Type(String name, String typeName, boolean optional, TypeInfo typeInfo, boolean defaultable, String defaultValue, Map<String, String> displayAnnotation, String documentation) {
        this.name = name;
        this.typeName = typeName;
        this.optional = optional;
        this.typeInfo = typeInfo;
        this.defaultable = defaultable;
        this.defaultValue = defaultValue;
        this.displayAnnotation = displayAnnotation;
        this.documentation = documentation;
    }

    public static void clearVisitedTypeMap() {
        visitedTypeMap.clear();
    }

    public static Optional<Type> fromSyntaxNode(Node node, SemanticModel semanticModel) {
        Optional<Type> type = Optional.empty();
        switch (node.kind()) {
            case SIMPLE_NAME_REFERENCE: 
            case QUALIFIED_NAME_REFERENCE: {
                Optional optSymbol = Optional.empty();
                try {
                    optSymbol = semanticModel.symbol(node);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (optSymbol == null || !optSymbol.isPresent()) break;
                Symbol symbol = (Symbol)optSymbol.get();
                type = Optional.of(Type.fromSemanticSymbol(symbol));
                Type.clearVisitedTypeMap();
                break;
            }
            case OPTIONAL_TYPE_DESC: {
                OptionalTypeDescriptorNode optionalTypeDescriptorNode = (OptionalTypeDescriptorNode)node;
                type = Type.fromSyntaxNode(optionalTypeDescriptorNode.typeDescriptor(), semanticModel);
                if (!type.isPresent()) break;
                Type optionalType = type.get();
                optionalType.optional = true;
                type = Optional.of(optionalType);
                break;
            }
            case UNION_TYPE_DESC: {
                UnionType unionType = new UnionType();
                Type.flattenUnionNode(node, semanticModel, unionType.members);
                type = Optional.of(unionType);
                break;
            }
            case INTERSECTION_TYPE_DESC: {
                IntersectionType intersectionType = new IntersectionType();
                Type.flattenIntersectionNode(node, semanticModel, intersectionType.members);
                type = Optional.of(intersectionType);
                break;
            }
            case ARRAY_TYPE_DESC: {
                ArrayTypeDescriptorNode arrayTypeDescriptorNode = (ArrayTypeDescriptorNode)node;
                Optional<Type> syntaxNode = Type.fromSyntaxNode((Node)arrayTypeDescriptorNode.memberTypeDesc(), semanticModel);
                if (!syntaxNode.isPresent()) break;
                type = Optional.of(new ArrayType(syntaxNode.get()));
                break;
            }
            case STREAM_TYPE_DESC: {
                StreamTypeDescriptorNode streamNode = (StreamTypeDescriptorNode)node;
                StreamTypeParamsNode streamParams = streamNode.streamTypeParamsNode().isPresent() ? (StreamTypeParamsNode)streamNode.streamTypeParamsNode().get() : null;
                Optional<Type> leftParam = Optional.empty();
                Optional<Type> rightParam = Optional.empty();
                if (streamParams != null) {
                    leftParam = Type.fromSyntaxNode(streamParams.leftTypeDescNode(), semanticModel);
                    if (streamParams.rightTypeDescNode().isPresent()) {
                        rightParam = Type.fromSyntaxNode((Node)streamParams.rightTypeDescNode().get(), semanticModel);
                    }
                }
                type = Optional.of(new StreamType(leftParam, rightParam));
                break;
            }
            case RECORD_TYPE_DESC: {
                RecordTypeDescriptorNode recordNode = (RecordTypeDescriptorNode)node;
                ArrayList<Type> fields = new ArrayList<Type>();
                recordNode.fields().forEach(node1 -> {
                    Optional<Type> optionalType = Type.fromSyntaxNode(node1, semanticModel);
                    optionalType.ifPresent(fields::add);
                });
                Optional<Type> restType = recordNode.recordRestDescriptor().isPresent() ? Type.fromSyntaxNode(((RecordRestDescriptorNode)recordNode.recordRestDescriptor().get()).typeName(), semanticModel) : Optional.empty();
                type = Optional.of(new RecordType(fields, restType));
                break;
            }
            case RECORD_FIELD: {
                RecordFieldNode recordField = (RecordFieldNode)node;
                type = Type.fromSyntaxNode(recordField.typeName(), semanticModel);
                if (!type.isPresent()) break;
                Type recordType = type.get();
                recordType.name = recordField.fieldName().text();
                type = Optional.of(recordType);
                break;
            }
            case MAP_TYPE_DESC: {
                MapTypeDescriptorNode mapNode = (MapTypeDescriptorNode)node;
                Optional<Type> mapStNode = Type.fromSyntaxNode((Node)mapNode.mapTypeParamsNode().typeNode(), semanticModel);
                if (!mapStNode.isPresent()) break;
                type = Optional.of(new MapType(mapStNode.get()));
                break;
            }
            case TABLE_TYPE_DESC: {
                TableTypeDescriptorNode tableTypeNode = (TableTypeDescriptorNode)node;
                Optional optTableTypeSymbol = Optional.empty();
                TableTypeSymbol tableTypeSymbol = null;
                List keySpecifiers = null;
                try {
                    optTableTypeSymbol = semanticModel.symbol((Node)tableTypeNode);
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
                if (optTableTypeSymbol != null && optTableTypeSymbol.isPresent()) {
                    tableTypeSymbol = (TableTypeSymbol)optTableTypeSymbol.get();
                }
                if (tableTypeSymbol != null) {
                    keySpecifiers = tableTypeSymbol.keySpecifiers();
                }
                if (tableTypeNode.keyConstraintNode().isEmpty()) break;
                Node keyConstraint = (Node)tableTypeNode.keyConstraintNode().get();
                Optional<Type> tableStNode = Type.fromSyntaxNode(tableTypeNode.rowTypeParameterNode(), semanticModel);
                Optional<Type> constraintStNode = Type.fromSyntaxNode(keyConstraint, semanticModel);
                if (!tableStNode.isPresent() || !constraintStNode.isPresent()) break;
                type = Optional.of(new TableType(tableStNode.get(), keySpecifiers, constraintStNode.get()));
                break;
            }
            default: {
                if (node instanceof BuiltinSimpleNameReferenceNode) {
                    BuiltinSimpleNameReferenceNode builtinSimpleNameReferenceNode = (BuiltinSimpleNameReferenceNode)node;
                    type = Optional.of(new PrimitiveType(builtinSimpleNameReferenceNode.name().text()));
                    break;
                }
                type = Optional.of(new PrimitiveType(node.toSourceCode()));
            }
        }
        return type;
    }

    public static void flattenUnionNode(Node node, SemanticModel semanticModel, List<Type> fields) {
        if (node.kind() == SyntaxKind.UNION_TYPE_DESC) {
            UnionTypeDescriptorNode unionTypeNode = (UnionTypeDescriptorNode)node;
            Type.flattenUnionNode((Node)unionTypeNode.leftTypeDesc(), semanticModel, fields);
            Type.flattenUnionNode((Node)unionTypeNode.rightTypeDesc(), semanticModel, fields);
            return;
        }
        Optional<Type> optionalType = Type.fromSyntaxNode(node, semanticModel);
        optionalType.ifPresent(fields::add);
    }

    public static void flattenIntersectionNode(Node node, SemanticModel semanticModel, List<Type> fields) {
        if (node.kind() == SyntaxKind.INTERSECTION_TYPE_DESC) {
            IntersectionTypeDescriptorNode intersectionTypeNode = (IntersectionTypeDescriptorNode)node;
            Type.flattenUnionNode(intersectionTypeNode.leftTypeDesc(), semanticModel, fields);
            Type.flattenUnionNode(intersectionTypeNode.rightTypeDesc(), semanticModel, fields);
            return;
        }
        Optional<Type> optionalType = Type.fromSyntaxNode(node, semanticModel);
        optionalType.ifPresent(fields::add);
    }

    public static VisitedType getVisitedType(String typeName) {
        if (visitedTypeMap.containsKey(typeName)) {
            return visitedTypeMap.get(typeName);
        }
        return null;
    }

    public static void completeVisitedTypeEntry(String typeName, Type typeNode) {
        VisitedType visitedType = visitedTypeMap.get(typeName);
        visitedType.setCompleted(true);
        visitedType.setTypeNode(typeNode);
    }

    public static Type fromSemanticSymbol(Symbol symbol) {
        return Type.fromSemanticSymbol(symbol, null);
    }

    public static Type fromSemanticSymbol(Symbol symbol, SemanticModel semanticModel) {
        return Type.fromSemanticSymbol(symbol, new HashMap<String, String>(), semanticModel);
    }

    private static Type fromSemanticSymbol(Symbol symbol, Map<String, String> documentationMap, SemanticModel semanticModel) {
        Type type = null;
        if (symbol instanceof TypeReferenceTypeSymbol) {
            TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)symbol;
            type = Type.getEnumType(typeReferenceTypeSymbol, symbol, documentationMap, semanticModel);
        } else if (symbol instanceof RecordTypeSymbol) {
            RecordTypeSymbol recordTypeSymbol = (RecordTypeSymbol)symbol;
            String typeName2 = String.valueOf(recordTypeSymbol.hashCode());
            VisitedType visitedType = Type.getVisitedType(typeName2);
            if (visitedType != null) {
                return Type.getAlreadyVisitedType(symbol, typeName2, visitedType, false);
            }
            if (typeName2.contains("record {")) {
                type = Type.getRecordType(recordTypeSymbol, documentationMap, semanticModel);
            } else {
                visitedTypeMap.put(typeName2, new VisitedType());
                type = Type.getRecordType(recordTypeSymbol, documentationMap, semanticModel);
                Type.completeVisitedTypeEntry(typeName2, type);
            }
        } else if (symbol instanceof ArrayTypeSymbol) {
            ArrayTypeSymbol arrayTypeSymbol = (ArrayTypeSymbol)symbol;
            type = new ArrayType(Type.fromSemanticSymbol((Symbol)arrayTypeSymbol.memberTypeDescriptor(), documentationMap, semanticModel));
        } else if (symbol instanceof MapTypeSymbol) {
            MapTypeSymbol mapTypeSymbol = (MapTypeSymbol)symbol;
            type = new MapType(Type.fromSemanticSymbol((Symbol)mapTypeSymbol.typeParam(), documentationMap, semanticModel));
        } else if (symbol instanceof TableTypeSymbol) {
            TableTypeSymbol tableTypeSymbol = (TableTypeSymbol)symbol;
            TypeSymbol keyConstraint = null;
            if (tableTypeSymbol.keyConstraintTypeParameter().isPresent()) {
                keyConstraint = (TypeSymbol)tableTypeSymbol.keyConstraintTypeParameter().get();
            }
            type = new TableType(Type.fromSemanticSymbol((Symbol)tableTypeSymbol.rowTypeParameter(), documentationMap, semanticModel), tableTypeSymbol.keySpecifiers(), Type.fromSemanticSymbol((Symbol)keyConstraint, documentationMap, semanticModel));
        } else if (symbol instanceof UnionTypeSymbol) {
            UnionTypeSymbol unionSymbol = (UnionTypeSymbol)symbol;
            String typeName3 = String.valueOf(unionSymbol.hashCode());
            VisitedType visitedType = Type.getVisitedType(typeName3);
            if (visitedType != null) {
                return Type.getAlreadyVisitedType(symbol, typeName3, visitedType, true);
            }
            visitedTypeMap.put(typeName3, new VisitedType());
            type = Type.getUnionType(unionSymbol, documentationMap, semanticModel);
            Type.completeVisitedTypeEntry(typeName3, type);
        } else if (symbol instanceof ErrorTypeSymbol) {
            ErrorTypeSymbol errSymbol = (ErrorTypeSymbol)symbol;
            ErrorType errType = new ErrorType();
            if (errSymbol.detailTypeDescriptor() instanceof TypeReferenceTypeSymbol) {
                errType.detailType = Type.fromSemanticSymbol((Symbol)errSymbol.detailTypeDescriptor(), documentationMap, semanticModel);
            }
            type = errType;
        } else if (symbol instanceof IntersectionTypeSymbol) {
            IntersectionTypeSymbol intersectionTypeSymbol = (IntersectionTypeSymbol)symbol;
            String typeName4 = String.valueOf(intersectionTypeSymbol.hashCode());
            VisitedType visitedType = Type.getVisitedType(typeName4);
            if (visitedType != null) {
                return Type.getAlreadyVisitedType(symbol, typeName4, visitedType, false);
            }
            visitedTypeMap.put(typeName4, new VisitedType());
            type = Type.getIntersectionType(intersectionTypeSymbol, documentationMap, semanticModel);
            Type.completeVisitedTypeEntry(typeName4, type);
        } else if (symbol instanceof StreamTypeSymbol) {
            StreamTypeSymbol streamTypeSymbol = (StreamTypeSymbol)symbol;
            type = Type.getStreamType(streamTypeSymbol, documentationMap, semanticModel);
        } else if (symbol instanceof ObjectTypeSymbol) {
            ObjectTypeSymbol objectTypeSymbol = (ObjectTypeSymbol)symbol;
            ObjectType objectType = new ObjectType();
            objectTypeSymbol.fieldDescriptors().forEach((typeName, typeSymbol) -> {
                Type semanticSymbol = Type.fromSemanticSymbol((Symbol)typeSymbol, documentationMap, semanticModel);
                if (semanticSymbol != null) {
                    objectType.fields.add(semanticSymbol);
                }
            });
            objectTypeSymbol.typeInclusions().forEach(typeSymbol -> {
                Type semanticSymbol = Type.fromSemanticSymbol((Symbol)typeSymbol, documentationMap, semanticModel);
                if (semanticSymbol != null) {
                    objectType.fields.add(new InclusionType(semanticSymbol));
                }
            });
            type = objectType;
        } else if (symbol instanceof RecordFieldSymbol) {
            RecordFieldSymbol recordFieldSymbol = (RecordFieldSymbol)symbol;
            type = Type.fromSemanticSymbol((Symbol)recordFieldSymbol.typeDescriptor(), documentationMap, semanticModel);
        } else if (symbol instanceof ParameterSymbol) {
            ParameterSymbol parameterSymbol = (ParameterSymbol)symbol;
            type = Type.fromSemanticSymbol((Symbol)parameterSymbol.typeDescriptor(), documentationMap, semanticModel);
            if (type != null) {
                type.defaultable = parameterSymbol.paramKind() == ParameterKind.DEFAULTABLE;
            }
        } else if (symbol instanceof VariableSymbol) {
            VariableSymbol variableSymbol = (VariableSymbol)symbol;
            type = Type.fromSemanticSymbol((Symbol)variableSymbol.typeDescriptor(), documentationMap, semanticModel);
        } else if (symbol instanceof TypeSymbol) {
            TypeSymbol typeSymbol2 = (TypeSymbol)symbol;
            String typeName5 = typeSymbol2.signature();
            if (typeName5.startsWith("\"") && typeName5.endsWith("\"")) {
                typeName5 = typeName5.substring(1, typeName5.length() - 1);
            }
            type = new PrimitiveType(typeName5);
        } else if (symbol instanceof TypeDefinitionSymbol) {
            TypeDefinitionSymbol typeDefinitionSymbol = (TypeDefinitionSymbol)symbol;
            AtomicReference typeDocumentation = new AtomicReference();
            typeDefinitionSymbol.documentation().ifPresent(doc -> {
                documentationMap.putAll(doc.parameterMap());
                typeDocumentation.set(doc.description().orElse(null));
            });
            type = Type.fromSemanticSymbol((Symbol)typeDefinitionSymbol.typeDescriptor(), documentationMap, semanticModel);
            type.documentation = (String)typeDocumentation.get();
        }
        return type;
    }

    private static Type getAlreadyVisitedType(Symbol symbol, String typeName, VisitedType visitedType, boolean getClone) {
        if (visitedType.isCompleted()) {
            Type existingType = visitedType.getTypeNode();
            if (getClone) {
                if (existingType instanceof UnionType) {
                    UnionType unionType = (UnionType)existingType;
                    return new UnionType(unionType);
                }
                return new Type(existingType.getName(), existingType.getTypeName(), existingType.isOptional(), existingType.getTypeInfo(), existingType.isDefaultable(), existingType.getDefaultValue(), existingType.getDisplayAnnotation(), existingType.getDocumentation());
            }
            if (existingType instanceof RecordType) {
                RecordType recordType = (RecordType)existingType;
                return new RecordType(recordType);
            }
            return existingType;
        }
        Type type = new Type();
        Type.setTypeInfo(typeName, symbol, type);
        return type;
    }

    private static Type getIntersectionType(IntersectionTypeSymbol intersectionTypeSymbol, Map<String, String> documentationMap, SemanticModel semanticModel) {
        IntersectionType intersectionType = new IntersectionType();
        intersectionTypeSymbol.memberTypeDescriptors().forEach(typeSymbol -> {
            Type semanticSymbol = Type.fromSemanticSymbol((Symbol)typeSymbol, documentationMap, semanticModel);
            if (semanticSymbol != null) {
                intersectionType.members.add(semanticSymbol);
            }
        });
        IntersectionType type = intersectionType;
        return type;
    }

    private static Type getUnionType(UnionTypeSymbol unionSymbol, Map<String, String> documentationMap, SemanticModel semanticModel) {
        Type type;
        UnionType unionType = new UnionType();
        unionSymbol.memberTypeDescriptors().forEach(typeSymbol -> {
            Type semanticSymbol = Type.fromSemanticSymbol((Symbol)typeSymbol, documentationMap, semanticModel);
            if (semanticSymbol != null) {
                unionType.members.add(semanticSymbol);
            }
        });
        if (unionType.members.stream().allMatch(type1 -> type1 instanceof ErrorType)) {
            ErrorType errType = new ErrorType();
            errType.isErrorUnion = true;
            errType.errorUnion = unionType;
            type = errType;
        } else {
            type = unionType;
        }
        return type;
    }

    private static Type getRecordType(RecordTypeSymbol recordTypeSymbol, Map<String, String> documentationMap, SemanticModel semanticModel) {
        ArrayList<Type> fields = new ArrayList<Type>();
        Type.collectRecordDocumentation(recordTypeSymbol, semanticModel, documentationMap);
        recordTypeSymbol.fieldDescriptors().forEach((name, field) -> {
            Type subType = Type.fromSemanticSymbol((Symbol)field.typeDescriptor(), documentationMap, semanticModel);
            if (subType != null) {
                subType.setName((String)name);
                subType.setOptional(field.isOptional());
                subType.setDefaultable(field.hasDefaultValue());
                subType.setDocumentation((String)documentationMap.get(name));
                fields.add(subType);
            }
        });
        Type restType = recordTypeSymbol.restTypeDescriptor().isPresent() ? Type.fromSemanticSymbol((Symbol)recordTypeSymbol.restTypeDescriptor().get(), documentationMap, semanticModel) : null;
        RecordType type = new RecordType(fields, restType);
        return type;
    }

    private static void collectRecordDocumentation(RecordTypeSymbol recordTypeSymbol, SemanticModel semanticModel, Map<String, String> documentationMap) {
        recordTypeSymbol.typeInclusions().forEach(includedType -> {
            if (Objects.nonNull(semanticModel) && includedType.getModule().isPresent() && includedType.getName().isPresent()) {
                Object patt0$temp;
                ModuleID id = ((ModuleSymbol)includedType.getModule().get()).id();
                Optional typeByName = semanticModel.types().getTypeByName(id.orgName(), id.moduleName(), "", (String)includedType.getName().get());
                if (typeByName.isPresent() && (patt0$temp = typeByName.get()) instanceof TypeDefinitionSymbol) {
                    TypeDefinitionSymbol typeDefinitionSymbol = (TypeDefinitionSymbol)patt0$temp;
                    Optional documentation = typeDefinitionSymbol.documentation();
                    documentation.ifPresent(documentation1 -> documentationMap.putAll(documentation1.parameterMap()));
                }
            }
        });
        recordTypeSymbol.fieldDescriptors().forEach((name, field) -> {
            String paramDescription = field.documentation().flatMap(Documentation::description).orElse("");
            if (documentationMap.containsKey(name) && !paramDescription.isEmpty()) {
                documentationMap.put((String)name, paramDescription);
            } else if (!documentationMap.containsKey(name)) {
                documentationMap.put((String)name, paramDescription);
            }
        });
    }

    private static Type getEnumType(TypeReferenceTypeSymbol typeReferenceTypeSymbol, Symbol symbol, Map<String, String> documentationMap, SemanticModel semanticModel) {
        Type type;
        if (typeReferenceTypeSymbol.definition().kind().equals((Object)SymbolKind.ENUM)) {
            ArrayList<Type> fields = new ArrayList<Type>();
            ((UnionTypeSymbol)typeReferenceTypeSymbol.typeDescriptor()).memberTypeDescriptors().forEach(typeSymbol -> {
                Type semanticSymbol = Type.fromSemanticSymbol((Symbol)typeSymbol, documentationMap, semanticModel);
                if (semanticSymbol != null) {
                    fields.add(semanticSymbol);
                }
            });
            type = new EnumType(fields);
        } else {
            type = Type.fromSemanticSymbol((Symbol)typeReferenceTypeSymbol.typeDescriptor(), documentationMap, semanticModel);
        }
        Type.setTypeInfo(typeReferenceTypeSymbol.getName().isPresent() ? (String)typeReferenceTypeSymbol.getName().get() : null, symbol, type);
        return type;
    }

    private static Type getStreamType(StreamTypeSymbol streamSymbol, Map<String, String> documentationMap, SemanticModel semanticModel) {
        Type leftType = Type.fromSemanticSymbol((Symbol)streamSymbol.typeParameter(), documentationMap, semanticModel);
        Type rightType = Type.fromSemanticSymbol((Symbol)streamSymbol.completionValueTypeParameter(), documentationMap, semanticModel);
        return new StreamType(leftType, rightType);
    }

    public static void clearParentSymbols() {
        Type.clearVisitedTypeMap();
    }

    private static void setTypeInfo(String typeName, Symbol symbol, Type type) {
        if (type != null && symbol.getName().isPresent() && symbol.getModule().isPresent()) {
            ModuleID moduleID = ((ModuleSymbol)symbol.getModule().get()).id();
            type.typeInfo = new TypeInfo((String)symbol.getName().get(), moduleID.orgName(), moduleID.moduleName(), null, moduleID.version());
            type.name = typeName;
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public boolean isOptional() {
        return this.optional;
    }

    public void setOptional(boolean optional) {
        this.optional = optional;
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    public boolean isDefaultable() {
        return this.defaultable;
    }

    public void setDefaultable(boolean defaultable) {
        this.defaultable = defaultable;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public Map<String, String> getDisplayAnnotation() {
        return this.displayAnnotation;
    }

    public String getDocumentation() {
        return this.documentation;
    }

    public void setDocumentation(String documentation) {
        this.documentation = documentation;
    }

    public void setRestType(boolean restType) {
        this.isRestType = restType;
    }
}

