/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.persist.compiler;

import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ArrayDimensionNode;
import io.ballerina.compiler.syntax.tree.ArrayTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.OptionalTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.projects.ProjectKind;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.persist.compiler.BalException;
import io.ballerina.stdlib.persist.compiler.Constants;
import io.ballerina.stdlib.persist.compiler.DiagnosticsCodes;
import io.ballerina.stdlib.persist.compiler.model.Entity;
import io.ballerina.stdlib.persist.compiler.model.GroupedRelationField;
import io.ballerina.stdlib.persist.compiler.model.IdentityField;
import io.ballerina.stdlib.persist.compiler.model.RelationField;
import io.ballerina.stdlib.persist.compiler.model.RelationType;
import io.ballerina.stdlib.persist.compiler.model.SimpleTypeField;
import io.ballerina.stdlib.persist.compiler.utils.Utils;
import io.ballerina.stdlib.persist.compiler.utils.ValidatorsByDatastore;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.Location;
import java.io.File;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.wso2.ballerinalang.compiler.diagnostic.properties.BNumericProperty;
import org.wso2.ballerinalang.compiler.diagnostic.properties.BStringProperty;

public class PersistModelDefinitionValidator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Map<String, Entity> entities = new HashMap<String, Entity>();
    private final List<String> entityNames = new ArrayList<String>();
    private final List<String> enumTypes = new ArrayList<String>();
    private final Map<String, List<RelationField>> deferredRelationKeyEntities = new HashMap<String, List<RelationField>>();
    private final Map<String, List<GroupedRelationField>> deferredGroupedRelationKeyEntities = new HashMap<String, List<GroupedRelationField>>();

    public void perform(SyntaxNodeAnalysisContext ctx) {
        TypeDescriptorNode typeDescriptorNode;
        String datastore;
        if (!this.isPersistModelDefinitionDocument(ctx)) {
            return;
        }
        if (Utils.hasCompilationErrors(ctx)) {
            return;
        }
        try {
            datastore = Utils.getDatastore(ctx);
        }
        catch (BalException e) {
            throw new RuntimeException(e);
        }
        if (ctx.node() instanceof ImportPrefixNode) {
            Token prefix = ((ImportPrefixNode)ctx.node()).prefix();
            if (prefix.kind() != SyntaxKind.UNDERSCORE_KEYWORD) {
                int startOffset = ctx.node().location().textRange().startOffset() - 1;
                int length = ctx.node().location().textRange().length() + 1;
                ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)new DiagnosticInfo(DiagnosticsCodes.PERSIST_102.getCode(), DiagnosticsCodes.PERSIST_102.getMessage(), DiagnosticsCodes.PERSIST_102.getSeverity()), (Location)ctx.node().location(), List.of(new BNumericProperty((Number)startOffset), new BNumericProperty((Number)length)), (Object[])new Object[0]));
            }
            return;
        }
        ModulePartNode rootNode = (ModulePartNode)ctx.node();
        ArrayList<String> entityNames = new ArrayList<String>();
        ArrayList<TypeDefinitionNode> foundEntities = new ArrayList<TypeDefinitionNode>();
        for (ModuleMemberDeclarationNode member : rootNode.members()) {
            if (member instanceof TypeDefinitionNode) {
                TypeDefinitionNode typeDefinitionNode = (TypeDefinitionNode)member;
                typeDescriptorNode = (TypeDescriptorNode)typeDefinitionNode.typeDescriptor();
                if (typeDescriptorNode instanceof RecordTypeDescriptorNode) {
                    String entityName = Utils.stripEscapeCharacter(typeDefinitionNode.typeName().text().trim());
                    if (entityNames.contains(entityName.toLowerCase(Locale.ROOT))) {
                        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)new DiagnosticInfo(DiagnosticsCodes.PERSIST_202.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_202.getMessage(), entityName), DiagnosticsCodes.PERSIST_202.getSeverity()), (Location)typeDefinitionNode.typeName().location(), (Object[])new Object[0]));
                        continue;
                    }
                    foundEntities.add(typeDefinitionNode);
                    entityNames.add(entityName.toLowerCase(Locale.ROOT));
                    this.entityNames.add(entityName);
                    continue;
                }
            } else if (member instanceof EnumDeclarationNode) {
                String enumTypeName = Utils.stripEscapeCharacter(((EnumDeclarationNode)member).identifier().text().trim());
                this.enumTypes.add(enumTypeName);
                continue;
            }
            ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)new DiagnosticInfo(DiagnosticsCodes.PERSIST_101.getCode(), DiagnosticsCodes.PERSIST_101.getMessage(), DiagnosticsCodes.PERSIST_101.getSeverity()), (Location)member.location(), (Object[])new Object[0]));
        }
        for (TypeDefinitionNode typeDefinitionNode : foundEntities) {
            String entityName = Utils.stripEscapeCharacter(typeDefinitionNode.typeName().text().trim());
            typeDescriptorNode = (TypeDescriptorNode)typeDefinitionNode.typeDescriptor();
            List<AnnotationNode> annotations = typeDefinitionNode.metadata().map(metadata -> metadata.annotations().stream().toList()).orElse(Collections.emptyList());
            Entity entity = new Entity(entityName, typeDefinitionNode.typeName().location(), (RecordTypeDescriptorNode)typeDescriptorNode, annotations);
            this.validateEntityRecordProperties(entity);
            this.validateEntityFields(entity, datastore);
            this.validateIdentityFields(entity);
            this.validateEntityRelations(entity);
            if (this.deferredRelationKeyEntities.containsKey(entityName)) {
                List<RelationField> relationFields = this.deferredRelationKeyEntities.get(entityName);
                for (RelationField relationField : relationFields) {
                    this.validateRelation(relationField, this.entities.get(relationField.getContainingEntity()), entity, entity);
                }
            }
            if (this.deferredGroupedRelationKeyEntities.containsKey(entityName)) {
                List<GroupedRelationField> groupedRelationFields = this.deferredGroupedRelationKeyEntities.get(entityName);
                for (GroupedRelationField groupedRelationField : groupedRelationFields) {
                    this.validateGroupedRelation(groupedRelationField, this.entities.get(groupedRelationField.getContainingEntity()), entity, entity);
                }
            }
            this.entities.put(entityName, entity);
            entity.getDiagnostics().forEach(arg_0 -> ((SyntaxNodeAnalysisContext)ctx).reportDiagnostic(arg_0));
        }
    }

    private void validateEntityRecordProperties(Entity entity) {
        RecordTypeDescriptorNode recordTypeDescriptorNode = entity.getTypeDescriptorNode();
        if (recordTypeDescriptorNode.bodyStartDelimiter().kind() != SyntaxKind.OPEN_BRACE_PIPE_TOKEN) {
            entity.reportDiagnostic(DiagnosticsCodes.PERSIST_201.getCode(), DiagnosticsCodes.PERSIST_201.getMessage(), DiagnosticsCodes.PERSIST_201.getSeverity(), recordTypeDescriptorNode.location(), List.of(new BNumericProperty((Number)recordTypeDescriptorNode.bodyStartDelimiter().textRange().endOffset()), new BNumericProperty((Number)recordTypeDescriptorNode.bodyEndDelimiter().textRange().startOffset())));
        }
    }

    private void validateEntityFields(Entity entity, String datastore) {
        RecordTypeDescriptorNode typeDescriptorNode = entity.getTypeDescriptorNode();
        if (typeDescriptorNode.recordRestDescriptor().isPresent()) {
            entity.reportDiagnostic(DiagnosticsCodes.PERSIST_301.getCode(), DiagnosticsCodes.PERSIST_301.getMessage(), DiagnosticsCodes.PERSIST_301.getSeverity(), ((RecordRestDescriptorNode)typeDescriptorNode.recordRestDescriptor().get()).location());
        }
        NodeList fields = typeDescriptorNode.fields();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Node fieldNode : fields) {
            Object fieldType;
            Node typeNode;
            int length;
            int startOffset;
            String fieldName;
            RecordFieldNode recordFieldNode;
            IdentityField identityField = null;
            boolean isIdentityField = false;
            int readonlyTextRangeStartOffset = 0;
            if (fieldNode instanceof RecordFieldNode) {
                recordFieldNode = (RecordFieldNode)fieldNode;
                fieldName = Utils.stripEscapeCharacter(recordFieldNode.fieldName().text().trim());
                if (recordFieldNode.readonlyKeyword().isPresent()) {
                    isIdentityField = true;
                    readonlyTextRangeStartOffset = ((Token)recordFieldNode.readonlyKeyword().get()).textRange().startOffset();
                    identityField = new IdentityField(fieldName);
                }
            } else {
                if (fieldNode instanceof RecordFieldWithDefaultValueNode) {
                    RecordFieldWithDefaultValueNode defaultField = (RecordFieldWithDefaultValueNode)fieldNode;
                    startOffset = defaultField.fieldName().textRange().endOffset();
                    length = defaultField.semicolonToken().textRange().startOffset() - startOffset;
                    entity.reportDiagnostic(DiagnosticsCodes.PERSIST_302.getCode(), DiagnosticsCodes.PERSIST_302.getMessage(), DiagnosticsCodes.PERSIST_302.getSeverity(), fieldNode.location(), List.of(new BNumericProperty((Number)startOffset), new BNumericProperty((Number)length)));
                    continue;
                }
                entity.reportDiagnostic(DiagnosticsCodes.PERSIST_303.getCode(), DiagnosticsCodes.PERSIST_303.getMessage(), DiagnosticsCodes.PERSIST_303.getSeverity(), fieldNode.location());
                continue;
            }
            List<AnnotationNode> annotations = recordFieldNode.metadata().map(metadata -> metadata.annotations().stream().toList()).orElse(Collections.emptyList());
            if (fieldNames.contains(fieldName.toLowerCase(Locale.ROOT))) {
                entity.reportDiagnostic(DiagnosticsCodes.PERSIST_307.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_307.getMessage(), fieldName), DiagnosticsCodes.PERSIST_307.getSeverity(), recordFieldNode.fieldName().location());
                continue;
            }
            fieldNames.add(fieldName.toLowerCase(Locale.ROOT));
            if (recordFieldNode.questionMarkToken().isPresent()) {
                if (datastore.equals("redis")) {
                    if (recordFieldNode.readonlyKeyword().isPresent()) {
                        startOffset = ((Token)recordFieldNode.questionMarkToken().get()).textRange().startOffset();
                        length = recordFieldNode.semicolonToken().textRange().startOffset() - startOffset;
                        entity.reportDiagnostic(DiagnosticsCodes.PERSIST_309.getCode(), DiagnosticsCodes.PERSIST_309.getMessage(), DiagnosticsCodes.PERSIST_309.getSeverity(), recordFieldNode.location(), List.of(new BNumericProperty((Number)startOffset), new BNumericProperty((Number)length)));
                    }
                } else {
                    startOffset = ((Token)recordFieldNode.questionMarkToken().get()).textRange().startOffset();
                    length = recordFieldNode.semicolonToken().textRange().startOffset() - startOffset;
                    entity.reportDiagnostic(DiagnosticsCodes.PERSIST_304.getCode(), DiagnosticsCodes.PERSIST_304.getMessage(), DiagnosticsCodes.PERSIST_304.getSeverity(), recordFieldNode.location(), List.of(new BNumericProperty((Number)startOffset), new BNumericProperty((Number)length)));
                }
            }
            Node processedTypeNode = typeNode = recordFieldNode.typeName();
            Object typeNamePostfix = "";
            boolean isArrayType = false;
            int arrayStartOffset = 0;
            int arrayLength = 0;
            boolean isOptionalType = false;
            boolean isValidType = false;
            boolean isSimpleType = false;
            int nullableStartOffset = 0;
            if (processedTypeNode instanceof OptionalTypeDescriptorNode) {
                isOptionalType = true;
                OptionalTypeDescriptorNode optionalTypeNode = (OptionalTypeDescriptorNode)processedTypeNode;
                processedTypeNode = optionalTypeNode.typeDescriptor();
                nullableStartOffset = optionalTypeNode.questionMarkToken().textRange().startOffset();
            }
            if (processedTypeNode instanceof ArrayTypeDescriptorNode) {
                isArrayType = true;
                ArrayTypeDescriptorNode arrayTypeDescriptorNode = (ArrayTypeDescriptorNode)processedTypeNode;
                arrayStartOffset = ((ArrayDimensionNode)arrayTypeDescriptorNode.dimensions().get(0)).openBracket().textRange().startOffset();
                arrayLength = ((ArrayDimensionNode)arrayTypeDescriptorNode.dimensions().get(0)).closeBracket().textRange().endOffset() - arrayStartOffset;
                processedTypeNode = arrayTypeDescriptorNode.memberTypeDesc();
                typeNamePostfix = SyntaxKind.OPEN_BRACKET_TOKEN.stringValue() + SyntaxKind.CLOSE_BRACKET_TOKEN.stringValue();
            }
            if (processedTypeNode instanceof BuiltinSimpleNameReferenceNode) {
                String type = ((BuiltinSimpleNameReferenceNode)processedTypeNode).name().text();
                fieldType = type;
                properties = List.of(new BNumericProperty((Number)arrayStartOffset), new BNumericProperty((Number)arrayLength), new BStringProperty((String)(isOptionalType ? type + "?" : type)));
                isValidType = ValidatorsByDatastore.validateSimpleTypes(entity, typeNode, (String)typeNamePostfix, isArrayType, isOptionalType, properties, type, datastore);
                isSimpleType = true;
            } else if (processedTypeNode instanceof QualifiedNameReferenceNode) {
                QualifiedNameReferenceNode qualifiedName = (QualifiedNameReferenceNode)processedTypeNode;
                String modulePrefix = Utils.stripEscapeCharacter(qualifiedName.modulePrefix().text());
                String identifier = Utils.stripEscapeCharacter(qualifiedName.identifier().text());
                fieldType = modulePrefix + ":" + identifier;
                List<BStringProperty> properties = List.of(new BNumericProperty((Number)arrayStartOffset), new BNumericProperty((Number)arrayLength), new BStringProperty((String)(isOptionalType ? (String)fieldType + "?" : fieldType)));
                isValidType = ValidatorsByDatastore.validateImportedTypes(entity, typeNode, isArrayType, isOptionalType, properties, modulePrefix, identifier, datastore);
                isSimpleType = true;
            } else if (processedTypeNode instanceof SimpleNameReferenceNode) {
                typeName = Utils.stripEscapeCharacter(((SimpleNameReferenceNode)processedTypeNode).name().text().trim());
                fieldType = typeName;
                if (this.entityNames.contains(typeName)) {
                    isValidType = true;
                    entity.setContainsRelations(true);
                    entity.addRelationField(new RelationField(fieldName, typeName, typeNode.location().textRange().endOffset(), isOptionalType, nullableStartOffset, isArrayType, arrayStartOffset, arrayLength, recordFieldNode.location(), entity.getEntityName(), annotations));
                } else {
                    if (this.enumTypes.contains(typeName)) {
                        typeName = "enum";
                    }
                    properties = List.of(new BNumericProperty((Number)arrayStartOffset), new BNumericProperty((Number)arrayLength), new BStringProperty((String)(isOptionalType ? typeName + "?" : typeName)));
                    isValidType = ValidatorsByDatastore.validateSimpleTypes(entity, typeNode, (String)typeNamePostfix, isArrayType, isOptionalType, properties, typeName, datastore);
                    isSimpleType = true;
                }
            } else {
                typeName = Utils.getTypeName(processedTypeNode);
                fieldType = typeName;
                if (!isArrayType && !ValidatorsByDatastore.isValidSimpleType(typeName, datastore)) {
                    entity.reportDiagnostic(DiagnosticsCodes.PERSIST_305.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_305.getMessage(), typeName), DiagnosticsCodes.PERSIST_305.getSeverity(), typeNode.location());
                } else if (isArrayType && !ValidatorsByDatastore.isValidArrayType(typeName, datastore)) {
                    entity.reportDiagnostic(DiagnosticsCodes.PERSIST_306.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_306.getMessage(), typeName), DiagnosticsCodes.PERSIST_306.getSeverity(), typeNode.location());
                }
            }
            if (isIdentityField) {
                identityField.setType((String)fieldType);
                identityField.setValidType(isValidType);
                identityField.setNullable(isOptionalType);
                identityField.setNullableStartOffset(nullableStartOffset);
                identityField.setReadonlyTextRangeStartOffset(readonlyTextRangeStartOffset);
                identityField.setTypeLocation(typeNode.location());
                entity.addIdentityField(identityField);
            }
            if (!isSimpleType) continue;
            entity.addNonRelationField(new SimpleTypeField(fieldName, (String)fieldType, isValidType, isOptionalType, isArrayType, fieldNode.location(), typeNode.location(), annotations));
        }
    }

    private void validateIdentityFields(Entity entity) {
        if (entity.getIdentityFields().isEmpty()) {
            entity.reportDiagnostic(DiagnosticsCodes.PERSIST_501.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_501.getMessage(), entity.getEntityName()), DiagnosticsCodes.PERSIST_501.getSeverity(), entity.getEntityNameLocation());
            entity.getNonRelationFields().stream().filter(field -> field.isValidType() && !field.isNullable() && !field.isArrayType() && this.getSupportedIdentityFields().contains(field.getType())).forEach(field -> {
                String codeActionTitle = MessageFormat.format("Mark field ''{0}'' as identity field", field.getName());
                entity.reportDiagnostic(DiagnosticsCodes.PERSIST_001.getCode(), DiagnosticsCodes.PERSIST_001.getMessage(), DiagnosticsCodes.PERSIST_001.getSeverity(), entity.getEntityNameLocation(), List.of(new BNumericProperty((Number)field.getNodeLocation().textRange().startOffset()), new BStringProperty(codeActionTitle), new BStringProperty("readonly ")));
            });
            return;
        }
        for (IdentityField identityField : entity.getIdentityFields()) {
            if (!identityField.isValidType()) continue;
            String type = identityField.getType();
            if (!this.getSupportedIdentityFields().contains(type)) {
                entity.reportDiagnostic(DiagnosticsCodes.PERSIST_503.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_503.getMessage(), type), DiagnosticsCodes.PERSIST_503.getSeverity(), identityField.getTypeLocation(), List.of(new BNumericProperty((Number)identityField.getReadonlyTextRangeStartOffset()), new BNumericProperty((Number)9)));
                continue;
            }
            if (!identityField.isNullable()) continue;
            entity.reportDiagnostic(DiagnosticsCodes.PERSIST_502.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_502.getMessage(), entity.getEntityName()), DiagnosticsCodes.PERSIST_502.getSeverity(), identityField.getTypeLocation(), List.of(new BNumericProperty((Number)identityField.getNullableStartOffset()), new BNumericProperty((Number)1), new BStringProperty(type)));
        }
    }

    private List<String> getSupportedIdentityFields() {
        return List.of("int", "string", "boolean", "decimal", "float");
    }

    private void validateEntityRelations(Entity entity) {
        String referredEntity;
        if (!entity.isContainsRelations()) {
            return;
        }
        for (RelationField relationField : entity.getRelationFields().values()) {
            referredEntity = relationField.getType();
            if (referredEntity.equals(relationField.getContainingEntity())) {
                entity.reportDiagnostic(DiagnosticsCodes.PERSIST_401.getCode(), DiagnosticsCodes.PERSIST_401.getMessage(), DiagnosticsCodes.PERSIST_401.getSeverity(), relationField.getLocation());
                break;
            }
            if (this.entities.containsKey(referredEntity)) {
                this.validateRelation(relationField, entity, this.entities.get(referredEntity), entity);
                this.removeDeferredRelationsFromFirstEntity(entity, referredEntity);
                continue;
            }
            this.deferredRelationKeyEntities.compute(referredEntity, (key, value) -> {
                if (value == null) {
                    value = new ArrayList<RelationField>();
                }
                value.add(relationField);
                return value;
            });
        }
        for (GroupedRelationField groupedRelationField : entity.getGroupedRelationFields().values()) {
            referredEntity = groupedRelationField.getRelationFields().get(0).getType();
            if (referredEntity.equals(groupedRelationField.getContainingEntity())) {
                groupedRelationField.getRelationFields().forEach(field -> entity.reportDiagnostic(DiagnosticsCodes.PERSIST_401.getCode(), DiagnosticsCodes.PERSIST_401.getMessage(), DiagnosticsCodes.PERSIST_401.getSeverity(), field.getLocation()));
                break;
            }
            if (this.entities.containsKey(referredEntity)) {
                this.validateGroupedRelation(groupedRelationField, entity, this.entities.get(referredEntity), entity);
                this.removeDeferredRelationsFromFirstEntity(entity, referredEntity);
                continue;
            }
            this.deferredGroupedRelationKeyEntities.compute(referredEntity, (key, value) -> {
                if (value == null) {
                    value = new ArrayList<GroupedRelationField>();
                }
                value.add(groupedRelationField);
                return value;
            });
        }
    }

    private void removeDeferredRelationsFromFirstEntity(Entity entity, String referredEntity) {
        List<Object> referredFields;
        if (this.deferredRelationKeyEntities.containsKey(entity.getEntityName())) {
            referredFields = this.deferredRelationKeyEntities.get(entity.getEntityName());
            referredFields.removeIf(field -> field.getContainingEntity().equals(referredEntity));
            if (referredFields.isEmpty()) {
                this.deferredRelationKeyEntities.remove(entity.getEntityName());
            }
        }
        if (this.deferredGroupedRelationKeyEntities.containsKey(entity.getEntityName())) {
            referredFields = this.deferredGroupedRelationKeyEntities.get(entity.getEntityName());
            referredFields.removeIf(field -> field.getContainingEntity().equals(referredEntity));
            if (referredFields.isEmpty()) {
                this.deferredGroupedRelationKeyEntities.remove(entity.getEntityName());
            }
        }
    }

    private void validateRelation(RelationField processingField, Entity processingEntity, Entity referredEntity, Entity reportDiagnosticsEntity) {
        String processingEntityName = processingField.getContainingEntity();
        RelationField referredField = referredEntity.getRelationFields().get(processingEntityName);
        if (referredField != null) {
            this.validateRelationType(processingField, processingEntity, referredField, referredEntity, reportDiagnosticsEntity);
            return;
        }
        GroupedRelationField groupedRelationField = referredEntity.getGroupedRelationFields().get(processingEntityName);
        if (groupedRelationField != null) {
            RelationField firstRelationMatch = groupedRelationField.getRelationFields().get(0);
            this.validateRelationType(processingField, processingEntity, firstRelationMatch, referredEntity, reportDiagnosticsEntity);
            for (int i = 1; i < groupedRelationField.getRelationFields().size(); ++i) {
                this.reportMandatoryCorrespondingFieldDiagnostic(groupedRelationField.getRelationFields().get(i), processingEntity, reportDiagnosticsEntity);
            }
            return;
        }
        this.reportMandatoryCorrespondingFieldDiagnostic(processingField, referredEntity, reportDiagnosticsEntity);
    }

    private void validateGroupedRelation(GroupedRelationField processingField, Entity processingEntity, Entity referredEntity, Entity reportDiagnosticsEntity) {
        String processingEntityName = processingField.getContainingEntity();
        GroupedRelationField groupedRelationField = referredEntity.getGroupedRelationFields().get(processingEntityName);
        List<RelationField> processingRelationFields = processingField.getRelationFields();
        if (groupedRelationField != null) {
            int i;
            List<RelationField> referredRelationFields = groupedRelationField.getRelationFields();
            int processingFieldSize = processingRelationFields.size();
            int relatedFieldSize = referredRelationFields.size();
            int minCount = Math.min(processingFieldSize, relatedFieldSize);
            for (i = 0; i < minCount; ++i) {
                RelationField processingRelationField = processingRelationFields.get(i);
                RelationField relatedRelationField = referredRelationFields.get(i);
                this.validateRelationType(processingRelationField, processingEntity, relatedRelationField, referredEntity, reportDiagnosticsEntity);
            }
            if (processingFieldSize < relatedFieldSize) {
                for (i = processingFieldSize; i < groupedRelationField.getRelationFields().size(); ++i) {
                    this.reportMandatoryCorrespondingFieldDiagnostic(groupedRelationField.getRelationFields().get(i), processingEntity, reportDiagnosticsEntity);
                }
            } else if (processingFieldSize > relatedFieldSize) {
                for (i = relatedFieldSize; i < processingField.getRelationFields().size(); ++i) {
                    this.reportMandatoryCorrespondingFieldDiagnostic(processingField.getRelationFields().get(i), referredEntity, reportDiagnosticsEntity);
                }
            } else {
                int i2;
                boolean isOwnerIdentifiable = processingRelationFields.stream().allMatch(RelationField::isOwnerIdentifiable);
                if (!isOwnerIdentifiable) {
                    return;
                }
                long processingFieldOwnerCount = processingRelationFields.stream().filter(field -> field.getOwner().equals(processingEntity.getEntityName())).count();
                if (processingFieldOwnerCount == 0L || processingFieldOwnerCount == (long)processingFieldSize) {
                    return;
                }
                ArrayList processingFieldDiagProperties = new ArrayList();
                processingFieldDiagProperties.add((DiagnosticProperty<?>)new BStringProperty(processingEntityName));
                ArrayList referredFieldDiagProperties = new ArrayList();
                referredFieldDiagProperties.add((DiagnosticProperty<?>)new BStringProperty(referredEntity.getEntityName()));
                for (i2 = 0; i2 < processingFieldSize; ++i2) {
                    RelationField processingRelationField = processingRelationFields.get(i2);
                    RelationField referredRelationField = referredRelationFields.get(i2);
                    if (processingRelationField.getOwner().equals(processingEntityName)) {
                        this.updateSameOwnerDiagnosticProperties(processingRelationField.getRelationType(), referredFieldDiagProperties, referredRelationField, processingRelationField);
                        continue;
                    }
                    this.updateSameOwnerDiagnosticProperties(processingRelationField.getRelationType(), processingFieldDiagProperties, processingRelationField, referredRelationField);
                }
                for (i2 = 0; i2 < processingFieldSize; ++i2) {
                    this.reportDiagnosticsForDifferentOwners(reportDiagnosticsEntity, processingRelationFields.get(i2), processingFieldDiagProperties, referredFieldDiagProperties);
                    this.reportDiagnosticsForDifferentOwners(reportDiagnosticsEntity, referredRelationFields.get(i2), processingFieldDiagProperties, referredFieldDiagProperties);
                }
            }
            return;
        }
        RelationField referredField = referredEntity.getRelationFields().get(processingEntityName);
        if (referredField != null) {
            this.validateRelationType(processingRelationFields.get(0), processingEntity, referredField, referredEntity, reportDiagnosticsEntity);
            for (int i = 1; i < processingField.getRelationFields().size(); ++i) {
                this.reportMandatoryCorrespondingFieldDiagnostic(processingField.getRelationFields().get(i), referredEntity, reportDiagnosticsEntity);
            }
            return;
        }
        for (int i = 0; i < processingField.getRelationFields().size(); ++i) {
            this.reportMandatoryCorrespondingFieldDiagnostic(processingField.getRelationFields().get(i), referredEntity, reportDiagnosticsEntity);
        }
    }

    private void updateSameOwnerDiagnosticProperties(RelationType relationType, List<DiagnosticProperty<?>> referredFieldDiagProperties, RelationField removeField, RelationField addField) {
        if (relationType.equals((Object)RelationType.ONE_TO_ONE)) {
            referredFieldDiagProperties.add((DiagnosticProperty<?>)new BNumericProperty((Number)removeField.getNullableStartOffset()));
            referredFieldDiagProperties.add((DiagnosticProperty<?>)new BNumericProperty((Number)1));
            referredFieldDiagProperties.add((DiagnosticProperty<?>)new BNumericProperty((Number)addField.getTypeEndOffset()));
            referredFieldDiagProperties.add((DiagnosticProperty<?>)new BStringProperty("?"));
        } else {
            referredFieldDiagProperties.add((DiagnosticProperty<?>)new BNumericProperty((Number)removeField.getArrayStartOffset()));
            referredFieldDiagProperties.add((DiagnosticProperty<?>)new BNumericProperty((Number)removeField.getArrayRangeLength()));
            referredFieldDiagProperties.add((DiagnosticProperty<?>)new BNumericProperty((Number)addField.getTypeEndOffset()));
            referredFieldDiagProperties.add((DiagnosticProperty<?>)new BStringProperty("[]"));
        }
    }

    private void reportDiagnosticsForDifferentOwners(Entity reportDiagnosticsEntity, RelationField relationField, List<DiagnosticProperty<?>> processingFieldProperties, List<DiagnosticProperty<?>> referredFieldProperties) {
        reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_403.getCode(), DiagnosticsCodes.PERSIST_403.getMessage(), DiagnosticsCodes.PERSIST_403.getSeverity(), relationField.getLocation());
        reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_004.getCode(), DiagnosticsCodes.PERSIST_004.getMessage(), DiagnosticsCodes.PERSIST_004.getSeverity(), relationField.getLocation(), processingFieldProperties);
        reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_004.getCode(), DiagnosticsCodes.PERSIST_004.getMessage(), DiagnosticsCodes.PERSIST_004.getSeverity(), relationField.getLocation(), referredFieldProperties);
    }

    private void validateRelationType(RelationField processingField, Entity processingEntity, RelationField referredField, Entity referredEntity, Entity reportDiagnosticsEntity) {
        if (!processingField.isArrayType() && !referredField.isArrayType()) {
            if (!processingField.isOptionalType() && !referredField.isOptionalType()) {
                this.reportOwnerUnidentifiableDiagnotics(reportDiagnosticsEntity, processingField.getLocation(), processingField, referredField);
                this.reportOwnerUnidentifiableDiagnotics(reportDiagnosticsEntity, referredField.getLocation(), processingField, referredField);
            } else if (processingField.isOptionalType() && referredField.isOptionalType()) {
                this.reportTwoNillableFieldInOneToOneRelation(reportDiagnosticsEntity, processingField.getLocation(), processingField, referredField);
                this.reportTwoNillableFieldInOneToOneRelation(reportDiagnosticsEntity, referredField.getLocation(), processingField, referredField);
            } else {
                processingField.setRelationType(RelationType.ONE_TO_ONE);
                processingField.setOwnerIdentifiable(true);
                processingField.setOwner(processingField.isOptionalType() ? referredEntity.getEntityName() : processingEntity.getEntityName());
                if (processingField.isOptionalType()) {
                    this.validatePresenceOfForeignKey(referredField, referredEntity, processingEntity, reportDiagnosticsEntity);
                } else {
                    this.validatePresenceOfForeignKey(processingField, processingEntity, referredEntity, reportDiagnosticsEntity);
                }
            }
            return;
        }
        if (processingField.isArrayType() && referredField.isArrayType()) {
            reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_420.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_420.getMessage(), referredEntity.getEntityName()), DiagnosticsCodes.PERSIST_420.getSeverity(), processingField.getLocation());
            reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_420.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_420.getMessage(), referredEntity.getEntityName()), DiagnosticsCodes.PERSIST_420.getSeverity(), referredField.getLocation());
            processingField.setOwnerIdentifiable(false);
            processingField.setRelationType(RelationType.MANY_TO_MANY);
            return;
        }
        boolean isProcessingFiledNillable = this.validateNillableTypeFor1ToMany(processingField, reportDiagnosticsEntity);
        boolean isReferredFieldNillable = this.validateNillableTypeFor1ToMany(referredField, reportDiagnosticsEntity);
        if (!isProcessingFiledNillable && !isReferredFieldNillable) {
            processingField.setRelationType(RelationType.ONE_TO_MANY);
            processingField.setOwnerIdentifiable(true);
            processingField.setOwner(processingField.isArrayType() ? referredEntity.getEntityName() : processingEntity.getEntityName());
        }
        if (!processingField.isArrayType()) {
            this.validatePresenceOfForeignKey(processingField, processingEntity, referredEntity, reportDiagnosticsEntity);
        } else {
            this.validatePresenceOfForeignKey(referredField, referredEntity, processingEntity, reportDiagnosticsEntity);
        }
    }

    private void reportTwoNillableFieldInOneToOneRelation(Entity reportDiagnosticsEntity, NodeLocation location, RelationField processingField, RelationField referredField) {
        reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_405.getCode(), DiagnosticsCodes.PERSIST_405.getMessage(), DiagnosticsCodes.PERSIST_405.getSeverity(), location);
        reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_003.getCode(), DiagnosticsCodes.PERSIST_003.getMessage(), DiagnosticsCodes.PERSIST_003.getSeverity(), location, List.of(new BNumericProperty((Number)processingField.getNullableStartOffset()), new BNumericProperty((Number)1), new BStringProperty(processingField.getContainingEntity() + "." + processingField.getName())));
        reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_003.getCode(), DiagnosticsCodes.PERSIST_003.getMessage(), DiagnosticsCodes.PERSIST_003.getSeverity(), location, List.of(new BNumericProperty((Number)referredField.getNullableStartOffset()), new BNumericProperty((Number)1), new BStringProperty(referredField.getContainingEntity() + "." + referredField.getName())));
    }

    private void reportOwnerUnidentifiableDiagnotics(Entity reportDiagnosticsEntity, NodeLocation location, RelationField processingField, RelationField referredField) {
        reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_404.getCode(), DiagnosticsCodes.PERSIST_404.getMessage(), DiagnosticsCodes.PERSIST_404.getSeverity(), location);
        String codeActionTitle = "Make ''{0}'' entity relation owner";
        reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_002.getCode(), DiagnosticsCodes.PERSIST_002.getMessage(), DiagnosticsCodes.PERSIST_002.getSeverity(), location, List.of(new BNumericProperty((Number)referredField.getTypeEndOffset()), new BStringProperty(MessageFormat.format(codeActionTitle, processingField.getContainingEntity())), new BStringProperty("?")));
        reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_002.getCode(), DiagnosticsCodes.PERSIST_002.getMessage(), DiagnosticsCodes.PERSIST_002.getSeverity(), location, List.of(new BNumericProperty((Number)processingField.getTypeEndOffset()), new BStringProperty(MessageFormat.format(codeActionTitle, referredField.getContainingEntity())), new BStringProperty("?")));
    }

    private void reportMandatoryCorrespondingFieldDiagnostic(RelationField relationField, Entity missingFieldEntity, Entity reportDiagnosticsEntity) {
        NodeList fields = missingFieldEntity.getTypeDescriptorNode().fields();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (Node field : fields) {
            String fieldName = ((RecordFieldNode)field).fieldName().text();
            fieldNames.add(fieldName);
        }
        Node lastField = fields.get(fields.size() - 1);
        int addFieldLocation = lastField.location().textRange().endOffset();
        reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_402.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_402.getMessage(), missingFieldEntity.getEntityName()), DiagnosticsCodes.PERSIST_402.getSeverity(), relationField.getLocation());
        String codeActionTitle = "Add corresponding{0}relation field in ''" + missingFieldEntity.getEntityName() + "'' entity";
        if (!relationField.isArrayType() && !relationField.isOptionalType()) {
            reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_005.getCode(), DiagnosticsCodes.PERSIST_005.getMessage(), DiagnosticsCodes.PERSIST_005.getSeverity(), relationField.getLocation(), List.of(new BNumericProperty((Number)addFieldLocation), new BStringProperty(MessageFormat.format(codeActionTitle, " 1-1 ")), new BStringProperty(MessageFormat.format(Constants.LS + "\t{0}? {1};", relationField.getContainingEntity(), Utils.getFieldName(relationField.getContainingEntity(), fieldNames)))));
            reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_005.getCode(), DiagnosticsCodes.PERSIST_005.getMessage(), DiagnosticsCodes.PERSIST_005.getSeverity(), relationField.getLocation(), List.of(new BNumericProperty((Number)addFieldLocation), new BStringProperty(MessageFormat.format(codeActionTitle, " 1-n ")), new BStringProperty(MessageFormat.format(Constants.LS + "\t{0}[] {1};", relationField.getContainingEntity(), Utils.getFieldName(relationField.getContainingEntity(), fieldNames)))));
        } else {
            reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_005.getCode(), DiagnosticsCodes.PERSIST_005.getMessage(), DiagnosticsCodes.PERSIST_005.getSeverity(), relationField.getLocation(), List.of(new BNumericProperty((Number)addFieldLocation), new BStringProperty(MessageFormat.format(codeActionTitle, " ")), new BStringProperty(MessageFormat.format(Constants.LS + "\t{0} {1};", relationField.getContainingEntity(), Utils.getFieldName(relationField.getContainingEntity(), fieldNames)))));
        }
    }

    private boolean validateNillableTypeFor1ToMany(RelationField field, Entity reportDiagnosticsEntity) {
        if (field.isOptionalType()) {
            Object type = field.isArrayType() ? field.getType() + "[]" : field.getType();
            reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_406.getCode(), DiagnosticsCodes.PERSIST_406.getMessage(), DiagnosticsCodes.PERSIST_406.getSeverity(), field.getLocation(), List.of(new BNumericProperty((Number)field.getNullableStartOffset()), new BNumericProperty((Number)1), new BStringProperty((String)type)));
            return true;
        }
        return false;
    }

    private void validatePresenceOfForeignKey(RelationField ownerRelationField, Entity owner, Entity referredEntity, Entity reportDiagnosticsEntity) {
        for (String identityField : referredEntity.getIdentityFieldNames()) {
            String foreignKey = ownerRelationField.getName().toLowerCase(Locale.ENGLISH) + identityField.substring(0, 1).toUpperCase(Locale.ENGLISH) + identityField.substring(1);
            owner.getNonRelationFields().stream().filter(field -> field.getName().equals(foreignKey)).findFirst().ifPresent(field -> this.validateRelationAnnotationFieldName((SimpleTypeField)field, reportDiagnosticsEntity, foreignKey, referredEntity, ownerRelationField));
        }
    }

    private void validateRelationAnnotationFieldName(SimpleTypeField field, Entity reportDiagnosticsEntity, String foreignKey, Entity referredEntity, RelationField ownerRelationField) {
        List<String> references = Utils.readStringArrayValueFromAnnotation(ownerRelationField.getAnnotations(), "sql:Relation", "keys");
        if (references == null || !references.contains(field.getName())) {
            reportDiagnosticsEntity.reportDiagnostic(DiagnosticsCodes.PERSIST_422.getCode(), MessageFormat.format(DiagnosticsCodes.PERSIST_422.getMessage(), foreignKey, referredEntity.getEntityName()), DiagnosticsCodes.PERSIST_422.getSeverity(), field.getNodeLocation());
        }
    }

    private boolean isPersistModelDefinitionDocument(SyntaxNodeAnalysisContext ctx) {
        try {
            File balProject;
            Path balProjectDir;
            Path balFilePath;
            Path balFileContainingFolder;
            if (ctx.currentPackage().project().kind().equals((Object)ProjectKind.SINGLE_FILE_PROJECT) && (balFileContainingFolder = (balFilePath = ctx.currentPackage().project().sourceRoot().toAbsolutePath()).getParent()) != null && balFileContainingFolder.endsWith("persist") && (balProjectDir = balFileContainingFolder.getParent()) != null && (balProject = balProjectDir.toFile()).isDirectory()) {
                File tomlFile = balProjectDir.resolve("Ballerina.toml").toFile();
                return tomlFile.exists();
            }
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        return false;
    }
}

