/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.hateoas;

import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.openapi.service.mapper.hateoas.HateoasLink;
import io.ballerina.openapi.service.mapper.hateoas.HateoasMapper;
import io.ballerina.openapi.service.mapper.hateoas.Resource;
import io.ballerina.openapi.service.mapper.hateoas.Service;
import io.ballerina.openapi.service.mapper.model.ResourceFunction;
import io.ballerina.openapi.service.mapper.model.ResourceFunctionDeclaration;
import io.ballerina.openapi.service.mapper.model.ResourceFunctionDefinition;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import io.ballerina.openapi.service.mapper.utils.MapperCommonUtils;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HateoasMapperImpl
implements HateoasMapper {
    @Override
    public void setOpenApiLinks(ServiceNode serviceNode, OpenAPI openAPI) {
        Paths paths = openAPI.getPaths();
        Service hateoasService = this.extractHateoasMetaInfo(serviceNode);
        if (hateoasService.getHateoasResourceMapping().isEmpty()) {
            return;
        }
        for (Node node : serviceNode.members()) {
            Optional<ApiResponses> responses;
            Optional<ResourceFunction> resource;
            if (!node.kind().equals((Object)SyntaxKind.RESOURCE_ACCESSOR_DEFINITION) && !node.kind().equals((Object)SyntaxKind.RESOURCE_ACCESSOR_DECLARATION) || (resource = HateoasMapperImpl.getResourceFunction(node)).isEmpty() || (responses = this.getApiResponsesForResource(resource.get(), paths)).isEmpty()) continue;
            this.setOpenApiLinksInApiResponse(hateoasService, resource.get(), responses.get());
        }
    }

    private Service extractHateoasMetaInfo(ServiceNode serviceNode) {
        Service service = new Service();
        for (Node member : serviceNode.members()) {
            Optional<ResourceFunction> resourceFunction = HateoasMapperImpl.getResourceFunction(member);
            resourceFunction.ifPresent(function -> this.addResourceToService((ResourceFunction)function, service));
        }
        return service;
    }

    private void addResourceToService(ResourceFunction resourceFunction, Service service) {
        String resourceMethod = resourceFunction.functionName();
        String operationId = MapperCommonUtils.getOperationId(resourceFunction);
        Optional resourceName = MapperCommonUtils.getResourceConfigAnnotation(resourceFunction).flatMap(resourceConfig -> MapperCommonUtils.getValueForAnnotationFields(resourceConfig, "name"));
        if (resourceName.isEmpty()) {
            return;
        }
        String cleanedResourceName = ((String)resourceName.get()).replaceAll("\"", "");
        Resource hateoasResource = new Resource(resourceMethod, operationId);
        service.addResource(cleanedResourceName, hateoasResource);
    }

    private static Optional<ResourceFunction> getResourceFunction(Node member) {
        if (SyntaxKind.RESOURCE_ACCESSOR_DEFINITION.equals((Object)member.kind())) {
            return Optional.of(new ResourceFunctionDefinition((FunctionDefinitionNode)member));
        }
        if (SyntaxKind.RESOURCE_ACCESSOR_DECLARATION.equals((Object)member.kind())) {
            return Optional.of(new ResourceFunctionDeclaration((MethodDeclarationNode)member));
        }
        return Optional.empty();
    }

    private Optional<ApiResponses> getApiResponsesForResource(ResourceFunction resource, Paths paths) {
        String resourcePath = MapperCommonUtils.unescapeIdentifier(MapperCommonUtils.generateRelativePath(resource));
        if (!paths.containsKey((Object)resourcePath)) {
            return Optional.empty();
        }
        PathItem openApiResource = (PathItem)paths.get((Object)resourcePath);
        String httpMethod = resource.functionName();
        Operation operation = HateoasMapperImpl.getOperation(httpMethod, openApiResource);
        return Objects.isNull(operation) ? Optional.empty() : Optional.ofNullable(operation.getResponses());
    }

    private static Operation getOperation(String httpMethod, PathItem openApiResource) {
        return switch (httpMethod.trim().toUpperCase(Locale.ENGLISH)) {
            case "GET" -> openApiResource.getGet();
            case "PUT" -> openApiResource.getPut();
            case "POST" -> openApiResource.getPost();
            case "DELETE" -> openApiResource.getDelete();
            case "OPTIONS" -> openApiResource.getOptions();
            case "PATCH" -> openApiResource.getPatch();
            case "HEAD" -> openApiResource.getHead();
            default -> null;
        };
    }

    private void setOpenApiLinksInApiResponse(Service hateoasService, ResourceFunction resource, ApiResponses apiResponses) {
        Map<String, Link> swaggerLinks = this.mapHateoasLinksToOpenApiLinks(hateoasService, resource);
        if (swaggerLinks.isEmpty()) {
            return;
        }
        for (Map.Entry entry : apiResponses.entrySet()) {
            int statusCode;
            if (!HateoasMapperImpl.hasOnlyDigits((String)entry.getKey()) || (statusCode = Integer.parseInt((String)entry.getKey())) < 200 || statusCode >= 300) continue;
            ((ApiResponse)entry.getValue()).setLinks(swaggerLinks);
        }
    }

    private static boolean hasOnlyDigits(String stringValue) {
        String regex = "\\d+";
        Pattern p = Pattern.compile(regex);
        if (Objects.isNull(stringValue)) {
            return false;
        }
        Matcher m = p.matcher(stringValue);
        return m.matches();
    }

    private List<HateoasLink> getLinks(String linkedTo) {
        String[] linkArray;
        ArrayList<HateoasLink> links = new ArrayList<HateoasLink>();
        for (String linkString : linkArray = linkedTo.replaceAll("[\\[\\]]", "").split("\\},\\s*")) {
            HateoasLink link = this.parseHateoasLink(linkString);
            links.add(link);
        }
        return links;
    }

    private HateoasLink parseHateoasLink(String input) {
        String[] keyValuePairs;
        HateoasLink hateoasLink = new HateoasLink();
        HashMap<String, String> keyValueMap = new HashMap<String, String>();
        for (String pair : keyValuePairs = input.replaceAll("[{}]", "").split(",\\s*")) {
            String[] parts = pair.split(":\\s*");
            if (parts.length != 2) continue;
            String key = parts[0].trim();
            String value = parts[1].replaceAll("\"", "").trim();
            keyValueMap.put(key, value);
        }
        hateoasLink.setResourceName((String)keyValueMap.get("name"));
        hateoasLink.setRel(keyValueMap.getOrDefault("relation", "_self"));
        hateoasLink.setResourceMethod((String)keyValueMap.get("method"));
        return hateoasLink;
    }

    private Map<String, Link> mapHateoasLinksToOpenApiLinks(Service hateoasService, ResourceFunction resourceFunction) {
        Optional linkedTo = MapperCommonUtils.getResourceConfigAnnotation(resourceFunction).flatMap(resourceConfig -> MapperCommonUtils.getValueForAnnotationFields(resourceConfig, "linkedTo"));
        if (linkedTo.isEmpty()) {
            return Collections.emptyMap();
        }
        List<HateoasLink> links = this.getLinks((String)linkedTo.get());
        HashMap<String, Link> hateoasLinks = new HashMap<String, Link>();
        for (HateoasLink link : links) {
            Optional resource = hateoasService.getHateoasResourceMapping().entrySet().stream().filter(resources -> link.getResourceName().equals(resources.getKey())).findFirst().flatMap(hateoasResourceMapping -> ((List)hateoasResourceMapping.getValue()).stream().filter(hateoasRes -> this.isValidResource(link, (Resource)hateoasRes)).findFirst());
            if (resource.isEmpty()) continue;
            Link openapiLink = new Link();
            String operationId = ((Resource)resource.get()).operationId();
            openapiLink.setOperationId(operationId);
            hateoasLinks.put(link.getRel(), openapiLink);
        }
        return hateoasLinks;
    }

    private boolean isValidResource(HateoasLink link, Resource currentResource) {
        if (Objects.isNull(link.getResourceMethod())) {
            return true;
        }
        return currentResource.resourceMethod().equals(link.getResourceMethod());
    }
}

