/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.pipeline;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.TupleTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.diagnostic.OpenAPIMapperDiagnostic;
import io.ballerina.openapi.service.mapper.interceptor.InterceptorMapperException;
import io.ballerina.openapi.service.mapper.interceptor.model.RequestParameterInfo;
import io.ballerina.openapi.service.mapper.interceptor.model.ResponseInfo;
import io.ballerina.openapi.service.mapper.interceptor.pipeline.RequestParameterCollector;
import io.ballerina.openapi.service.mapper.interceptor.pipeline.ResponseCollector;
import io.ballerina.openapi.service.mapper.interceptor.types.Interceptor;
import io.ballerina.openapi.service.mapper.interceptor.types.RequestErrorInterceptor;
import io.ballerina.openapi.service.mapper.interceptor.types.RequestInterceptor;
import io.ballerina.openapi.service.mapper.interceptor.types.ResponseErrorInterceptor;
import io.ballerina.openapi.service.mapper.interceptor.types.ResponseInterceptor;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.model.ModuleMemberVisitor;
import io.ballerina.openapi.service.mapper.model.ServiceNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class InterceptorPipeline {
    private Interceptor initReqInterceptor = null;
    private Interceptor initResInterceptor = null;
    private final SemanticModel semanticModel;
    private final List<OpenAPIMapperDiagnostic> diagnostics;

    private InterceptorPipeline(AdditionalData additionalData) {
        this.semanticModel = additionalData.semanticModel();
        this.diagnostics = additionalData.diagnostics();
    }

    public static InterceptorPipeline build(ServiceNode serviceDefinition, AdditionalData additionalData) {
        List<Interceptor> interceptors = InterceptorPipeline.buildInterceptors(serviceDefinition, additionalData);
        if (!interceptors.isEmpty()) {
            InterceptorPipeline pipeline = new InterceptorPipeline(additionalData);
            Interceptor prevInterceptor = interceptors.get(0);
            if (prevInterceptor.getType().equals((Object)Interceptor.InterceptorType.REQUEST)) {
                pipeline.initReqInterceptor = prevInterceptor;
            } else if (prevInterceptor instanceof ResponseInterceptor) {
                pipeline.initResInterceptor = prevInterceptor;
            }
            for (int i = 1; i < interceptors.size(); ++i) {
                prevInterceptor.setNextInReqPath(interceptors.get(i));
                interceptors.get(i).setNextInResPath(prevInterceptor);
                prevInterceptor = interceptors.get(i);
                if (prevInterceptor.getType().equals((Object)Interceptor.InterceptorType.REQUEST) && Objects.isNull(pipeline.initReqInterceptor)) {
                    pipeline.initReqInterceptor = prevInterceptor;
                    continue;
                }
                if (!(prevInterceptor instanceof ResponseInterceptor)) continue;
                pipeline.initResInterceptor = prevInterceptor;
            }
            return pipeline;
        }
        return null;
    }

    private static List<Interceptor> buildInterceptors(ServiceNode serviceDefinition, AdditionalData additionalData) {
        SemanticModel semanticModel = additionalData.semanticModel();
        ModuleMemberVisitor moduleMemberVisitor = additionalData.moduleMemberVisitor();
        Optional<TypeSymbol> optInterceptorReturn = serviceDefinition.getInterceptorReturnType(semanticModel);
        if (optInterceptorReturn.isEmpty()) {
            return new ArrayList<Interceptor>();
        }
        TypeSymbol interceptorReturn = optInterceptorReturn.get();
        try {
            if (interceptorReturn instanceof TypeReferenceTypeSymbol) {
                TypeReferenceTypeSymbol interceptorType = (TypeReferenceTypeSymbol)interceptorReturn;
                if (InterceptorPipeline.isSubTypeOf(interceptorReturn, "Interceptor", semanticModel)) {
                    Interceptor.InterceptorType type = InterceptorPipeline.getInterceptorType((TypeSymbol)interceptorType, semanticModel);
                    Interceptor interceptor = InterceptorPipeline.getInterceptor(interceptorType, type, semanticModel, moduleMemberVisitor);
                    return List.of(interceptor);
                }
            }
            if (interceptorReturn instanceof TupleTypeSymbol) {
                TupleTypeSymbol interceptorTupleType = (TupleTypeSymbol)interceptorReturn;
                return InterceptorPipeline.getInterceptorListFromReturnType(interceptorTupleType, semanticModel, moduleMemberVisitor);
            }
        }
        catch (InterceptorMapperException e) {
            InterceptorPipeline.addWarningDiagnostic(additionalData, e.getMessage());
            return new ArrayList<Interceptor>();
        }
        String cause = "the return type of `createInterceptors` function should be defined as a tuple with specific interceptor types as members. For example: `[ResponseInterceptor_, RequestInterceptor_, RequestErrorInterceptor_]`";
        InterceptorPipeline.addWarningDiagnostic(additionalData, cause);
        return new ArrayList<Interceptor>();
    }

    private static void addWarningDiagnostic(AdditionalData additionalData, String cause) {
        ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_126, cause);
        additionalData.diagnostics().add(error);
    }

    private static Interceptor getInterceptor(TypeReferenceTypeSymbol interceptorType, Interceptor.InterceptorType type, SemanticModel semanticModel, ModuleMemberVisitor moduleMemberVisitor) throws InterceptorMapperException {
        return switch (Objects.requireNonNull(type)) {
            case Interceptor.InterceptorType.REQUEST -> new RequestInterceptor(interceptorType, semanticModel, moduleMemberVisitor);
            case Interceptor.InterceptorType.REQUEST_ERROR -> new RequestErrorInterceptor(interceptorType, semanticModel, moduleMemberVisitor);
            case Interceptor.InterceptorType.RESPONSE -> new ResponseInterceptor(interceptorType, semanticModel, moduleMemberVisitor);
            default -> new ResponseErrorInterceptor(interceptorType, semanticModel, moduleMemberVisitor);
        };
    }

    private static List<Interceptor> getInterceptorListFromReturnType(TupleTypeSymbol interceptorTupleType, SemanticModel semanticModel, ModuleMemberVisitor moduleMemberVisitor) throws InterceptorMapperException {
        ArrayList<Interceptor> interceptors = new ArrayList<Interceptor>();
        for (TypeSymbol typeDescriptor : interceptorTupleType.memberTypeDescriptors()) {
            if (!(typeDescriptor instanceof TypeReferenceTypeSymbol)) continue;
            TypeReferenceTypeSymbol interceptorType = (TypeReferenceTypeSymbol)typeDescriptor;
            Interceptor.InterceptorType type = InterceptorPipeline.getInterceptorType((TypeSymbol)interceptorType, semanticModel);
            Interceptor interceptor = InterceptorPipeline.getInterceptor(interceptorType, type, semanticModel, moduleMemberVisitor);
            interceptors.add(interceptor);
        }
        return interceptors;
    }

    private static Interceptor.InterceptorType getInterceptorType(TypeSymbol interceptorType, SemanticModel semanticModel) {
        if (InterceptorPipeline.isSubTypeOf(interceptorType, "RequestInterceptor", semanticModel)) {
            return Interceptor.InterceptorType.REQUEST;
        }
        if (InterceptorPipeline.isSubTypeOf(interceptorType, "RequestErrorInterceptor", semanticModel)) {
            return Interceptor.InterceptorType.REQUEST_ERROR;
        }
        if (InterceptorPipeline.isSubTypeOf(interceptorType, "ResponseInterceptor", semanticModel)) {
            return Interceptor.InterceptorType.RESPONSE;
        }
        return Interceptor.InterceptorType.RESPONSE_ERROR;
    }

    private static boolean isSubTypeOf(TypeSymbol typeSymbol, String typeName, SemanticModel semanticModel) {
        Object t;
        Optional optType = semanticModel.types().getTypeByName("ballerina", "http", "", typeName);
        if (optType.isEmpty() || !((t = optType.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol typeDef = (TypeDefinitionSymbol)t;
        return typeSymbol.subtypeOf(typeDef.typeDescriptor());
    }

    protected SemanticModel getSemanticModel() {
        return this.semanticModel;
    }

    protected List<OpenAPIMapperDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    protected Interceptor getInitReqInterceptor() {
        return this.initReqInterceptor;
    }

    protected Interceptor getInitResInterceptor() {
        return this.initResInterceptor;
    }

    public ResponseInfo getInfoFromInterceptors(ResourceMethodSymbol targetResource) {
        return ResponseCollector.getResponseInfo(this, targetResource);
    }

    public RequestParameterInfo getRequestParameterInfo(ResourceMethodSymbol targetResource) {
        return RequestParameterCollector.getRequestParameterInfo(this, targetResource);
    }
}

