/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.pipeline;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.service.mapper.interceptor.model.ResponseInfo;
import io.ballerina.openapi.service.mapper.interceptor.pipeline.InterceptorPipeline;
import io.ballerina.openapi.service.mapper.interceptor.types.Interceptor;
import io.ballerina.openapi.service.mapper.interceptor.types.TargetResource;
import java.util.Objects;

public final class ResponseCollector {
    private ResponseCollector() {
    }

    public static ResponseInfo getResponseInfo(InterceptorPipeline pipeline, ResourceMethodSymbol targetResource) {
        SemanticModel semanticModel = pipeline.getSemanticModel();
        Interceptor initReqInterceptor = pipeline.getInitReqInterceptor();
        Interceptor initResInterceptor = pipeline.getInitResInterceptor();
        TargetResource target = new TargetResource(targetResource, semanticModel);
        ResponseInfo responseInfoFromInterceptors = new ResponseInfo(target.hasDataBinding());
        if (Objects.isNull(initReqInterceptor)) {
            ResponseCollector.processTargetResource(responseInfoFromInterceptors, target, initResInterceptor);
        } else {
            ResponseCollector.processReqInterceptor(initReqInterceptor, responseInfoFromInterceptors, target, initResInterceptor);
        }
        return responseInfoFromInterceptors;
    }

    private static void processReqInterceptor(Interceptor interceptor, ResponseInfo responseInfo, TargetResource targetResource, Interceptor initResInterceptor) {
        if (Objects.isNull(interceptor)) {
            ResponseCollector.processTargetResource(responseInfo, targetResource, initResInterceptor);
            return;
        }
        if (interceptor.isContinueExecution() || !interceptor.isInvokable(targetResource)) {
            ResponseCollector.processReqInterceptor(interceptor.getNextInReqPath(), responseInfo, targetResource, initResInterceptor);
            if (!interceptor.isInvokable(targetResource)) {
                return;
            }
        }
        if (interceptor.hasErrorReturn() || interceptor.hasDataBinding()) {
            if (interceptor.hasDataBinding()) {
                responseInfo.markDataBindingError();
            }
            ResponseCollector.updateErrorReturnTypeInReqPath(interceptor, responseInfo, targetResource, initResInterceptor);
        }
        TypeSymbol nonErrorReturnType = interceptor.getNonErrorReturnType();
        ResponseCollector.updateNonErrorReturnTypeForInterceptor(interceptor, nonErrorReturnType, responseInfo, false);
    }

    private static void updateErrorReturnTypeInReqPath(Interceptor interceptor, ResponseInfo responseInfo, TargetResource targetResource, Interceptor initResInterceptor) {
        Interceptor nextErrorInterceptor = interceptor.getNextInReqErrorPath();
        if (Objects.nonNull(nextErrorInterceptor) && nextErrorInterceptor.isInvokable(targetResource)) {
            ResponseCollector.processReqInterceptor(nextErrorInterceptor, responseInfo, targetResource, initResInterceptor);
        } else {
            nextErrorInterceptor = ResponseCollector.getNextErrorInterceptor(initResInterceptor);
            ResponseCollector.updateErrorReturnTypeForInterceptor(interceptor, responseInfo, nextErrorInterceptor);
        }
    }

    private static Interceptor getNextErrorInterceptor(Interceptor initResInterceptor) {
        Interceptor nextErrorInterceptor = null;
        if (Objects.nonNull(initResInterceptor)) {
            nextErrorInterceptor = initResInterceptor.getType().equals((Object)Interceptor.InterceptorType.RESPONSE_ERROR) ? initResInterceptor : initResInterceptor.getNextInResErrorPath();
        }
        return nextErrorInterceptor;
    }

    private static void updateErrorReturnTypeForInterceptor(Interceptor interceptor, ResponseInfo responseInfo, Interceptor nextErrorInterceptor) {
        if (Objects.nonNull(nextErrorInterceptor)) {
            ResponseCollector.processResInterceptor(nextErrorInterceptor, responseInfo, null, false);
        } else {
            responseInfo.addReturnTypeFromInterceptors(interceptor.getErrorReturnType());
        }
    }

    private static void updateNonErrorReturnTypeForInterceptor(Interceptor interceptor, TypeSymbol nonErrorReturnType, ResponseInfo responseInfo, boolean fromTarget) {
        if (Objects.nonNull(nonErrorReturnType)) {
            Interceptor nextResInterceptor = interceptor.getNextInResPath();
            if (Objects.nonNull(nextResInterceptor)) {
                ResponseCollector.processResInterceptor(nextResInterceptor, responseInfo, nonErrorReturnType, fromTarget);
            } else {
                ResponseCollector.updateReturnType(responseInfo, nonErrorReturnType, fromTarget);
            }
        }
    }

    private static void processResInterceptor(Interceptor interceptor, ResponseInfo responseInfo, TypeSymbol prevReturnType, boolean fromTarget) {
        if (interceptor.isContinueExecution() && Objects.nonNull(prevReturnType)) {
            ResponseCollector.updateNonErrorReturnTypeForInterceptor(interceptor, prevReturnType, responseInfo, fromTarget);
        }
        if (interceptor.hasErrorReturn()) {
            Interceptor nextErrorInterceptor = interceptor.getNextInResErrorPath();
            ResponseCollector.updateErrorReturnTypeForInterceptor(interceptor, responseInfo, nextErrorInterceptor);
        }
        TypeSymbol nonErrorReturnType = interceptor.getNonErrorReturnType();
        ResponseCollector.updateNonErrorReturnTypeForInterceptor(interceptor, nonErrorReturnType, responseInfo, false);
    }

    private static void updateReturnType(ResponseInfo responseInfo, TypeSymbol prevReturnType, boolean fromTarget) {
        if (fromTarget) {
            responseInfo.addReturnTypeFromTargetResource(prevReturnType);
        } else {
            responseInfo.addReturnTypeFromInterceptors(prevReturnType);
        }
    }

    private static void processTargetResource(ResponseInfo responseInfo, TargetResource targetResource, Interceptor initResInterceptor) {
        TypeSymbol nonErrorReturnType;
        TypeSymbol returnType = targetResource.getEffectiveReturnType();
        if (Objects.isNull(initResInterceptor)) {
            responseInfo.addReturnTypeFromTargetResource(returnType);
            return;
        }
        if (targetResource.hasErrorReturn() || targetResource.hasDataBinding()) {
            if (targetResource.hasDataBinding()) {
                responseInfo.markDataBindingError();
            }
            ResponseCollector.updateErrorReturnTypeForTarget(responseInfo, targetResource, initResInterceptor);
        }
        if (Objects.nonNull(nonErrorReturnType = targetResource.getNonErrorReturnType())) {
            ResponseCollector.updateNonErrorReturnTypeForTarget(responseInfo, nonErrorReturnType, initResInterceptor);
        }
    }

    private static void updateNonErrorReturnTypeForTarget(ResponseInfo responseInfo, TypeSymbol nonErrorReturnType, Interceptor initResInterceptor) {
        if (initResInterceptor.getType().equals((Object)Interceptor.InterceptorType.RESPONSE)) {
            ResponseCollector.processResInterceptor(initResInterceptor, responseInfo, nonErrorReturnType, true);
        } else {
            Interceptor nextResponseErrorInterceptor = initResInterceptor.getNextInResPath();
            if (Objects.nonNull(nextResponseErrorInterceptor)) {
                ResponseCollector.processResInterceptor(nextResponseErrorInterceptor, responseInfo, nonErrorReturnType, true);
            } else {
                responseInfo.addReturnTypeFromTargetResource(nonErrorReturnType);
            }
        }
    }

    private static void updateErrorReturnTypeForTarget(ResponseInfo responseInfo, TargetResource target, Interceptor initResInterceptor) {
        if (initResInterceptor.getType().equals((Object)Interceptor.InterceptorType.RESPONSE_ERROR)) {
            responseInfo.markDataBindingErrorHandled();
            ResponseCollector.processResInterceptor(initResInterceptor, responseInfo, null, true);
        } else {
            Interceptor nextResponseErrorInterceptor = initResInterceptor.getNextInResErrorPath();
            if (Objects.nonNull(nextResponseErrorInterceptor)) {
                responseInfo.markDataBindingErrorHandled();
                ResponseCollector.processResInterceptor(nextResponseErrorInterceptor, responseInfo, null, true);
            } else if (Objects.nonNull(target.getErrorReturnType())) {
                responseInfo.addReturnTypeFromTargetResource(target.getErrorReturnType());
            }
        }
    }
}

