/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.interceptor.types;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import io.ballerina.openapi.service.mapper.interceptor.types.Resource;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class TargetResource
extends Resource {
    private final TypeSymbol effectiveReturnType;

    public TargetResource(ResourceMethodSymbol resourceMethodSymbol, SemanticModel semanticModel) {
        super(semanticModel);
        this.resourceMethod = resourceMethodSymbol;
        Optional optReturnType = resourceMethodSymbol.typeDescriptor().returnTypeDescriptor();
        if (optReturnType.isEmpty()) {
            this.effectiveReturnType = semanticModel.types().NIL;
            return;
        }
        this.effectiveReturnType = (TypeSymbol)optReturnType.get();
        this.extractErrorAndNonErrorReturnTypes(this.effectiveReturnType);
    }

    public TypeSymbol getEffectiveReturnType() {
        return this.effectiveReturnType;
    }

    public ResourceMethodSymbol getResourceMethodSymbol() {
        return this.resourceMethod;
    }

    @Override
    public boolean hasDataBinding() {
        return super.hasDataBinding() || this.hasPathParameter(this.resourceMethod.resourcePath());
    }

    private boolean hasPathParameter(ResourcePath path) {
        return switch (path.kind()) {
            default -> throw new MatchException(null, null);
            case ResourcePath.Kind.DOT_RESOURCE_PATH, ResourcePath.Kind.PATH_REST_PARAM -> false;
            case ResourcePath.Kind.PATH_SEGMENT_LIST -> {
                List pathParams = ((PathSegmentList)path).pathParameters();
                if (Objects.nonNull(pathParams) && !pathParams.isEmpty()) {
                    yield true;
                }
                yield false;
            }
        };
    }
}

