/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.parameter;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ParameterSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.openapi.service.mapper.ServiceMapperFactory;
import io.ballerina.openapi.service.mapper.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.service.mapper.diagnostic.ExceptionDiagnostic;
import io.ballerina.openapi.service.mapper.model.AdditionalData;
import io.ballerina.openapi.service.mapper.model.OperationInventory;
import io.ballerina.openapi.service.mapper.model.ResourceFunction;
import io.ballerina.openapi.service.mapper.parameter.HeaderParameterMapper;
import io.ballerina.openapi.service.mapper.parameter.ParameterMapper;
import io.ballerina.openapi.service.mapper.parameter.ParameterMapperException;
import io.ballerina.openapi.service.mapper.parameter.PathParameterMapper;
import io.ballerina.openapi.service.mapper.parameter.QueryParameterMapper;
import io.ballerina.openapi.service.mapper.parameter.RequestBodyMapper;
import io.ballerina.openapi.service.mapper.type.TypeMapper;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DefaultParameterMapper
implements ParameterMapper {
    private final ResourceFunction functionDefinitionNode;
    private final OperationInventory operationInventory;
    private final Map<String, String> apiDocs;
    private final AdditionalData additionalData;
    private final boolean treatNilableAsOptional;
    private final TypeMapper typeMapper;

    public DefaultParameterMapper(ResourceFunction functionDefinitionNode, OperationInventory operationInventory, Map<String, String> apiDocs, AdditionalData additionalData, Boolean treatNilableAsOptional, ServiceMapperFactory serviceMapperFactory) {
        this.functionDefinitionNode = functionDefinitionNode;
        this.operationInventory = operationInventory;
        this.apiDocs = apiDocs;
        this.additionalData = additionalData;
        this.treatNilableAsOptional = treatNilableAsOptional;
        this.typeMapper = serviceMapperFactory.getTypeMapper();
    }

    @Override
    public void setParameters() throws ParameterMapperException {
        NodeList<Node> pathParams = this.functionDefinitionNode.relativeResourcePath();
        if (!pathParams.isEmpty()) {
            this.setPathParameters(pathParams);
        }
        Iterable<ParameterNode> parameterList = this.getParameterNodes();
        for (ParameterNode parameterNode : parameterList) {
            this.setParameter(parameterNode);
        }
    }

    private void setParameter(ParameterNode parameterNode) throws ParameterMapperException {
        ParameterType parameterType = this.getParameterType(parameterNode);
        if (parameterType.equals((Object)ParameterType.OTHER)) {
            return;
        }
        if ((parameterType.equals((Object)ParameterType.REQUEST) || parameterType.equals((Object)ParameterType.PAYLOAD)) && "GET".equalsIgnoreCase(this.operationInventory.getHttpOperation())) {
            ExceptionDiagnostic error = new ExceptionDiagnostic(DiagnosticMessages.OAS_CONVERTOR_113, (Location)parameterNode.location(), new String[0]);
            this.additionalData.diagnostics().add(error);
            return;
        }
        this.setParameter(parameterNode, parameterType);
    }

    protected Iterable<ParameterNode> getParameterNodes() {
        FunctionSignatureNode functionSignature = this.functionDefinitionNode.functionSignature();
        return functionSignature.parameters();
    }

    private void setParameter(ParameterNode parameterNode, ParameterType parameterType) throws ParameterMapperException {
        switch (parameterType.ordinal()) {
            case 2: {
                QueryParameterMapper queryParameterMapper = new QueryParameterMapper(parameterNode, this.apiDocs, this.operationInventory, this.treatNilableAsOptional, this.additionalData, this.typeMapper);
                queryParameterMapper.setParameter();
                break;
            }
            case 3: {
                HeaderParameterMapper headerParameterMapper = new HeaderParameterMapper(parameterNode, this.apiDocs, this.operationInventory, this.treatNilableAsOptional, this.additionalData, this.typeMapper);
                headerParameterMapper.setParameter();
                break;
            }
            case 0: {
                Optional symbol = this.additionalData.semanticModel().symbol((Node)parameterNode);
                if (symbol.isEmpty() || !(symbol.get() instanceof ParameterSymbol)) {
                    return;
                }
                AnnotationNode annotation = this.getPayloadAnnotation(parameterNode);
                RequestBodyMapper requestBodyMapper = new RequestBodyMapper((ParameterSymbol)symbol.get(), annotation, this.operationInventory, this.functionDefinitionNode, this.apiDocs, this.additionalData, this.typeMapper);
                requestBodyMapper.setRequestBody();
                break;
            }
            case 1: {
                RequestBody requestBody = new RequestBody();
                MediaType mediaType = new MediaType();
                mediaType.setSchema(new Schema().description("Any type of entity body"));
                requestBody.setContent(new Content().addMediaType("*/*", mediaType));
                this.operationInventory.setRequestBody(requestBody);
                break;
            }
        }
    }

    private AnnotationNode getPayloadAnnotation(ParameterNode parameterNode) {
        if (parameterNode instanceof DefaultableParameterNode) {
            DefaultableParameterNode defaultableParameterNode = (DefaultableParameterNode)parameterNode;
            return defaultableParameterNode.annotations().stream().filter(annotationNode -> annotationNode.annotReference().toString().trim().equals("http:Payload")).findFirst().orElse(null);
        }
        if (parameterNode instanceof RequiredParameterNode) {
            RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
            return requiredParameterNode.annotations().stream().filter(annotationNode -> annotationNode.annotReference().toString().trim().equals("http:Payload")).findFirst().orElse(null);
        }
        return null;
    }

    private void setPathParameters(NodeList<Node> pathParams) throws ParameterMapperException {
        for (Node param : pathParams) {
            if (!(param instanceof ResourcePathParameterNode)) continue;
            ResourcePathParameterNode pathParam = (ResourcePathParameterNode)param;
            SemanticModel semanticModel = this.additionalData.semanticModel();
            PathParameterSymbol pathParameterSymbol = (PathParameterSymbol)semanticModel.symbol((Node)pathParam).get();
            PathParameterMapper pathParameterMapper = new PathParameterMapper(pathParameterSymbol, this.apiDocs, this.operationInventory, this.typeMapper);
            pathParameterMapper.setParameter();
        }
    }

    private ParameterType getParameterType(ParameterNode parameterNode) {
        ParameterType parameterType = this.getObjectParameterType(parameterNode);
        if (Objects.nonNull((Object)parameterType)) {
            return parameterType;
        }
        NodeList<AnnotationNode> annotationNodes = DefaultParameterMapper.getAnnotationNodes(parameterNode);
        if (Objects.isNull(annotationNodes) || annotationNodes.isEmpty()) {
            return ParameterType.QUERY;
        }
        return DefaultParameterMapper.getParameterTypeFromAnnotation(annotationNodes);
    }

    private ParameterType getObjectParameterType(ParameterNode parameterNode) {
        ParameterType parameterType = null;
        if (parameterNode instanceof RequiredParameterNode) {
            RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
            String parameterTypeName = requiredParameterNode.typeName().toString().trim();
            parameterType = parameterTypeName.equals("http:Request") ? ParameterType.REQUEST : this.getOtherParameterType(requiredParameterNode);
        }
        return parameterType;
    }

    private ParameterType getOtherParameterType(RequiredParameterNode requiredParameterNode) {
        SemanticModel semanticModel = this.additionalData.semanticModel();
        Symbol parameterSymbol = semanticModel.symbol((Node)requiredParameterNode).orElse(null);
        if (Objects.isNull(parameterSymbol) || !(parameterSymbol instanceof ParameterSymbol)) {
            return ParameterType.OTHER;
        }
        TypeSymbol parameterTypeSymbol = ((ParameterSymbol)parameterSymbol).typeDescriptor();
        if (!parameterTypeSymbol.subtypeOf(semanticModel.types().ANYDATA)) {
            return ParameterType.OTHER;
        }
        return null;
    }

    private static ParameterType getParameterTypeFromAnnotation(NodeList<AnnotationNode> annotationNodes) {
        for (AnnotationNode annotationNode : annotationNodes) {
            String annotationTypeName = annotationNode.annotReference().toString().trim();
            if (annotationTypeName.equals("http:Header")) {
                return ParameterType.HEADER;
            }
            if (!annotationTypeName.equals("http:Payload")) continue;
            return ParameterType.PAYLOAD;
        }
        return ParameterType.QUERY;
    }

    private static NodeList<AnnotationNode> getAnnotationNodes(ParameterNode parameterNode) {
        NodeList annotationNodes = null;
        if (parameterNode instanceof DefaultableParameterNode) {
            DefaultableParameterNode defaultableParameterNode = (DefaultableParameterNode)parameterNode;
            annotationNodes = defaultableParameterNode.annotations();
        } else if (parameterNode instanceof RequiredParameterNode) {
            RequiredParameterNode requiredParameterNode = (RequiredParameterNode)parameterNode;
            annotationNodes = requiredParameterNode.annotations();
        }
        return annotationNodes;
    }

    public static enum ParameterType {
        PAYLOAD,
        REQUEST,
        QUERY,
        HEADER,
        OTHER;

    }
}

