/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.service.mapper.response.utils;

import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.openapi.service.mapper.response.model.CacheConfigAnnotation;
import io.swagger.v3.oas.models.headers.Header;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.media.StringSchema;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.stream.Collectors;

public final class CacheHeaderUtils {
    private CacheHeaderUtils() {
    }

    public static CacheConfigAnnotation setCacheConfigValues(SeparatedNodeList<MappingFieldNode> fields) {
        CacheConfigAnnotation cacheConfig = new CacheConfigAnnotation();
        Spliterator spliterator = fields.spliterator();
        spliterator.forEachRemaining(field -> {
            if (field.kind() == SyntaxKind.SPECIFIC_FIELD) {
                SpecificFieldNode specificFieldNode = (SpecificFieldNode)field;
                String name = specificFieldNode.fieldName().toString().trim();
                ExpressionNode expressionNode = (ExpressionNode)specificFieldNode.valueExpr().get();
                CacheHeaderUtils.setCacheConfigField(cacheConfig, name, expressionNode);
            }
        });
        return cacheConfig;
    }

    private static void setCacheConfigField(CacheConfigAnnotation cacheConfig, String fieldName, ExpressionNode expressionNode) {
        if (expressionNode.toString().equals("true")) {
            switch (fieldName) {
                case "noCache": {
                    cacheConfig.setNoCache(true);
                    break;
                }
                case "noStore": {
                    cacheConfig.setNoStore(true);
                    break;
                }
                case "noTransform": {
                    cacheConfig.setNoTransform(true);
                    break;
                }
                case "isPrivate": {
                    cacheConfig.setPrivate(true);
                    break;
                }
                case "proxyRevalidate": {
                    cacheConfig.setProxyRevalidate(true);
                    break;
                }
            }
        } else if ("maxAge".equals(fieldName)) {
            String maxAge = expressionNode.toString();
            try {
                int maxA = Integer.parseInt(maxAge);
                cacheConfig.setMaxAge(maxA);
            }
            catch (NumberFormatException maxA) {}
        } else if ("sMaxAge".equals(fieldName)) {
            String sMaxAge = expressionNode.toString();
            try {
                int maxA = Integer.parseInt(sMaxAge);
                cacheConfig.setsMaxAge(maxA);
            }
            catch (NumberFormatException maxA) {}
        } else if (expressionNode.toString().equals("false")) {
            switch (fieldName) {
                case "setETag": {
                    cacheConfig.setSetETag(false);
                    break;
                }
                case "setLastModified": {
                    cacheConfig.setSetLastModified(false);
                    break;
                }
                case "mustRevalidate": {
                    cacheConfig.setMustRevalidate(false);
                    break;
                }
            }
        } else if ("privateFields".equals(fieldName)) {
            ArrayList<String> privateFields = new ArrayList<String>();
            SeparatedNodeList fields = ((ListConstructorExpressionNode)expressionNode).expressions();
            fields.stream().forEach(field -> privateFields.add(field.toString().trim()));
            cacheConfig.setPrivateFields(privateFields);
        } else if ("noCacheFields".equals(fieldName)) {
            ArrayList<String> noCacheFields = new ArrayList<String>();
            SeparatedNodeList fields = ((ListConstructorExpressionNode)expressionNode).expressions();
            fields.stream().forEach(field -> noCacheFields.add(field.toString().trim()));
            cacheConfig.setNoCacheFields(noCacheFields);
        }
    }

    public static void updateResponseHeaderWithCacheValues(Map<String, Header> headers, CacheConfigAnnotation cache) {
        Header cacheHeader = new Header();
        StringSchema stringSchema = new StringSchema();
        if (!cache.isSetETag() && !cache.isSetLastModified()) {
            stringSchema._default(CacheHeaderUtils.generateCacheControlString(cache));
            cacheHeader.setSchema((Schema)stringSchema);
            headers.put("Cache-Control", cacheHeader);
        } else if (!cache.isSetETag() && cache.isSetLastModified()) {
            stringSchema._default(CacheHeaderUtils.generateCacheControlString(cache));
            cacheHeader.setSchema((Schema)stringSchema);
            headers.put("Cache-Control", cacheHeader);
            Header lmHeader = new Header();
            lmHeader.setSchema((Schema)new StringSchema());
            headers.put("Last-Modified", lmHeader);
        } else if (!cache.isSetLastModified() && cache.isSetETag()) {
            stringSchema._default(CacheHeaderUtils.generateCacheControlString(cache));
            cacheHeader.setSchema((Schema)stringSchema);
            headers.put("Cache-Control", cacheHeader);
            Header eTag = new Header();
            eTag.setSchema((Schema)new StringSchema());
            headers.put("ETag", eTag);
        } else {
            CacheHeaderUtils.cacheHeaderForEmptyValues(headers, cacheHeader, stringSchema, CacheHeaderUtils.generateCacheControlString(cache));
        }
    }

    private static void cacheHeaderForEmptyValues(Map<String, Header> headers, Header cacheHeader, StringSchema stringSchema, String value) {
        stringSchema._default(value);
        cacheHeader.setSchema((Schema)stringSchema);
        headers.put("Cache-Control", cacheHeader);
        Header eTag = new Header();
        eTag.setSchema((Schema)new StringSchema());
        headers.put("ETag", eTag);
        Header lmHeader = new Header();
        lmHeader.setSchema((Schema)new StringSchema());
        headers.put("Last-Modified", lmHeader);
    }

    private static String generateCacheControlString(CacheConfigAnnotation cacheConfig) {
        ArrayList<Object> directives = new ArrayList<Object>();
        if (cacheConfig.isMustRevalidate()) {
            directives.add("must-revalidate");
        }
        if (cacheConfig.isNoCache()) {
            directives.add("no-cache" + CacheHeaderUtils.appendFields(cacheConfig.getNoCacheFields()));
        }
        if (cacheConfig.isNoStore()) {
            directives.add("no-store");
        }
        if (cacheConfig.isNoTransform()) {
            directives.add("no-transform");
        }
        if (cacheConfig.isPrivate()) {
            List<String> privateCacheFields = cacheConfig.getPrivateFields();
            if (privateCacheFields.isEmpty()) {
                directives.add("private");
            } else {
                directives.add("private" + CacheHeaderUtils.appendFields(privateCacheFields));
            }
        } else {
            directives.add("public");
        }
        if (cacheConfig.isProxyRevalidate()) {
            directives.add("proxy-revalidate");
        }
        if (cacheConfig.getMaxAge() > -1) {
            directives.add("max-age=" + cacheConfig.getMaxAge());
        }
        if (cacheConfig.getsMaxAge() > -1) {
            directives.add("s-maxage=" + cacheConfig.getsMaxAge());
        }
        return String.join((CharSequence)",", directives);
    }

    private static String appendFields(List<String> fields) {
        return "=\"" + CacheHeaderUtils.buildCommaSeparatedString(fields) + "\"";
    }

    private static String buildCommaSeparatedString(List<String> fields) {
        String genString = fields.stream().map(field -> field.replaceAll("\"", "") + ",").collect(Collectors.joining());
        return genString.substring(0, genString.length() - 1);
    }
}

