/*
 * Decompiled with CFR 0.152.
 */
package io.jaegertracing.internal;

import io.jaegertracing.internal.JaegerObjectFactory;
import io.jaegertracing.internal.propagation.TextMapCodec;
import io.opentracing.SpanContext;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class JaegerSpanContext
implements SpanContext {
    protected static final byte flagSampled = 1;
    protected static final byte flagDebug = 2;
    private final long traceId;
    private final long spanId;
    private final long parentId;
    private final byte flags;
    private final Map<String, String> baggage;
    private final String debugId;
    private final JaegerObjectFactory objectFactory;

    public JaegerSpanContext(long traceId, long spanId, long parentId, byte flags) {
        this(traceId, spanId, parentId, flags, Collections.emptyMap(), null, new JaegerObjectFactory());
    }

    protected JaegerSpanContext(long traceId, long spanId, long parentId, byte flags, Map<String, String> baggage, String debugId, JaegerObjectFactory objectFactory) {
        if (baggage == null) {
            baggage = Collections.emptyMap();
        }
        this.traceId = traceId;
        this.spanId = spanId;
        this.parentId = parentId;
        this.flags = flags;
        this.baggage = baggage;
        this.debugId = debugId;
        this.objectFactory = objectFactory;
    }

    public Iterable<Map.Entry<String, String>> baggageItems() {
        return new HashMap<String, String>(this.baggage).entrySet();
    }

    public String getBaggageItem(String key) {
        return this.baggage.get(key);
    }

    Map<String, String> baggage() {
        return this.baggage;
    }

    public long getTraceId() {
        return this.traceId;
    }

    public long getSpanId() {
        return this.spanId;
    }

    public long getParentId() {
        return this.parentId;
    }

    public byte getFlags() {
        return this.flags;
    }

    public boolean isSampled() {
        return (this.flags & 1) == 1;
    }

    public boolean isDebug() {
        return (this.flags & 2) == 2;
    }

    public String toString() {
        return TextMapCodec.contextAsString(this);
    }

    public JaegerSpanContext withBaggageItem(String key, String val) {
        HashMap<String, String> newBaggage = new HashMap<String, String>(this.baggage);
        if (val == null) {
            newBaggage.remove(key);
        } else {
            newBaggage.put(key, val);
        }
        return this.objectFactory.createSpanContext(this.traceId, this.spanId, this.parentId, this.flags, newBaggage, this.debugId);
    }

    public JaegerSpanContext withBaggage(Map<String, String> newBaggage) {
        return this.objectFactory.createSpanContext(this.traceId, this.spanId, this.parentId, this.flags, newBaggage, this.debugId);
    }

    public JaegerSpanContext withFlags(byte flags) {
        return this.objectFactory.createSpanContext(this.traceId, this.spanId, this.parentId, flags, this.baggage, this.debugId);
    }

    boolean isDebugIdContainerOnly() {
        return this.traceId == 0L && this.debugId != null;
    }

    String getDebugId() {
        return this.debugId;
    }
}

