/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.ldap;

import com.unboundid.ldap.sdk.AddRequest;
import com.unboundid.ldap.sdk.AsyncResultListener;
import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.CompareRequest;
import com.unboundid.ldap.sdk.DeleteRequest;
import com.unboundid.ldap.sdk.Entry;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPConnectionOptions;
import com.unboundid.ldap.sdk.LDAPException;
import com.unboundid.ldap.sdk.LDAPResult;
import com.unboundid.ldap.sdk.Modification;
import com.unboundid.ldap.sdk.ModificationType;
import com.unboundid.ldap.sdk.ModifyDNRequest;
import com.unboundid.ldap.sdk.ModifyRequest;
import com.unboundid.ldap.sdk.ResultCode;
import com.unboundid.ldap.sdk.SearchRequest;
import com.unboundid.ldap.sdk.SearchResultEntry;
import com.unboundid.ldap.sdk.SearchResultListener;
import com.unboundid.ldap.sdk.SearchScope;
import com.unboundid.util.Base64;
import com.unboundid.util.ssl.AggregateTrustManager;
import com.unboundid.util.ssl.HostNameSSLSocketVerifier;
import com.unboundid.util.ssl.JVMDefaultTrustManager;
import com.unboundid.util.ssl.PEMFileTrustManager;
import com.unboundid.util.ssl.SSLSocketVerifier;
import com.unboundid.util.ssl.SSLUtil;
import com.unboundid.util.ssl.TrustStoreTrustManager;
import io.ballerina.lib.ldap.CustomAsyncResultListener;
import io.ballerina.lib.ldap.CustomSearchEntryListener;
import io.ballerina.lib.ldap.CustomSearchResultListener;
import io.ballerina.lib.ldap.ModuleUtils;
import io.ballerina.lib.ldap.Utils;
import io.ballerina.lib.ldap.ssl.SSLConfig;
import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.runtime.api.values.BTypedesc;
import java.io.File;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import javax.net.SocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public final class Client {
    public static final BString RESULT_STATUS = StringUtils.fromString((String)"resultCode");
    public static final BString MATCHED_DN = StringUtils.fromString((String)"matchedDN");
    public static final BString DIAGNOSTIC_MESSAGE = StringUtils.fromString((String)"diagnosticMessage");
    public static final BString HOST_NAME = StringUtils.fromString((String)"hostName");
    public static final BString PORT = StringUtils.fromString((String)"port");
    public static final BString DOMAIN_NAME = StringUtils.fromString((String)"domainName");
    public static final BString PASSWORD = StringUtils.fromString((String)"password");
    public static final BString CLIENT_SECURE_SOCKET = StringUtils.fromString((String)"clientSecureSocket");
    public static final String NATIVE_CLIENT = "client";
    public static final String LDAP_RESPONSE = "LdapResponse";
    public static final BString REFERRAL = StringUtils.fromString((String)"referral");
    public static final BString OPERATION_TYPE = StringUtils.fromString((String)"operationType");
    public static final String OBJECT_GUID = "objectGUID";
    public static final String OBJECT_SID = "objectSid";
    private static final BString SECURE_SOCKET_CONFIG_ENABLE_TLS = StringUtils.fromString((String)"enable");
    private static final BString VERIFY_HOSTNAME = StringUtils.fromString((String)"verifyHostName");
    private static final BString TLS_VERSIONS = StringUtils.fromString((String)"tlsVersions");
    private static final BString SECURE_SOCKET_CONFIG_TRUSTSTORE_FILE_PATH = StringUtils.fromString((String)"path");
    private static final BString SECURE_SOCKET_CONFIG_TRUSTSTORE_PASSWORD = StringUtils.fromString((String)"password");
    private static final BString SECURE_SOCKET_CONFIG_CERT = StringUtils.fromString((String)"cert");
    public static final String PKCS_12 = "PKCS12";
    public static final String PEM = "PEM";
    public static final String TRUST_STORE_INITIALIZATION_ERROR = "Error occurred while initializing trust store";
    public static final String UNSUPPORTED_TRUST_STORE_TYPE_ERROR = "Unsupported trust store type";
    public static final String EMPTY_TRUST_STORE_FILE_PATH_ERROR = "Truststore file path cannot be empty";
    public static final String EMPTY_TRUST_STORE_PASSWORD_ERROR = "Truststore password cannot be empty";
    public static final String EMPTY_CERTIFICATE_FILE_PATH_ERROR = "Certificate file path cannot be empty";

    private Client() {
    }

    public static BError initLdapConnection(BObject ldapClient, BMap<BString, Object> config) {
        String hostName = ((BString)config.get((Object)HOST_NAME)).getValue();
        int port = Math.toIntExact(config.getIntValue(PORT));
        String domainName = ((BString)config.get((Object)DOMAIN_NAME)).getValue();
        String password = ((BString)config.get((Object)PASSWORD)).getValue();
        BMap secureSocketConfig = config.getMapValue(CLIENT_SECURE_SOCKET);
        try {
            if (Objects.nonNull(secureSocketConfig) && Client.isClientSecurityConfigured((BMap<BString, Object>)secureSocketConfig)) {
                SSLConfig sslConfig = Client.populateSSLConfig((BMap<BString, Object>)secureSocketConfig);
                AggregateTrustManager trustManager = Client.buildAggregatedTrustManager(sslConfig);
                SSLUtil sslUtil = new SSLUtil((TrustManager)trustManager);
                if (sslConfig.getTLSVersions().isEmpty()) {
                    SSLUtil.setDefaultSSLProtocol((String)"TLSv1.2");
                } else {
                    SSLUtil.setEnabledSSLProtocols(sslConfig.getTLSVersions());
                }
                LDAPConnectionOptions connectionOptions = new LDAPConnectionOptions();
                connectionOptions.setSSLSocketVerifier((SSLSocketVerifier)new HostNameSSLSocketVerifier(sslConfig.getVerifyHostnames().booleanValue()));
                LDAPConnection ldapConnection = new LDAPConnection((SocketFactory)sslUtil.createSSLSocketFactory(), connectionOptions, hostName, port, domainName, password);
                ldapClient.addNativeData(NATIVE_CLIENT, (Object)ldapConnection);
            } else {
                LDAPConnection ldapConnection = new LDAPConnection(hostName, port, domainName, password);
                ldapClient.addNativeData(NATIVE_CLIENT, (Object)ldapConnection);
            }
        }
        catch (LDAPException | GeneralSecurityException e) {
            return Utils.createError(e.getMessage(), e);
        }
        return null;
    }

    private static SSLConfig populateSSLConfig(BMap<BString, Object> secureSocketConfig) {
        SSLConfig sslConfig = new SSLConfig();
        Object cert = secureSocketConfig.get((Object)SECURE_SOCKET_CONFIG_CERT);
        Client.evaluateCertField(cert, sslConfig);
        sslConfig.setVerifyHostnames(secureSocketConfig.getBooleanValue(VERIFY_HOSTNAME));
        BArray tlsVersions = (BArray)secureSocketConfig.get((Object)TLS_VERSIONS);
        if (Objects.nonNull(tlsVersions)) {
            List tlsVersionsList = Arrays.stream(tlsVersions.getStringArray()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
            sslConfig.setTLSVersions(tlsVersionsList);
        }
        return sslConfig;
    }

    private static boolean isClientSecurityConfigured(BMap<BString, Object> secureSocketConfig) {
        return secureSocketConfig.get((Object)SECURE_SOCKET_CONFIG_ENABLE_TLS) != null;
    }

    private static void evaluateCertField(Object cert, SSLConfig sslConfiguration) {
        if (cert instanceof BMap) {
            BMap trustStore = (BMap)cert;
            String trustStoreFile = trustStore.getStringValue(SECURE_SOCKET_CONFIG_TRUSTSTORE_FILE_PATH).getValue();
            String trustStorePassword = trustStore.getStringValue(SECURE_SOCKET_CONFIG_TRUSTSTORE_PASSWORD).getValue();
            if (trustStoreFile.isBlank()) {
                throw new IllegalArgumentException(EMPTY_TRUST_STORE_FILE_PATH_ERROR);
            }
            if (trustStorePassword.isBlank()) {
                throw new IllegalArgumentException(EMPTY_TRUST_STORE_PASSWORD_ERROR);
            }
            sslConfiguration.setTrustStoreFile(trustStoreFile);
            sslConfiguration.setTrustStorePass(trustStorePassword);
            sslConfiguration.setTLSStoreType(PKCS_12);
        } else {
            String certFile = ((BString)cert).getValue();
            if (certFile.isBlank()) {
                throw new IllegalArgumentException(EMPTY_CERTIFICATE_FILE_PATH_ERROR);
            }
            sslConfiguration.setTrustStoreFile(certFile);
            sslConfiguration.setTLSStoreType(PEM);
        }
    }

    private static AggregateTrustManager buildAggregatedTrustManager(SSLConfig sslConfiguration) {
        if (sslConfiguration.getTLSStoreType().equals(PEM)) {
            try {
                PEMFileTrustManager pemFileTrustManager = new PEMFileTrustManager(new File[]{sslConfiguration.getTrustStore()});
                return new AggregateTrustManager(false, new X509TrustManager[]{JVMDefaultTrustManager.getInstance(), pemFileTrustManager});
            }
            catch (KeyStoreException e) {
                throw new IllegalArgumentException(TRUST_STORE_INITIALIZATION_ERROR + e.getMessage());
            }
        }
        if (sslConfiguration.getTLSStoreType().equals(PKCS_12)) {
            TrustStoreTrustManager trustStoreManager = new TrustStoreTrustManager(sslConfiguration.getTrustStore(), sslConfiguration.getTrustStorePass().toCharArray(), sslConfiguration.getTLSStoreType(), true);
            return new AggregateTrustManager(false, new X509TrustManager[]{JVMDefaultTrustManager.getInstance(), trustStoreManager});
        }
        throw new IllegalArgumentException(UNSUPPORTED_TRUST_STORE_TYPE_ERROR);
    }

    public static Object add(Environment env, BObject ldapClient, BString dN, BMap<BString, Object> entry) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            try {
                LDAPConnection ldapConnection = (LDAPConnection)ldapClient.getNativeData(NATIVE_CLIENT);
                Client.validateConnection(ldapConnection);
                AddRequest addRequest = Client.generateAddRequest(dN, entry);
                CustomAsyncResultListener customAsyncResultListener = new CustomAsyncResultListener(future);
                ldapConnection.asyncAdd(addRequest, (AsyncResultListener)customAsyncResultListener);
                return future.get();
            }
            catch (LDAPException e) {
                return Utils.createError(e.getMessage(), e);
            }
            catch (Throwable e) {
                return Utils.createError(e.getMessage(), e);
            }
        });
    }

    public static Object modify(Environment env, BObject ldapClient, BString dN, BMap<BString, BString> entry) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            try {
                LDAPConnection ldapConnection = (LDAPConnection)ldapClient.getNativeData(NATIVE_CLIENT);
                Client.validateConnection(ldapConnection);
                ModifyRequest modifyRequest = Client.generateModifyRequest(dN, entry);
                CustomAsyncResultListener customAsyncResultListener = new CustomAsyncResultListener(future);
                ldapConnection.asyncModify(modifyRequest, (AsyncResultListener)customAsyncResultListener);
                return future.get();
            }
            catch (LDAPException e) {
                return Utils.createError(e.getMessage(), e);
            }
            catch (Throwable e) {
                return Utils.createError(e.getMessage(), e);
            }
        });
    }

    public static Object modifyDn(Environment env, BObject ldapClient, BString currentDn, BString newRdn, boolean deleteOldRdn) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            try {
                LDAPConnection ldapConnection = (LDAPConnection)ldapClient.getNativeData(NATIVE_CLIENT);
                Client.validateConnection(ldapConnection);
                ModifyDNRequest modifyRequest = new ModifyDNRequest(currentDn.getValue(), newRdn.getValue(), deleteOldRdn);
                CustomAsyncResultListener customAsyncResultListener = new CustomAsyncResultListener(future);
                ldapConnection.asyncModifyDN(modifyRequest, (AsyncResultListener)customAsyncResultListener);
                return future.get();
            }
            catch (LDAPException e) {
                return Utils.createError(e.getMessage(), e);
            }
            catch (Throwable e) {
                return Utils.createError(e.getMessage(), e);
            }
        });
    }

    public static Object delete(Environment env, BObject ldapClient, BString dN) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            try {
                LDAPConnection ldapConnection = (LDAPConnection)ldapClient.getNativeData(NATIVE_CLIENT);
                Client.validateConnection(ldapConnection);
                CustomAsyncResultListener customAsyncResultListener = new CustomAsyncResultListener(future);
                ldapConnection.asyncDelete(new DeleteRequest(dN.getValue()), (AsyncResultListener)customAsyncResultListener);
                return future.get();
            }
            catch (LDAPException e) {
                return Utils.createError(e.getMessage(), e);
            }
            catch (Throwable e) {
                return Utils.createError(e.getMessage(), e);
            }
        });
    }

    public static Object compare(Environment env, BObject ldapClient, BString dN, BString attributeName, BString assertionValue) {
        return env.yieldAndRun(() -> {
            try {
                LDAPConnection ldapConnection = (LDAPConnection)ldapClient.getNativeData(NATIVE_CLIENT);
                Client.validateConnection(ldapConnection);
                CompareRequest compareRequest = new CompareRequest(dN.getValue(), attributeName.getValue(), assertionValue.getValue());
                CompletableFuture future = new CompletableFuture();
                ldapConnection.asyncCompare(compareRequest, (requestID, compareResult) -> {
                    if (compareResult.getResultCode().equals((Object)ResultCode.COMPARE_TRUE)) {
                        future.complete(true);
                    } else if (compareResult.getResultCode().equals((Object)ResultCode.COMPARE_FALSE)) {
                        future.complete(false);
                    } else {
                        LDAPException ldapException = new LDAPException((LDAPResult)compareResult);
                        future.complete(Utils.createError(ldapException.getMessage(), ldapException));
                    }
                });
                return future.get();
            }
            catch (LDAPException e) {
                return Utils.createError(e.getMessage(), e);
            }
            catch (Throwable e) {
                return Utils.createError(e.getMessage(), e);
            }
        });
    }

    public static Object getEntry(BObject ldapClient, BString dN, BTypedesc typeParam) {
        BMap entry = ValueCreator.createMapValue();
        try {
            LDAPConnection ldapConnection = (LDAPConnection)ldapClient.getNativeData(NATIVE_CLIENT);
            Client.validateConnection(ldapConnection);
            SearchResultEntry userEntry = ldapConnection.getEntry(dN.getValue());
            if (Objects.isNull(userEntry)) {
                return Utils.createError(String.format("Entry is not found for DN: '%s'", dN), new LDAPException(ResultCode.NO_SUCH_OBJECT));
            }
            for (Attribute attribute : userEntry.getAttributes()) {
                Client.processAttribute(attribute, (BMap<BString, Object>)entry);
            }
            return ValueUtils.convert((Object)entry, (Type)typeParam.getDescribingType());
        }
        catch (LDAPException e) {
            return Utils.createError(e.getMessage(), e);
        }
    }

    public static Object search(Environment env, BObject ldapClient, BString baseDn, BString filter, BString scope) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            try {
                SearchScope searchScope = Utils.getSearchScope(scope);
                LDAPConnection ldapConnection = (LDAPConnection)ldapClient.getNativeData(NATIVE_CLIENT);
                Client.validateConnection(ldapConnection);
                CustomSearchResultListener searchResultListener = new CustomSearchResultListener(future, baseDn.getValue());
                SearchRequest searchRequest = new SearchRequest((SearchResultListener)searchResultListener, baseDn.getValue(), searchScope, filter.getValue(), new String[0]);
                ldapConnection.asyncSearch(searchRequest);
                return future.get();
            }
            catch (LDAPException e) {
                return Utils.createError(e.getMessage(), e);
            }
            catch (Throwable e) {
                return Utils.createError(e.getMessage(), e);
            }
        });
    }

    public static Object searchWithType(Environment env, BObject ldapClient, BString baseDn, BString filter, BString scope, BTypedesc typeParam) {
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> future = new CompletableFuture<Object>();
            try {
                SearchScope searchScope = Utils.getSearchScope(scope);
                LDAPConnection ldapConnection = (LDAPConnection)ldapClient.getNativeData(NATIVE_CLIENT);
                Client.validateConnection(ldapConnection);
                CustomSearchEntryListener searchResultListener = new CustomSearchEntryListener(future, typeParam, baseDn.getValue());
                SearchRequest searchRequest = new SearchRequest((SearchResultListener)searchResultListener, baseDn.getValue(), searchScope, filter.getValue(), new String[0]);
                ldapConnection.asyncSearch(searchRequest);
                return future.get();
            }
            catch (LDAPException e) {
                return Utils.createError(e.getMessage(), e);
            }
            catch (Throwable e) {
                return Utils.createError(e.getMessage(), e);
            }
        });
    }

    public static void close(BObject ldapClient) {
        LDAPConnection ldapConnection = (LDAPConnection)ldapClient.getNativeData(NATIVE_CLIENT);
        ldapConnection.close();
    }

    public static boolean isConnected(BObject ldapClient) {
        LDAPConnection ldapConnection = (LDAPConnection)ldapClient.getNativeData(NATIVE_CLIENT);
        return ldapConnection.isConnected();
    }

    public static void validateConnection(LDAPConnection ldapConnection) throws LDAPException {
        if (!ldapConnection.isConnected()) {
            throw new LDAPException(ResultCode.OTHER, "LDAP Connection has been closed");
        }
    }

    private static AddRequest generateAddRequest(BString dN, BMap<BString, Object> entry) {
        Entry newEntry = new Entry(dN.getValue());
        for (BString key : (BString[])entry.getKeys()) {
            if (TypeUtils.getType((Object)entry.get((Object)key)).getTag() == 32) {
                BArray arrayValue = (BArray)entry.get((Object)key);
                String[] stringArray = arrayValue.getElementType().getTag() == 5 ? Utils.convertToStringArray(arrayValue.getStringArray()) : Utils.convertToStringArray(arrayValue.getValues());
                newEntry.addAttribute(key.getValue(), stringArray);
                continue;
            }
            newEntry.addAttribute(key.getValue(), entry.get((Object)key).toString());
        }
        return new AddRequest(newEntry);
    }

    private static ModifyRequest generateModifyRequest(BString dN, BMap<BString, BString> entry) {
        ArrayList<Modification> modificationList = new ArrayList<Modification>();
        for (BString key : (BString[])entry.getKeys()) {
            if (TypeUtils.getType((Object)entry.get((Object)key)).getTag() == 32) {
                BArray arrayValue = (BArray)entry.get((Object)key);
                String[] stringArray = arrayValue.getElementType().getTag() == 5 ? Utils.convertToStringArray(arrayValue.getStringArray()) : Utils.convertToStringArray(arrayValue.getValues());
                modificationList.add(new Modification(ModificationType.REPLACE, key.getValue(), stringArray));
                continue;
            }
            modificationList.add(new Modification(ModificationType.REPLACE, key.getValue(), ((BString)entry.get((Object)key)).toString()));
        }
        return new ModifyRequest(dN.getValue(), modificationList);
    }

    static void processAttribute(Attribute attribute, BMap<BString, Object> entry) {
        BString attributeName = StringUtils.fromString((String)attribute.getName());
        if (attribute.needsBase64Encoding()) {
            String readableString = Client.encodeAttributeValue(attribute);
            entry.put((Object)attributeName, (Object)StringUtils.fromString((String)readableString));
        } else if (attribute.getValues().length > 1) {
            String[] values = attribute.getValues();
            BString[] stringValues = (BString[])Arrays.stream(values).map(StringUtils::fromString).toArray(BString[]::new);
            entry.put((Object)attributeName, (Object)ValueCreator.createArrayValue((BString[])stringValues));
        } else {
            entry.put((Object)attributeName, (Object)StringUtils.fromString((String)attribute.getValue()));
        }
    }

    private static String encodeAttributeValue(Attribute attribute) {
        byte[] valueBytes = attribute.getValueByteArray();
        return switch (attribute.getName()) {
            case OBJECT_GUID -> Utils.convertObjectGUIDToString(valueBytes);
            case OBJECT_SID -> Utils.convertObjectSidToString(valueBytes);
            default -> Base64.encode((byte[])valueBytes);
        };
    }

    public static BMap<BString, Object> generateLdapResponse(LDAPResult ldapResult) {
        BMap response = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)LDAP_RESPONSE);
        response.put((Object)MATCHED_DN, (Object)StringUtils.fromString((String)ldapResult.getMatchedDN()));
        response.put((Object)RESULT_STATUS, (Object)StringUtils.fromString((String)ldapResult.getResultCode().getName().toUpperCase(Locale.ROOT)));
        response.put((Object)DIAGNOSTIC_MESSAGE, (Object)StringUtils.fromString((String)ldapResult.getDiagnosticMessage()));
        response.put((Object)REFERRAL, (Object)Utils.convertToBArray(ldapResult.getReferralURLs()));
        response.put((Object)OPERATION_TYPE, (Object)StringUtils.fromString((String)ldapResult.getOperationType().name()));
        return response;
    }
}

