/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.action.api;

import io.ballerina.stdlib.websub.Constants;
import io.ballerina.stdlib.websub.action.api.CodeSnippet;
import io.ballerina.stdlib.websub.action.api.Type;
import java.util.List;
import java.util.stream.Collectors;

public class Function
implements CodeSnippet {
    private String type = "remote";
    private final String name;
    private final List<FunctionArg> args;
    private final List<Type> returnTypes;
    private boolean optionalReturnTypes = false;

    private Function(String name, List<FunctionArg> args, List<Type> returnTypes) {
        this.name = name;
        this.args = args;
        this.returnTypes = returnTypes;
    }

    public static Function remoteFunctionWithOptionalReturnTypes(String name, List<FunctionArg> args, List<Type> returnTypes) {
        Function function = new Function(name, args, returnTypes);
        function.optionalReturnTypes = true;
        return function;
    }

    @Override
    public String snippetAsAString() {
        String functionArgs = this.args.stream().map(FunctionArg::snippetAsAString).collect(Collectors.joining(" ,"));
        String returnTypes = this.constructReturnTypes();
        return String.format("\t%s %s %s(%s) returns %s {%s%s\t}", this.type, "function", this.name, functionArgs, returnTypes, Constants.LS, Constants.LS);
    }

    private String constructReturnTypes() {
        String providedReturnTypes = this.returnTypes.stream().map(Type::snippetAsAString).collect(Collectors.joining("|"));
        if (this.optionalReturnTypes) {
            return String.format("%s?", providedReturnTypes);
        }
        return providedReturnTypes;
    }

    public static class FunctionArg
    implements CodeSnippet {
        private final Type type;
        private final String name;

        public FunctionArg(Type type, String name) {
            this.type = type;
            this.name = name;
        }

        @Override
        public String snippetAsAString() {
            return String.format("%s %s", this.type.snippetAsAString(), this.name);
        }
    }
}

