/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.task;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Qualifier;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websub.WebSubDiagnosticCodes;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.Location;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Optional;

public final class AnalyserUtils {
    private AnalyserUtils() {
    }

    public static void updateContext(SyntaxNodeAnalysisContext context, WebSubDiagnosticCodes errorCode, NodeLocation location, Object ... args) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(errorCode.getCode(), errorCode.getDescription(), errorCode.getSeverity());
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])args);
        context.reportDiagnostic(diagnostic);
    }

    public static boolean isWebSubService(ServiceDeclarationSymbol serviceDeclarationSymbol) {
        return serviceDeclarationSymbol.listenerTypes().stream().anyMatch(AnalyserUtils::isWebSubListener);
    }

    public static boolean isWebSubListener(TypeSymbol listenerType) {
        if (listenerType.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)listenerType).memberTypeDescriptors().stream().filter(typeDescriptor -> typeDescriptor instanceof TypeReferenceTypeSymbol).map(typeReferenceTypeSymbol -> (TypeReferenceTypeSymbol)typeReferenceTypeSymbol).anyMatch(AnalyserUtils::isWebSubListenerType);
        }
        if (listenerType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return AnalyserUtils.isWebSubListenerType((TypeReferenceTypeSymbol)listenerType);
        }
        if (listenerType.typeKind() == TypeDescKind.OBJECT) {
            Optional moduleOpt = listenerType.getModule();
            return moduleOpt.isPresent() && AnalyserUtils.isWebSub((ModuleSymbol)moduleOpt.get());
        }
        return false;
    }

    private static boolean isWebSubListenerType(TypeReferenceTypeSymbol typeSymbol) {
        if (typeSymbol.getName().isEmpty() || !"Listener".equals(typeSymbol.getName().get())) {
            return false;
        }
        return typeSymbol.getModule().isPresent() && AnalyserUtils.isWebSub((ModuleSymbol)typeSymbol.getModule().get());
    }

    public static boolean isWebSub(ModuleSymbol moduleSymbol) {
        Optional moduleNameOpt = moduleSymbol.getName();
        return moduleNameOpt.isPresent() && "websub".equals(moduleNameOpt.get()) && "ballerina".equals(moduleSymbol.id().orgName());
    }

    public static String getTypeDescription(TypeSymbol paramType) {
        TypeDescKind paramKind = paramType.typeKind();
        if (TypeDescKind.TYPE_REFERENCE.equals((Object)paramKind)) {
            TypeSymbol internalType = ((TypeReferenceTypeSymbol)paramType).typeDescriptor();
            if (internalType instanceof ErrorTypeSymbol) {
                return AnalyserUtils.getErrorTypeDescription(paramType);
            }
            String moduleName = paramType.getModule().flatMap(Symbol::getName).orElse("");
            String type = paramType.getName().orElse("");
            return AnalyserUtils.getQualifiedType(type, moduleName);
        }
        if (TypeDescKind.UNION.equals((Object)paramKind)) {
            List availableTypes = ((UnionTypeSymbol)paramType).memberTypeDescriptors();
            boolean optionalSymbolAvailable = availableTypes.stream().anyMatch(t -> TypeDescKind.NIL.equals((Object)t.typeKind()));
            String concatenatedTypeDesc = availableTypes.stream().map(AnalyserUtils::getTypeDescription).filter(e -> !e.isEmpty() && !e.isBlank()).reduce((a, b) -> String.join((CharSequence)"|", a, b)).orElse("");
            return optionalSymbolAvailable ? concatenatedTypeDesc + "?" : concatenatedTypeDesc;
        }
        if (TypeDescKind.INTERSECTION.equals((Object)paramKind)) {
            List availableTypes = ((IntersectionTypeSymbol)paramType).memberTypeDescriptors();
            return availableTypes.stream().filter(e -> TypeDescKind.TYPE_REFERENCE.equals((Object)e.typeKind())).map(AnalyserUtils::getTypeDescription).filter(e -> !e.isEmpty() && !e.isBlank()).reduce((a, b) -> String.join((CharSequence)"&", a, b)).orElse("");
        }
        if (TypeDescKind.ERROR.equals((Object)paramKind)) {
            return AnalyserUtils.getErrorTypeDescription(paramType);
        }
        return paramType.getName().orElse("");
    }

    private static String getErrorTypeDescription(TypeSymbol internalType) {
        String signature = internalType.signature();
        Optional<ModuleID> moduleIdOpt = internalType.getModule().map(ModuleSymbol::id);
        String moduleId = moduleIdOpt.map(ModuleID::toString).orElse("");
        String type = signature.replace(moduleId, "").replace(":", "");
        String moduleName = moduleIdOpt.map(ModuleID::modulePrefix).orElse("");
        return AnalyserUtils.getQualifiedType(type, moduleName);
    }

    public static String getQualifiedType(String paramType, String moduleName) {
        return moduleName.isBlank() ? paramType : String.format("%s:%s", moduleName, paramType);
    }

    public static boolean isRemoteMethod(FunctionSymbol functionSymbol) {
        return functionSymbol.qualifiers().contains(Qualifier.REMOTE);
    }

    public static <T extends InputStream, E extends OutputStream> void copyContent(T inputStream, E outStream) throws IOException {
        byte[] data = new byte[1024];
        int bytesRead = inputStream.read(data);
        while (bytesRead != -1) {
            outStream.write(data, 0, bytesRead);
            bytesRead = inputStream.read(data);
        }
    }
}

