/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.task;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.RestArgumentNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websub.WebSubDiagnosticCodes;
import io.ballerina.stdlib.websub.task.AnalyserUtils;
import java.util.Optional;

public class ListenerInitAnalysisTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public void perform(SyntaxNodeAnalysisContext context) {
        SyntaxKind nodeSyntaxKind = context.node().kind();
        if (nodeSyntaxKind == SyntaxKind.EXPLICIT_NEW_EXPRESSION) {
            ExplicitNewExpressionNode expressionNode = (ExplicitNewExpressionNode)context.node();
            this.validateExplicitNewListener(context, expressionNode);
        } else if (nodeSyntaxKind == SyntaxKind.IMPLICIT_NEW_EXPRESSION) {
            ImplicitNewExpressionNode expressionNode = (ImplicitNewExpressionNode)context.node();
            this.validateImplicitNewListener(context, expressionNode);
        }
    }

    private void validateExplicitNewListener(SyntaxNodeAnalysisContext context, ExplicitNewExpressionNode node) {
        TypeDescriptorNode typeDescriptor = node.typeDescriptor();
        if (context.semanticModel().symbol((Node)typeDescriptor).isEmpty()) {
            return;
        }
        Symbol listenerSymbol = (Symbol)context.semanticModel().symbol((Node)typeDescriptor).get();
        if (listenerSymbol.kind() != SymbolKind.TYPE) {
            return;
        }
        TypeSymbol listenerTypeSymbol = ((TypeReferenceTypeSymbol)listenerSymbol).typeDescriptor();
        if (!AnalyserUtils.isWebSubListener(listenerTypeSymbol)) {
            return;
        }
        SeparatedNodeList functionArgs = node.parenthesizedArgList().arguments();
        this.verifyListenerArgType(context, (SeparatedNodeList<FunctionArgumentNode>)functionArgs);
    }

    private void validateImplicitNewListener(SyntaxNodeAnalysisContext context, ImplicitNewExpressionNode node) {
        Optional<ListenerDeclarationNode> listenerNodeOpt = this.getImplicitListenerNode(node);
        if (listenerNodeOpt.flatMap(ListenerDeclarationNode::typeDescriptor).isEmpty()) {
            return;
        }
        TypeDescriptorNode typeDescriptor = (TypeDescriptorNode)listenerNodeOpt.flatMap(ListenerDeclarationNode::typeDescriptor).get();
        if (context.semanticModel().symbol((Node)typeDescriptor).isEmpty()) {
            return;
        }
        Symbol listenerSymbol = (Symbol)context.semanticModel().symbol((Node)typeDescriptor).get();
        if (listenerSymbol.kind() != SymbolKind.TYPE) {
            return;
        }
        TypeSymbol listenerTypeSymbol = ((TypeReferenceTypeSymbol)listenerSymbol).typeDescriptor();
        if (!AnalyserUtils.isWebSubListener(listenerTypeSymbol)) {
            return;
        }
        if (node.parenthesizedArgList().isPresent()) {
            SeparatedNodeList functionArgs = ((ParenthesizedArgList)node.parenthesizedArgList().get()).arguments();
            this.verifyListenerArgType(context, (SeparatedNodeList<FunctionArgumentNode>)functionArgs);
        }
    }

    private Optional<ListenerDeclarationNode> getImplicitListenerNode(ImplicitNewExpressionNode node) {
        if (node.parent().kind() == SyntaxKind.LISTENER_DECLARATION) {
            return Optional.of((ListenerDeclarationNode)node.parent());
        }
        if (node.parent().kind() == SyntaxKind.CHECK_EXPRESSION && node.parent().parent().kind() == SyntaxKind.LISTENER_DECLARATION) {
            return Optional.of((ListenerDeclarationNode)node.parent().parent());
        }
        return Optional.empty();
    }

    private void verifyListenerArgType(SyntaxNodeAnalysisContext context, SeparatedNodeList<FunctionArgumentNode> functionArgs) {
        if (functionArgs.size() > 1) {
            VariableSymbol variable;
            Optional<Symbol> firstArgSymbolOpt = this.getFirstListenerArg(context.semanticModel(), (FunctionArgumentNode)functionArgs.get(0));
            if (firstArgSymbolOpt.isEmpty()) {
                return;
            }
            Symbol firstArgSymbol = firstArgSymbolOpt.get();
            if (SymbolKind.VARIABLE.equals((Object)firstArgSymbol.kind()) && TypeDescKind.INT.equals((Object)(variable = (VariableSymbol)firstArgSymbol).typeDescriptor().typeKind())) {
                return;
            }
            FunctionArgumentNode secondArg = (FunctionArgumentNode)functionArgs.get(1);
            AnalyserUtils.updateContext(context, WebSubDiagnosticCodes.WEBSUB_109, secondArg.location(), new Object[0]);
        }
    }

    private Optional<Symbol> getFirstListenerArg(SemanticModel semanticModel, FunctionArgumentNode firstArg) {
        if (SyntaxKind.POSITIONAL_ARG.equals((Object)firstArg.kind())) {
            return semanticModel.symbol((Node)((PositionalArgumentNode)firstArg).expression());
        }
        if (SyntaxKind.NAMED_ARG.equals((Object)firstArg.kind())) {
            return semanticModel.symbol((Node)((NamedArgumentNode)firstArg).expression());
        }
        return semanticModel.symbol((Node)((RestArgumentNode)firstArg).expression());
    }
}

