/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.task;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websub.WebSubDiagnosticCodes;
import io.ballerina.stdlib.websub.task.AnalyserUtils;
import io.ballerina.stdlib.websub.task.service.path.ServicePathGeneratorException;
import io.ballerina.stdlib.websub.task.service.path.ServicePathGeneratorManager;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import java.util.Optional;

public class WebSubServiceInfoGeneratorTask
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final ServicePathGeneratorManager servicePathGenerator = new ServicePathGeneratorManager();

    public void perform(SyntaxNodeAnalysisContext context) {
        SemanticModel semanticModel = context.semanticModel();
        boolean erroneousCompilation = semanticModel.diagnostics().stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
        if (erroneousCompilation) {
            return;
        }
        ServiceDeclarationNode serviceNode = (ServiceDeclarationNode)context.node();
        Optional serviceDeclarationOpt = semanticModel.symbol((Node)serviceNode);
        if (serviceDeclarationOpt.isPresent()) {
            ServiceDeclarationSymbol serviceDeclarationSymbol = (ServiceDeclarationSymbol)serviceDeclarationOpt.get();
            if (!AnalyserUtils.isWebSubService(serviceDeclarationSymbol)) {
                return;
            }
            if (!this.shouldGenerateServicePath(serviceNode, semanticModel)) {
                return;
            }
            this.generateUniqueServicePath(context, serviceDeclarationSymbol.hashCode(), serviceNode);
        }
    }

    private boolean shouldGenerateServicePath(ServiceDeclarationNode serviceNode, SemanticModel semanticModel) {
        boolean servicePathAvailable;
        Optional<AnnotationNode> subscriberConfigOpt = this.getSubscriberConfigAnnotation(serviceNode, semanticModel);
        if (subscriberConfigOpt.isEmpty()) {
            return false;
        }
        AnnotationNode subscriberConfig = subscriberConfigOpt.get();
        Optional<String> callbackUrl = this.retrieveValueForAnnotationFields(subscriberConfig, "callback");
        boolean bl = servicePathAvailable = serviceNode.absoluteResourcePath().size() >= 1;
        if (callbackUrl.isEmpty() && !servicePathAvailable) {
            return true;
        }
        Optional<String> appendServicePath = this.retrieveValueForAnnotationFields(subscriberConfig, "appendServicePath");
        return callbackUrl.isPresent() && appendServicePath.isPresent() && Boolean.parseBoolean(appendServicePath.get()) && !servicePathAvailable;
    }

    private Optional<AnnotationNode> getSubscriberConfigAnnotation(ServiceDeclarationNode serviceNode, SemanticModel semanticModel) {
        Optional metadata = serviceNode.metadata();
        if (metadata.isEmpty()) {
            return Optional.empty();
        }
        MetadataNode metaData = (MetadataNode)metadata.get();
        NodeList annotations = metaData.annotations();
        return annotations.stream().filter(ann -> this.isSubscriberConfigAnnotation((AnnotationNode)ann, semanticModel)).findFirst();
    }

    private boolean isSubscriberConfigAnnotation(AnnotationNode annotation, SemanticModel semanticModel) {
        Optional symbolOpt = semanticModel.symbol((Node)annotation);
        if (symbolOpt.isEmpty()) {
            return false;
        }
        Symbol symbol = (Symbol)symbolOpt.get();
        if (!(symbol instanceof AnnotationSymbol)) {
            return false;
        }
        AnnotationSymbol annotationSymbol = (AnnotationSymbol)symbol;
        String moduleName = annotationSymbol.getModule().flatMap(Symbol::getName).orElse("");
        String type = annotationSymbol.getName().orElse("");
        String annotationName = AnalyserUtils.getQualifiedType(type, moduleName);
        return "websub:SubscriberServiceConfig".equals(annotationName);
    }

    private Optional<String> retrieveValueForAnnotationFields(AnnotationNode serviceInfoAnnotation, String fieldName) {
        return serviceInfoAnnotation.annotValue().map(MappingConstructorExpressionNode::fields).flatMap(fields -> fields.stream().filter(fld -> fld instanceof SpecificFieldNode).map(fld -> (SpecificFieldNode)fld).filter(fld -> fieldName.equals(fld.fieldName().toString().trim())).findFirst()).flatMap(SpecificFieldNode::valueExpr).map(en -> en.toString().trim());
    }

    private void generateUniqueServicePath(SyntaxNodeAnalysisContext context, int serviceId, ServiceDeclarationNode serviceNode) {
        try {
            this.servicePathGenerator.generate(context, serviceId);
        }
        catch (ServicePathGeneratorException ex) {
            String errorMsg = ex.getLocalizedMessage();
            WebSubDiagnosticCodes errorCode = WebSubDiagnosticCodes.WEBSUB_200;
            AnalyserUtils.updateContext(context, errorCode, serviceNode.location(), errorMsg);
        }
    }
}

