/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.websub.task.validator;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ErrorTypeSymbol;
import io.ballerina.compiler.api.symbols.FunctionSymbol;
import io.ballerina.compiler.api.symbols.FunctionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeLocation;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.websub.CommonUtil;
import io.ballerina.stdlib.websub.WebSubDiagnosticCodes;
import io.ballerina.stdlib.websub.task.AnalyserUtils;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class ServiceDeclarationValidator {
    private static final ServiceDeclarationValidator INSTANCE = new ServiceDeclarationValidator();
    private static final List<String> allowedMethods = List.of("onSubscriptionValidationDenied", "onSubscriptionVerification", "onUnsubscriptionVerification", "onEventNotification");
    private static final Map<String, List<String>> allowedParameterTypes = Map.of("onSubscriptionValidationDenied", Collections.singletonList("websub:SubscriptionDeniedError"), "onSubscriptionVerification", Collections.singletonList("websub:SubscriptionVerification"), "onUnsubscriptionVerification", Collections.singletonList("websub:UnsubscriptionVerification"), "onEventNotification", Collections.singletonList("websub:ContentDistributionMessage"));
    private static final Map<String, List<String>> allowedReturnTypes = Map.of("onSubscriptionValidationDenied", Collections.singletonList("websub:Acknowledgement"), "onSubscriptionVerification", List.of("websub:SubscriptionVerificationSuccess", "websub:SubscriptionVerificationError"), "onUnsubscriptionVerification", List.of("websub:UnsubscriptionVerificationSuccess", "websub:UnsubscriptionVerificationError"), "onEventNotification", List.of("websub:Acknowledgement", "websub:SubscriptionDeletedError"));
    private static final List<String> methodsWithOptionalReturnTypes = List.of("onSubscriptionValidationDenied", "onEventNotification");

    public static ServiceDeclarationValidator getInstance() {
        return INSTANCE;
    }

    public void validate(SyntaxNodeAnalysisContext context, ServiceDeclarationNode serviceNode, ServiceDeclarationSymbol serviceDeclarationSymbol) {
        this.executeServiceAnnotationValidation(context, serviceNode, serviceDeclarationSymbol);
        List<FunctionDefinitionNode> availableFunctionDeclarations = serviceNode.members().stream().filter(member -> member.kind() == SyntaxKind.OBJECT_METHOD_DEFINITION).map(member -> (FunctionDefinitionNode)member).collect(Collectors.toList());
        this.executeRequiredMethodValidation(context, availableFunctionDeclarations, serviceNode.location());
        availableFunctionDeclarations.forEach(fd -> context.semanticModel().symbol((Node)fd).ifPresent(fs -> {
            NodeLocation location = fd.location();
            this.executeRemoteMethodValidation(context, (FunctionSymbol)fs, location);
            this.executeMethodParameterValidation(context, (FunctionDefinitionNode)fd, ((FunctionSymbol)fs).typeDescriptor());
            this.executeMethodReturnTypeValidation(context, (FunctionDefinitionNode)fd, ((FunctionSymbol)fs).typeDescriptor());
        }));
    }

    private void executeServiceAnnotationValidation(SyntaxNodeAnalysisContext context, ServiceDeclarationNode serviceNode, ServiceDeclarationSymbol serviceSymbol) {
        Optional<AnnotationSymbol> subscriberServiceAnnotationOptional = CommonUtil.extractSubscriberServiceConfig(serviceSymbol);
        if (subscriberServiceAnnotationOptional.isEmpty()) {
            WebSubDiagnosticCodes errorCode = WebSubDiagnosticCodes.WEBSUB_101;
            AnalyserUtils.updateContext(context, errorCode, serviceNode.location(), new Object[0]);
        }
    }

    private void executeRequiredMethodValidation(SyntaxNodeAnalysisContext context, List<FunctionDefinitionNode> availableFunctionDeclarations, NodeLocation location) {
        boolean isRequiredMethodNotAvailable = availableFunctionDeclarations.stream().noneMatch(fd -> "onEventNotification".equalsIgnoreCase(fd.functionName().toString()));
        if (isRequiredMethodNotAvailable) {
            WebSubDiagnosticCodes errorCode = WebSubDiagnosticCodes.WEBSUB_103;
            AnalyserUtils.updateContext(context, errorCode, location, new Object[0]);
        }
    }

    private void executeRemoteMethodValidation(SyntaxNodeAnalysisContext context, FunctionSymbol functionSymbol, NodeLocation location) {
        Optional functionNameOpt = functionSymbol.getName();
        if (functionNameOpt.isPresent()) {
            WebSubDiagnosticCodes errorCode;
            String functionName = (String)functionNameOpt.get();
            boolean isRemoteMethod = AnalyserUtils.isRemoteMethod(functionSymbol);
            boolean isAllowedMethod = allowedMethods.contains(functionName);
            if (isRemoteMethod && !isAllowedMethod) {
                errorCode = WebSubDiagnosticCodes.WEBSUB_104;
                AnalyserUtils.updateContext(context, errorCode, location, functionName);
            }
            if (!isRemoteMethod && isAllowedMethod) {
                errorCode = WebSubDiagnosticCodes.WEBSUB_102;
                AnalyserUtils.updateContext(context, errorCode, location, functionName);
            }
        }
    }

    private void executeMethodParameterValidation(SyntaxNodeAnalysisContext context, FunctionDefinitionNode functionDefinition, FunctionTypeSymbol typeSymbol) {
        String functionName = functionDefinition.functionName().toString();
        if (allowedMethods.contains(functionName)) {
            List<String> allowedParameters = allowedParameterTypes.get(functionName);
            Optional paramOpt = typeSymbol.params();
            if (paramOpt.isPresent()) {
                List params = (List)paramOpt.get();
                if (params.isEmpty()) {
                    if (!allowedParameters.isEmpty()) {
                        WebSubDiagnosticCodes errorCode = WebSubDiagnosticCodes.WEBSUB_106;
                        AnalyserUtils.updateContext(context, errorCode, functionDefinition.location(), functionName, String.join((CharSequence)"", allowedParameters));
                    }
                } else {
                    List availableParamNames = params.stream().map(e -> AnalyserUtils.getTypeDescription(e.typeDescriptor())).collect(Collectors.toList());
                    if (!allowedParameters.containsAll(availableParamNames)) {
                        List notAllowedParams = availableParamNames.stream().filter(e -> !allowedParameters.contains(e)).collect(Collectors.toList());
                        String message = String.join((CharSequence)",", notAllowedParams);
                        WebSubDiagnosticCodes errorCode = WebSubDiagnosticCodes.WEBSUB_105;
                        AnalyserUtils.updateContext(context, errorCode, functionDefinition.location(), message, functionName);
                    }
                }
            } else if (!allowedParameters.isEmpty()) {
                WebSubDiagnosticCodes errorCode = WebSubDiagnosticCodes.WEBSUB_106;
                AnalyserUtils.updateContext(context, errorCode, functionDefinition.location(), functionName, String.join((CharSequence)"", allowedParameters));
            }
        }
    }

    private void executeMethodReturnTypeValidation(SyntaxNodeAnalysisContext context, FunctionDefinitionNode functionDefinition, FunctionTypeSymbol typeSymbol) {
        String functionName = functionDefinition.functionName().toString();
        List<String> predefinedReturnTypes = allowedReturnTypes.get(functionName);
        boolean nilableReturnTypeAllowed = methodsWithOptionalReturnTypes.contains(functionName);
        if (allowedMethods.contains(functionName)) {
            Optional returnTypesOpt = typeSymbol.returnTypeDescriptor();
            if (returnTypesOpt.isPresent()) {
                TypeSymbol returnTypeDescription = (TypeSymbol)returnTypesOpt.get();
                if (returnTypeDescription.typeKind().equals((Object)TypeDescKind.NIL) && !nilableReturnTypeAllowed) {
                    WebSubDiagnosticCodes errorCode = WebSubDiagnosticCodes.WEBSUB_108;
                    AnalyserUtils.updateContext(context, errorCode, functionDefinition.location(), functionName, String.join((CharSequence)"|", predefinedReturnTypes));
                    return;
                }
                boolean invalidReturnTypePresent = this.isReturnTypeNotAllowed(predefinedReturnTypes, returnTypeDescription, nilableReturnTypeAllowed);
                if (invalidReturnTypePresent) {
                    String returnTypeName = AnalyserUtils.getTypeDescription(returnTypeDescription);
                    WebSubDiagnosticCodes errorCode = WebSubDiagnosticCodes.WEBSUB_107;
                    AnalyserUtils.updateContext(context, errorCode, functionDefinition.location(), returnTypeName, functionName);
                }
            } else if (!nilableReturnTypeAllowed) {
                WebSubDiagnosticCodes errorCode = WebSubDiagnosticCodes.WEBSUB_108;
                AnalyserUtils.updateContext(context, errorCode, functionDefinition.location(), functionName, String.join((CharSequence)"|", predefinedReturnTypes));
            }
        }
    }

    private boolean isReturnTypeNotAllowed(List<String> allowedReturnTypes, TypeSymbol returnTypeDescriptor, boolean nilableReturnTypeAllowed) {
        TypeDescKind typeKind = returnTypeDescriptor.typeKind();
        if (TypeDescKind.UNION.equals((Object)typeKind)) {
            return ((UnionTypeSymbol)returnTypeDescriptor).memberTypeDescriptors().stream().map(e -> this.isReturnTypeNotAllowed(allowedReturnTypes, (TypeSymbol)e, nilableReturnTypeAllowed)).reduce(false, (a, b) -> a != false || b != false);
        }
        if (TypeDescKind.TYPE_REFERENCE.equals((Object)typeKind)) {
            TypeSymbol internalType = ((TypeReferenceTypeSymbol)returnTypeDescriptor).typeDescriptor();
            if (internalType instanceof ErrorTypeSymbol) {
                return this.isInvalidErrorReturn(allowedReturnTypes, returnTypeDescriptor);
            }
            String moduleName = returnTypeDescriptor.getModule().flatMap(Symbol::getName).orElse("");
            String paramType = returnTypeDescriptor.getName().orElse("");
            String qualifiedParamType = AnalyserUtils.getQualifiedType(paramType, moduleName);
            return !allowedReturnTypes.contains(qualifiedParamType);
        }
        if (TypeDescKind.ERROR.equals((Object)typeKind)) {
            return this.isInvalidErrorReturn(allowedReturnTypes, returnTypeDescriptor);
        }
        if (TypeDescKind.NIL.equals((Object)typeKind)) {
            return !nilableReturnTypeAllowed;
        }
        return true;
    }

    private boolean isInvalidErrorReturn(List<String> allowedReturnTypes, TypeSymbol internalType) {
        String moduleName;
        Optional<ModuleID> moduleIdOpt;
        String moduleId;
        String signature = internalType.signature();
        String paramType = signature.replace(moduleId = (moduleIdOpt = internalType.getModule().map(ModuleSymbol::id)).map(ModuleID::toString).orElse(""), "").replace(":", "");
        String qualifiedParamType = AnalyserUtils.getQualifiedType(paramType, moduleName = moduleIdOpt.map(ModuleID::modulePrefix).orElse(""));
        if ("annotations:error".equals(qualifiedParamType)) {
            return false;
        }
        return !allowedReturnTypes.contains(qualifiedParamType);
    }

    private ServiceDeclarationValidator() {
    }
}

