/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.xmltorecordconverter;

import io.ballerina.xmltorecordconverter.XMLToRecordConverter;
import io.ballerina.xmltorecordconverter.XMLToRecordRequest;
import io.ballerina.xmltorecordconverter.XMLToRecordResponse;
import java.util.concurrent.CompletableFuture;
import org.ballerinalang.langserver.commons.service.spi.ExtendedLanguageServerService;
import org.eclipse.lsp4j.jsonrpc.services.JsonRequest;
import org.eclipse.lsp4j.jsonrpc.services.JsonSegment;

@JsonSegment(value="xmlToRecord")
public class XMLToRecordConverterService
implements ExtendedLanguageServerService {
    public Class<?> getRemoteInterface() {
        return this.getClass();
    }

    @JsonRequest
    public CompletableFuture<XMLToRecordResponse> convert(XMLToRecordRequest request) {
        return CompletableFuture.supplyAsync(() -> {
            String xmlValue = request.getXmlValue();
            boolean isRecordTypeDesc = request.getIsRecordTypeDesc();
            boolean isClosed = request.getIsClosed();
            boolean forceFormatRecordFields = request.getForceFormatRecordFields();
            String textFieldName = request.getTextFieldName();
            boolean withNameSpace = request.getIsWithNameSpace();
            boolean withoutAttributes = request.getWithoutAttributes();
            boolean withoutAttributeAnnot = request.getWithoutAttributeAnnot();
            return XMLToRecordConverter.convert(xmlValue, isRecordTypeDesc, isClosed, forceFormatRecordFields, textFieldName, withNameSpace, withoutAttributes, withoutAttributeAnnot);
        });
    }

    public String getName() {
        return "xmlToRecord";
    }
}

