/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.compiler;

import io.ballerina.tools.diagnostics.DiagnosticSeverity;

public enum XmldataDiagnosticCodes {
    DUPLICATE_FIELD("XML_ERROR_201", "invalid field: duplicate field found", DiagnosticSeverity.ERROR),
    UNSUPPORTED_UNION_TYPE("XML_ERROR_202", "unsupported union type: union type does not support multiple non-primitive record types", DiagnosticSeverity.ERROR),
    UNSUPPORTED_TYPE("XML_ERROR_203", "unsupported type: the record field does not support the expected type", DiagnosticSeverity.ERROR),
    EXPECTED_RECORD_TYPE("XML_ERROR_204", "invalid type: expected a record type", DiagnosticSeverity.ERROR),
    NAME_ANNOTATION_NOT_ALLOWED("XML_ERROR_205", "invalid annotation attachment: child record does not allow name annotation", DiagnosticSeverity.WARNING),
    INVALID_XSD_MODEL_GROUP_ANNOTATION("XML_ERROR_206", "invalid xsd annotation: record type or record array type expected", DiagnosticSeverity.ERROR),
    INVALID_SEQUENCE_TYPE("XML_ERROR_207", "Invalid sequence member: Order should be defined in in all fields", DiagnosticSeverity.ERROR),
    INVALID_SEQUENCE_REST_TYPE("XML_ERROR_208", "Invalid sequence member: Sequence members should be defined in a closed record", DiagnosticSeverity.ERROR),
    INVALID_CHOICE_REST_TYPE("XML_ERROR_209", "Invalid choice member: Choice members should be defined in a closed record", DiagnosticSeverity.ERROR),
    INVALID_ANNOTATIONS("XML_ERROR_210", "A record field cannot contains sequence/choice/element/attribute annotations simultaneously", DiagnosticSeverity.ERROR),
    UNSUPPORTED_XPATH_TYPE("XML_ERROR_211", "unsupported type: XPath projection does not support the expected type", DiagnosticSeverity.ERROR);

    private final String code;
    private final String message;
    private final DiagnosticSeverity severity;

    private XmldataDiagnosticCodes(String code, String message, DiagnosticSeverity severity) {
        this.code = code;
        this.message = message;
        this.severity = severity;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public DiagnosticSeverity getSeverity() {
        return this.severity;
    }
}

