/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.lib.data.xmldata.compiler;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.AnnotationSymbol;
import io.ballerina.compiler.api.symbols.ArrayTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.RecordFieldSymbol;
import io.ballerina.compiler.api.symbols.RecordTypeSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.api.symbols.VariableSymbol;
import io.ballerina.compiler.api.values.ConstantValue;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.ChildNodeList;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.lib.data.xmldata.compiler.XmldataDiagnosticCodes;
import io.ballerina.lib.data.xmldata.compiler.objects.QualifiedName;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;

public class XmldataRecordFieldValidator
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    private final Predicate<FunctionCallExpressionNode> isParseFunctionPredicate = this.createFunctionPredicateForName(functionName -> functionName.contains("parseString") || functionName.contains("parseBytes") || functionName.contains("parseStream") || functionName.contains("parseAsType"));
    private final Predicate<FunctionCallExpressionNode> isXPathFunctionPredicate = this.createFunctionPredicateForName(name -> name.contains("transform"));
    private SemanticModel semanticModel;
    private final HashMap<Location, DiagnosticInfo> allDiagnosticInfo = new HashMap();
    private String modulePrefix = "xmldata";
    private TypeDefinitionSymbol xPathSupportedTypes;

    public void perform(SyntaxNodeAnalysisContext ctx) {
        this.semanticModel = ctx.semanticModel();
        this.xPathSupportedTypes = (TypeDefinitionSymbol)this.semanticModel.types().getTypeByName("ballerina", "data.xmldata", "", "SupportedType").orElseThrow(() -> new IllegalStateException("Failed to find XPath SupportedTypes"));
        List diagnostics = this.semanticModel.diagnostics();
        boolean erroneousCompilation = diagnostics.stream().anyMatch(d -> d.diagnosticInfo().severity().equals((Object)DiagnosticSeverity.ERROR));
        if (erroneousCompilation) {
            this.reset();
            return;
        }
        ModulePartNode rootNode = (ModulePartNode)ctx.node();
        this.updateModulePrefix(rootNode);
        for (ModuleMemberDeclarationNode member : rootNode.members()) {
            switch (member.kind()) {
                case FUNCTION_DEFINITION: {
                    this.processFunctionDefinitionNode((FunctionDefinitionNode)member, ctx);
                    break;
                }
                case MODULE_VAR_DECL: {
                    this.processModuleVariableDeclarationNode((ModuleVariableDeclarationNode)member, ctx);
                    break;
                }
                case TYPE_DEFINITION: {
                    this.processTypeDefinitionNode((TypeDefinitionNode)member, ctx);
                }
            }
        }
        this.reset();
    }

    private void reset() {
        this.semanticModel = null;
        this.allDiagnosticInfo.clear();
        this.modulePrefix = "xmldata";
    }

    private void updateModulePrefix(ModulePartNode rootNode) {
        for (ImportDeclarationNode importDeclarationNode : rootNode.imports()) {
            ModuleSymbol moduleSymbol;
            Optional symbol = this.semanticModel.symbol((Node)importDeclarationNode);
            if (!symbol.isPresent() || ((Symbol)symbol.get()).kind() != SymbolKind.MODULE || !this.isXmldataImport(moduleSymbol = (ModuleSymbol)symbol.get())) continue;
            this.modulePrefix = moduleSymbol.id().modulePrefix();
            break;
        }
    }

    private boolean isXmldataImport(ModuleSymbol moduleSymbol) {
        ModuleID moduleId = moduleSymbol.id();
        return "ballerina".equals(moduleId.orgName()) && "data.xmldata".equals(moduleId.moduleName());
    }

    private void processFunctionDefinitionNode(FunctionDefinitionNode functionDefinitionNode, SyntaxNodeAnalysisContext ctx) {
        ChildNodeList childNodeList = functionDefinitionNode.functionBody().children();
        for (Node node : childNodeList) {
            Optional symbol;
            VariableDeclarationNode variableDeclarationNode;
            Optional initializer;
            if (node.kind() != SyntaxKind.LOCAL_VAR_DECL || (initializer = (variableDeclarationNode = (VariableDeclarationNode)node).initializer()).isEmpty() || (symbol = this.semanticModel.symbol((Node)variableDeclarationNode.typedBindingPattern())).isEmpty()) continue;
            TypeSymbol typeSymbol = ((VariableSymbol)symbol.get()).typeDescriptor();
            ExpressionNode expressionNode = (ExpressionNode)initializer.get();
            if (this.isParseFunctionFromXmldata(expressionNode)) {
                this.validateParseFunctionExpectedType(typeSymbol, ((Symbol)symbol.get()).getLocation(), ctx);
                continue;
            }
            if (this.isXpathTransformFunction(expressionNode)) {
                this.validateXPathTransformFunctionExpectedType(typeSymbol, ((Symbol)symbol.get()).getLocation(), ctx);
                continue;
            }
            this.validateAnnotationUsageInAllInlineExpectedTypes(typeSymbol, ctx);
        }
    }

    private void validateAnnotationUsageInAllInlineExpectedTypes(TypeSymbol typeSymbol, SyntaxNodeAnalysisContext ctx) {
        switch (typeSymbol.typeKind()) {
            case RECORD: {
                this.validateRecordFieldNames((RecordTypeSymbol)typeSymbol, ctx);
                this.validateXsdModelGroupAnnotations((RecordTypeSymbol)typeSymbol, ctx);
                break;
            }
            case UNION: {
                for (TypeSymbol memberTSymbol : ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors()) {
                    this.validateAnnotationUsageInAllInlineExpectedTypes(memberTSymbol, ctx);
                }
                break;
            }
        }
    }

    private void validateXPathTransformFunctionExpectedType(TypeSymbol typeSymbol, Optional<Location> location, SyntaxNodeAnalysisContext ctx) {
        if (!typeSymbol.subtypeOf(this.xPathSupportedTypes.typeDescriptor())) {
            this.reportDiagnosticInfo(ctx, location, XmldataDiagnosticCodes.UNSUPPORTED_XPATH_TYPE);
        }
    }

    private void validateParseFunctionExpectedType(TypeSymbol typeSymbol, Optional<Location> location, SyntaxNodeAnalysisContext ctx) {
        if (this.isNotValidExpectedType(typeSymbol)) {
            this.reportDiagnosticInfo(ctx, location, XmldataDiagnosticCodes.EXPECTED_RECORD_TYPE);
        }
        switch (typeSymbol.typeKind()) {
            case RECORD: {
                RecordTypeSymbol recordSymbol = (RecordTypeSymbol)typeSymbol;
                this.validateRecordFieldNames(recordSymbol, ctx);
                this.validateXsdModelGroupAnnotations(recordSymbol, ctx);
                this.processRecordFieldsType(recordSymbol, ctx);
                break;
            }
            case TYPE_REFERENCE: {
                this.validateParseFunctionExpectedType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), location, ctx);
                break;
            }
            case UNION: {
                int recordCount = 0;
                for (TypeSymbol memberTSymbol : ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors()) {
                    TypeDescKind typeDescKind = this.getReferredTypeSymbol(memberTSymbol).typeKind();
                    if (typeDescKind == TypeDescKind.ERROR || typeDescKind != TypeDescKind.RECORD) continue;
                    this.validateParseFunctionExpectedType(memberTSymbol, location, ctx);
                    ++recordCount;
                }
                if (recordCount != 0) break;
                this.reportDiagnosticInfo(ctx, location, XmldataDiagnosticCodes.EXPECTED_RECORD_TYPE);
            }
        }
    }

    private TypeSymbol getReferredTypeSymbol(TypeSymbol typeSymbol) {
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return ((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor();
        }
        return typeSymbol;
    }

    private boolean isNotValidExpectedType(TypeSymbol typeSymbol) {
        switch (typeSymbol.typeKind()) {
            case RECORD: 
            case MAP: {
                return false;
            }
            case TYPE_REFERENCE: {
                return this.isNotValidExpectedType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor());
            }
            case UNION: {
                for (TypeSymbol memberTSymbol : ((UnionTypeSymbol)typeSymbol).memberTypeDescriptors()) {
                    TypeSymbol referredTypeSymbol = this.getReferredTypeSymbol(memberTSymbol);
                    if (referredTypeSymbol.typeKind() == TypeDescKind.ERROR || referredTypeSymbol.typeKind() == TypeDescKind.RECORD) continue;
                    return true;
                }
                return false;
            }
        }
        return true;
    }

    private void processModuleVariableDeclarationNode(ModuleVariableDeclarationNode moduleVariableDeclarationNode, SyntaxNodeAnalysisContext ctx) {
        Optional initializer = moduleVariableDeclarationNode.initializer();
        if (initializer.isEmpty()) {
            return;
        }
        Optional symbol = this.semanticModel.symbol((Node)moduleVariableDeclarationNode.typedBindingPattern());
        if (symbol.isEmpty()) {
            return;
        }
        TypeSymbol typeSymbol = ((VariableSymbol)symbol.get()).typeDescriptor();
        ExpressionNode expressionNode = (ExpressionNode)initializer.get();
        if (this.isParseFunctionFromXmldata(expressionNode)) {
            this.validateParseFunctionExpectedType(typeSymbol, ((Symbol)symbol.get()).getLocation(), ctx);
        } else if (this.isXpathTransformFunction(expressionNode)) {
            this.validateXPathTransformFunctionExpectedType(typeSymbol, ((Symbol)symbol.get()).getLocation(), ctx);
        } else {
            this.validateAnnotationUsageInAllInlineExpectedTypes(typeSymbol, ctx);
        }
    }

    private void processTypeDefinitionNode(TypeDefinitionNode typeDefinitionNode, SyntaxNodeAnalysisContext ctx) {
        Node typeDescriptor = typeDefinitionNode.typeDescriptor();
        if (typeDescriptor.kind() != SyntaxKind.RECORD_TYPE_DESC) {
            return;
        }
        this.validateRecordTypeDefinition(typeDefinitionNode, ctx);
    }

    private void validateRecordTypeDefinition(TypeDefinitionNode typeDefinitionNode, SyntaxNodeAnalysisContext ctx) {
        Optional symbol = this.semanticModel.symbol((Node)typeDefinitionNode);
        if (symbol.isEmpty()) {
            return;
        }
        TypeDefinitionSymbol typeDefinitionSymbol = (TypeDefinitionSymbol)symbol.get();
        this.validateRecordFieldNames((RecordTypeSymbol)typeDefinitionSymbol.typeDescriptor(), ctx);
        this.validateXsdModelGroupAnnotations((RecordTypeSymbol)typeDefinitionSymbol.typeDescriptor(), ctx);
    }

    private void validateXsdModelGroupAnnotations(RecordTypeSymbol recordTypeSymbol, SyntaxNodeAnalysisContext ctx) {
        for (Map.Entry entry : recordTypeSymbol.fieldDescriptors().entrySet()) {
            RecordFieldSymbol fieldSymbol = (RecordFieldSymbol)entry.getValue();
            boolean isUniqueAnnotationHasValue = false;
            for (AnnotationAttachmentSymbol annotationAttachmentSymbol : fieldSymbol.annotAttachments()) {
                Optional annotName;
                AnnotationSymbol annotationSymbol = annotationAttachmentSymbol.typeDescriptor();
                if (!this.isAnnotFromXmldata(annotationSymbol) || (annotName = annotationSymbol.getName()).isEmpty()) continue;
                String name = (String)annotName.get();
                if (this.isModelGroupAnnotation(name) || name.equals("Element") || name.equals("Attribute")) {
                    if (isUniqueAnnotationHasValue) {
                        this.reportDiagnosticInfo(ctx, fieldSymbol.getLocation(), XmldataDiagnosticCodes.INVALID_ANNOTATIONS);
                    } else {
                        isUniqueAnnotationHasValue = true;
                    }
                }
                if (this.isModelGroupAnnotation(name)) {
                    this.validateXsdModelGroupAnnotation(fieldSymbol.typeDescriptor(), fieldSymbol.getLocation(), ctx);
                }
                if (name.equals("Sequence")) {
                    this.validateSequenceAnnotation(fieldSymbol.typeDescriptor(), fieldSymbol.getLocation(), ctx);
                }
                if (!name.equals("Choice")) continue;
                this.validateChoiceAnnotation(fieldSymbol.typeDescriptor(), fieldSymbol.getLocation(), ctx);
            }
        }
    }

    private void validateChoiceAnnotation(TypeSymbol typeSymbol, Optional<Location> location, SyntaxNodeAnalysisContext ctx) {
        RecordTypeSymbol recordTypeSymbol = null;
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            this.validateChoiceAnnotation(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), location, ctx);
            return;
        }
        if (typeSymbol.typeKind() == TypeDescKind.RECORD) {
            recordTypeSymbol = (RecordTypeSymbol)typeSymbol;
        }
        if (typeSymbol.typeKind() == TypeDescKind.ARRAY) {
            TypeSymbol memberTypeSymbol = ((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor();
            if (memberTypeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                memberTypeSymbol = ((TypeReferenceTypeSymbol)memberTypeSymbol).typeDescriptor();
            }
            if (memberTypeSymbol.typeKind() == TypeDescKind.RECORD) {
                recordTypeSymbol = (RecordTypeSymbol)memberTypeSymbol;
            }
        }
        if (recordTypeSymbol != null) {
            Optional loctaion = recordTypeSymbol.getLocation();
            recordTypeSymbol.restTypeDescriptor().ifPresent(restTypeSymbol -> this.reportDiagnosticInfo(ctx, loctaion, XmldataDiagnosticCodes.INVALID_CHOICE_REST_TYPE));
        }
    }

    private void validateSequenceAnnotation(TypeSymbol typeSymbol, Optional<Location> location, SyntaxNodeAnalysisContext ctx) {
        RecordTypeSymbol recordTypeSymbol = null;
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            this.validateSequenceAnnotation(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), location, ctx);
            return;
        }
        if (typeSymbol.typeKind() == TypeDescKind.RECORD) {
            recordTypeSymbol = (RecordTypeSymbol)typeSymbol;
        }
        if (typeSymbol.typeKind() == TypeDescKind.ARRAY) {
            TypeSymbol memberTypeSymbol = ((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor();
            if (memberTypeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                memberTypeSymbol = ((TypeReferenceTypeSymbol)memberTypeSymbol).typeDescriptor();
            }
            if (memberTypeSymbol.typeKind() == TypeDescKind.RECORD) {
                recordTypeSymbol = (RecordTypeSymbol)memberTypeSymbol;
            }
        }
        if (recordTypeSymbol != null) {
            Optional loctaion = recordTypeSymbol.getLocation();
            recordTypeSymbol.restTypeDescriptor().ifPresent(restTypeSymbol -> this.reportDiagnosticInfo(ctx, loctaion, XmldataDiagnosticCodes.INVALID_SEQUENCE_REST_TYPE));
            for (Map.Entry entry : recordTypeSymbol.fieldDescriptors().entrySet()) {
                RecordFieldSymbol fieldSymbol = (RecordFieldSymbol)entry.getValue();
                if (fieldSymbol.annotAttachments().isEmpty()) {
                    this.reportDiagnosticInfo(ctx, fieldSymbol.getLocation(), XmldataDiagnosticCodes.INVALID_SEQUENCE_TYPE);
                }
                boolean isOrderAnnotationFound = false;
                for (AnnotationAttachmentSymbol annotSymbol : fieldSymbol.annotAttachments()) {
                    String name;
                    Optional annotName;
                    AnnotationSymbol annotationSymbol = annotSymbol.typeDescriptor();
                    if (!this.isAnnotFromXmldata(annotationSymbol) || (annotName = annotationSymbol.getName()).isEmpty() || !(name = (String)annotName.get()).equals("SequenceOrder")) continue;
                    isOrderAnnotationFound = true;
                }
                if (isOrderAnnotationFound) continue;
                this.reportDiagnosticInfo(ctx, fieldSymbol.getLocation(), XmldataDiagnosticCodes.INVALID_SEQUENCE_TYPE);
            }
        }
    }

    private boolean isModelGroupAnnotation(String annotationName) {
        return annotationName.equals("Sequence") || annotationName.equals("Choice");
    }

    private void validateXsdModelGroupAnnotation(TypeSymbol typeSymbol, Optional<Location> location, SyntaxNodeAnalysisContext ctx) {
        if (typeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            this.validateXsdModelGroupAnnotation(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), location, ctx);
            return;
        }
        if (typeSymbol.typeKind() == TypeDescKind.RECORD) {
            return;
        }
        if (typeSymbol.typeKind() == TypeDescKind.ARRAY) {
            TypeSymbol memberTypeSymbol = ((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor();
            if (memberTypeSymbol.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                memberTypeSymbol = ((TypeReferenceTypeSymbol)memberTypeSymbol).typeDescriptor();
            }
            if (memberTypeSymbol.typeKind() == TypeDescKind.RECORD) {
                return;
            }
        }
        this.reportDiagnosticInfo(ctx, location, XmldataDiagnosticCodes.INVALID_XSD_MODEL_GROUP_ANNOTATION);
    }

    private void validateRecordFieldNames(RecordTypeSymbol recordTypeSymbol, SyntaxNodeAnalysisContext ctx) {
        ArrayList<QualifiedName> fieldMembers = new ArrayList<QualifiedName>();
        for (Map.Entry entry : recordTypeSymbol.fieldDescriptors().entrySet()) {
            RecordFieldSymbol fieldSymbol = (RecordFieldSymbol)entry.getValue();
            this.detectDuplicateFields((String)entry.getKey(), fieldSymbol, fieldMembers, ctx);
            if (fieldSymbol.typeDescriptor().typeKind() != TypeDescKind.TYPE_REFERENCE) continue;
            this.detectNameAnnotUsageWarning(fieldSymbol, ctx);
        }
    }

    private void detectDuplicateFields(String fieldName, RecordFieldSymbol fieldSymbol, List<QualifiedName> fieldMembers, SyntaxNodeAnalysisContext ctx) {
        QualifiedName fieldQName = this.getQNameFromAnnotation(fieldName, fieldSymbol.annotAttachments());
        if (fieldMembers.contains(fieldQName)) {
            this.reportDiagnosticInfo(ctx, fieldSymbol.getLocation(), XmldataDiagnosticCodes.DUPLICATE_FIELD);
            return;
        }
        fieldMembers.add(fieldQName);
    }

    private void detectNameAnnotUsageWarning(RecordFieldSymbol fieldSymbol, SyntaxNodeAnalysisContext ctx) {
        Optional location = fieldSymbol.typeDescriptor().getLocation();
        if (location.isEmpty()) {
            return;
        }
        TypeSymbol typeSymbol = fieldSymbol.typeDescriptor();
        if (typeSymbol.typeKind() != TypeDescKind.TYPE_REFERENCE) {
            return;
        }
        TypeReferenceTypeSymbol typeReferenceTypeSymbol = (TypeReferenceTypeSymbol)typeSymbol;
        Symbol symbol = typeReferenceTypeSymbol.definition();
        if (symbol == null || symbol.kind() != SymbolKind.TYPE_DEFINITION) {
            return;
        }
        TypeDefinitionSymbol typeDefinitionSymbol = (TypeDefinitionSymbol)symbol;
        typeDefinitionSymbol.annotations().forEach(annotationSymbol -> {
            if (!this.isAnnotFromXmldata((AnnotationSymbol)annotationSymbol)) {
                return;
            }
            Optional annotName = annotationSymbol.getName();
            if (annotName.isPresent() && ((String)annotName.get()).equals("Name")) {
                this.reportDiagnosticInfo(ctx, typeDefinitionSymbol.getLocation(), XmldataDiagnosticCodes.NAME_ANNOTATION_NOT_ALLOWED);
            }
        });
    }

    private void processRecordFieldsType(RecordTypeSymbol recordTypeSymbol, SyntaxNodeAnalysisContext ctx) {
        for (Map.Entry entry : recordTypeSymbol.fieldDescriptors().entrySet()) {
            RecordFieldSymbol fieldSymbol = (RecordFieldSymbol)entry.getValue();
            TypeSymbol typeSymbol = fieldSymbol.typeDescriptor();
            this.validateRecordFieldType(typeSymbol, fieldSymbol.getLocation(), ctx);
        }
    }

    private void validateRecordFieldType(TypeSymbol typeSymbol, Optional<Location> location, SyntaxNodeAnalysisContext ctx) {
        switch (typeSymbol.typeKind()) {
            case NIL: 
            case TUPLE: {
                this.reportDiagnosticInfo(ctx, location, XmldataDiagnosticCodes.UNSUPPORTED_TYPE);
                break;
            }
            case ARRAY: {
                this.validateRecordFieldType(((ArrayTypeSymbol)typeSymbol).memberTypeDescriptor(), location, ctx);
                break;
            }
            case TYPE_REFERENCE: {
                this.validateRecordFieldType(((TypeReferenceTypeSymbol)typeSymbol).typeDescriptor(), location, ctx);
            }
        }
    }

    private boolean isAnnotFromXmldata(AnnotationSymbol annotationSymbol) {
        Optional moduleSymbol = annotationSymbol.getModule();
        if (moduleSymbol.isEmpty()) {
            return false;
        }
        Optional moduleName = ((ModuleSymbol)moduleSymbol.get()).getName();
        return moduleName.map(val -> val.contains("xmldata")).orElse(false);
    }

    private QualifiedName getQNameFromAnnotation(String fieldName, List<AnnotationAttachmentSymbol> annotationAttachments) {
        String uri = "";
        String name = fieldName;
        String prefix = "";
        boolean isAttribute = false;
        for (AnnotationAttachmentSymbol annotAttSymbol : annotationAttachments) {
            Optional nameAnnot;
            AnnotationSymbol annotation = annotAttSymbol.typeDescriptor();
            if (!this.getAnnotModuleName(annotation).contains("xmldata") || (nameAnnot = annotation.getName()).isEmpty()) continue;
            String value = (String)nameAnnot.get();
            if (value.equals("Name")) {
                name = ((LinkedHashMap)((ConstantValue)annotAttSymbol.attachmentValue().orElseThrow()).value()).get("value").toString();
                continue;
            }
            if (value.equals("Namespace")) {
                Object temp = ((LinkedHashMap)((ConstantValue)annotAttSymbol.attachmentValue().orElseThrow()).value()).get("prefix");
                if (temp != null) {
                    prefix = temp.toString();
                }
                uri = ((LinkedHashMap)((ConstantValue)annotAttSymbol.attachmentValue().orElseThrow()).value()).get("uri").toString();
                continue;
            }
            if (!value.equals("Attribute")) continue;
            isAttribute = true;
        }
        return new QualifiedName(uri, name, prefix, isAttribute);
    }

    private String getAnnotModuleName(AnnotationSymbol annotation) {
        Optional moduleSymbol = annotation.getModule();
        if (moduleSymbol.isEmpty()) {
            return "";
        }
        Optional moduleName = ((ModuleSymbol)moduleSymbol.get()).getName();
        return moduleName.orElse("");
    }

    private boolean isParseFunctionFromXmldata(ExpressionNode expressionNode) {
        return this.isFunctionCallMatching(expressionNode, this.isParseFunctionPredicate);
    }

    private boolean isXpathTransformFunction(ExpressionNode expressionNode) {
        return this.isFunctionCallMatching(expressionNode, this.isXPathFunctionPredicate);
    }

    private boolean isFunctionCallMatching(ExpressionNode expressionNode, Predicate<FunctionCallExpressionNode> predicate) {
        if (expressionNode.kind() == SyntaxKind.CHECK_EXPRESSION) {
            expressionNode = ((CheckExpressionNode)expressionNode).expression();
        }
        if (expressionNode.kind() != SyntaxKind.FUNCTION_CALL) {
            return false;
        }
        FunctionCallExpressionNode functionCallExpression = (FunctionCallExpressionNode)expressionNode;
        return predicate.test(functionCallExpression);
    }

    private Predicate<FunctionCallExpressionNode> createFunctionPredicateForName(Predicate<String> namePredicate) {
        return functionCallExpression -> {
            NameReferenceNode nameReferenceNode = functionCallExpression.functionName();
            if (nameReferenceNode.kind() != SyntaxKind.QUALIFIED_NAME_REFERENCE) {
                return false;
            }
            String prefix = ((QualifiedNameReferenceNode)nameReferenceNode).modulePrefix().text();
            if (!prefix.equals(this.modulePrefix)) {
                return false;
            }
            String functionName = functionCallExpression.functionName().toSourceCode().trim();
            return namePredicate.test(functionName);
        };
    }

    private void reportDiagnosticInfo(SyntaxNodeAnalysisContext ctx, Optional<Location> location, XmldataDiagnosticCodes diagnosticsCodes) {
        if (location.isEmpty()) {
            return;
        }
        Location pos = location.get();
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(diagnosticsCodes.getCode(), diagnosticsCodes.getMessage(), diagnosticsCodes.getSeverity());
        if (this.allDiagnosticInfo.containsKey(pos) && this.allDiagnosticInfo.get(pos).equals((Object)diagnosticInfo)) {
            return;
        }
        this.allDiagnosticInfo.put(pos, diagnosticInfo);
        ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)pos, (Object[])new Object[0]));
    }
}

