/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langserver.launchers.stdio;

import com.google.gson.JsonObject;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.ballerinalang.langserver.BallerinaLanguageServer;
import org.ballerinalang.langserver.apispec.ApiSpecGenerator;
import org.ballerinalang.langserver.commons.client.ExtendedLanguageClient;
import org.eclipse.lsp4j.jsonrpc.Launcher;

public final class Main {
    private Main() {
    }

    public static void main(String[] args) throws InterruptedException, ExecutionException {
        LogManager.getLogManager().reset();
        Logger globalLogger = Logger.getLogger("global");
        globalLogger.setLevel(Level.OFF);
        Main.startServer(System.in, System.out);
    }

    public static void startServer(InputStream in, OutputStream out) throws InterruptedException, ExecutionException {
        System.getProperty("enableOutputStream", "false");
        BallerinaLanguageServer server = new BallerinaLanguageServer();
        Launcher launcher = Launcher.createLauncher((Object)server, ExtendedLanguageClient.class, (InputStream)in, (OutputStream)out);
        ExtendedLanguageClient client = (ExtendedLanguageClient)launcher.getRemoteProxy();
        server.connect(client);
        Future startListening = launcher.startListening();
        startListening.get();
    }

    public static List<JsonObject> generateApiDoc() {
        System.getProperty("enableOutputStream", "false");
        BallerinaLanguageServer langServer = new BallerinaLanguageServer();
        Map jsonRpcMethodMap = langServer.supportedMethods();
        return jsonRpcMethodMap.values().stream().map(ApiSpecGenerator::generate).toList();
    }
}

