/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.parser;

import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.syntaxapicallsgen.parser.SyntaxApiCallsGenParser;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;

public class StatementParser
extends SyntaxApiCallsGenParser {
    public StatementParser(long timeoutMs) {
        super(timeoutMs);
    }

    @Override
    public Node parse(String source) {
        String sourceCode = String.format("function main(){%s}", source);
        TextDocument document = TextDocuments.from((String)sourceCode);
        SyntaxTree tree = this.getSyntaxTree(document);
        ModulePartNode node = (ModulePartNode)tree.rootNode();
        NodeList moduleDclns = node.members();
        this.assertIf(!moduleDclns.isEmpty(), "not a valid statement: expected at least one member");
        ModuleMemberDeclarationNode moduleDeclaration = (ModuleMemberDeclarationNode)moduleDclns.get(0);
        FunctionDefinitionNode mainFunction = (FunctionDefinitionNode)moduleDeclaration;
        FunctionBodyBlockNode mainFunctionBody = (FunctionBodyBlockNode)mainFunction.functionBody();
        return NodeFactory.createBlockStatementNode((Token)mainFunctionBody.openBraceToken(), (NodeList)mainFunctionBody.statements(), (Token)mainFunctionBody.closeBraceToken());
    }
}

