/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.parser;

import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.syntaxapicallsgen.SyntaxApiCallsGenException;
import io.ballerina.syntaxapicallsgen.config.SyntaxApiCallsGenConfig;
import io.ballerina.syntaxapicallsgen.parser.ExpressionParser;
import io.ballerina.syntaxapicallsgen.parser.ModuleParser;
import io.ballerina.syntaxapicallsgen.parser.StatementParser;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.text.TextDocument;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public abstract class SyntaxApiCallsGenParser {
    private static final Set<String> SILENCED_ERRORS = Set.of("BCE0517");
    private final long timeoutMs;

    protected SyntaxApiCallsGenParser(long timeoutMs) {
        this.timeoutMs = timeoutMs;
    }

    public static SyntaxApiCallsGenParser fromConfig(SyntaxApiCallsGenConfig config) {
        long timeoutMs = config.parserTimeout();
        return switch (config.parser()) {
            case SyntaxApiCallsGenConfig.Parser.EXPRESSION -> new ExpressionParser(timeoutMs);
            case SyntaxApiCallsGenConfig.Parser.STATEMENT -> new StatementParser(timeoutMs);
            default -> new ModuleParser(timeoutMs);
        };
    }

    public static String highlightDiagnostic(TextDocument textDocument, Diagnostic diagnostic) {
        String space = " ";
        String sourceLine = textDocument.line(diagnostic.location().lineRange().startLine().line()).text();
        int position = diagnostic.location().lineRange().startLine().offset();
        return String.format("%s%n%s%n%s^", diagnostic.message(), sourceLine, space.repeat(position));
    }

    protected SyntaxTree getSyntaxTree(TextDocument document) throws SyntaxApiCallsGenException {
        SyntaxTree tree;
        ExecutorService executor = Executors.newFixedThreadPool(1);
        Future<SyntaxTree> future = executor.submit(() -> SyntaxTree.from((TextDocument)document));
        executor.shutdown();
        try {
            tree = future.get(this.timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            throw new SyntaxApiCallsGenException("Parsing was interrupted.");
        }
        catch (ExecutionException e) {
            throw new SyntaxApiCallsGenException("Executor failure because " + e.getCause().getMessage());
        }
        catch (TimeoutException e) {
            future.cancel(true);
            throw new SyntaxApiCallsGenException("Parsing was timed out.");
        }
        for (Diagnostic diagnostic : tree.diagnostics()) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR || SILENCED_ERRORS.contains(diagnostic.diagnosticInfo().code())) continue;
            throw new SyntaxApiCallsGenException(SyntaxApiCallsGenParser.highlightDiagnostic(document, diagnostic));
        }
        return tree;
    }

    public abstract Node parse(String var1);

    protected void assertIf(boolean condition, String message) {
        if (!condition) {
            throw new SyntaxApiCallsGenException(message);
        }
    }
}

