/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.segment;

import io.ballerina.syntaxapicallsgen.segment.CodeSegment;

public class StringSegment
extends CodeSegment {
    private static final String BACKSLASH_CHAR = "\\";
    private static final String TAB_CHAR = "\t";
    private static final String BACKSPACE_CHAR = "\b";
    private static final String NEWLINE_CHAR = "\n";
    private static final String CAR_RETURN_CHAR = "\r";
    private static final String FORM_FEED_CHAR = "\f";
    private static final String SINGLE_QUOTE_CHAR = "'";
    private static final String DOUBLE_QUOTE_CHAR = "\"";
    private static final String ESCAPED_BACKSLASH_CHAR = "\\\\";
    private static final String ESCAPED_TAB_CHAR = "\\t";
    private static final String ESCAPED_BACKSPACE_CHAR = "\\b";
    private static final String ESCAPED_NEWLINE_CHAR = "\\n";
    private static final String ESCAPED_CAR_RETURN_CHAR = "\\r";
    private static final String ESCAPED_FORM_FEED_CHAR = "\\f";
    private static final String ESCAPED_SINGLE_QUOTE_CHAR = "\\'";
    private static final String ESCAPED_DOUBLE_QUOTE_CHAR = "\\\"";

    public StringSegment(String content) {
        super(content);
    }

    @Override
    public StringBuilder stringBuilder() {
        String escapedString = this.content.replace(BACKSLASH_CHAR, ESCAPED_BACKSLASH_CHAR).replace(TAB_CHAR, ESCAPED_TAB_CHAR).replace(BACKSPACE_CHAR, ESCAPED_BACKSPACE_CHAR).replace(NEWLINE_CHAR, ESCAPED_NEWLINE_CHAR).replace(CAR_RETURN_CHAR, ESCAPED_CAR_RETURN_CHAR).replace(FORM_FEED_CHAR, ESCAPED_FORM_FEED_CHAR).replace(SINGLE_QUOTE_CHAR, ESCAPED_SINGLE_QUOTE_CHAR).replace(DOUBLE_QUOTE_CHAR, ESCAPED_DOUBLE_QUOTE_CHAR);
        return new StringBuilder().append(DOUBLE_QUOTE_CHAR).append(escapedString).append(DOUBLE_QUOTE_CHAR);
    }
}

