/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.syntaxapicallsgen.segment.factories;

import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.syntaxapicallsgen.SyntaxApiCallsGenException;
import io.ballerina.syntaxapicallsgen.segment.NodeFactorySegment;
import io.ballerina.syntaxapicallsgen.segment.Segment;
import io.ballerina.syntaxapicallsgen.segment.factories.SegmentFactory;

public final class MinutiaeSegmentFactory {
    private static final String CREATE_EMPTY_MINUTIAE_LIST_METHOD_NAME = "createEmptyMinutiaeList";
    private static final String CREATE_MINUTIAE_LIST_METHOD_NAME = "createMinutiaeList";
    private static final String CREATE_COMMENT_METHOD_NAME = "createCommentMinutiae";
    private static final String CREATE_WHITESPACE_METHOD_NAME = "createWhitespaceMinutiae";
    private static final String CREATE_EOL_METHOD_NAME = "createEndOfLineMinutiae";

    private MinutiaeSegmentFactory() {
    }

    public static Segment createMinutiaeListSegment(MinutiaeList minutiaeList) {
        if (minutiaeList.isEmpty()) {
            return SegmentFactory.createMinutiaeFactorySegment(CREATE_EMPTY_MINUTIAE_LIST_METHOD_NAME);
        }
        NodeFactorySegment minutiaeListMethod = SegmentFactory.createMinutiaeFactorySegment(CREATE_MINUTIAE_LIST_METHOD_NAME);
        minutiaeList.forEach(minutiae -> minutiaeListMethod.addParameter(MinutiaeSegmentFactory.createMinutiaeSegment(minutiae)));
        return minutiaeListMethod;
    }

    private static Segment createMinutiaeSegment(Minutiae minutiae) {
        String methodName;
        if (minutiae.kind() == SyntaxKind.COMMENT_MINUTIAE) {
            methodName = CREATE_COMMENT_METHOD_NAME;
        } else if (minutiae.kind() == SyntaxKind.WHITESPACE_MINUTIAE) {
            methodName = CREATE_WHITESPACE_METHOD_NAME;
        } else if (minutiae.kind() == SyntaxKind.END_OF_LINE_MINUTIAE) {
            methodName = CREATE_EOL_METHOD_NAME;
        } else {
            if (minutiae.kind() == SyntaxKind.INVALID_NODE_MINUTIAE) {
                throw new SyntaxApiCallsGenException("Invalid node minutiae found with text: " + minutiae.text() + " at " + String.valueOf(minutiae.lineRange()));
            }
            throw new SyntaxApiCallsGenException("Unexpected Minutiae found");
        }
        NodeFactorySegment nodeFactorySegment = SegmentFactory.createNodeFactorySegment(methodName);
        nodeFactorySegment.addParameter(SegmentFactory.createStringSegment(minutiae.text()));
        return nodeFactorySegment;
    }
}

