/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import io.ballerina.stdlib.grpc.ClientCall;
import io.ballerina.stdlib.grpc.Codec;
import io.ballerina.stdlib.grpc.Decompressor;
import io.ballerina.stdlib.grpc.DecompressorRegistry;
import io.ballerina.stdlib.grpc.GrpcThreadFactory;
import io.ballerina.stdlib.grpc.InboundMessage;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnectorListener;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.LastHttpContent;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;

public class ClientConnectorListener
implements HttpClientConnectorListener {
    private Status transportError;
    private HttpHeaders transportErrorMetadata;
    private boolean headersReceived;
    private ClientInboundStateListener stateListener;
    private static ExecutorService workerExecutor = Executors.newFixedThreadPool(10, new GrpcThreadFactory(new ThreadGroup("grpc-worker"), "grpc-client-worker-thread-pool"));

    ClientConnectorListener(ClientCall.ClientStreamListener streamListener, Long maxInboundMsgSize) {
        this.stateListener = new ClientInboundStateListener(maxInboundMsgSize, streamListener);
    }

    final void setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
        this.stateListener.setDecompressorRegistry(decompressorRegistry);
    }

    public void onMessage(HttpCarbonMessage httpMessage) {
        InboundMessage inboundMessage = new InboundMessage(httpMessage);
        if (this.isValid(inboundMessage)) {
            this.stateListener.inboundHeadersReceived(inboundMessage.getHeaders());
        }
        workerExecutor.execute(() -> {
            try {
                HttpCarbonMessage httpCarbonMessage = inboundMessage.getHttpCarbonMessage();
                HttpContent httpContent = httpCarbonMessage.getHttpContent();
                while (httpContent != null) {
                    if (this.transportError != null) {
                        this.transportError = this.transportError.augmentDescription("MESSAGE DATA: " + MessageUtils.readAsString(httpContent, Charset.forName("UTF-8")));
                        httpContent.release();
                        if (this.transportError.getDescription() != null && this.transportError.getDescription().length() > 1000 || httpContent instanceof LastHttpContent) {
                            this.stateListener.transportReportStatus(this.transportError, false, this.transportErrorMetadata);
                            break;
                        }
                    } else {
                        this.stateListener.inboundDataReceived(httpContent);
                        if (httpContent instanceof LastHttpContent) {
                            LastHttpContent lastHttpContent = (LastHttpContent)httpContent;
                            if (lastHttpContent.decoderResult() != null && lastHttpContent.decoderResult().isFailure()) {
                                this.transportError = Status.Code.ABORTED.toStatus().withDescription(lastHttpContent.decoderResult().cause().getMessage());
                            } else if (!httpCarbonMessage.getTrailerHeaders().isEmpty()) {
                                this.transportTrailersReceived(httpCarbonMessage.getTrailerHeaders());
                            } else if (this.containsTrailers(inboundMessage.getHeaders())) {
                                this.transportTrailersReceived(inboundMessage.getHeaders());
                            } else {
                                this.transportError = Status.Code.INTERNAL.toStatus().withDescription("Received unexpected end-of-stream on DATA frame from server.");
                                this.transportErrorMetadata = new DefaultHttpHeaders();
                                this.stateListener.transportReportStatus(this.transportError, false, this.transportErrorMetadata);
                            }
                            break;
                        }
                    }
                    httpContent = httpCarbonMessage.getHttpContent();
                }
            }
            catch (RuntimeException e) {
                this.transportError = this.transportError != null ? this.transportError.augmentDescription(e.getMessage()) : Status.fromThrowable(e);
                this.stateListener.transportReportStatus(this.transportError, false, this.transportErrorMetadata);
            }
        });
    }

    public void onError(Throwable throwable) {
        this.transportError = this.transportError != null ? this.transportError.augmentDescription(throwable.getMessage()) : Status.Code.UNAVAILABLE.toStatus().withCause(throwable);
        this.stateListener.transportReportStatus(this.transportError, false, this.transportErrorMetadata);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isValid(InboundMessage inboundMessage) {
        HttpHeaders headers = inboundMessage.getHeaders();
        if (headers == null) {
            this.transportError = Status.Code.INTERNAL.toStatus().withDescription("Message headers is null");
            return false;
        }
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription("headers: " + String.valueOf(headers));
            return false;
        }
        try {
            if (this.headersReceived) {
                this.transportError = Status.Code.INTERNAL.toStatus().withDescription("Received headers twice");
                boolean bl = false;
                return bl;
            }
            int httpStatus = inboundMessage.getStatus();
            if (httpStatus >= 100 && httpStatus < 200) {
                boolean bl = false;
                return bl;
            }
            this.transportError = httpStatus == 431 ? MessageUtils.httpStatusToGrpcCode(httpStatus).toStatus().withDescription("Exceeded the maximum header size allowed") : this.validateInitialMetadata(inboundMessage);
            this.headersReceived = true;
            boolean bl = this.transportError == null;
            return bl;
        }
        finally {
            if (this.transportError != null) {
                this.transportErrorMetadata = headers;
            }
        }
    }

    private Status validateInitialMetadata(InboundMessage inboundMessage) {
        String contentType = inboundMessage.getHeaders().get("content-type");
        if (!MessageUtils.isGrpcContentType(contentType)) {
            return MessageUtils.httpStatusToGrpcStatus(inboundMessage.getStatus()).augmentDescription("invalid content-type: " + contentType);
        }
        return null;
    }

    private void transportTrailersReceived(HttpHeaders trailers) {
        if (this.transportError != null) {
            this.transportError = this.transportError.augmentDescription("trailers: " + String.valueOf(trailers));
            this.stateListener.transportReportStatus(this.transportError, false, this.transportErrorMetadata);
        } else {
            Status status = this.statusFromTrailers(trailers);
            this.stateListener.transportReportStatus(status, false, trailers);
        }
    }

    private Status statusFromTrailers(HttpHeaders trailers) {
        String statusString = trailers.get("grpc-status");
        Status status = null;
        if (statusString != null) {
            status = Status.CODE_MARSHALLER.parseAsciiString(statusString.getBytes(Charset.forName("US-ASCII")));
        }
        if (status != null) {
            return status.withDescription(trailers.get("grpc-message"));
        }
        return Status.Code.UNKNOWN.toStatus().withDescription("missing GRPC status in response");
    }

    private boolean containsTrailers(HttpHeaders headers) {
        return headers.get("grpc-status") != null;
    }

    private static class ClientInboundStateListener
    extends InboundMessage.InboundStateListener {
        final ClientCall.ClientStreamListener listener;
        private DecompressorRegistry decompressorRegistry = DecompressorRegistry.getDefaultInstance();
        private boolean deframerClosed = false;
        private Runnable deframerClosedTask;
        private boolean statusReported;
        private boolean listenerClosed;

        ClientInboundStateListener(long maxMessageSize, ClientCall.ClientStreamListener listener) {
            super(maxMessageSize);
            this.listener = listener;
        }

        private void setDecompressorRegistry(DecompressorRegistry decompressorRegistry) {
            this.decompressorRegistry = decompressorRegistry;
        }

        @Override
        protected ClientCall.ClientStreamListener listener() {
            return this.listener;
        }

        @Override
        public void deframerClosed(boolean hasPartialMessage) {
            this.deframerClosed = true;
            if (this.deframerClosedTask != null) {
                this.deframerClosedTask.run();
                this.deframerClosedTask = null;
            }
        }

        void inboundHeadersReceived(HttpHeaders headers) {
            String streamEncoding = headers.get("content-encoding");
            if (streamEncoding != null) {
                this.deframeFailed(Status.Code.INTERNAL.toStatus().withDescription(String.format("Full stream decompressor for %s is not supported", streamEncoding)).asRuntimeException());
                return;
            }
            String messageEncoding = headers.get("grpc-encoding");
            if (messageEncoding != null) {
                Decompressor decompressor = this.decompressorRegistry.lookupDecompressor(messageEncoding);
                if (decompressor == null) {
                    this.deframeFailed(Status.Code.INTERNAL.toStatus().withDescription(String.format("Can't find decompressor for %s", messageEncoding)).asRuntimeException());
                    return;
                }
                if (decompressor != Codec.Identity.NONE) {
                    this.setDecompressor(decompressor);
                }
            }
            this.listener().headersRead(headers);
        }

        void inboundDataReceived(HttpContent httpContent) {
            this.deframe(httpContent);
        }

        final void transportReportStatus(Status status, boolean stopDelivery, HttpHeaders trailers) {
            if (this.statusReported && !stopDelivery) {
                return;
            }
            this.statusReported = true;
            if (this.deframerClosed) {
                this.deframerClosedTask = null;
                this.closeListener(status, trailers);
            } else {
                this.deframerClosedTask = () -> this.closeListener(status, trailers);
                this.closeDeframer(stopDelivery);
            }
        }

        private void closeListener(Status status, HttpHeaders trailers) {
            if (!this.listenerClosed) {
                this.listenerClosed = true;
                this.listener().closed(status, trailers);
            }
        }

        @Override
        public void deframeFailed(Throwable cause) {
            this.listener().cancelCall(cause);
            this.transportReportStatus(Status.fromThrowable(cause), true, (HttpHeaders)new DefaultHttpHeaders());
        }
    }
}

