/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc;

import com.google.protobuf.ByteString;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.InvalidProtocolBufferException;
import io.ballerina.runtime.api.types.ErrorType;
import io.ballerina.runtime.api.types.Field;
import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.NullType;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.PredefinedTypes;
import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.types.UnionType;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.grpc.MessageParser;
import io.ballerina.stdlib.grpc.MessageRegistry;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.MethodDescriptor;
import io.ballerina.stdlib.grpc.ProtoUtils;
import io.ballerina.stdlib.grpc.ServicesBuilderUtils;
import io.ballerina.stdlib.grpc.exception.GrpcClientException;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public final class ServiceDefinition {
    private String rootDescriptor;
    private BMap<BString, Object> descriptorMap;
    private Descriptors.FileDescriptor fileDescriptor;

    public ServiceDefinition(String rootDescriptor, BMap<BString, Object> descriptorMap) {
        this.rootDescriptor = rootDescriptor;
        this.descriptorMap = descriptorMap;
    }

    public Descriptors.FileDescriptor getDescriptor() throws GrpcClientException {
        if (this.fileDescriptor != null) {
            return this.fileDescriptor;
        }
        try {
            this.fileDescriptor = this.getFileDescriptor(this.rootDescriptor, this.descriptorMap);
            return this.fileDescriptor;
        }
        catch (Descriptors.DescriptorValidationException | IOException e) {
            throw new GrpcClientException("Error while generating service descriptor : " + e.getMessage(), e);
        }
    }

    private Descriptors.FileDescriptor getFileDescriptor(String rootDescriptor, BMap<BString, Object> descriptorMap) throws InvalidProtocolBufferException, Descriptors.DescriptorValidationException, GrpcClientException {
        byte[] descriptor = ServicesBuilderUtils.hexStringToByteArray(rootDescriptor);
        if (descriptor.length == 0) {
            throw new GrpcClientException("Error while reading the service proto descriptor. input descriptor string is null.");
        }
        DescriptorProtos.FileDescriptorProto descriptorProto = DescriptorProtos.FileDescriptorProto.parseFrom((byte[])descriptor);
        if (descriptorProto == null) {
            throw new GrpcClientException("Error while reading the service proto descriptor. File proto descriptor is null.");
        }
        ArrayList<Descriptors.FileDescriptor> fileDescriptors = new ArrayList<Descriptors.FileDescriptor>();
        for (ByteString dependency : descriptorProto.getDependencyList().asByteStringList()) {
            if (!descriptorMap.containsKey((Object)StringUtils.fromString((String)dependency.toStringUtf8()))) continue;
            BString bRootDescriptor = (BString)descriptorMap.get((Object)StringUtils.fromString((String)dependency.toString(StandardCharsets.UTF_8)));
            fileDescriptors.add(this.getFileDescriptor(bRootDescriptor.getValue(), descriptorMap));
        }
        return Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)descriptorProto, (Descriptors.FileDescriptor[])((Descriptors.FileDescriptor[])fileDescriptors.toArray(Descriptors.FileDescriptor[]::new)), (boolean)true);
    }

    private Descriptors.ServiceDescriptor getServiceDescriptor(String clientTypeName) throws GrpcClientException {
        Descriptors.FileDescriptor descriptor = this.getDescriptor();
        if (descriptor.getFile().getServices().isEmpty()) {
            throw new GrpcClientException("No service found in proto definition file");
        }
        Descriptors.ServiceDescriptor serviceDescriptor = null;
        String serviceName = null;
        if (clientTypeName != null) {
            if (clientTypeName.endsWith("BlockingClient")) {
                serviceName = clientTypeName.substring(0, clientTypeName.length() - 14);
            } else if (clientTypeName.endsWith("Client")) {
                serviceName = clientTypeName.substring(0, clientTypeName.length() - 6);
            }
        }
        if (serviceName != null) {
            serviceDescriptor = descriptor.findServiceByName(serviceName);
        }
        if (serviceDescriptor == null) {
            if (descriptor.getFile().getServices().size() == 1) {
                serviceDescriptor = (Descriptors.ServiceDescriptor)descriptor.getFile().getServices().get(0);
            } else {
                throw new GrpcClientException("Couldn't find service descriptor for client endpoint in the proto definition. Please check client endpoint type name with the service name in the proto definition.");
            }
        }
        return serviceDescriptor;
    }

    public Map<String, MethodDescriptor> getMethodDescriptors(ObjectType clientEndpointType) throws GrpcClientException {
        MethodType[] attachedFunctions;
        HashMap<String, MethodDescriptor> descriptorMap = new HashMap<String, MethodDescriptor>();
        Descriptors.ServiceDescriptor serviceDescriptor = this.getServiceDescriptor(clientEndpointType.getName());
        for (MethodType attachedFunction : attachedFunctions = clientEndpointType.getMethods()) {
            String methodName = attachedFunction.getName();
            if (methodName.endsWith("Context")) continue;
            Descriptors.MethodDescriptor methodDescriptor = serviceDescriptor.findMethodByName(methodName);
            if (methodDescriptor == null) {
                throw new GrpcClientException("Error while initializing client stub. Couldn't find method descriptor for remote function: " + methodName);
            }
            Descriptors.Descriptor reqMessage = methodDescriptor.getInputType();
            Descriptors.Descriptor resMessage = methodDescriptor.getOutputType();
            MessageRegistry messageRegistry = MessageRegistry.getInstance();
            messageRegistry.addMessageDescriptor(reqMessage.getFullName(), reqMessage);
            MessageUtils.setNestedMessages(reqMessage, messageRegistry);
            messageRegistry.addMessageDescriptor(resMessage.getFullName(), resMessage);
            MessageUtils.setNestedMessages(resMessage, messageRegistry);
            String fullMethodName = MethodDescriptor.generateFullMethodName(serviceDescriptor.getFullName(), methodName);
            Type requestType = this.getInputParameterType(methodDescriptor, attachedFunction);
            Type responseType = this.getReturnParameterType(methodDescriptor, attachedFunction);
            if (responseType == null) {
                responseType = this.getStreamDataType(methodDescriptor, attachedFunction, resMessage.getName());
            }
            MethodDescriptor descriptor = MethodDescriptor.newBuilder().setType(MessageUtils.getMethodType(methodDescriptor.toProto())).setFullMethodName(fullMethodName).setRequestMarshaller(ProtoUtils.marshaller(new MessageParser(reqMessage.getFullName(), requestType))).setResponseMarshaller(ProtoUtils.marshaller(new MessageParser(resMessage.getFullName(), responseType == null ? ServicesBuilderUtils.getBallerinaValueType(clientEndpointType.getPackage(), resMessage.getName()) : responseType))).setSchemaDescriptor(methodDescriptor).build();
            descriptorMap.put(fullMethodName, descriptor);
        }
        return Collections.unmodifiableMap(descriptorMap);
    }

    private Type getStreamDataType(Descriptors.MethodDescriptor methodDescriptor, MethodType attachedFunction, String typeOfStream) {
        Type streamType;
        Type functionReturnType = attachedFunction.getType().getReturnParameterType();
        UnionType unionReturnType = (UnionType)functionReturnType;
        Type streamParameterType = (Type)unionReturnType.getMemberTypes().get(0);
        if (streamParameterType instanceof ErrorType && unionReturnType.getMemberTypes().size() > 1) {
            streamParameterType = (Type)unionReturnType.getMemberTypes().get(1);
        }
        if (methodDescriptor.isClientStreaming() && streamParameterType instanceof ObjectType) {
            return this.getStreamDataTypeFromBidirectionalStream((ObjectType)streamParameterType);
        }
        if (streamParameterType instanceof StreamType && (streamType = ((StreamType)streamParameterType).getConstrainedType()).getName().equals(typeOfStream)) {
            return streamType;
        }
        return null;
    }

    private Type getStreamDataTypeFromBidirectionalStream(ObjectType streamingClient) {
        MethodType[] methodTypes;
        for (MethodType methodType : methodTypes = streamingClient.getMethods()) {
            if (!methodType.getName().contains("receive") || methodType.getName().toLowerCase(Locale.ROOT).contains("context")) continue;
            List returnTypes = ((UnionType)methodType.getType().getReturnType()).getMemberTypes();
            for (Type returnType : returnTypes) {
                if (returnType instanceof ErrorType || returnType instanceof NullType) continue;
                return returnType;
            }
        }
        return null;
    }

    private Type getReturnParameterType(Descriptors.MethodDescriptor methodDescriptor, MethodType attachedFunction) {
        if (methodDescriptor.isClientStreaming() || methodDescriptor.isServerStreaming()) {
            return null;
        }
        Type functionReturnType = attachedFunction.getType().getReturnParameterType();
        if (functionReturnType.getTag() == 33) {
            UnionType unionReturnType = (UnionType)functionReturnType;
            Type firstParamType = (Type)unionReturnType.getMemberTypes().get(0);
            if (MessageUtils.isContextRecordByType(firstParamType)) {
                RecordType recordParamType = (RecordType)firstParamType;
                return TypeUtils.getReferredType((Type)((Field)recordParamType.getFields().get("content")).getFieldType());
            }
            return firstParamType;
        }
        return null;
    }

    private Type getInputParameterType(Descriptors.MethodDescriptor methodDescriptor, MethodType attachedFunction) {
        Type inputType;
        if (methodDescriptor.isClientStreaming()) {
            return null;
        }
        Type[] inputParams = ServicesBuilderUtils.getParameterTypesFromParameters(attachedFunction.getParameters());
        if (inputParams.length > 0 && (inputType = inputParams[0]).getTag() == 33) {
            UnionType unionInputType = (UnionType)inputType;
            for (Type paramType : unionInputType.getMemberTypes()) {
                if (MessageUtils.isContextRecordByType(paramType)) continue;
                return paramType;
            }
        }
        return PredefinedTypes.TYPE_NULL;
    }
}

