/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc.listener;

import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.creators.TypeCreator;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.StreamType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BStream;
import io.ballerina.runtime.observability.ObserveUtils;
import io.ballerina.runtime.observability.ObserverContext;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.ServerCall;
import io.ballerina.stdlib.grpc.ServiceResource;
import io.ballerina.stdlib.grpc.StreamObserver;
import io.ballerina.stdlib.grpc.callback.StreamingCallableUnitCallBack;
import io.ballerina.stdlib.grpc.exception.GrpcServerException;
import io.ballerina.stdlib.grpc.listener.ServerCallHandler;
import io.ballerina.stdlib.grpc.nativeimpl.ModuleUtils;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.HashMap;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;

public class StreamingServerCallHandler
extends ServerCallHandler {
    private final ServiceResource resource;
    private final Type inputType;

    public StreamingServerCallHandler(Descriptors.MethodDescriptor methodDescriptor, ServiceResource resource, Type inputType) throws GrpcServerException {
        super(methodDescriptor);
        if (resource == null) {
            String serviceType = "Client streaming";
            if (methodDescriptor.isServerStreaming() && methodDescriptor.isClientStreaming()) {
                serviceType = "Bidirectional streaming";
            }
            throw new GrpcServerException(serviceType + " remote function '" + methodDescriptor.getFullName() + "' does not exist.");
        }
        this.resource = resource;
        this.inputType = inputType;
    }

    @Override
    public ServerCallHandler.Listener startCall(ServerCall call) {
        ServerCallHandler.ServerCallStreamObserver responseObserver = new ServerCallHandler.ServerCallStreamObserver(call);
        StreamObserver requestObserver = this.invoke(responseObserver, call);
        return new StreamingServerCallListener(requestObserver, responseObserver);
    }

    private StreamObserver invoke(StreamObserver responseObserver, ServerCall call) {
        ObserverContext context = call.getObserverContext();
        BObject streamIterator = ValueCreator.createObjectValue((Module)ModuleUtils.getModule(), (String)"StreamIterator", (Object[])new Object[1]);
        LinkedBlockingQueue<Message> messageQueue = new LinkedBlockingQueue<Message>();
        streamIterator.addNativeData("messageQueue", messageQueue);
        streamIterator.addNativeData("ResponseObserver", (Object)responseObserver);
        BStream requestStream = ValueCreator.createStreamValue((StreamType)TypeCreator.createStreamType((Type)this.inputType), (BObject)streamIterator);
        this.onStreamInvoke(this.resource, requestStream, call.getHeaders(), responseObserver, context);
        return new StreamingServerRequestObserver(streamIterator, messageQueue);
    }

    private boolean isEmptyResponse() {
        return this.methodDescriptor != null && MessageUtils.isEmptyResponse(this.methodDescriptor.getOutputType());
    }

    void onStreamInvoke(ServiceResource resource, BStream requestStream, HttpHeaders headers, StreamObserver responseObserver, ObserverContext context) {
        Object[] requestParams = this.computeResourceParams(resource, requestStream, headers, responseObserver);
        HashMap<String, Object> properties = new HashMap<String, Object>();
        if (ObserveUtils.isObservabilityEnabled()) {
            properties.put("__observer_context__", context);
        }
        properties.put("authorization", headers.get("authorization"));
        StreamingCallableUnitCallBack callback = new StreamingCallableUnitCallBack(resource.getRuntime(), responseObserver, this.isEmptyResponse(), this.methodDescriptor.getOutputType(), context);
        String functionName = resource.getFunctionName();
        BObject service = resource.getService();
        ObjectType serviceObjectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)service));
        Thread.startVirtualThread(() -> {
            try {
                boolean isConcurrentSafe = serviceObjectType.isIsolated() && serviceObjectType.isIsolated(functionName);
                StrandMetadata metadata = new StrandMetadata(isConcurrentSafe, properties);
                Object result = resource.getRuntime().callMethod(service, functionName, metadata, requestParams);
                callback.notifySuccess(result);
            }
            catch (BError error) {
                callback.notifyFailure(error);
            }
        });
    }

    private static final class StreamingServerCallListener
    implements ServerCallHandler.Listener {
        private final StreamObserver requestObserver;
        private final ServerCallHandler.ServerCallStreamObserver responseObserver;
        private boolean halfClosed = false;

        StreamingServerCallListener(StreamObserver requestObserver, ServerCallHandler.ServerCallStreamObserver responseObserver) {
            this.requestObserver = requestObserver;
            this.responseObserver = responseObserver;
        }

        @Override
        public void onMessage(Message request) {
            this.requestObserver.onNext(request);
        }

        @Override
        public void onHalfClose() {
            if (!this.halfClosed) {
                this.halfClosed = true;
                this.requestObserver.onCompleted();
            }
        }

        @Override
        public void onCancel(Message message) {
            this.responseObserver.cancelled = true;
            this.requestObserver.onError(message);
        }

        @Override
        public void onComplete() {
            if (!this.halfClosed) {
                this.halfClosed = true;
                this.requestObserver.onCompleted();
            }
        }
    }

    private static final class StreamingServerRequestObserver
    implements StreamObserver {
        private final BlockingQueue<Message> messageQueue;

        StreamingServerRequestObserver(BObject streamIterator, BlockingQueue<Message> messageQueue) {
            this.messageQueue = messageQueue;
        }

        @Override
        public void onNext(Message value) {
            this.messageQueue.add(value);
        }

        @Override
        public void onError(Message error) {
            this.messageQueue.add(error);
        }

        @Override
        public void onCompleted() {
            this.messageQueue.add(new Message("completedMessage", null));
        }
    }
}

