/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.grpc.nativeimpl.client;

import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.types.ObjectType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.grpc.DataContext;
import io.ballerina.stdlib.grpc.GrpcConstants;
import io.ballerina.stdlib.grpc.GrpcUtil;
import io.ballerina.stdlib.grpc.Message;
import io.ballerina.stdlib.grpc.MessageRegistry;
import io.ballerina.stdlib.grpc.MessageUtils;
import io.ballerina.stdlib.grpc.MethodDescriptor;
import io.ballerina.stdlib.grpc.ServiceDefinition;
import io.ballerina.stdlib.grpc.Status;
import io.ballerina.stdlib.grpc.exception.GrpcClientException;
import io.ballerina.stdlib.grpc.exception.StatusRuntimeException;
import io.ballerina.stdlib.grpc.nativeimpl.client.AbstractExecute;
import io.ballerina.stdlib.grpc.stubs.Stub;
import io.ballerina.stdlib.http.api.HttpConnectionManager;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.contract.config.SenderConfiguration;
import io.ballerina.stdlib.http.transport.contract.config.TransportsConfiguration;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.ConnectionManager;
import io.ballerina.stdlib.http.transport.contractimpl.sender.channel.pool.PoolConfiguration;
import io.ballerina.stdlib.http.transport.message.HttpConnectorUtil;
import io.netty.handler.codec.http.HttpHeaders;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

public class FunctionUtils
extends AbstractExecute {
    private FunctionUtils() {
    }

    public static void externInitGlobalPool(BObject endpointObject, BMap<BString, Long> globalPoolConfig) {
        PoolConfiguration globalPool = new PoolConfiguration();
        GrpcUtil.populatePoolingConfig(globalPoolConfig, globalPool);
        ConnectionManager connectionManager = new ConnectionManager(globalPool);
        globalPoolConfig.addNativeData("ConnectionManager", (Object)connectionManager);
    }

    public static Object externInit(BObject clientEndpoint, BString urlString, BMap clientEndpointConfig, BMap globalPoolConfig, BString optionsString) {
        URL url;
        HttpConnectionManager connectionManager = HttpConnectionManager.getInstance();
        try {
            url = new URL(urlString.getValue());
        }
        catch (MalformedURLException e) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Malformed URL: " + urlString.getValue())));
        }
        String scheme = url.getProtocol();
        Map properties = HttpConnectorUtil.getTransportProperties((TransportsConfiguration)connectionManager.getTransportConfig());
        properties.put("ClientConfigHashCode", optionsString.hashCode());
        SenderConfiguration senderConfiguration = new SenderConfiguration();
        senderConfiguration.setScheme(scheme);
        if (connectionManager.isHTTPTraceLoggerEnabled()) {
            senderConfiguration.setHttpTraceLogEnabled(true);
        }
        senderConfiguration.setTLSStoreType("PKCS12");
        try {
            GrpcUtil.populateSenderConfigurations(senderConfiguration, (BMap<BString, Object>)clientEndpointConfig, scheme);
            BMap userDefinedPoolConfig = (BMap)clientEndpointConfig.get((Object)HttpConstants.USER_DEFINED_POOL_CONFIG);
            ConnectionManager poolManager = userDefinedPoolConfig == null ? GrpcUtil.getConnectionManager((BMap<BString, Long>)globalPoolConfig) : GrpcUtil.getConnectionManager((BMap<BString, Long>)userDefinedPoolConfig);
            senderConfiguration.setHttpVersion("2.0");
            senderConfiguration.setForceHttp2(true);
            HttpClientConnector clientConnector = HttpUtil.createHttpWsConnectionFactory().createHttpsClientConnector(properties, senderConfiguration, poolManager);
            clientEndpoint.addNativeData("ClientConnector", (Object)clientConnector);
            clientEndpoint.addNativeData("url", (Object)urlString.getValue());
        }
        catch (BError ex) {
            return ex;
        }
        catch (Exception ex) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withCause(ex)));
        }
        return null;
    }

    public static Object externInitStub(BObject genericEndpoint, BObject clientEndpoint, BString rootDescriptor, BMap<BString, Object> descriptorMap) {
        HttpClientConnector clientConnector = (HttpClientConnector)genericEndpoint.getNativeData("ClientConnector");
        String urlString = (String)genericEndpoint.getNativeData("url");
        if (rootDescriptor == null || descriptorMap == null) {
            return MessageUtils.getConnectorError(new StatusRuntimeException(Status.fromCode(Status.Code.INTERNAL.toStatus().getCode()).withDescription("Error while initializing connector. message descriptor keys not exist. Please check the generated stub file")));
        }
        try {
            ServiceDefinition serviceDefinition = new ServiceDefinition(rootDescriptor.getValue(), descriptorMap);
            MessageRegistry.getInstance().setFileDescriptor(serviceDefinition.getDescriptor());
            ObjectType objectType = (ObjectType)TypeUtils.getReferredType((Type)TypeUtils.getType((Object)clientEndpoint));
            Map<String, MethodDescriptor> methodDescriptorMap = serviceDefinition.getMethodDescriptors(objectType);
            genericEndpoint.addNativeData("MethodDescriptors", methodDescriptorMap);
            Stub stub = new Stub(clientConnector, urlString);
            genericEndpoint.addNativeData("Stub", (Object)stub);
        }
        catch (GrpcClientException | RuntimeException e) {
            return MessageUtils.getConnectorError(e);
        }
        return null;
    }

    public static Object externExecuteSimpleRPC(Environment env, BObject clientEndpoint, BString methodName, Object payloadBValue, BMap headerValues) {
        Descriptors.MethodDescriptor methodDescriptor;
        if (clientEndpoint == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connector. gRPC client connector is not initialized properly");
        }
        Object connectionStub = clientEndpoint.getNativeData("Stub");
        if (connectionStub == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connection stub. gRPC Client connector is not initialized properly");
        }
        if (methodName == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. RPC endpoint doesn't set properly");
        }
        Map methodDescriptors = (Map)clientEndpoint.getNativeData("MethodDescriptors");
        if (methodDescriptors == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. method descriptors doesn't set properly");
        }
        Descriptors.MethodDescriptor methodDescriptor2 = methodDescriptor = methodDescriptors.get(methodName.getValue()) != null ? ((MethodDescriptor)methodDescriptors.get(methodName.getValue())).getSchemaDescriptor() : null;
        if (methodDescriptor == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "No registered method descriptor for '" + methodName.getValue() + "'");
        }
        Message requestMsg = new Message(methodDescriptor.getInputType(), payloadBValue);
        HttpHeaders headers = MessageUtils.convertToHttpHeaders(headerValues);
        requestMsg.setHeaders(headers);
        Stub stub = (Stub)connectionStub;
        HashMap<String, Long> messageSizeMap = new HashMap<String, Long>();
        messageSizeMap.put("maxInboundMessageSize", (Long)clientEndpoint.getMapValue(GrpcConstants.CONFIG).get((Object)StringUtils.fromString((String)"maxInboundMessageSize")));
        try {
            MethodDescriptor.MethodType methodType = FunctionUtils.getMethodType(methodDescriptor);
            if (methodType.equals((Object)MethodDescriptor.MethodType.UNARY)) {
                return env.yieldAndRun(() -> {
                    try {
                        CompletableFuture<Object> future = new CompletableFuture<Object>();
                        DataContext dataContext = new DataContext(env, future);
                        stub.executeUnary(requestMsg, (MethodDescriptor)methodDescriptors.get(methodName.getValue()), dataContext, messageSizeMap);
                        return GrpcUtil.getResult(future);
                    }
                    catch (Exception e) {
                        return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "gRPC Client Connector Error :" + e.getMessage());
                    }
                });
            }
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while executing the client call. Method type " + methodType.name() + " not supported");
        }
        catch (Exception e) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "gRPC Client Connector Error :" + e.getMessage());
        }
    }

    public static Object externExecuteServerStreaming(Environment env, BObject clientEndpoint, BString methodName, Object payload, BMap headerValues) {
        Descriptors.MethodDescriptor methodDescriptor;
        if (clientEndpoint == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connector. gRPC Client connector is not initialized properly");
        }
        Object connectionStub = clientEndpoint.getNativeData("Stub");
        if (connectionStub == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connection stub. gRPC Client connector is not initialized properly");
        }
        if (methodName == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. RPC endpoint doesn't set properly");
        }
        Map methodDescriptors = (Map)clientEndpoint.getNativeData("MethodDescriptors");
        if (methodDescriptors == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. method descriptors doesn't set properly");
        }
        Descriptors.MethodDescriptor methodDescriptor2 = methodDescriptor = methodDescriptors.get(methodName.getValue()) != null ? ((MethodDescriptor)methodDescriptors.get(methodName.getValue())).getSchemaDescriptor() : null;
        if (methodDescriptor == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "No registered method descriptor for '" + methodName.getValue() + "'");
        }
        Message requestMsg = new Message(methodDescriptor.getInputType(), payload);
        HttpHeaders headers = MessageUtils.convertToHttpHeaders(headerValues);
        requestMsg.setHeaders(headers);
        Stub stub = (Stub)connectionStub;
        HashMap<String, Long> messageSizeMap = new HashMap<String, Long>();
        messageSizeMap.put("maxInboundMessageSize", (Long)clientEndpoint.getMapValue(GrpcConstants.CONFIG).get((Object)StringUtils.fromString((String)"maxInboundMessageSize")));
        try {
            return env.yieldAndRun(() -> {
                try {
                    CompletableFuture<Object> future = new CompletableFuture<Object>();
                    DataContext dataContext = new DataContext(env, future);
                    stub.executeServerStreaming(requestMsg, (MethodDescriptor)methodDescriptors.get(methodName.getValue()), dataContext, messageSizeMap);
                    return GrpcUtil.getResult(future);
                }
                catch (Exception e) {
                    return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "gRPC Client Connector Error :" + e.getMessage());
                }
            });
        }
        catch (Exception e) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "gRPC Client Connector Error :" + e.getMessage());
        }
    }

    public static Object externExecuteClientStreaming(Environment env, BObject clientEndpoint, BString methodName, BMap headerValues) {
        Descriptors.MethodDescriptor methodDescriptor;
        if (clientEndpoint == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connector. gRPC Client connector is not initialized properly");
        }
        Object connectionStub = clientEndpoint.getNativeData("Stub");
        if (connectionStub == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connection stub. gRPC Client connector is not initialized properly");
        }
        if (methodName == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. RPC endpoint doesn't set properly");
        }
        Map methodDescriptors = (Map)clientEndpoint.getNativeData("MethodDescriptors");
        if (methodDescriptors == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. method descriptors doesn't set properly");
        }
        Descriptors.MethodDescriptor methodDescriptor2 = methodDescriptor = methodDescriptors.get(methodName.getValue()) != null ? ((MethodDescriptor)methodDescriptors.get(methodName.getValue())).getSchemaDescriptor() : null;
        if (methodDescriptor == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "No registered method descriptor for '" + methodName.getValue() + "'");
        }
        HashMap<String, Long> messageSizeMap = new HashMap<String, Long>();
        messageSizeMap.put("maxInboundMessageSize", (Long)clientEndpoint.getMapValue(GrpcConstants.CONFIG).get((Object)StringUtils.fromString((String)"maxInboundMessageSize")));
        try {
            Stub stub = (Stub)connectionStub;
            HttpHeaders headers = MessageUtils.convertToHttpHeaders(headerValues);
            DataContext context = new DataContext(env, null);
            return stub.executeClientStreaming(headers, (MethodDescriptor)methodDescriptors.get(methodName.getValue()), context, messageSizeMap);
        }
        catch (Exception e) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "gRPC Client Connector Error :" + e.getMessage());
        }
    }

    public static Object externExecuteBidirectionalStreaming(Environment env, BObject clientEndpoint, BString methodName, BMap headerValues) {
        Descriptors.MethodDescriptor methodDescriptor;
        if (clientEndpoint == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connector. gRPC Client connector is not initialized properly");
        }
        Object connectionStub = clientEndpoint.getNativeData("Stub");
        if (connectionStub == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while getting connection stub. gRPC Client connector is not initialized properly");
        }
        if (methodName == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. RPC endpoint doesn't set properly");
        }
        Map methodDescriptors = (Map)clientEndpoint.getNativeData("MethodDescriptors");
        if (methodDescriptors == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "Error while processing the request. method descriptors doesn't set properly");
        }
        Descriptors.MethodDescriptor methodDescriptor2 = methodDescriptor = methodDescriptors.get(methodName.getValue()) != null ? ((MethodDescriptor)methodDescriptors.get(methodName.getValue())).getSchemaDescriptor() : null;
        if (methodDescriptor == null) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "No registered method descriptor for '" + methodName.getValue() + "'");
        }
        HashMap<String, Long> messageSizeMap = new HashMap<String, Long>();
        messageSizeMap.put("maxInboundMessageSize", (Long)clientEndpoint.getMapValue(GrpcConstants.CONFIG).get((Object)StringUtils.fromString((String)"maxInboundMessageSize")));
        try {
            Stub stub = (Stub)connectionStub;
            HttpHeaders headers = MessageUtils.convertToHttpHeaders(headerValues);
            DataContext context = new DataContext(env, null);
            return stub.executeBidirectionalStreaming(headers, (MethodDescriptor)methodDescriptors.get(methodName.getValue()), context, messageSizeMap);
        }
        catch (Exception e) {
            return FunctionUtils.notifyErrorReply(Status.Code.INTERNAL, "gRPC Client Connector Error :" + e.getMessage());
        }
    }
}

