/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.stdlib.http.api.HttpOASResource;
import io.ballerina.stdlib.http.api.HttpService;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.util.CharsetUtil;

public class HttpSwaggerUiResource
extends HttpOASResource {
    private static final String STATIC_HTML_PAGE = "        <!DOCTYPE html>\n        <html lang=\"en\">\n        <head>\n          <meta charset=\"utf-8\" />\n          <meta name=\"viewport\" content=\"width=device-width, initial-scale=1\" />\n          <meta name=\"description\" content=\"SwaggerUI\" />\n          <title>SwaggerUI</title>\n          <link rel=\"stylesheet\" href=\"https://unpkg.com/swagger-ui-dist@5.11.0/swagger-ui.css\" />\n        </head>\n        <body>\n        <div id=\"swagger-ui\"></div>\n        <script src=\"https://unpkg.com/swagger-ui-dist@5.11.0/swagger-ui-bundle.js\" crossorigin></script>\n        <script>\n          window.onload = () => {\n            window.ui = SwaggerUIBundle({\n              spec: OPENAPI_SPEC,\n              dom_id: '#swagger-ui',\n            });\n          };\n        </script>\n        </body>\n        </html>\n";
    private static final String RESOURCE_NAME = "swagger-ui-dygixywsw";
    private static final String REL_PARAM = "rel=\"swagger-ui\"";
    private static final String OAS_PLACEHOLDER = "OPENAPI_SPEC";
    private final byte[] payload;

    public HttpSwaggerUiResource(HttpService httpService, byte[] payload) {
        super(httpService, REL_PARAM, RESOURCE_NAME);
        String oasSpec = new String((byte[])payload.clone(), CharsetUtil.UTF_8);
        String content = STATIC_HTML_PAGE.replace(OAS_PLACEHOLDER, oasSpec);
        this.payload = content.getBytes(CharsetUtil.UTF_8);
    }

    @Override
    public byte[] getPayload() {
        return (byte[])this.payload.clone();
    }

    @Override
    protected String getResourceName() {
        return RESOURCE_NAME;
    }

    @Override
    public String getContentType() {
        return HttpHeaderValues.TEXT_HTML.toString();
    }

    public static String getResourceId() {
        return String.format("%s%s", "$get$", RESOURCE_NAME);
    }
}

