/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.RemoteMethodType;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.InterceptorResource;
import io.ballerina.stdlib.http.api.Resource;
import io.ballerina.stdlib.http.api.ResourceDataElement;
import io.ballerina.stdlib.http.api.ResourceElementFactory;
import io.ballerina.stdlib.http.api.Service;
import io.ballerina.stdlib.http.api.service.signature.RemoteMethodParamHandler;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.uri.DispatcherUtil;
import io.ballerina.stdlib.http.uri.URITemplate;
import io.ballerina.stdlib.http.uri.URITemplateException;
import io.ballerina.stdlib.http.uri.parser.Literal;
import java.io.UnsupportedEncodingException;
import java.util.List;

public class InterceptorService
implements Service {
    private final BObject balService;
    private InterceptorResource interceptorResource;
    private List<String> allAllowedMethods;
    private final String basePath;
    private URITemplate<Resource, HttpCarbonMessage> uriTemplate;
    private String hostName;
    private String serviceType;
    private RemoteMethodType remoteMethod;
    private RemoteMethodParamHandler remoteMethodParamHandler;

    protected InterceptorService(BObject service, String basePath) {
        this.balService = service;
        this.basePath = basePath;
    }

    public BObject getBalService() {
        return this.balService;
    }

    public InterceptorResource getResource() {
        return this.interceptorResource;
    }

    public void setInterceptorResource(InterceptorResource resource) {
        this.interceptorResource = resource;
    }

    @Override
    public List<String> getAllAllowedMethods() {
        return this.allAllowedMethods;
    }

    @Override
    public String getOasResourceLink() {
        return null;
    }

    public void setAllAllowedMethods(List<String> allAllowedMethods) {
        this.allAllowedMethods = allAllowedMethods;
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public String getHostName() {
        return this.hostName;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    public void setServiceType(String serviceType) {
        this.serviceType = serviceType;
    }

    public String getServiceType() {
        return this.serviceType;
    }

    @Override
    public BMap<BString, Object> getCompressionConfig() {
        return null;
    }

    @Override
    public String getChunkingConfig() {
        return null;
    }

    @Override
    public String getMediaTypeSubtypePrefix() {
        return null;
    }

    @Override
    public URITemplate<Resource, HttpCarbonMessage> getUriTemplate() throws URITemplateException {
        if (this.uriTemplate == null) {
            this.uriTemplate = new URITemplate<Resource, HttpCarbonMessage>(new Literal<Resource, HttpCarbonMessage>(new ResourceDataElement(), "/"));
        }
        return this.uriTemplate;
    }

    public static InterceptorService buildHttpService(BObject service, String basePath, String serviceType, boolean fromListener) {
        InterceptorService interceptorService = new InterceptorService(service, basePath);
        interceptorService.setServiceType(serviceType);
        interceptorService.setHostName("b7a.default");
        if (serviceType.equals("RequestInterceptor") || serviceType.equals("RequestErrorInterceptor")) {
            InterceptorService.processInterceptorResource(interceptorService, fromListener);
            interceptorService.setAllAllowedMethods(DispatcherUtil.getInterceptorResourceMethods(interceptorService));
        } else {
            InterceptorService.processInterceptorRemoteMethod(interceptorService);
        }
        return interceptorService;
    }

    private static void processInterceptorResource(InterceptorService interceptorService, boolean fromListener) {
        ResourceMethodType[] resourceMethods = ((ServiceType)TypeUtils.getType((Object)interceptorService.getBalService())).getResourceMethods();
        if (resourceMethods.length == 1) {
            ResourceMethodType resource = resourceMethods[0];
            InterceptorService.updateInterceptorResourceTree(interceptorService, InterceptorResource.buildInterceptorResource((MethodType)resource, interceptorService, fromListener));
        }
    }

    private static void processInterceptorRemoteMethod(InterceptorService interceptorService) {
        RemoteMethodType remoteMethod;
        RemoteMethodType[] remoteMethods = ((ServiceType)TypeUtils.getType((Object)interceptorService.getBalService())).getRemoteMethods();
        if (remoteMethods.length == 1 && ((remoteMethod = remoteMethods[0]).getName().equals("interceptResponse") || remoteMethod.getName().equals("interceptResponseError"))) {
            interceptorService.setRemoteMethodParamHandler(remoteMethod);
        }
    }

    public void setRemoteMethodParamHandler(RemoteMethodType remoteMethod) {
        this.remoteMethod = remoteMethod;
        this.remoteMethodParamHandler = new RemoteMethodParamHandler(remoteMethod);
    }

    public RemoteMethodParamHandler getRemoteMethodParamHandler() {
        return this.remoteMethodParamHandler;
    }

    public RemoteMethodType getRemoteMethod() {
        return this.remoteMethod;
    }

    private static void updateInterceptorResourceTree(InterceptorService httpService, InterceptorResource httpInterceptorResource) {
        try {
            httpService.getUriTemplate().parse(httpInterceptorResource.getPath(), httpInterceptorResource, new ResourceElementFactory());
        }
        catch (URITemplateException | UnsupportedEncodingException e) {
            throw new BallerinaConnectorException(e.getMessage());
        }
        httpService.setInterceptorResource(httpInterceptorResource);
    }
}

