/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.client.actions;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.DataContext;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.client.actions.AbstractHTTPAction;
import io.ballerina.stdlib.http.api.nativeimpl.ExternUtils;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;

public class Execute
extends AbstractHTTPAction {
    public static Object execute(Environment env, BObject httpClient, BString verb, BString path, BObject requestObj) {
        String url = (String)httpClient.getNativeData("url");
        BMap config = (BMap)httpClient.getNativeData("config");
        HttpClientConnector clientConnector = (HttpClientConnector)httpClient.getNativeData("Client");
        HttpCarbonMessage outboundRequestMsg = Execute.createOutboundRequestMsg((BMap<BString, Object>)config, url, verb.getValue(), path.getValue(), requestObj);
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            DataContext dataContext = new DataContext(env, balFuture, clientConnector, requestObj, outboundRequestMsg);
            Execute.executeNonBlockingAction(dataContext, false);
            return ExternUtils.getResult(balFuture);
        });
    }

    protected static HttpCarbonMessage createOutboundRequestMsg(BMap<BString, Object> config, String serviceUri, String httpVerb, String path, BObject requestObj) {
        HttpCarbonMessage outboundRequestMsg = HttpUtil.getCarbonMsg(requestObj, HttpUtil.createHttpCarbonMessage(true));
        HttpUtil.checkEntityAvailability(requestObj);
        HttpUtil.enrichOutboundMessage(outboundRequestMsg, requestObj);
        Execute.prepareOutboundRequest(serviceUri, path, outboundRequestMsg, Execute.isNoEntityBodyRequest(requestObj), Execute.isHostHeaderSet(requestObj));
        String verb = "";
        if (!httpVerb.isEmpty()) {
            verb = httpVerb;
        } else if (outboundRequestMsg.getHttpMethod() != null) {
            verb = outboundRequestMsg.getHttpMethod();
        } else {
            throw HttpUtil.createHttpError("HTTP Verb cannot be empty", HttpErrorType.GENERIC_CLIENT_ERROR);
        }
        outboundRequestMsg.setHttpMethod(verb.trim().toUpperCase(Locale.getDefault()));
        Execute.handleAcceptEncodingHeader(outboundRequestMsg, Execute.getCompressionConfigFromEndpointConfig(config));
        return outboundRequestMsg;
    }
}

