/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.mime.util.MimeUtil;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaders;
import java.util.List;
import java.util.TreeSet;

public class ExternHeaders {
    public static void addHeader(BObject messageObj, BString headerName, BString headerValue, Object position) {
        try {
            ExternHeaders.getOrCreateHeadersBasedOnPosition(messageObj, position).add(headerName.getValue(), (Object)headerValue.getValue());
        }
        catch (IllegalArgumentException ex) {
            throw MimeUtil.createError((String)"InvalidHeaderOperationError", (String)ex.getMessage());
        }
    }

    public static Object getHeader(BObject messageObj, BString headerName, Object position) {
        HttpHeaders httpHeaders = ExternHeaders.getHeadersBasedOnPosition(messageObj, position);
        if (httpHeaders == null) {
            return HttpUtil.createHttpError("Http header does not exist", HttpErrorType.HEADER_NOT_FOUND_ERROR);
        }
        if (httpHeaders.get(headerName.getValue()) != null) {
            return StringUtils.fromString((String)httpHeaders.get(headerName.getValue()));
        }
        return HttpUtil.createHttpError("Http header does not exist", HttpErrorType.HEADER_NOT_FOUND_ERROR);
    }

    public static BArray getHeaderNames(BObject messageObj, Object position) {
        HttpHeaders httpHeaders = ExternHeaders.getHeadersBasedOnPosition(messageObj, position);
        if (httpHeaders == null || httpHeaders.isEmpty()) {
            return StringUtils.fromStringArray((String[])new String[0]);
        }
        TreeSet distinctNames = new TreeSet(String.CASE_INSENSITIVE_ORDER);
        distinctNames.addAll(httpHeaders.names());
        return StringUtils.fromStringArray((String[])distinctNames.toArray(new String[0]));
    }

    public static Object getHeaders(BObject messageObj, BString headerName, Object position) {
        HttpHeaders httpHeaders = ExternHeaders.getHeadersBasedOnPosition(messageObj, position);
        if (httpHeaders == null) {
            return HttpUtil.createHttpError("Http header does not exist", HttpErrorType.HEADER_NOT_FOUND_ERROR);
        }
        List headerValueList = httpHeaders.getAll(headerName.getValue());
        if (headerValueList == null || headerValueList.isEmpty()) {
            return HttpUtil.createHttpError("Http header does not exist", HttpErrorType.HEADER_NOT_FOUND_ERROR);
        }
        return StringUtils.fromStringArray((String[])headerValueList.toArray(new String[0]));
    }

    public static boolean hasHeader(BObject messageObj, BString headerName, Object position) {
        HttpHeaders httpHeaders = ExternHeaders.getHeadersBasedOnPosition(messageObj, position);
        if (httpHeaders == null) {
            return false;
        }
        List headerValueList = httpHeaders.getAll(headerName.getValue());
        return headerValueList != null && !headerValueList.isEmpty();
    }

    public static void removeAllHeaders(BObject messageObj, Object position) {
        HttpHeaders httpHeaders = ExternHeaders.getHeadersBasedOnPosition(messageObj, position);
        if (httpHeaders != null) {
            httpHeaders.clear();
        }
    }

    public static void removeHeader(BObject messageObj, BString headerName, Object position) {
        HttpHeaders httpHeaders = ExternHeaders.getHeadersBasedOnPosition(messageObj, position);
        if (httpHeaders != null) {
            httpHeaders.remove(headerName.getValue());
        }
    }

    public static void setHeader(BObject messageObj, BString headerName, BString headerValue, Object position) {
        if (headerName == null || headerValue == null) {
            return;
        }
        try {
            ExternHeaders.getOrCreateHeadersBasedOnPosition(messageObj, position).set(headerName.getValue(), (Object)headerValue.getValue());
            if (headerName.getValue().equalsIgnoreCase(HttpHeaderNames.HOST.toString())) {
                messageObj.addNativeData("set_host_header", (Object)true);
            }
        }
        catch (IllegalArgumentException ex) {
            throw MimeUtil.createError((String)"InvalidHeaderOperationError", (String)ex.getMessage());
        }
    }

    private static HttpHeaders getHeadersBasedOnPosition(BObject messageObj, Object position) {
        return position.equals(StringUtils.fromString((String)"leading")) ? (HttpHeaders)messageObj.getNativeData("http_headers") : (HttpHeaders)messageObj.getNativeData("http_trailer_headers");
    }

    private static HttpHeaders getOrCreateHeadersBasedOnPosition(BObject messageObj, Object position) {
        return position.equals(StringUtils.fromString((String)"leading")) ? ExternHeaders.getHeaders(messageObj) : ExternHeaders.getTrailerHeaders(messageObj);
    }

    private static HttpHeaders getHeaders(BObject messageObj) {
        DefaultHttpHeaders httpHeaders;
        if (messageObj.getNativeData("http_headers") != null) {
            httpHeaders = (HttpHeaders)messageObj.getNativeData("http_headers");
        } else {
            httpHeaders = new DefaultHttpHeaders();
            messageObj.addNativeData("http_headers", (Object)httpHeaders);
        }
        return httpHeaders;
    }

    private static HttpHeaders getTrailerHeaders(BObject messageObj) {
        HttpHeaders httpTrailerHeaders;
        if (messageObj.getNativeData("http_trailer_headers") != null) {
            httpTrailerHeaders = (HttpHeaders)messageObj.getNativeData("http_trailer_headers");
        } else {
            httpTrailerHeaders = new DefaultLastHttpContent().trailingHeaders();
            messageObj.addNativeData("http_trailer_headers", (Object)httpTrailerHeaders);
        }
        return httpTrailerHeaders;
    }

    public static Object getAuthorizationHeader(Environment env) {
        HttpCarbonMessage inboundMessage = (HttpCarbonMessage)env.getStrandLocal("INBOUND_MESSAGE");
        String authorizationHeader = inboundMessage.getHeader(HttpHeaderNames.AUTHORIZATION.toString());
        if (authorizationHeader == null) {
            return HttpUtil.createHttpError("Http header does not exist", HttpErrorType.HEADER_NOT_FOUND_ERROR);
        }
        return StringUtils.fromString((String)authorizationHeader);
    }

    private ExternHeaders() {
    }
}

