/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener;

import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.handler.codec.TooLongFrameException;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriAndHeaderLengthValidator
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(UriAndHeaderLengthValidator.class);
    private String serverName;

    UriAndHeaderLengthValidator(String serverName) {
        this.serverName = serverName;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            if (ctx.channel().isActive()) {
                HttpRequest inboundRequest = (HttpRequest)msg;
                Throwable cause = inboundRequest.decoderResult().cause();
                if (cause instanceof TooLongFrameException) {
                    if (cause.getMessage().contains("HTTP header is larger than")) {
                        Util.sendAndCloseNoEntityBodyResp(ctx, HttpResponseStatus.REQUEST_HEADER_FIELDS_TOO_LARGE, HttpVersion.HTTP_1_0, this.serverName);
                        LOG.warn("Inbound request Entity exceeds the max entity size allowed for a request");
                    } else if (cause.getMessage().contains("An HTTP line is larger than")) {
                        Util.sendAndCloseNoEntityBodyResp(ctx, HttpResponseStatus.REQUEST_URI_TOO_LONG, HttpVersion.HTTP_1_0, this.serverName);
                        LOG.warn("Inbound request URI length exceeds the max uri length allowed for a request");
                    } else {
                        super.channelRead(ctx, msg);
                    }
                } else {
                    super.channelRead(ctx, msg);
                }
            }
        } else {
            super.channelRead(ctx, msg);
        }
    }
}

