/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.http2;

import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2MessageStateContext;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.listener.HttpServerChannelInitializer;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2ServerChannel;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2ServerTimeoutHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2SourceConnectionHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.InboundMessageHolder;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.EntityBodyReceived;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.ReceivingHeaders;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2DataEventListener;
import io.ballerina.stdlib.http.transport.message.Http2DataFrame;
import io.ballerina.stdlib.http.transport.message.Http2HeadersFrame;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.HttpCarbonRequest;
import io.ballerina.stdlib.http.transport.message.ServerRemoteFlowControlListener;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.group.ChannelGroup;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpServerUpgradeHandler;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2EventAdapter;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.util.concurrent.Promise;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Http2SourceHandler
extends ChannelInboundHandlerAdapter {
    private static final Logger LOG = LoggerFactory.getLogger(Http2SourceHandler.class);
    private Http2ServerChannel http2ServerChannel;
    private ChannelHandlerContext ctx;
    private ServerConnectorFuture serverConnectorFuture;
    private HttpServerChannelInitializer serverChannelInitializer;
    private Http2ConnectionEncoder encoder;
    private Http2Connection conn;
    private String interfaceId;
    private String serverName;
    private String remoteHost;
    private Map<String, GenericObjectPool> targetChannelPool;
    private ServerRemoteFlowControlListener serverRemoteFlowControlListener;
    private SocketAddress remoteAddress;
    private ChannelGroup allChannels;
    private ChannelGroup listenerChannels;
    private AtomicBoolean isStale = new AtomicBoolean(false);
    private long timeSinceMarkedAsStale = 0L;
    Http2SourceConnectionHandler sourceConnectionHandler;

    Http2SourceHandler(HttpServerChannelInitializer serverChannelInitializer, Http2ConnectionEncoder encoder, String interfaceId, Http2Connection conn, ServerConnectorFuture serverConnectorFuture, String serverName, ChannelGroup allChannels, ChannelGroup listenerChannels, Http2SourceConnectionHandler sourceConnectionHandler) {
        this.serverChannelInitializer = serverChannelInitializer;
        this.encoder = encoder;
        this.interfaceId = interfaceId;
        this.serverConnectorFuture = serverConnectorFuture;
        this.conn = conn;
        this.serverName = serverName;
        this.targetChannelPool = new ConcurrentHashMap<String, GenericObjectPool>();
        this.allChannels = allChannels;
        this.listenerChannels = listenerChannels;
        this.http2ServerChannel = new Http2ServerChannel();
        this.setRemoteFlowController();
        this.setDataEventListeners();
        conn.addListener((Http2Connection.Listener)new GoAwayListener());
        this.sourceConnectionHandler = sourceConnectionHandler;
    }

    private void setDataEventListeners() {
        long serverTimeout = this.serverChannelInitializer.getSocketIdleTimeout() <= 0L ? 300000L : this.serverChannelInitializer.getSocketIdleTimeout();
        this.http2ServerChannel.addDataEventListener("idleStateHandler", new Http2ServerTimeoutHandler(serverTimeout, this.http2ServerChannel, this.serverConnectorFuture));
    }

    private void setRemoteFlowController() {
        Http2RemoteFlowController remoteFlowController = (Http2RemoteFlowController)this.conn.remote().flowController();
        this.serverRemoteFlowControlListener = new ServerRemoteFlowControlListener(remoteFlowController);
        remoteFlowController.listener((Http2RemoteFlowController.Listener)this.serverRemoteFlowControlListener);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        super.handlerAdded(ctx);
        this.ctx = ctx;
        this.allChannels.add((Object)ctx.channel());
        this.listenerChannels.add((Object)ctx.channel());
        this.remoteAddress = ctx.channel().remoteAddress();
        if (this.remoteAddress instanceof InetSocketAddress) {
            this.remoteHost = ((InetSocketAddress)this.remoteAddress).getAddress().toString();
            if (this.remoteHost.startsWith("/")) {
                this.remoteHost = this.remoteHost.substring(1);
            }
        }
    }

    public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
        if (evt instanceof HttpServerUpgradeHandler.UpgradeEvent) {
            FullHttpRequest upgradedRequest = ((HttpServerUpgradeHandler.UpgradeEvent)evt).upgradeRequest();
            DefaultHttpRequest httpRequest = new DefaultHttpRequest(new HttpVersion("HTTP/2.0", true), upgradedRequest.method(), upgradedRequest.uri(), upgradedRequest.headers());
            HttpCarbonRequest requestCarbonMessage = Http2StateUtil.setupCarbonRequest((HttpRequest)httpRequest, this, 1);
            requestCarbonMessage.addHttpContent((HttpContent)new DefaultLastHttpContent(upgradedRequest.content()));
            requestCarbonMessage.setLastHttpContentArrived();
            InboundMessageHolder inboundMsgHolder = new InboundMessageHolder(requestCarbonMessage);
            if (requestCarbonMessage.getHttp2MessageStateContext() == null) {
                Http2MessageStateContext http2MessageStateContext = new Http2MessageStateContext();
                http2MessageStateContext.setListenerState(new EntityBodyReceived(http2MessageStateContext));
                requestCarbonMessage.setHttp2MessageStateContext(http2MessageStateContext);
            }
            this.http2ServerChannel.getStreamIdRequestMap().put(1, inboundMsgHolder);
            this.http2ServerChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamInit(ctx, 1));
            Http2StateUtil.notifyRequestListener(this, inboundMsgHolder, 1);
        }
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Http2Exception, ServerConnectorException {
        if (msg instanceof Http2HeadersFrame) {
            Http2HeadersFrame headersFrame = (Http2HeadersFrame)msg;
            Http2MessageStateContext http2MessageStateContext = new Http2MessageStateContext();
            http2MessageStateContext.setListenerState(new ReceivingHeaders(this, http2MessageStateContext));
            http2MessageStateContext.getListenerState().readInboundRequestHeaders(ctx, headersFrame);
        } else if (msg instanceof Http2DataFrame) {
            Http2DataFrame dataFrame = (Http2DataFrame)msg;
            int streamId = dataFrame.getStreamId();
            InboundMessageHolder inboundMessageHolder = this.http2ServerChannel.getInboundMessage(streamId);
            HttpCarbonMessage sourceReqCMsg = null;
            if (inboundMessageHolder != null) {
                sourceReqCMsg = inboundMessageHolder.getInboundMsg();
            }
            if (sourceReqCMsg == null) {
                dataFrame.getData().release();
            } else {
                sourceReqCMsg.getHttp2MessageStateContext().getListenerState().readInboundRequestBody(this, dataFrame);
            }
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    public void channelActive(ChannelHandlerContext ctx) {
        this.allChannels.add((Object)ctx.channel());
        this.listenerChannels.add((Object)ctx.channel());
    }

    public void channelInactive(ChannelHandlerContext ctx) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("Channel inactive event received in HTTP2SourceHandler");
        }
        this.destroy();
        this.closeTargetChannels();
        ctx.fireChannelInactive();
    }

    public void channelUnregistered(ChannelHandlerContext ctx) {
        this.destroy();
        ctx.fireChannelUnregistered();
    }

    private void destroy() {
        LOG.debug("Inbound request map size {}", (Object)this.http2ServerChannel.getStreamIdRequestMap().size());
        this.http2ServerChannel.getStreamIdRequestMap().forEach((streamId, inboundMessageHolder) -> {
            HttpCarbonMessage inboundMsg = inboundMessageHolder.getInboundMsg();
            LOG.debug("Listener state {}", (Object)inboundMsg.getHttp2MessageStateContext().getListenerState());
            inboundMsg.getHttp2MessageStateContext().getListenerState().handleAbruptChannelClosure(this.serverConnectorFuture, this.getChannelHandlerContext(), inboundMessageHolder.getHttp2OutboundRespListener(), (int)streamId);
            inboundMessageHolder.getHttp2OutboundRespListener().removeDefaultResponseWriter();
            inboundMessageHolder.getHttp2OutboundRespListener().removeBackPressureListener();
        });
        this.http2ServerChannel.getDataEventListeners().forEach(Http2DataEventListener::destroy);
        this.http2ServerChannel.destroy();
    }

    private void closeTargetChannels() {
        this.targetChannelPool.forEach((hostPortKey, genericObjectPool) -> {
            try {
                this.targetChannelPool.remove(hostPortKey).close();
            }
            catch (Exception e) {
                LOG.error("Couldn't close target channel socket connections", (Throwable)e);
            }
        });
    }

    public Map<Integer, InboundMessageHolder> getStreamIdRequestMap() {
        return this.http2ServerChannel.getStreamIdRequestMap();
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.ctx;
    }

    public ServerConnectorFuture getServerConnectorFuture() {
        return this.serverConnectorFuture;
    }

    public HttpServerChannelInitializer getServerChannelInitializer() {
        return this.serverChannelInitializer;
    }

    public Http2ConnectionEncoder getEncoder() {
        return this.encoder;
    }

    public Http2Connection getConnection() {
        return this.conn;
    }

    public String getInterfaceId() {
        return this.interfaceId;
    }

    public String getServerName() {
        return this.serverName;
    }

    public String getRemoteHost() {
        return this.remoteHost;
    }

    public Map<String, GenericObjectPool> getTargetChannelPool() {
        return this.targetChannelPool;
    }

    public ChannelHandlerContext getInboundChannelContext() {
        return this.ctx;
    }

    public ServerRemoteFlowControlListener getServerRemoteFlowControlListener() {
        return this.serverRemoteFlowControlListener;
    }

    public Http2ServerChannel getHttp2ServerChannel() {
        return this.http2ServerChannel;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void markAsStale() {
        this.isStale.set(true);
        this.serverChannelInitializer.addToStaleChannels(this);
        this.setTimeSinceMarkedAsStale(System.currentTimeMillis());
    }

    public void closeChannelAfterBecomingStale() {
        this.destroy();
        this.closeH2Connection();
    }

    private void closeH2Connection() {
        this.conn.close((Promise)this.getChannelHandlerContext().newPromise());
        try {
            this.sourceConnectionHandler.close(this.getChannelHandlerContext(), this.getChannelHandlerContext().newPromise());
        }
        catch (Exception e) {
            LOG.error("Exception occured while closing the connection,");
        }
    }

    void setTimeSinceMarkedAsStale(long timeSinceMarkedAsStale) {
        this.timeSinceMarkedAsStale = timeSinceMarkedAsStale;
    }

    public long getTimeSinceMarkedAsStale() {
        return this.timeSinceMarkedAsStale;
    }

    private class GoAwayListener
    extends Http2EventAdapter {
        private GoAwayListener() {
        }

        public void onGoAwayReceived(int lastStreamId, long errorCode, ByteBuf debugData) {
            if (Http2SourceHandler.this.isStale.get()) {
                return;
            }
            Http2SourceHandler.this.markAsStale();
            Http2SourceHandler.this.getStreamIdRequestMap().forEach((streamId, inboundMsg) -> {
                if (streamId > lastStreamId) {
                    Http2SourceHandler.this.http2ServerChannel.getDataEventListeners().forEach(dataEventListener -> dataEventListener.onStreamClose((int)streamId));
                    Http2MessageStateContext messageStateContext = inboundMsg.getInboundMsg().getHttp2MessageStateContext();
                    if (messageStateContext != null) {
                        messageStateContext.getListenerState().handleClientGoAway(Http2SourceHandler.this.serverConnectorFuture, Http2SourceHandler.this.getChannelHandlerContext(), inboundMsg.getHttp2OutboundRespListener(), (Integer)streamId);
                    }
                }
            });
        }
    }
}

