/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.states;

import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ClientClosedConnectionException;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.HttpOutboundRespListener;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.listener.SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerReqRespStateManager;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerState;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.SendingHeaders;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityBodyReceived
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(EntityBodyReceived.class);
    private final ListenerReqRespStateManager listenerReqRespStateManager;
    private final SourceHandler sourceHandler;
    private final float httpVersion;

    EntityBodyReceived(ListenerReqRespStateManager listenerReqRespStateManager, SourceHandler sourceHandler, float httpVersion) {
        this.listenerReqRespStateManager = listenerReqRespStateManager;
        this.sourceHandler = sourceHandler;
        this.httpVersion = httpVersion;
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        LOG.warn("readInboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        LOG.warn("readInboundRequestBody is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundResponseListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        if (Util.getHttpResponseStatus(outboundResponseMsg).code() != HttpResponseStatus.CONTINUE.code()) {
            this.listenerReqRespStateManager.state = new SendingHeaders(this.listenerReqRespStateManager, outboundResponseListener);
            this.listenerReqRespStateManager.writeOutboundResponseHeaders(outboundResponseMsg, httpContent);
        }
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        try {
            serverConnectorFuture.notifyErrorListener(new ClientClosedConnectionException("Remote client closed the connection before initiating outbound response"));
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener", (Throwable)e);
        }
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        try {
            serverConnectorFuture.notifyErrorListener(new ServerConnectorException("Idle timeout triggered before initiating outbound response"));
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener", (Throwable)e);
        }
        String responseValue = "Idle timeout triggered before initiating outbound response";
        ChannelFuture outboundRespFuture = StateUtil.sendRequestTimeoutResponse(ctx, HttpResponseStatus.REQUEST_TIMEOUT, Unpooled.copiedBuffer((CharSequence)responseValue, (Charset)CharsetUtil.UTF_8), responseValue.length(), this.httpVersion, this.sourceHandler.getServerName());
        outboundRespFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            Throwable cause = channelFuture.cause();
            if (cause != null) {
                LOG.warn("Failed to send: {}", (Object)cause.getMessage());
            }
            ctx.close();
        }));
        return outboundRespFuture;
    }
}

