/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.uri.parser;

import io.ballerina.stdlib.http.api.HttpResourceArguments;
import io.ballerina.stdlib.http.uri.URITemplateException;
import io.ballerina.stdlib.http.uri.parser.DataElement;
import io.ballerina.stdlib.http.uri.parser.Expression;
import io.ballerina.stdlib.http.uri.parser.Variable;
import java.util.HashMap;
import java.util.Map;

public class SimpleStringExpression<DataType, InboundMsgType>
extends Expression<DataType, InboundMsgType> {
    private static final char[] RESERVED = new char[]{':', '/', '?', '#', '[', ']', '@', '!', '$', '&', '\'', '(', ')', '*', '+', ',', ';', '='};

    SimpleStringExpression(DataElement<DataType, InboundMsgType> dataElement, String token, int index) throws URITemplateException {
        super(dataElement, token, index);
    }

    @Override
    String expand(Map<String, String> variables) {
        boolean emptyString = false;
        StringBuilder buffer = new StringBuilder();
        for (Variable var : this.variableList) {
            String value;
            String name = var.getName();
            if (!variables.containsKey(name)) continue;
            if (buffer.length() > 0) {
                buffer.append(this.getSeparator());
            }
            if ("".equals(value = var.modify(variables.get(name)))) {
                emptyString = true;
            }
            buffer.append(this.encodeValue(value));
        }
        if (buffer.length() == 0 && !emptyString) {
            return null;
        }
        return buffer.toString();
    }

    @Override
    int match(String uriFragment, HttpResourceArguments variables) {
        int length = uriFragment.length();
        for (int i = 0; i < length; ++i) {
            char ch = uriFragment.charAt(i);
            if (this.isEndCharacter(Character.valueOf(ch))) {
                if (ch == this.getSeparator() && this.variableList.size() > 0) continue;
                if (!this.setVariables(uriFragment.substring(0, i), variables)) {
                    return -1;
                }
                return i;
            }
            if (i != length - 1) continue;
            if (!this.setVariables(uriFragment, variables)) {
                return -1;
            }
            return length;
        }
        return 0;
    }

    @Override
    char getFirstCharacter() {
        return '\u0001';
    }

    protected boolean isEndCharacter(Character endCharacter) {
        return endCharacter.charValue() == '/';
    }

    private char getSeparator() {
        return ',';
    }

    boolean setVariables(String expressionValue, HttpResourceArguments variables) {
        String finalValue = this.decodeValue(expressionValue);
        for (Variable var : this.variableList) {
            Map<Object, Object> indexValueMap;
            String name = var.getName();
            if (variables.getMap().containsKey(name)) {
                indexValueMap = variables.getMap().get(name);
            } else {
                indexValueMap = new HashMap();
                variables.getMap().put(name, indexValueMap);
            }
            if (var.checkModifier(finalValue)) {
                indexValueMap.put(this.getExpressionIndex(), finalValue);
                continue;
            }
            return false;
        }
        return true;
    }

    protected boolean isReserved(char ch) {
        for (char reservedChar : RESERVED) {
            if (ch != reservedChar) continue;
            return true;
        }
        return false;
    }
}

