/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.constraint.compiler;

import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.constraint.compiler.annotation.tag.AnnotationTag;
import io.ballerina.stdlib.constraint.compiler.annotation.tag.AnnotationTagArray;
import io.ballerina.stdlib.constraint.compiler.annotation.tag.AnnotationTagDate;
import io.ballerina.stdlib.constraint.compiler.annotation.tag.AnnotationTagFloat;
import io.ballerina.stdlib.constraint.compiler.annotation.tag.AnnotationTagInt;
import io.ballerina.stdlib.constraint.compiler.annotation.tag.AnnotationTagNumber;
import io.ballerina.stdlib.constraint.compiler.annotation.tag.AnnotationTagString;
import io.ballerina.stdlib.constraint.compiler.annotation.tag.DigitsConstrainedAnnotationTag;
import io.ballerina.stdlib.constraint.compiler.annotation.tag.LengthConstrainedAnnotationTag;
import java.util.ArrayList;
import java.util.HashMap;

public class ConstraintCompatibilityMatrix {
    private static final HashMap<String, AnnotationTag> matrix = new HashMap();

    ConstraintCompatibilityMatrix() {
        matrix.put("Int", new AnnotationTagInt());
        matrix.put("Float", new AnnotationTagFloat());
        matrix.put("Number", new AnnotationTagNumber());
        matrix.put("String", new AnnotationTagString());
        matrix.put("Array", new AnnotationTagArray());
        matrix.put("Date", new AnnotationTagDate());
    }

    boolean isAnnotationTagCompatibleWithTypeSymbol(SyntaxNodeAnalysisContext ctx, String annotationTag, TypeSymbol fielsTypeSymbol) {
        return matrix.get(annotationTag).isCompatibleFieldType(ctx, fielsTypeSymbol);
    }

    boolean isAnnotationConstraintsCompatible(String annotationTag, ArrayList<String> constraints) {
        return matrix.get(annotationTag).haveCompatibleConstraints(constraints);
    }

    boolean isAnnotationConstraintsValid(String annotationTag, String constraintField, String constraintValue) {
        AnnotationTag tag = matrix.get(annotationTag);
        if (tag instanceof LengthConstrainedAnnotationTag) {
            return ((LengthConstrainedAnnotationTag)tag).isValidConstraintValue(constraintField, constraintValue);
        }
        if (tag instanceof DigitsConstrainedAnnotationTag) {
            return ((DigitsConstrainedAnnotationTag)tag).isValidConstraintValue(constraintField, constraintValue);
        }
        return true;
    }
}

