/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ChildNodeEntry;
import io.ballerina.compiler.syntax.tree.EnumDeclarationNode;
import io.ballerina.compiler.syntax.tree.EnumMemberNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.IntersectionTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.NilLiteralNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.RequiredExpressionNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SingletonTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.document.DocCommentsGeneratorUtil;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Package;
import io.ballerina.projects.Project;
import io.ballerina.projects.directory.ProjectLoader;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BallerinaUtilGenerator {
    private boolean pathParametersFound = false;
    private boolean queryParamsFound = false;
    private boolean requestBodyEncodingFound = false;
    private boolean requestBodyMultipartFormDatafound = false;
    private boolean defaultStatusCodeResponseBindingFound = false;
    private static final Logger LOGGER = LoggerFactory.getLogger(BallerinaUtilGenerator.class);
    private static final String CREATE_FORM_URLENCODED_REQUEST_BODY = "createFormURLEncodedRequestBody";
    private static final String GET_DEEP_OBJECT_STYLE_REQUEST = "getDeepObjectStyleRequest";
    private static final String GET_FORM_STYLE_REQUEST = "getFormStyleRequest";
    private static final String GET_SERIALIZED_ARRAY = "getSerializedArray";
    private static final String GET_ENCODED_URI = "getEncodedUri";
    private static final String GET_ORIGINAL_KEY = "getOriginalKey";
    private static final String GET_PATH_FOR_QUERY_PARAM = "getPathForQueryParam";
    private static final String GET_SERIALIZED_RECORD_ARRAY = "getSerializedRecordArray";
    private static final String CREATE_MULTIPART_BODY_PARTS = "createBodyParts";
    private static final String CONSTRUCT_ENTITY = "constructEntity";
    private static final String POPULATE_ENCODING_INFO = "populateEncodingInfo";
    private static final String GET_VALIDATED_RESPONSE_FOR_DEFAULT_MAPPING = "getValidatedResponseForDefaultMapping";
    private static final String CREATE_STATUS_CODE_RESPONSE_BINDING_ERROR = "createStatusCodeResponseBindingError";

    public void setQueryParamsFound(boolean flag) {
        this.queryParamsFound = flag;
    }

    public void setPathParametersFound(boolean flag) {
        this.pathParametersFound = flag;
    }

    public void setRequestBodyEncodingFound(boolean flag) {
        this.requestBodyEncodingFound = flag;
    }

    public void setRequestBodyMultipartFormDatafound(boolean flag) {
        this.requestBodyMultipartFormDatafound = flag;
    }

    public void setDefaultStatusCodeResponseBinding(boolean flag) {
        this.defaultStatusCodeResponseBindingFound = flag;
    }

    public boolean hasDefaultStatusCodeResponseBinding() {
        return this.defaultStatusCodeResponseBindingFound;
    }

    public SyntaxTree generateUtilSyntaxTree() throws IOException {
        Set<String> functionNameList = this.getFunctionNameList();
        ArrayList<ModuleMemberDeclarationNode> memberDeclarationNodes = new ArrayList<ModuleMemberDeclarationNode>();
        this.getUtilTypeDeclarationNodes(memberDeclarationNodes);
        this.addUtilFunctionDeclarationNodes(memberDeclarationNodes, functionNameList);
        List<ImportDeclarationNode> imports = this.generateImports(functionNameList);
        NodeList importsList = AbstractNodeFactory.createNodeList(imports);
        ModulePartNode utilModulePartNode = NodeFactory.createModulePartNode((NodeList)importsList, (NodeList)AbstractNodeFactory.createNodeList(memberDeclarationNodes), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EOF_TOKEN));
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree utilSyntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return utilSyntaxTree.modifyWith((Node)utilModulePartNode);
    }

    private void addUtilFunctionDeclarationNodes(List<ModuleMemberDeclarationNode> memberDeclarationNodes, Set<String> functionNameList) throws IOException {
        Path path = this.getResourceFilePath();
        Project project = ProjectLoader.loadProject((Path)path);
        Package currentPackage = project.currentPackage();
        DocumentId docId = (DocumentId)currentPackage.getDefaultModule().documentIds().iterator().next();
        SyntaxTree fileSyntaxTree = currentPackage.getDefaultModule().document(docId).syntaxTree();
        ModulePartNode modulePartNode = (ModulePartNode)fileSyntaxTree.rootNode();
        NodeList members = modulePartNode.members();
        for (ModuleMemberDeclarationNode node : members) {
            if (!node.kind().equals((Object)SyntaxKind.FUNCTION_DEFINITION)) continue;
            for (ChildNodeEntry childNodeEntry : node.childEntries()) {
                if (!childNodeEntry.name().equals("functionName") || !functionNameList.contains(((Node)childNodeEntry.node().get()).toString())) continue;
                memberDeclarationNodes.add(node);
            }
        }
    }

    private Set<String> getFunctionNameList() {
        LinkedHashSet<String> functionNameList = new LinkedHashSet<String>();
        if (this.requestBodyEncodingFound) {
            functionNameList.addAll(Arrays.asList(CREATE_FORM_URLENCODED_REQUEST_BODY, GET_DEEP_OBJECT_STYLE_REQUEST, GET_FORM_STYLE_REQUEST, GET_ENCODED_URI, GET_ORIGINAL_KEY, GET_SERIALIZED_ARRAY, GET_SERIALIZED_RECORD_ARRAY));
        }
        if (this.queryParamsFound) {
            functionNameList.addAll(Arrays.asList(GET_DEEP_OBJECT_STYLE_REQUEST, GET_FORM_STYLE_REQUEST, GET_ENCODED_URI, GET_ORIGINAL_KEY, GET_SERIALIZED_ARRAY, GET_PATH_FOR_QUERY_PARAM, GET_SERIALIZED_RECORD_ARRAY));
        }
        if (this.pathParametersFound) {
            functionNameList.add(GET_ENCODED_URI);
        }
        if (this.requestBodyMultipartFormDatafound) {
            functionNameList.add(CREATE_MULTIPART_BODY_PARTS);
            functionNameList.add(CONSTRUCT_ENTITY);
            functionNameList.add(POPULATE_ENCODING_INFO);
        }
        if (this.defaultStatusCodeResponseBindingFound) {
            functionNameList.addAll(Arrays.asList(GET_VALIDATED_RESPONSE_FOR_DEFAULT_MAPPING, CREATE_STATUS_CODE_RESPONSE_BINDING_ERROR));
        }
        return functionNameList;
    }

    private List<ImportDeclarationNode> generateImports(Set<String> functionNameList) {
        ArrayList<ImportDeclarationNode> imports = new ArrayList<ImportDeclarationNode>();
        if (functionNameList.contains(GET_ENCODED_URI)) {
            ImportDeclarationNode importForUrl = GeneratorUtils.getImportDeclarationNode("ballerina", "url");
            imports.add(importForUrl);
        }
        if (this.requestBodyMultipartFormDatafound) {
            ImportDeclarationNode importMime = GeneratorUtils.getImportDeclarationNode("ballerina", "mime");
            imports.add(importMime);
        }
        if (this.defaultStatusCodeResponseBindingFound || this.queryParamsFound) {
            ImportDeclarationNode importForHttp = GeneratorUtils.getImportDeclarationNode("ballerina", "http");
            imports.add(importForHttp);
        }
        return imports;
    }

    private void getUtilTypeDeclarationNodes(List<ModuleMemberDeclarationNode> memberDeclarationNodes) {
        if (this.requestBodyEncodingFound || this.queryParamsFound || this.requestBodyMultipartFormDatafound) {
            memberDeclarationNodes.add((ModuleMemberDeclarationNode)this.getSimpleBasicTypeDefinitionNode());
        }
        if (this.requestBodyEncodingFound || this.queryParamsFound || this.requestBodyMultipartFormDatafound) {
            memberDeclarationNodes.addAll(Arrays.asList(this.getEncodingRecord(), this.getStyleEnum()));
        }
        if (this.requestBodyEncodingFound || this.queryParamsFound) {
            memberDeclarationNodes.add((ModuleMemberDeclarationNode)this.getDefaultEncoding());
        }
    }

    private TypeDefinitionNode getEncodingRecord() {
        ArrayList<MarkdownDocumentationLineNode> styleDoc = new ArrayList<MarkdownDocumentationLineNode>(DocCommentsGeneratorUtil.createAPIDescriptionDoc("Defines how multiple values are delimited", false));
        MarkdownDocumentationNode styleDocumentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(styleDoc));
        MetadataNode styleMetadataNode = NodeFactory.createMetadataNode((Node)styleDocumentationNode, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        RequiredExpressionNode styleExpressionNode = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"FORM"));
        RecordFieldWithDefaultValueNode styleFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)styleMetadataNode, null, (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)"style"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)styleExpressionNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        ArrayList<MarkdownDocumentationLineNode> explodeDoc = new ArrayList<MarkdownDocumentationLineNode>(DocCommentsGeneratorUtil.createAPIDescriptionDoc("Specifies whether arrays and objects should generate as separate fields", false));
        MarkdownDocumentationNode explodeDocumentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(explodeDoc));
        MetadataNode explodeMetadataNode = NodeFactory.createMetadataNode((Node)explodeDocumentationNode, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        RequiredExpressionNode explodeExpressionNode = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"true"));
        RecordFieldWithDefaultValueNode explodeFieldNode = NodeFactory.createRecordFieldWithDefaultValueNode((MetadataNode)explodeMetadataNode, null, (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BOOLEAN_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)"explode"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)explodeExpressionNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        ArrayList<MarkdownDocumentationLineNode> contentTypeDoc = new ArrayList<MarkdownDocumentationLineNode>(DocCommentsGeneratorUtil.createAPIDescriptionDoc("Specifies the custom content type", false));
        MarkdownDocumentationNode contentTypeDocumentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(contentTypeDoc));
        MetadataNode contentTypeMetadataNode = NodeFactory.createMetadataNode((Node)contentTypeDocumentationNode, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        RecordFieldNode contentTypeFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)contentTypeMetadataNode, null, (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)"contentType"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        ArrayList<MarkdownDocumentationLineNode> headerDoc = new ArrayList<MarkdownDocumentationLineNode>(DocCommentsGeneratorUtil.createAPIDescriptionDoc("Specifies the custom headers", false));
        MarkdownDocumentationNode headerDocumentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(headerDoc));
        MetadataNode headerMetadataNode = NodeFactory.createMetadataNode((Node)headerDocumentationNode, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        RecordFieldNode headerFieldNode = NodeFactory.createRecordFieldNode((MetadataNode)headerMetadataNode, null, (Node)AbstractNodeFactory.createIdentifierToken((String)"map<any>"), (Token)AbstractNodeFactory.createIdentifierToken((String)"headers"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.QUESTION_MARK_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        ArrayList<MarkdownDocumentationLineNode> typeDoc = new ArrayList<MarkdownDocumentationLineNode>(DocCommentsGeneratorUtil.createAPIDescriptionDoc("Represents encoding mechanism details.", false));
        MarkdownDocumentationNode typeDocumentationNode = NodeFactory.createMarkdownDocumentationNode((NodeList)AbstractNodeFactory.createNodeList(typeDoc));
        MetadataNode typeMetadataNode = NodeFactory.createMetadataNode((Node)typeDocumentationNode, (NodeList)AbstractNodeFactory.createEmptyNodeList());
        NodeList fieldNodes = AbstractNodeFactory.createNodeList((Node[])new Node[]{styleFieldNode, explodeFieldNode, contentTypeFieldNode, headerFieldNode});
        RecordTypeDescriptorNode typeDescriptorNode = NodeFactory.createRecordTypeDescriptorNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RECORD_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)fieldNodes, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        return NodeFactory.createTypeDefinitionNode((MetadataNode)typeMetadataNode, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)"Encoding"), (Node)typeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private EnumDeclarationNode getStyleEnum() {
        EnumMemberNode deepObject = NodeFactory.createEnumMemberNode(null, (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"DEEPOBJECT"), null, null);
        EnumMemberNode form = NodeFactory.createEnumMemberNode(null, (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"FORM"), null, null);
        EnumMemberNode spaceDelimited = NodeFactory.createEnumMemberNode(null, (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"SPACEDELIMITED"), null, null);
        EnumMemberNode pipeDelimited = NodeFactory.createEnumMemberNode(null, (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"PIPEDELIMITED"), null, null);
        SeparatedNodeList enumMembers = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{deepObject, AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), form, AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), spaceDelimited, AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), pipeDelimited});
        return NodeFactory.createEnumDeclarationNode(null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ENUM_KEYWORD), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"EncodingStyle"), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)enumMembers, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
    }

    private TypeDefinitionNode getSimpleBasicTypeDefinitionNode() {
        SingletonTypeDescriptorNode typeDescriptorNode = NodeFactory.createSingletonTypeDescriptorNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"string|boolean|int|float|decimal")));
        return NodeFactory.createTypeDefinitionNode(null, null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.TYPE_KEYWORD), (Token)AbstractNodeFactory.createIdentifierToken((String)"SimpleBasicType"), (Node)typeDescriptorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private ModuleVariableDeclarationNode getDefaultEncoding() {
        IntersectionTypeDescriptorNode typeName = NodeFactory.createIntersectionTypeDescriptorNode((Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"Encoding")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BITWISE_AND_TOKEN), (Node)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.READONLY_KEYWORD)));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"defaultEncoding"));
        TypedBindingPatternNode bindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeName, (BindingPatternNode)bindingPattern);
        NilLiteralNode expressionNode = NodeFactory.createNilLiteralNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        return NodeFactory.createModuleVariableDeclarationNode(null, null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FINAL_KEYWORD)}), (TypedBindingPatternNode)bindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)expressionNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private Path getResourceFilePath() throws IOException {
        Path path = null;
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream inputStream = classLoader.getResourceAsStream("templates/utils_openapi.bal");
        if (inputStream != null) {
            String clientSyntaxTreeString = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            Path tmpDir = Files.createTempDirectory(".util-tmp" + System.nanoTime(), new FileAttribute[0]);
            path = tmpDir.resolve("utils.bal");
            try (PrintWriter writer = new PrintWriter(path.toString(), StandardCharsets.UTF_8);){
                writer.print(clientSyntaxTreeString);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(() -> {
                try {
                    FileUtils.deleteDirectory((File)tmpDir.toFile());
                }
                catch (IOException ex) {
                    LOGGER.error("Unable to delete the temporary directory : " + String.valueOf(tmpDir), (Throwable)ex);
                }
            }));
        }
        return path;
    }
}

