/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.mime;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.openapi.core.generators.client.BallerinaUtilGenerator;
import io.ballerina.openapi.core.generators.client.mime.MimeType;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.MediaType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class UrlEncodedType
extends MimeType {
    private final BallerinaUtilGenerator ballerinaUtilGenerator;
    private final List<ImportDeclarationNode> imports;

    public UrlEncodedType(BallerinaUtilGenerator ballerinaUtilGenerator, List<ImportDeclarationNode> imports) {
        this.ballerinaUtilGenerator = ballerinaUtilGenerator;
        this.imports = imports;
    }

    @Override
    public void setPayload(List<StatementNode> statementsList, Map.Entry<String, MediaType> mediaTypeEntry) {
        GeneratorUtils.addImport(this.imports, "data.jsondata");
        this.ballerinaUtilGenerator.setRequestBodyEncodingFound(true);
        VariableDeclarationNode requestBodyEncodingMap = this.getRequestBodyEncodingMap(mediaTypeEntry.getValue().getEncoding());
        String payloadName = "encodedRequestBody";
        if (requestBodyEncodingMap != null) {
            statementsList.add((StatementNode)requestBodyEncodingMap);
            VariableDeclarationNode requestBodyVariable = GeneratorUtils.getSimpleStatement("string", payloadName, "createFormURLEncodedRequestBody(check jsondata:toJson(payload).ensureType(), requestBodyEncoding)");
            statementsList.add((StatementNode)requestBodyVariable);
        } else {
            VariableDeclarationNode requestBodyVariable = GeneratorUtils.getSimpleStatement("string", payloadName, "createFormURLEncodedRequestBody(check jsondata:toJson(payload).ensureType())");
            statementsList.add((StatementNode)requestBodyVariable);
        }
        this.setPayload(statementsList, payloadName, mediaTypeEntry.getKey());
    }

    public VariableDeclarationNode getRequestBodyEncodingMap(Map<String, Encoding> encodingMap) {
        ArrayList<Node> filedOfMap = new ArrayList<Node>();
        BuiltinSimpleNameReferenceNode mapType = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"map<Encoding>"));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"requestBodyEncoding"));
        TypedBindingPatternNode bindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)mapType, (BindingPatternNode)bindingPattern);
        if (encodingMap != null && encodingMap.size() > 0) {
            for (Map.Entry<String, Encoding> encoding : encodingMap.entrySet()) {
                if (encoding.getValue().getStyle() == null && encoding.getValue().getExplode() == null) continue;
                GeneratorUtils.createEncodingMap(filedOfMap, encoding.getValue().getStyle().toString(), encoding.getValue().getExplode(), encoding.getKey());
            }
            if (!filedOfMap.isEmpty()) {
                filedOfMap.remove(filedOfMap.size() - 1);
                MappingConstructorExpressionNode initialize = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList(filedOfMap), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
                return NodeFactory.createVariableDeclarationNode((NodeList)AbstractNodeFactory.createEmptyNodeList(), null, (TypedBindingPatternNode)bindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initialize, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
            }
        }
        return null;
    }
}

