/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.client.mock;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.client.FunctionBodyGenerator;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnostic;
import io.ballerina.openapi.core.generators.client.diagnostic.ClientDiagnosticImp;
import io.ballerina.openapi.core.generators.client.diagnostic.DiagnosticMessages;
import io.ballerina.openapi.core.generators.common.GeneratorConstants;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.InvalidReferenceException;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.examples.Example;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;

public class MockFunctionBodyGenerator
implements FunctionBodyGenerator {
    String path;
    Map.Entry<PathItem.HttpMethod, Operation> operation;
    OpenAPI openAPI;
    List<ClientDiagnostic> diagnostics = new ArrayList<ClientDiagnostic>();
    boolean isAdvanceClient;

    public MockFunctionBodyGenerator(String path, Map.Entry<PathItem.HttpMethod, Operation> operation, OpenAPI openAPI, boolean isAdvanceClient) {
        this.path = path;
        this.operation = operation;
        this.openAPI = openAPI;
        this.isAdvanceClient = isAdvanceClient;
    }

    @Override
    public Optional<FunctionBodyNode> getFunctionBodyNode() {
        Object statement;
        String code;
        ApiResponse successResponse;
        ClientDiagnosticImp diagnosticImp;
        ApiResponses responses = this.operation.getValue().getResponses();
        String method = this.operation.getKey().toString().toLowerCase(Locale.ENGLISH);
        HashMap<String, ApiResponse> successResponses = new HashMap<String, ApiResponse>();
        for (Object response : responses.entrySet()) {
            if (!((String)response.getKey()).startsWith("2")) continue;
            successResponses.put((String)response.getKey(), (ApiResponse)response.getValue());
        }
        if (successResponses.isEmpty()) {
            diagnosticImp = new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_115, this.path, this.operation.getKey().toString());
            this.diagnostics.add(diagnosticImp);
            return Optional.empty();
        }
        if (method.equals("post") && successResponses.containsKey("201")) {
            successResponse = (ApiResponse)successResponses.get("201");
            code = "201";
        } else {
            Optional firstRes = successResponses.entrySet().stream().findFirst();
            successResponse = (ApiResponse)((Map.Entry)firstRes.get()).getValue();
            code = ((String)((Map.Entry)firstRes.get()).getKey()).toLowerCase(Locale.ENGLISH);
        }
        if (successResponse.getContent() == null) {
            diagnosticImp = new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_115, this.path, this.operation.getKey().toString());
            this.diagnostics.add(diagnosticImp);
            return Optional.empty();
        }
        Map<Object, Object> examples = new HashMap();
        for (Map.Entry mediaType : successResponse.getContent().entrySet()) {
            MediaType value = (MediaType)mediaType.getValue();
            Schema schema = value.getSchema();
            if (value.getExamples() != null) {
                examples = value.getExamples();
                continue;
            }
            if (value.getExample() != null) {
                Object exampleObject = value.getExample();
                Example example = new Example();
                example.setValue(exampleObject);
                examples.put("response", example);
                continue;
            }
            try {
                examples = this.getExamplesFromSchema(schema);
            }
            catch (InvalidReferenceException e) {
                ClientDiagnosticImp diagnosticImp2 = new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_117, this.path, this.operation.getKey().toString());
                this.diagnostics.add(diagnosticImp2);
                return Optional.empty();
            }
        }
        if (examples.isEmpty()) {
            ClientDiagnosticImp diagnosticImp3 = new ClientDiagnosticImp(DiagnosticMessages.OAS_CLIENT_116, this.path, this.operation.getKey().toString());
            this.diagnostics.add(diagnosticImp3);
            return Optional.empty();
        }
        Example example = (Example)examples.get("response");
        if (example == null) {
            example = (Example)examples.values().iterator().next();
        }
        try {
            if (example.get$ref() != null) {
                String exampleName = GeneratorUtils.extractReferenceType(example.get$ref());
                Map exampleMap = this.openAPI.getComponents().getExamples();
                example = (Example)exampleMap.get(exampleName);
            }
            String exampleValue = example.getValue().toString();
            if (this.isAdvanceClient) {
                ArrayList<Diagnostic> newDiagnostics = new ArrayList<Diagnostic>();
                statement = this.getReturnForAdvanceClient(successResponse, code, exampleValue, newDiagnostics);
                this.diagnostics.addAll(newDiagnostics.stream().map(ClientDiagnosticImp::new).toList());
            } else {
                statement = "return " + exampleValue + ";";
            }
        }
        catch (InvalidReferenceException e) {
            this.diagnostics.add(new ClientDiagnosticImp(e.getDiagnostic()));
            return Optional.empty();
        }
        StatementNode returnNode = NodeParser.parseStatement((String)statement);
        NodeList statementList = AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{returnNode});
        FunctionBodyBlockNode fBodyBlock = NodeFactory.createFunctionBodyBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), null, (NodeList)statementList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
        return Optional.of(fBodyBlock);
    }

    private String getReturnForAdvanceClient(ApiResponse successResponse, String code, String exampleValue, List<Diagnostic> newDiagnostics) throws InvalidReferenceException {
        code = GeneratorConstants.HTTP_CODES_DES.get(code);
        String method = this.operation.getKey().toString().toLowerCase(Locale.ENGLISH);
        TypeDescriptorNode typeDescriptorNode = GeneratorUtils.generateStatusCodeTypeInclusionRecord(code, successResponse, method, this.openAPI, this.path, newDiagnostics);
        String statement = "return  <" + typeDescriptorNode.toSourceCode() + " > {\n            body : " + exampleValue + "\n        };";
        return statement;
    }

    private Map<String, Example> getExamplesFromSchema(Schema<?> schema) throws InvalidReferenceException {
        HashMap<String, Example> examples = new HashMap<String, Example>();
        if (schema.getExample() != null) {
            Object exampleObject = schema.getExample();
            Example example = new Example();
            example.setValue(exampleObject);
            examples.put("response", example);
        } else if (schema.getExamples() != null) {
            List schemaExamples = schema.getExamples();
            Object exampleObject = schemaExamples.get(0);
            Example example = new Example();
            example.setValue(exampleObject);
            examples.put("response", example);
        } else if (schema.get$ref() != null) {
            String ref = schema.get$ref();
            String refName = GeneratorUtils.extractReferenceType(ref);
            schema = (Schema)this.openAPI.getComponents().getSchemas().get(refName);
            if (schema != null) {
                return this.getExamplesFromSchema(schema);
            }
        }
        return examples;
    }

    @Override
    public List<ClientDiagnostic> getDiagnostics() {
        return this.diagnostics;
    }
}

