/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.common;

import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.common.exception.InvalidReferenceException;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.parser.OpenAPIParser;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.ComposedSchema;
import io.swagger.v3.oas.models.media.MapSchema;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityScheme;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class OASModifier {
    private static final String REGEX_FOR_CURLY_BRACED_CONTENT = "\\{([^}]*)}";
    private static final String COMPONENT_REF_WITH_NAME_PATTERN = "\"$ref\":\"#/components/schemas/%s\"";
    private static final String COMPONENT_REF_REGEX_PATTERN = "(\\\"\\$ref\\\"\\s*:\\s*\\\"#/components/schemas/%s\\\")|('\\$ref'\\s*:\\s*'#/components/schemas/%s')";
    private static final PrintStream outErrorStream = System.err;
    private static final String BALLERINA_NAME_EXT = "x-ballerina-name";
    public static final String ENDS_WITH_FULLSTOP = "\\.$";
    public static final String EMPTY = "";
    public static final String LINE_BREAK = "\n";
    public static final String SLASH = "/";
    public static final String OPEN_BRACE = "{";
    public static final String CLOSED_BRACE = "}";
    public static final String NAME = "name";
    public static final String DOC = "doc";
    public static final String BASEPATH = "basepath";
    public static final List<String> DEFAULT_ALIGNMENT_TYPES = List.of("name", "doc", "basepath");
    List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    public OpenAPI modify(OpenAPI openAPI) throws BallerinaOpenApiException {
        return this.modify(openAPI, DEFAULT_ALIGNMENT_TYPES);
    }

    public OpenAPI modify(OpenAPI openAPI, List<String> alignmentTypes) throws BallerinaOpenApiException {
        if (alignmentTypes.contains(NAME)) {
            openAPI = this.modifyWithBallerinaNamingConventions(openAPI);
        }
        if (alignmentTypes.contains(DOC)) {
            openAPI = this.modifyDescriptions(openAPI);
        }
        if (alignmentTypes.contains(BASEPATH)) {
            openAPI = this.modifyWithCommonBasePath(openAPI);
        }
        return openAPI;
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public Map<String, String> getProposedNameMapping(OpenAPI openapi) {
        HashMap<String, String> nameMap = new HashMap<String, String>();
        if (Objects.isNull(openapi.getComponents())) {
            return Collections.emptyMap();
        }
        Components components = openapi.getComponents();
        Map schemas = components.getSchemas();
        if (Objects.isNull(schemas)) {
            return Collections.emptyMap();
        }
        for (Map.Entry schemaEntry : schemas.entrySet()) {
            String modifiedName = OASModifier.getValidNameForType((String)schemaEntry.getKey());
            nameMap.put((String)schemaEntry.getKey(), modifiedName);
        }
        return OASModifier.getResolvedNameMapping(nameMap);
    }

    public static Map<String, String> getResolvedNameMapping(Map<String, String> nameMap) {
        HashMap<String, String> resolvedNames = new HashMap<String, String>();
        HashMap<String, Integer> nameCount = new HashMap<String, Integer>();
        for (Map.Entry<String, String> entry : nameMap.entrySet()) {
            String currentName = entry.getKey();
            String newName = entry.getValue();
            Object resolvedName = newName;
            while (resolvedNames.containsValue(resolvedName)) {
                int count = nameCount.getOrDefault(newName, 1);
                resolvedName = newName + count;
                nameCount.put(newName, count + 1);
            }
            resolvedNames.put(currentName, (String)resolvedName);
        }
        return resolvedNames;
    }

    public OpenAPI modifyWithBallerinaNamingConventions(OpenAPI openapi, Map<String, String> nameMap) throws BallerinaOpenApiException {
        openapi = OASModifier.modifyOASWithSchemaName(openapi, nameMap);
        OASModifier.modifyOASWithParameterName(openapi);
        OASModifier.modifyOASWithObjectPropertyName(openapi);
        this.modifyOASWithInlineObjectPropertyName(openapi);
        return openapi;
    }

    private void modifyOASWithInlineObjectPropertyName(OpenAPI openAPI) {
        openAPI.getPaths().forEach((path, pathItem) -> this.modifyNameInPathItem((PathItem)pathItem));
    }

    private void modifyNameInPathItem(PathItem pathItem) {
        pathItem.readOperationsMap().forEach((method, operation) -> this.modifyNameInOperationWithInlineObjectSchema((Operation)operation));
    }

    private void modifyNameInOperationWithInlineObjectSchema(Operation operation) {
        if (Objects.nonNull(operation.getRequestBody()) && Objects.nonNull(operation.getRequestBody().getContent())) {
            OASModifier.modifyNameInInlineObjectContent((Map<String, MediaType>)operation.getRequestBody().getContent());
        }
        this.modifyNameInParametersWithInlineObjectSchema(operation.getParameters());
        this.modifyNameInResponsesWithInlineObjectSchema((Map<String, ApiResponse>)operation.getResponses());
    }

    private void modifyNameInParametersWithInlineObjectSchema(List<Parameter> parameters) {
        if (Objects.isNull(parameters)) {
            return;
        }
        for (Parameter parameter : parameters) {
            if (!Objects.nonNull(parameter.getSchema())) continue;
            OASModifier.modifyNameInInlineObjectSchema(parameter.getSchema());
        }
    }

    private void modifyNameInResponsesWithInlineObjectSchema(Map<String, ApiResponse> responses) {
        responses.forEach((status, response) -> {
            if (Objects.nonNull(response.getContent())) {
                OASModifier.modifyNameInInlineObjectContent((Map<String, MediaType>)response.getContent());
            }
        });
    }

    private static void modifyNameInInlineObjectSchema(Schema<?> schema) {
        if (Objects.isNull(schema)) {
            return;
        }
        OASModifier.modifyNameInInlineComposedSchema(schema);
        OASModifier.modifyNameInInlineObjectSchemaInternal(schema);
        OASModifier.modifyNameInInlineObjectSchemaItems(schema);
        OASModifier.modifyNameInInlineObjectSchemaWithAdditionalProperties(schema);
        OASModifier.modifyNameInInlineObjectSchemaProperties(schema);
    }

    private static void modifyNameInInlineComposedSchema(Schema<?> schema) {
        if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            OASModifier.modifyNameInSubSchemas(composedSchema.getAllOf());
            OASModifier.modifyNameInSubSchemas(composedSchema.getAnyOf());
            OASModifier.modifyNameInSubSchemas(composedSchema.getOneOf());
        }
    }

    private static void modifyNameInSubSchemas(List<Schema> subSchemas) {
        if (Objects.nonNull(subSchemas)) {
            subSchemas.forEach(OASModifier::modifyNameInInlineObjectSchema);
        }
    }

    private static void modifyNameInInlineObjectSchemaInternal(Schema<?> schema) {
        Map properties;
        if (OASModifier.isInlineObjectSchema(schema) && Objects.nonNull(properties = schema.getProperties()) && !properties.isEmpty()) {
            schema.setProperties(OASModifier.getPropertiesWithBallerinaNameExtension(properties));
        }
    }

    private static boolean isInlineObjectSchema(Schema<?> schema) {
        return schema instanceof ObjectSchema || Objects.isNull(schema.getType()) && Objects.isNull(schema.get$ref()) && Objects.nonNull(schema.getProperties());
    }

    private static void modifyNameInInlineObjectSchemaItems(Schema<?> schema) {
        if (Objects.nonNull(schema.getItems())) {
            OASModifier.modifyNameInInlineObjectSchema(schema.getItems());
        }
    }

    private static void modifyNameInInlineObjectSchemaWithAdditionalProperties(Schema<?> schema) {
        if (schema.getAdditionalProperties() instanceof Schema) {
            OASModifier.modifyNameInInlineObjectSchema((Schema)schema.getAdditionalProperties());
        }
    }

    private static void modifyNameInInlineObjectSchemaProperties(Schema<?> schema) {
        if (Objects.nonNull(schema.getProperties())) {
            schema.getProperties().values().forEach(OASModifier::modifyNameInInlineObjectSchema);
        }
    }

    private static void modifyNameInInlineObjectContent(Map<String, MediaType> content) {
        for (Map.Entry<String, MediaType> entry : content.entrySet()) {
            Schema schema = entry.getValue().getSchema();
            OASModifier.modifyNameInInlineObjectSchema(schema);
        }
    }

    private static void modifyOASWithObjectPropertyName(OpenAPI openapi) {
        Components components = openapi.getComponents();
        if (Objects.isNull(components) || Objects.isNull(components.getSchemas())) {
            return;
        }
        Map schemas = components.getSchemas();
        for (Map.Entry schema : schemas.entrySet()) {
            ObjectSchema objectSchema;
            Map properties;
            Schema schemaValue = (Schema)schema.getValue();
            if (schemaValue instanceof ObjectSchema && Objects.nonNull(properties = (objectSchema = (ObjectSchema)schemaValue).getProperties()) && !properties.isEmpty()) {
                objectSchema.setProperties(OASModifier.getPropertiesWithBallerinaNameExtension(properties));
            }
            OASModifier.modifyNameInInlineComposedSchema(schemaValue);
        }
    }

    private static void modifyOASWithParameterName(OpenAPI openapi) {
        Paths paths = openapi.getPaths();
        if (Objects.isNull(paths) || paths.isEmpty()) {
            return;
        }
        Paths modifiedPaths = new Paths();
        for (Map.Entry path : paths.entrySet()) {
            PathDetails result = OASModifier.updateParameterNameDetails(openapi, path);
            modifiedPaths.put((Object)result.pathValue(), (Object)result.pathItem());
        }
        openapi.setPaths(modifiedPaths);
    }

    public OpenAPI modifyWithBallerinaNamingConventions(OpenAPI openapi) throws BallerinaOpenApiException {
        Map<String, String> proposedNameMapping = this.getProposedNameMapping(openapi);
        if (proposedNameMapping.isEmpty()) {
            return openapi;
        }
        return this.modifyWithBallerinaNamingConventions(openapi, proposedNameMapping);
    }

    private static OpenAPI modifyOASWithSchemaName(OpenAPI openapi, Map<String, String> nameMap) throws BallerinaOpenApiException {
        SwaggerParseResult parseResult = OASModifier.getOASWithSchemaNameModification(openapi, nameMap);
        OpenAPI openAPI = parseResult.getOpenAPI();
        if (Objects.isNull(openAPI)) {
            List messages = parseResult.getMessages();
            if (Objects.nonNull(messages) && !messages.isEmpty()) {
                outErrorStream.println("Aligning schema name for Ballerina contains errors: ");
                messages.forEach(outErrorStream::println);
            }
            throw new BallerinaOpenApiException("Failed to align the OpenAPI specification for Ballerina. Please consider generating the client/service without the sanitization option.");
        }
        OASModifier.removeDefaultServers(openAPI);
        return openAPI;
    }

    public static SwaggerParseResult getOASWithSchemaNameModification(OpenAPI openapi, Map<String, String> nameMap) {
        Components components = openapi.getComponents();
        if (Objects.isNull(components) || nameMap.isEmpty() || Objects.isNull(components.getSchemas())) {
            SwaggerParseResult result = new SwaggerParseResult();
            result.setOpenAPI(openapi);
            return result;
        }
        Map schemas = components.getSchemas();
        HashMap<String, Schema> modifiedSchemas = new HashMap<String, Schema>();
        Map securitySchemes = components.getSecuritySchemes();
        if (Objects.nonNull(securitySchemes) && !securitySchemes.isEmpty()) {
            securitySchemes.forEach((s, securityScheme) -> OASModifier.addBallerinaNameExtension(securityScheme));
        }
        for (Map.Entry schema : schemas.entrySet()) {
            String string = (String)schema.getKey();
            String modifiedName = nameMap.get(string);
            if (Objects.nonNull(modifiedName) && !modifiedName.equals(string)) {
                modifiedSchemas.put(modifiedName, (Schema)schema.getValue());
                continue;
            }
            modifiedSchemas.put(string, (Schema)schema.getValue());
        }
        components.setSchemas(modifiedSchemas);
        openapi.setComponents(components);
        String openApiJson = Json.pretty((Object)openapi);
        for (Map.Entry entry : nameMap.entrySet()) {
            String modifiedName;
            String schemaName = (String)entry.getKey();
            if (schemaName.equals(modifiedName = (String)entry.getValue())) continue;
            String patternString = COMPONENT_REF_REGEX_PATTERN.formatted(schemaName, schemaName);
            Pattern pattern = Pattern.compile(patternString);
            Matcher matcher = pattern.matcher(openApiJson);
            String replacement = COMPONENT_REF_WITH_NAME_PATTERN.formatted(modifiedName).replace("$", "\\$");
            openApiJson = matcher.replaceAll(replacement);
        }
        ParseOptions parseOptions = new ParseOptions();
        return new OpenAPIParser().readContents(openApiJson, null, parseOptions);
    }

    private static PathDetails updateParameterNameDetails(OpenAPI openAPI, Map.Entry<String, PathItem> path) {
        Operation operation;
        PathItem pathItem = path.getValue();
        String pathValue = path.getKey();
        pathValue = OASModifier.updateParameterNames(openAPI, pathValue, pathItem);
        if (Objects.nonNull(pathItem.getGet())) {
            operation = pathItem.getGet();
            if (Objects.isNull(operation.getParameters())) {
                return new PathDetails(pathItem, pathValue);
            }
            pathValue = OASModifier.updateParameterNames(openAPI, pathValue, operation);
            pathItem.setGet(operation);
        }
        if (Objects.nonNull(pathItem.getPost())) {
            operation = pathItem.getPost();
            if (Objects.isNull(operation.getParameters())) {
                return new PathDetails(pathItem, pathValue);
            }
            pathValue = OASModifier.updateParameterNames(openAPI, pathValue, operation);
            pathItem.setPost(operation);
        }
        if (Objects.nonNull(pathItem.getPut())) {
            operation = pathItem.getPut();
            if (Objects.isNull(operation.getParameters())) {
                return new PathDetails(pathItem, pathValue);
            }
            pathValue = OASModifier.updateParameterNames(openAPI, pathValue, operation);
            pathItem.setPut(operation);
        }
        if (Objects.nonNull(pathItem.getDelete())) {
            operation = pathItem.getDelete();
            if (Objects.isNull(operation.getParameters())) {
                return new PathDetails(pathItem, pathValue);
            }
            pathValue = OASModifier.updateParameterNames(openAPI, pathValue, operation);
            pathItem.setDelete(operation);
        }
        if (Objects.nonNull(pathItem.getPatch())) {
            operation = pathItem.getPatch();
            if (Objects.isNull(operation.getParameters())) {
                return new PathDetails(pathItem, pathValue);
            }
            pathValue = OASModifier.updateParameterNames(openAPI, pathValue, operation);
            pathItem.setPatch(operation);
        }
        if (Objects.nonNull(pathItem.getHead())) {
            operation = pathItem.getHead();
            if (Objects.isNull(operation.getParameters())) {
                return new PathDetails(pathItem, pathValue);
            }
            pathValue = OASModifier.updateParameterNames(openAPI, pathValue, operation);
            pathItem.setHead(operation);
        }
        if (Objects.nonNull(pathItem.getOptions())) {
            operation = pathItem.getOptions();
            if (Objects.isNull(operation.getParameters())) {
                return new PathDetails(pathItem, pathValue);
            }
            pathValue = OASModifier.updateParameterNames(openAPI, pathValue, operation);
            pathItem.setOptions(operation);
        }
        if (Objects.nonNull(pathItem.getTrace())) {
            operation = pathItem.getTrace();
            if (Objects.isNull(operation.getParameters())) {
                return new PathDetails(pathItem, pathValue);
            }
            pathValue = OASModifier.updateParameterNames(openAPI, pathValue, operation);
            pathItem.setTrace(operation);
        }
        return new PathDetails(pathItem, pathValue);
    }

    private static String updateParameterNames(OpenAPI openAPI, String pathValue, PathItem pathItem) {
        List parameters = pathItem.getParameters();
        if (Objects.nonNull(parameters)) {
            Map<String, String> parameterNames = OASModifier.collectParameterNames(openAPI, pathItem.getParameters());
            ArrayList<Parameter> modifiedParameters = new ArrayList<Parameter>();
            pathValue = OASModifier.updateParameters(openAPI, pathValue, parameterNames, parameters, modifiedParameters);
            pathItem.setParameters(modifiedParameters);
        }
        return pathValue;
    }

    private static String updateParameterNames(OpenAPI openAPI, String pathValue, Operation operation) {
        Map<String, String> parameterNames = OASModifier.collectParameterNames(openAPI, operation.getParameters());
        List parameters = operation.getParameters();
        if (Objects.nonNull(parameters)) {
            ArrayList<Parameter> modifiedParameters = new ArrayList<Parameter>();
            pathValue = OASModifier.updateParameters(openAPI, pathValue, parameterNames, parameters, modifiedParameters);
            operation.setParameters(modifiedParameters);
        }
        return pathValue;
    }

    private static String updateParameters(OpenAPI openAPI, String pathValue, Map<String, String> parameterNames, List<Parameter> parameters, List<Parameter> modifiedParameters) {
        Iterator<Parameter> iterator = parameters.iterator();
        while (iterator.hasNext()) {
            String location;
            Parameter parameter;
            Parameter refParameter = parameter = iterator.next();
            if (Objects.nonNull(parameter.get$ref())) {
                try {
                    refParameter = (Parameter)openAPI.getComponents().getParameters().get(GeneratorUtils.extractReferenceType(parameter.get$ref()));
                }
                catch (InvalidReferenceException e) {
                    modifiedParameters.add(parameter);
                    continue;
                }
            }
            if (Objects.isNull(location = refParameter.getIn())) {
                modifiedParameters.add(parameter);
                continue;
            }
            if (location.equals("path")) {
                String modifiedPathParam = parameterNames.get(refParameter.getName());
                refParameter.setName(modifiedPathParam);
                pathValue = OASModifier.replaceContentInBraces(pathValue, modifiedPathParam);
            } else if (location.equals("query") || location.equals("header")) {
                OASModifier.addBallerinaNameExtension(refParameter);
            }
            modifiedParameters.add(parameter);
        }
        return pathValue;
    }

    private static void addBallerinaNameExtension(Parameter parameter) {
        String parameterName = parameter.getName();
        if (Objects.isNull(parameterName)) {
            return;
        }
        String alignedName = OASModifier.getValidNameForParameter(parameterName);
        if (parameterName.equals(alignedName)) {
            return;
        }
        if (Objects.isNull(parameter.getExtensions())) {
            parameter.setExtensions(new HashMap());
        }
        parameter.getExtensions().put(BALLERINA_NAME_EXT, alignedName);
    }

    private static void addBallerinaNameExtension(SecurityScheme securityScheme) {
        String securitySchemeName = securityScheme.getName();
        if (Objects.isNull(securitySchemeName)) {
            return;
        }
        String alignedName = OASModifier.getValidNameForParameter(securitySchemeName);
        if (securitySchemeName.equals(alignedName)) {
            return;
        }
        if (Objects.isNull(securityScheme.getExtensions())) {
            securityScheme.setExtensions(new HashMap());
        }
        securityScheme.getExtensions().put(BALLERINA_NAME_EXT, alignedName);
    }

    private static Schema getSchemaWithBallerinaNameExtension(String propertyName, Schema<?> propertySchema) {
        String alignedPropertyName = OASModifier.getValidNameForParameter(propertyName);
        if (propertyName.equals(alignedPropertyName)) {
            return propertySchema;
        }
        if (Objects.nonNull(propertySchema.get$ref())) {
            Schema refSchema = new Schema();
            refSchema.set$ref(propertySchema.get$ref());
            propertySchema.set$ref(null);
            propertySchema.addAllOfItem(refSchema);
            propertySchema.setType(null);
        }
        if (Objects.isNull(propertySchema.getExtensions())) {
            propertySchema.setExtensions(new HashMap());
        }
        propertySchema.getExtensions().put(BALLERINA_NAME_EXT, alignedPropertyName);
        return propertySchema;
    }

    private static Map<String, Schema> getPropertiesWithBallerinaNameExtension(Map<String, Schema> properties) {
        HashMap<String, Schema> modifiedProperties = new HashMap<String, Schema>();
        for (Map.Entry<String, Schema> property : properties.entrySet()) {
            Schema propertySchema = property.getValue();
            String propertyName = property.getKey();
            modifiedProperties.put(propertyName, OASModifier.getSchemaWithBallerinaNameExtension(propertyName, propertySchema));
        }
        return modifiedProperties;
    }

    private static void updateObjectPropertyRef(Map<String, Schema> properties, String schemaName, String modifiedName) {
        if (Objects.nonNull(properties)) {
            for (Map.Entry<String, Schema> property : properties.entrySet()) {
                Schema fieldValue = property.getValue();
                OASModifier.updateSchemaWithReference(schemaName, modifiedName, fieldValue);
                properties.put(property.getKey(), fieldValue);
            }
        }
    }

    private static void updateSchemaWithReference(String schemaName, String modifiedName, Schema typeSchema) {
        Object object;
        String ref = typeSchema.get$ref();
        if (Objects.nonNull(ref)) {
            OASModifier.updateRef(schemaName, modifiedName, typeSchema);
        } else if (typeSchema instanceof ObjectSchema) {
            ObjectSchema objectSchema = (ObjectSchema)typeSchema;
            Map objectSchemaProperties = objectSchema.getProperties();
            OASModifier.updateObjectPropertyRef(objectSchemaProperties, schemaName, modifiedName);
        } else if (typeSchema instanceof ArraySchema) {
            ArraySchema arraySchema = (ArraySchema)typeSchema;
            Schema items = arraySchema.getItems();
            OASModifier.updateSchemaWithReference(schemaName, modifiedName, items);
        } else if (typeSchema instanceof MapSchema) {
            MapSchema mapSchema = (MapSchema)typeSchema;
            OASModifier.updateObjectPropertyRef(mapSchema.getProperties(), schemaName, modifiedName);
        } else if (Objects.nonNull(typeSchema.getProperties())) {
            OASModifier.updateObjectPropertyRef(typeSchema.getProperties(), schemaName, modifiedName);
        } else if (typeSchema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)typeSchema;
            if (Objects.nonNull(composedSchema.getAllOf())) {
                List allOf = composedSchema.getAllOf();
                ArrayList<Schema> modifiedAllOf = new ArrayList<Schema>();
                for (Schema schema : allOf) {
                    OASModifier.updateSchemaWithReference(schemaName, modifiedName, schema);
                    modifiedAllOf.add(schema);
                }
                composedSchema.setAllOf(modifiedAllOf);
            }
            if (Objects.nonNull(composedSchema.getOneOf())) {
                List oneOf = composedSchema.getOneOf();
                ArrayList<Schema> modifiedOneOf = new ArrayList<Schema>();
                for (Schema schema : oneOf) {
                    OASModifier.updateSchemaWithReference(schemaName, modifiedName, schema);
                    modifiedOneOf.add(schema);
                }
                composedSchema.setOneOf(modifiedOneOf);
            }
            if (Objects.nonNull(composedSchema.getAnyOf())) {
                List anyOf = composedSchema.getAnyOf();
                ArrayList<Schema> modifiedAnyOf = new ArrayList<Schema>();
                for (Schema schema : anyOf) {
                    OASModifier.updateSchemaWithReference(schemaName, modifiedName, schema);
                    modifiedAnyOf.add(schema);
                }
                composedSchema.setAnyOf(modifiedAnyOf);
            }
        }
        if (Objects.nonNull(typeSchema.getAdditionalProperties()) && (object = typeSchema.getAdditionalProperties()) instanceof Schema) {
            Schema addtionalSchema = (Schema)object;
            OASModifier.updateSchemaWithReference(schemaName, modifiedName, addtionalSchema);
        }
    }

    private static void updateRef(String schemaName, String modifiedName, Schema value) {
        String ref = value.get$ref().replaceAll("\\s+", EMPTY);
        String patternString = SLASH + schemaName.replaceAll("\\s+", EMPTY) + "(?!\\S)";
        Pattern pattern = Pattern.compile(patternString);
        Matcher matcher = pattern.matcher(ref);
        ref = matcher.replaceAll(SLASH + modifiedName);
        value.set$ref(ref);
    }

    public static String getValidNameForType(String identifier) {
        if (identifier.isBlank()) {
            return "\\" + identifier;
        }
        identifier = OASModifier.getValidStringFromIdentifier(identifier, "Schema");
        return (identifier.substring(0, 1).toUpperCase(Locale.ENGLISH) + identifier.substring(1)).trim();
    }

    public static String getValidNameForParameter(String identifier) {
        if (identifier.isBlank()) {
            return "param";
        }
        identifier = OASModifier.getValidStringFromIdentifier(identifier, "param");
        return (identifier.substring(0, 1).toLowerCase(Locale.ENGLISH) + identifier.substring(1)).trim();
    }

    /*
     * WARNING - void declaration
     */
    private static String getValidStringFromIdentifier(String identifier, String prefix) {
        if (!((String)identifier).matches("\\b[0-9]*\\b") && ((String)identifier).matches(".*[a-zA-Z].*")) {
            String[] split = ((String)identifier).split("([\\[\\]\\\\?!<>@#&~'`*\\_\\-=^+();:\\/{}\\s|.$])");
            StringBuilder validName = new StringBuilder();
            for (String string : split) {
                void var7_7;
                if (string.isBlank()) continue;
                if (split.length > 1) {
                    String string2 = string.substring(0, 1).toUpperCase(Locale.ENGLISH) + string.substring(1);
                }
                validName.append((String)var7_7);
            }
            identifier = validName.toString();
        } else {
            identifier = prefix + GeneratorUtils.escapeIdentifier((String)identifier);
        }
        return identifier;
    }

    public static Map<String, String> collectParameterNames(OpenAPI openAPI, List<Parameter> parameters) {
        HashMap<String, String> parameterNames = new HashMap<String, String>();
        for (Parameter parameter : parameters) {
            String parameterName;
            if (Objects.nonNull(parameter.get$ref())) {
                try {
                    parameter = (Parameter)openAPI.getComponents().getParameters().get(GeneratorUtils.extractReferenceType(parameter.get$ref()));
                }
                catch (InvalidReferenceException invalidReferenceException) {
                    // empty catch block
                }
            }
            if (Objects.isNull(parameterName = parameter.getName())) continue;
            parameterNames.put(parameter.getName(), OASModifier.getValidNameForParameter(parameterName));
        }
        return OASModifier.getResolvedNameMapping(parameterNames);
    }

    public static String replaceContentInBraces(String input, String expectedValue) {
        Pattern pattern = Pattern.compile(REGEX_FOR_CURLY_BRACED_CONTENT);
        Matcher matcher = pattern.matcher(input);
        StringBuilder result = new StringBuilder();
        int lastEnd = 0;
        while (matcher.find()) {
            result.append(input, lastEnd, matcher.start());
            String content = OASModifier.getValidNameForParameter(matcher.group(1));
            if (content.equals(expectedValue)) {
                result.append(OPEN_BRACE).append(expectedValue).append(CLOSED_BRACE);
            } else {
                result.append(matcher.group());
            }
            lastEnd = matcher.end();
        }
        result.append(input.substring(lastEnd));
        return result.toString();
    }

    public OpenAPI modifyDescriptions(OpenAPI openapi) {
        Paths paths = openapi.getPaths();
        if (Objects.isNull(paths) || paths.isEmpty()) {
            return openapi;
        }
        paths.forEach((path, pathItem) -> OASModifier.modifyDescriptionInPath(openapi, pathItem));
        Components components = openapi.getComponents();
        if (Objects.isNull(components) || Objects.isNull(components.getSchemas())) {
            return openapi;
        }
        components.getSchemas().forEach((schemaName, schema) -> OASModifier.modifyObjectPropertyDescriptions(schema));
        return openapi;
    }

    private static void modifyDescriptionInPath(OpenAPI openapi, PathItem pathItem) {
        List parametersForPath = pathItem.getParameters();
        if (Objects.nonNull(parametersForPath) && !parametersForPath.isEmpty()) {
            parametersForPath.forEach(parameter -> OASModifier.modifyParameterDescription(openapi, parameter));
        }
        pathItem.readOperationsMap().forEach((method, operation) -> OASModifier.modifyDescriptionInOperation(openapi, operation));
    }

    private static void modifyDescriptionInOperation(OpenAPI openapi, Operation operation) {
        OASModifier.modifyParameterDescriptions(openapi, operation);
        OASModifier.modifyRequestBodyDescription(openapi, operation);
        OASModifier.modifyApiResponseDescriptions(openapi, operation);
    }

    private static void modifyObjectPropertyDescriptions(Schema schema) {
        if (Objects.isNull(schema)) {
            return;
        }
        String description = schema.getDescription();
        if (Objects.nonNull(description)) {
            String modifiedDescription = description.replaceAll(ENDS_WITH_FULLSTOP, EMPTY);
            schema.setDescription(modifiedDescription);
        }
        if (schema instanceof ObjectSchema) {
            ObjectSchema objectSchema = (ObjectSchema)schema;
            if (Objects.isNull(objectSchema.getProperties()) || objectSchema.getProperties().isEmpty()) {
                return;
            }
            objectSchema.getProperties().forEach((propertyName, property) -> OASModifier.modifyPropertyDescription(property));
        } else if (schema instanceof ComposedSchema) {
            ComposedSchema composedSchema = (ComposedSchema)schema;
            OASModifier.modifyDescriptionInInlineComposedSchema(composedSchema);
        } else if (schema instanceof ArraySchema) {
            if (Objects.isNull(schema.getItems())) {
                return;
            }
            OASModifier.modifyPropertyDescription(schema.getItems());
        }
    }

    private static void modifyPropertyDescription(Schema schema) {
        String description = schema.getDescription();
        if (Objects.isNull(description)) {
            return;
        }
        String modifiedDescription = description.replaceAll(ENDS_WITH_FULLSTOP, EMPTY);
        schema.setDescription(modifiedDescription);
    }

    private static void modifyApiResponseDescriptions(OpenAPI openapi, Operation operation) {
        ApiResponses responses = operation.getResponses();
        if (Objects.isNull(responses)) {
            return;
        }
        Collection values = responses.values();
        Iterator iteratorRes = values.iterator();
        if (iteratorRes.hasNext()) {
            ApiResponse response = (ApiResponse)iteratorRes.next();
            String description = response.getDescription();
            if (Objects.nonNull(description)) {
                String modifiedDescription = description.replaceAll(ENDS_WITH_FULLSTOP, EMPTY);
                response.setDescription(modifiedDescription);
            } else if (Objects.nonNull(response.get$ref())) {
                try {
                    if (Objects.isNull(openapi.getComponents()) || Objects.isNull(openapi.getComponents().getResponses())) {
                        return;
                    }
                    ApiResponse apiResponseRef = (ApiResponse)openapi.getComponents().getResponses().get(GeneratorUtils.extractReferenceType(response.get$ref()));
                    description = apiResponseRef.getDescription();
                    if (Objects.isNull(description)) {
                        return;
                    }
                    String modifiedDescription = description.replaceAll(ENDS_WITH_FULLSTOP, EMPTY);
                    apiResponseRef.setDescription(modifiedDescription);
                }
                catch (InvalidReferenceException invalidReferenceException) {
                    // empty catch block
                }
            }
        }
    }

    private static void modifyRequestBodyDescription(OpenAPI openapi, Operation operation) {
        RequestBody requestBody = operation.getRequestBody();
        if (Objects.isNull(requestBody)) {
            return;
        }
        String description = requestBody.getDescription();
        if (Objects.nonNull(description)) {
            String modifiedDescription = OASModifier.getModifiedReqBodyDescription(description, requestBody);
            requestBody.setDescription(modifiedDescription);
        } else if (Objects.nonNull(requestBody.get$ref())) {
            try {
                if (Objects.isNull(openapi.getComponents()) || Objects.isNull(openapi.getComponents().getRequestBodies())) {
                    return;
                }
                RequestBody requestBodyRef = (RequestBody)openapi.getComponents().getRequestBodies().get(GeneratorUtils.extractReferenceType(requestBody.get$ref()));
                description = requestBodyRef.getDescription();
                if (Objects.isNull(description)) {
                    return;
                }
                String modifiedDescription = description.replaceAll(ENDS_WITH_FULLSTOP, EMPTY);
                requestBodyRef.setDescription(modifiedDescription);
            }
            catch (InvalidReferenceException invalidReferenceException) {
                // empty catch block
            }
        }
    }

    private static String getModifiedReqBodyDescription(String description, RequestBody requestBody) {
        String modifiedDescription;
        if (description.contains(LINE_BREAK)) {
            ArrayList<String> descriptionLines = new ArrayList<String>(Arrays.asList(requestBody.getDescription().split(LINE_BREAK)));
            String firstLine = (String)descriptionLines.removeFirst();
            descriptionLines.addFirst(firstLine.replaceAll(ENDS_WITH_FULLSTOP, EMPTY));
            modifiedDescription = String.join((CharSequence)LINE_BREAK, descriptionLines);
        } else {
            modifiedDescription = description.replaceAll(ENDS_WITH_FULLSTOP, EMPTY);
        }
        return modifiedDescription;
    }

    private static void modifyParameterDescriptions(OpenAPI openapi, Operation operation) {
        if (Objects.isNull(operation.getParameters())) {
            return;
        }
        operation.getParameters().forEach(parameter -> OASModifier.modifyParameterDescription(openapi, parameter));
    }

    private static void modifyParameterDescription(OpenAPI openapi, Parameter parameter) {
        String description = parameter.getDescription();
        if (Objects.nonNull(description)) {
            String modifiedDescription = description.replaceAll(ENDS_WITH_FULLSTOP, EMPTY);
            parameter.setDescription(modifiedDescription);
        } else if (Objects.nonNull(parameter.get$ref())) {
            try {
                if (Objects.isNull(openapi.getComponents()) || Objects.isNull(openapi.getComponents().getParameters())) {
                    return;
                }
                Parameter parameterRef = (Parameter)openapi.getComponents().getParameters().get(GeneratorUtils.extractReferenceType(parameter.get$ref()));
                description = parameterRef.getDescription();
                if (Objects.isNull(description)) {
                    return;
                }
                String modifiedDescription = description.replaceAll(ENDS_WITH_FULLSTOP, EMPTY);
                parameterRef.setDescription(modifiedDescription);
            }
            catch (InvalidReferenceException invalidReferenceException) {
                // empty catch block
            }
        }
    }

    private static void modifyDescriptionInSubSchemas(List<Schema> subSchemas) {
        if (Objects.nonNull(subSchemas)) {
            subSchemas.forEach(OASModifier::modifyObjectPropertyDescriptions);
        }
    }

    private static void modifyDescriptionInInlineComposedSchema(ComposedSchema composedSchema) {
        OASModifier.modifyDescriptionInSubSchemas(composedSchema.getAllOf());
        OASModifier.modifyDescriptionInSubSchemas(composedSchema.getAnyOf());
        OASModifier.modifyDescriptionInSubSchemas(composedSchema.getOneOf());
    }

    public OpenAPI modifyWithCommonBasePath(OpenAPI openapi) {
        Paths paths = openapi.getPaths();
        List servers = openapi.getServers();
        if (Objects.isNull(paths) || paths.isEmpty() || Objects.isNull(servers) || servers.isEmpty()) {
            return openapi;
        }
        ArrayList<String> pathValues = new ArrayList<String>(paths.keySet());
        CommonPathResult commonPathResult = OASModifier.getCommonPathResult(pathValues);
        commonPathResult.commonPath().ifPresent(commonPath -> {
            OASModifier.modifyPathNames(openapi, paths, commonPathResult.pathMap());
            OASModifier.modifyServersUrl(servers, commonPath);
        });
        return openapi;
    }

    private static void modifyServersUrl(List<Server> servers, String commonPath) {
        servers.stream().filter(server -> Objects.nonNull(server.getUrl())).forEach(server -> server.setUrl(server.getUrl().concat(commonPath)));
    }

    private static void modifyPathNames(OpenAPI openapi, Paths paths, Map<String, String> pathMap) {
        Paths modifiedPaths = new Paths();
        paths.forEach((pathValue, pathItem) -> modifiedPaths.put((Object)((String)pathMap.get(pathValue)), pathItem));
        openapi.setPaths(modifiedPaths);
    }

    private static CommonPathResult getCommonPathResult(List<String> pathValues) {
        if (pathValues == null || pathValues.isEmpty()) {
            return new CommonPathResult(Optional.empty(), Map.of());
        }
        Optional<String> commonPath = OASModifier.getCommonPath(pathValues);
        if (commonPath.isEmpty()) {
            return new CommonPathResult(Optional.empty(), Map.of());
        }
        HashMap<String, String> pathMap = new HashMap<String, String>();
        for (String path : pathValues) {
            pathMap.put(path, OASModifier.removeCommonPath(path, commonPath.get()));
        }
        return new CommonPathResult(commonPath, pathMap);
    }

    private static Optional<String> getCommonPath(List<String> pathValues) {
        String path;
        String nonParameterizedPath;
        String commonPath = OASModifier.getPathWithoutLastSegment(pathValues.getFirst());
        for (int i = 1; i < pathValues.size() && ((nonParameterizedPath = OASModifier.getNonParameterizedPath(path = pathValues.get(i))).startsWith(commonPath) || !(commonPath = OASModifier.calculateCommonPath(OASModifier.getPathWithoutLastSegment(nonParameterizedPath), commonPath)).isEmpty()); ++i) {
        }
        return commonPath.isEmpty() || commonPath.equals(SLASH) ? Optional.empty() : Optional.of(commonPath);
    }

    private static String calculateCommonPath(String path, String commonPath) {
        String[] pathSegments = path.split(SLASH);
        String[] commonPathSegments = commonPath.split(SLASH);
        StringJoiner commonPathBuilder = new StringJoiner(SLASH);
        for (int i = 0; i < Math.min(pathSegments.length, commonPathSegments.length) && pathSegments[i].equals(commonPathSegments[i]); ++i) {
            commonPathBuilder.add(pathSegments[i]);
        }
        return commonPathBuilder.toString();
    }

    private static String getPathWithoutLastSegment(String path) {
        if (path.endsWith(SLASH)) {
            return path;
        }
        String[] pathSegments = path.split(SLASH);
        return Arrays.stream(pathSegments, 0, pathSegments.length - 1).collect(Collectors.joining(SLASH));
    }

    private static String removeCommonPath(String path, String commonPath) {
        return path.replace(commonPath, EMPTY);
    }

    private static String getNonParameterizedPath(String path) {
        String part;
        StringJoiner nonParameterizedPath = new StringJoiner(SLASH);
        String[] stringArray = path.split(SLASH);
        int n = stringArray.length;
        for (int i = 0; !(i >= n || (part = stringArray[i]).startsWith(OPEN_BRACE) && part.endsWith(CLOSED_BRACE)); ++i) {
            nonParameterizedPath.add(part);
        }
        return nonParameterizedPath.toString();
    }

    private static void removeDefaultServers(OpenAPI openAPI) {
        List servers = openAPI.getServers();
        if (Objects.nonNull(servers) && servers.size() == 1 && ((Server)servers.getFirst()).equals((Object)new Server().url(SLASH))) {
            openAPI.setServers(null);
        }
    }

    private record PathDetails(PathItem pathItem, String pathValue) {
    }

    private record CommonPathResult(Optional<String> commonPath, Map<String, String> pathMap) {
    }
}

