/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.constraint;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.RecordFieldNode;
import io.ballerina.compiler.syntax.tree.RecordFieldWithDefaultValueNode;
import io.ballerina.compiler.syntax.tree.RecordRestDescriptorNode;
import io.ballerina.compiler.syntax.tree.RecordTypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDefinitionNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.common.exception.BallerinaOpenApiException;
import io.ballerina.openapi.core.generators.constraint.ConstraintDiagnosticMessages;
import io.ballerina.openapi.core.generators.constraint.ConstraintGenerator;
import io.ballerina.openapi.core.generators.constraint.ConstraintGeneratorDiagnostic;
import io.ballerina.openapi.core.generators.constraint.ConstraintResult;
import io.ballerina.openapi.core.generators.type.model.GeneratorMetaData;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.internal.regexp.RegExpFactory;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class ConstraintGeneratorImp
implements ConstraintGenerator {
    OpenAPI openAPI;
    HashMap<String, TypeDefinitionNode> typeDefinitions;
    boolean isConstraint = false;
    List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    public ConstraintGeneratorImp(OpenAPI openAPI, HashMap<String, TypeDefinitionNode> typeDefinitions) {
        this.openAPI = openAPI;
        this.typeDefinitions = typeDefinitions;
    }

    boolean getIsConstraint() {
        return this.isConstraint;
    }

    @Override
    public ConstraintResult updateTypeDefinitionsWithConstraints() {
        if (this.openAPI.getComponents() == null) {
            return new ConstraintResult(this.typeDefinitions, this.isConstraint, this.diagnostics);
        }
        if (this.openAPI.getComponents().getSchemas() == null) {
            return new ConstraintResult(this.typeDefinitions, this.isConstraint, this.diagnostics);
        }
        this.openAPI.getComponents().getSchemas().forEach((key, value) -> {
            if (this.typeDefinitions.containsKey(key) && GeneratorUtils.hasConstraints(value) && this.typeDefinitions.containsKey(key = GeneratorUtils.escapeIdentifier(key))) {
                TypeDefinitionNode typeDefinitionNode = this.typeDefinitions.get(key);
                if (typeDefinitionNode.typeDescriptor().kind().equals((Object)SyntaxKind.RECORD_TYPE_DESC)) {
                    Map properties = value.getProperties();
                    RecordTypeDescriptorNode record = (RecordTypeDescriptorNode)typeDefinitionNode.typeDescriptor();
                    NodeList fields = record.fields();
                    ArrayList<RecordFieldNode> recordFields = new ArrayList<RecordFieldNode>();
                    for (Node field : fields) {
                        String fieldName;
                        RecordFieldNode node;
                        if (field instanceof RecordFieldNode) {
                            RecordFieldNode recordFieldNode;
                            node = recordFieldNode = (RecordFieldNode)field;
                            fieldName = recordFieldNode.fieldName().text();
                        } else if (field instanceof RecordFieldWithDefaultValueNode) {
                            RecordFieldWithDefaultValueNode recordFieldWithTypeNode = (RecordFieldWithDefaultValueNode)field;
                            node = recordFieldWithTypeNode;
                            fieldName = recordFieldWithTypeNode.fieldName().text();
                        } else {
                            return;
                        }
                        fieldName = fieldName.replaceAll("^'", "");
                        if (properties == null) {
                            return;
                        }
                        Schema fieldSchema = (Schema)properties.get(fieldName);
                        if (ConstraintGeneratorImp.hasConstraints(fieldSchema)) {
                            MetadataNode metadataNode;
                            AnnotationNode constraintNode = null;
                            try {
                                constraintNode = this.generateConstraintNode(fieldName, fieldSchema);
                            }
                            catch (BallerinaOpenApiException ballerinaOpenApiException) {
                                // empty catch block
                            }
                            boolean isConstraintSupport = constraintNode != null && fieldSchema.getNullable() != null && fieldSchema.getNullable() != false || fieldSchema.getOneOf() != null || fieldSchema.getAnyOf() != null;
                            boolean nullable = GeneratorMetaData.getInstance().isNullable();
                            if (nullable) {
                                constraintNode = null;
                            } else if (isConstraintSupport) {
                                ConstraintDiagnosticMessages diagnostic = ConstraintDiagnosticMessages.OAS_CONSTRAINT_101;
                                ConstraintGeneratorDiagnostic constraintDiagnostic = new ConstraintGeneratorDiagnostic(diagnostic, fieldName.trim());
                                this.diagnostics.add(constraintDiagnostic);
                                constraintNode = null;
                            }
                            if (constraintNode == null) {
                                metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
                            } else {
                                this.isConstraint = true;
                                metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{constraintNode}));
                            }
                            if (node instanceof RecordFieldNode) {
                                RecordFieldNode recordFieldNode = node;
                                node = recordFieldNode = recordFieldNode.modify(metadataNode, (Token)recordFieldNode.readonlyKeyword().orElse(null), recordFieldNode.typeName(), recordFieldNode.fieldName(), (Token)recordFieldNode.questionMarkToken().orElse(null), recordFieldNode.semicolonToken());
                            } else if (node instanceof RecordFieldWithDefaultValueNode) {
                                RecordFieldWithDefaultValueNode recordFieldWithTypeNode = (RecordFieldWithDefaultValueNode)node;
                                recordFieldWithTypeNode = recordFieldWithTypeNode.modify(metadataNode, (Token)recordFieldWithTypeNode.readonlyKeyword().orElse(null), recordFieldWithTypeNode.typeName(), recordFieldWithTypeNode.fieldName(), recordFieldWithTypeNode.equalsToken(), recordFieldWithTypeNode.expression(), recordFieldWithTypeNode.semicolonToken());
                                node = recordFieldWithTypeNode;
                            } else {
                                return;
                            }
                        }
                        recordFields.add(node);
                        if (!(fieldSchema instanceof ArraySchema)) continue;
                        ArraySchema arraySchema = (ArraySchema)fieldSchema;
                        this.updateConstraintWithArrayItems(StringUtils.capitalize((String)key), fieldName, arraySchema);
                    }
                    RecordTypeDescriptorNode updatedRecord = record.modify(record.recordKeyword(), record.bodyStartDelimiter(), AbstractNodeFactory.createNodeList(recordFields), (RecordRestDescriptorNode)record.recordRestDescriptor().orElse(null), record.bodyEndDelimiter());
                    typeDefinitionNode = typeDefinitionNode.modify((MetadataNode)typeDefinitionNode.metadata().orElse(null), (Token)typeDefinitionNode.visibilityQualifier().orElse(null), typeDefinitionNode.typeKeyword(), typeDefinitionNode.typeName(), (Node)updatedRecord, typeDefinitionNode.semicolonToken());
                } else if (ConstraintGeneratorImp.hasConstraints(value)) {
                    MetadataNode metadataNode;
                    AnnotationNode constraintNode = null;
                    try {
                        constraintNode = this.generateConstraintNode((String)key, (Schema<?>)value);
                    }
                    catch (BallerinaOpenApiException record) {
                        // empty catch block
                    }
                    boolean isConstraintSupport = constraintNode != null && value.getNullable() != null && value.getNullable() != false || value.getOneOf() != null || value.getAnyOf() != null;
                    boolean nullable = GeneratorMetaData.getInstance().isNullable();
                    if (nullable) {
                        constraintNode = null;
                    } else if (isConstraintSupport) {
                        ConstraintDiagnosticMessages diagnostic = ConstraintDiagnosticMessages.OAS_CONSTRAINT_101;
                        ConstraintGeneratorDiagnostic constraintDiagnostic = new ConstraintGeneratorDiagnostic(diagnostic, key.trim());
                        this.diagnostics.add(constraintDiagnostic);
                        constraintNode = null;
                    }
                    if (constraintNode == null) {
                        metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
                    } else {
                        this.isConstraint = true;
                        metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{constraintNode}));
                    }
                    typeDefinitionNode = typeDefinitionNode.modify(metadataNode, (Token)typeDefinitionNode.visibilityQualifier().orElse(null), typeDefinitionNode.typeKeyword(), typeDefinitionNode.typeName(), typeDefinitionNode.typeDescriptor(), typeDefinitionNode.semicolonToken());
                    if (value instanceof ArraySchema) {
                        ArraySchema arraySchema = (ArraySchema)value;
                        String normalizedTypeName = key.replaceAll("([\\[\\]\\\\?!<>@#&~`*\\-=^+'();:\\/\\_{}\\s|.$])", "").trim();
                        this.updateConstraintWithArrayItems("", normalizedTypeName, arraySchema);
                    }
                }
                this.typeDefinitions.put((String)key, typeDefinitionNode);
            }
        });
        ArrayList typeDefinitionSortingList = new ArrayList();
        this.typeDefinitions.forEach((key, value) -> typeDefinitionSortingList.add(key));
        Collections.sort(typeDefinitionSortingList);
        LinkedHashMap sortedTypeDefinitions = new LinkedHashMap();
        typeDefinitionSortingList.forEach(key -> sortedTypeDefinitions.put(key, this.typeDefinitions.get(key)));
        return new ConstraintResult(this.typeDefinitions, this.isConstraint, this.diagnostics);
    }

    private void updateConstraintWithArrayItems(String key, String fieldName, ArraySchema arraySchema) {
        String normalizedTypeName;
        String itemTypeName;
        Schema itemSchema = arraySchema.getItems();
        if (ConstraintGeneratorImp.hasConstraints(itemSchema) && this.typeDefinitions.containsKey(itemTypeName = key + (normalizedTypeName = StringUtils.capitalize((String)fieldName.replaceAll("([\\[\\]\\\\?!<>@#&~`*\\-=^+'();:\\/\\_{}\\s|.$])", "").trim())) + "Items" + StringUtils.capitalize((String)itemSchema.getType()))) {
            TypeDefinitionNode itemTypeDefNode = this.typeDefinitions.get(itemTypeName);
            if (ConstraintGeneratorImp.hasConstraints(itemSchema)) {
                MetadataNode metadataNode;
                AnnotationNode constraintNode = null;
                try {
                    constraintNode = this.generateConstraintNode(itemTypeName, itemSchema);
                }
                catch (BallerinaOpenApiException ballerinaOpenApiException) {
                    // empty catch block
                }
                boolean isConstraintSupport = constraintNode != null && itemSchema.getNullable() != null && itemSchema.getNullable() != false || itemSchema.getOneOf() != null || itemSchema.getAnyOf() != null;
                boolean nullable = GeneratorMetaData.getInstance().isNullable();
                if (nullable) {
                    constraintNode = null;
                } else if (isConstraintSupport) {
                    ConstraintDiagnosticMessages diagnostic = ConstraintDiagnosticMessages.OAS_CONSTRAINT_101;
                    ConstraintGeneratorDiagnostic constraintDiagnostic = new ConstraintGeneratorDiagnostic(diagnostic, fieldName.trim());
                    this.diagnostics.add(constraintDiagnostic);
                    constraintNode = null;
                }
                if (constraintNode == null) {
                    metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createEmptyNodeList());
                } else {
                    this.isConstraint = true;
                    metadataNode = NodeFactory.createMetadataNode(null, (NodeList)AbstractNodeFactory.createNodeList((Node[])new AnnotationNode[]{constraintNode}));
                }
                itemTypeDefNode = itemTypeDefNode.modify(metadataNode, (Token)itemTypeDefNode.visibilityQualifier().orElse(null), itemTypeDefNode.typeKeyword(), itemTypeDefNode.typeName(), itemTypeDefNode.typeDescriptor(), itemTypeDefNode.semicolonToken());
                this.typeDefinitions.put(itemTypeName, itemTypeDefNode);
            }
        }
    }

    @Override
    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }

    public static boolean hasConstraints(Schema<?> value) {
        if (value == null) {
            return false;
        }
        if (value.getProperties() != null) {
            boolean constraintExists = value.getProperties().values().stream().anyMatch(GeneratorUtils::hasConstraints);
            if (constraintExists) {
                return true;
            }
        } else if (GeneratorUtils.isComposedSchema(value)) {
            List allOf = value.getAllOf();
            List oneOf = value.getOneOf();
            List anyOf = value.getAnyOf();
            boolean constraintExists = false;
            if (allOf != null) {
                constraintExists = allOf.stream().anyMatch(GeneratorUtils::hasConstraints);
            } else if (oneOf != null) {
                constraintExists = oneOf.stream().anyMatch(GeneratorUtils::hasConstraints);
            } else if (anyOf != null) {
                constraintExists = anyOf.stream().anyMatch(GeneratorUtils::hasConstraints);
            }
            if (constraintExists) {
                return true;
            }
        } else if (GeneratorUtils.isArraySchema(value) && !ConstraintGeneratorImp.isConstraintExists(value)) {
            return ConstraintGeneratorImp.isConstraintExists(value.getItems());
        }
        return ConstraintGeneratorImp.isConstraintExists(value);
    }

    private static boolean isConstraintExists(Schema<?> propertyValue) {
        return propertyValue.getMaximum() != null || propertyValue.getMinimum() != null || propertyValue.getMaxLength() != null || propertyValue.getMinLength() != null || propertyValue.getMaxItems() != null || propertyValue.getMinItems() != null || propertyValue.getExclusiveMinimum() != null || propertyValue.getExclusiveMinimumValue() != null || propertyValue.getExclusiveMaximum() != null || propertyValue.getExclusiveMaximumValue() != null || propertyValue.getPattern() != null;
    }

    public AnnotationNode generateConstraintNode(String typeName, Schema<?> fieldSchema) throws BallerinaOpenApiException {
        if (this.isConstraintAllowed(typeName, fieldSchema)) {
            String ballerinaType = GeneratorUtils.convertOpenAPITypeToBallerina(fieldSchema, true);
            if (ballerinaType.equals("string")) {
                return this.generateStringConstraint(fieldSchema);
            }
            if (ballerinaType.equals("decimal") || ballerinaType.equals("float") || ballerinaType.equals("int") || ballerinaType.equals("int:Signed32")) {
                return ConstraintGeneratorImp.generateNumberConstraint(fieldSchema);
            }
            if (GeneratorUtils.isArraySchema(fieldSchema)) {
                return ConstraintGeneratorImp.generateArrayConstraint(fieldSchema);
            }
            return null;
        }
        return null;
    }

    public boolean isConstraintAllowed(String typeName, Schema schema) {
        boolean isConstraintNotAllowed = schema.getNullable() != null && schema.getNullable() != false || schema.getOneOf() != null || schema.getAnyOf() != null || GeneratorUtils.getOpenAPIType(schema) == null;
        boolean nullable = GeneratorMetaData.getInstance().isNullable();
        if (nullable) {
            return false;
        }
        if (isConstraintNotAllowed) {
            ConstraintDiagnosticMessages diagnostic = ConstraintDiagnosticMessages.OAS_CONSTRAINT_101;
            ConstraintGeneratorDiagnostic constraintDiagnostic = new ConstraintGeneratorDiagnostic(diagnostic, typeName);
            this.diagnostics.add(constraintDiagnostic);
            return false;
        }
        return true;
    }

    private static AnnotationNode generateNumberConstraint(Schema<?> fieldSchema) {
        List<String> fields = ConstraintGeneratorImp.getNumberAnnotFields(fieldSchema);
        if (fields.isEmpty()) {
            return null;
        }
        String annotBody = "{" + String.join((CharSequence)",", fields) + "}";
        AnnotationNode annotationNode = GeneratorUtils.isNumberSchema(fieldSchema) ? (fieldSchema.getFormat() != null && fieldSchema.getFormat().equals("float") ? ConstraintGeneratorImp.createAnnotationNode("constraint:Float", annotBody) : ConstraintGeneratorImp.createAnnotationNode("constraint:Number", annotBody)) : ConstraintGeneratorImp.createAnnotationNode("constraint:Int", annotBody);
        return annotationNode;
    }

    private AnnotationNode generateStringConstraint(Schema<?> stringSchema) {
        List<String> fields = this.getStringAnnotFields(stringSchema);
        if (fields.isEmpty()) {
            return null;
        }
        String annotBody = "{" + String.join((CharSequence)",", fields) + "}";
        return ConstraintGeneratorImp.createAnnotationNode("constraint:String", annotBody);
    }

    private static AnnotationNode generateArrayConstraint(Schema arraySchema) {
        List<String> fields = ConstraintGeneratorImp.getArrayAnnotFields(arraySchema);
        if (fields.isEmpty()) {
            return null;
        }
        String annotBody = "{" + String.join((CharSequence)",", fields) + "}";
        return ConstraintGeneratorImp.createAnnotationNode("constraint:Array", annotBody);
    }

    private static List<String> getNumberAnnotFields(Schema<?> numberSchema) {
        String value;
        ArrayList<String> fields = new ArrayList<String>();
        boolean isInt = GeneratorUtils.isIntegerSchema(numberSchema);
        if (numberSchema.getMinimum() != null && numberSchema.getExclusiveMinimum() == null) {
            value = ConstraintGeneratorImp.formatIntegerConstraintValue(numberSchema.getMinimum(), isInt);
            fields.add("minValue:" + value);
        }
        if (numberSchema.getMaximum() != null && numberSchema.getExclusiveMaximum() == null) {
            value = ConstraintGeneratorImp.formatIntegerConstraintValue(numberSchema.getMaximum(), isInt);
            fields.add("maxValue:" + value);
        }
        if (numberSchema.getExclusiveMinimum() != null && numberSchema.getExclusiveMinimum().booleanValue() && numberSchema.getMinimum() != null) {
            value = ConstraintGeneratorImp.formatIntegerConstraintValue(numberSchema.getMinimum(), isInt);
            fields.add("minValueExclusive:" + value);
        }
        if (numberSchema.getMinimum() == null && numberSchema.getExclusiveMinimumValue() != null) {
            value = ConstraintGeneratorImp.formatIntegerConstraintValue(numberSchema.getExclusiveMinimumValue(), isInt);
            fields.add("minValueExclusive:" + value);
        }
        if (numberSchema.getExclusiveMaximum() != null && numberSchema.getExclusiveMaximum().booleanValue() && numberSchema.getMaximum() != null) {
            value = ConstraintGeneratorImp.formatIntegerConstraintValue(numberSchema.getMaximum(), isInt);
            fields.add("maxValueExclusive:" + value);
        }
        if (numberSchema.getMaximum() == null && numberSchema.getExclusiveMaximumValue() != null) {
            value = ConstraintGeneratorImp.formatIntegerConstraintValue(numberSchema.getExclusiveMaximumValue(), isInt);
            fields.add("maxValueExclusive:" + value);
        }
        return fields;
    }

    private static String formatIntegerConstraintValue(Number number, boolean isIntType) {
        double numericValue = number.doubleValue();
        if (isIntType) {
            long truncatedValue = (long)numericValue;
            if (truncatedValue <= Integer.MAX_VALUE && truncatedValue >= Integer.MIN_VALUE) {
                return String.valueOf((int)truncatedValue);
            }
            return String.valueOf(truncatedValue);
        }
        return number.toString();
    }

    private List<String> getStringAnnotFields(Schema stringSchema) {
        Object fieldRef;
        String value;
        ArrayList<String> fields = new ArrayList<String>();
        if (stringSchema.getMaxLength() != null && stringSchema.getMaxLength() != 0) {
            value = stringSchema.getMaxLength().toString();
            fieldRef = "maxLength:" + value;
            fields.add((String)fieldRef);
        }
        if (stringSchema.getMinLength() != null && stringSchema.getMinLength() != 0) {
            value = stringSchema.getMinLength().toString();
            fieldRef = "minLength:" + value;
            fields.add((String)fieldRef);
        }
        if (stringSchema.getPattern() != null) {
            value = stringSchema.getPattern();
            try {
                Pattern.compile(value, 256);
                RegExpFactory.parse((String)value);
                fieldRef = String.format("pattern: re`%s`", value);
                fields.add((String)fieldRef);
            }
            catch (BError err) {
                ConstraintDiagnosticMessages diagnostic = ConstraintDiagnosticMessages.OAS_CONSTRAINT_102;
                ConstraintGeneratorDiagnostic constraintDiagnostic = new ConstraintGeneratorDiagnostic(diagnostic, value);
                this.diagnostics.add(constraintDiagnostic);
            }
            catch (Exception e) {
                ConstraintDiagnosticMessages diagnostic = ConstraintDiagnosticMessages.OAS_CONSTRAINT_103;
                ConstraintGeneratorDiagnostic constraintDiagnostic = new ConstraintGeneratorDiagnostic(diagnostic, value);
                this.diagnostics.add(constraintDiagnostic);
            }
        }
        return fields;
    }

    private static List<String> getArrayAnnotFields(Schema arraySchema) {
        String fieldRef;
        String value;
        ArrayList<String> fields = new ArrayList<String>();
        if (arraySchema.getMaxItems() != null && arraySchema.getMaxItems() != 0) {
            value = arraySchema.getMaxItems().toString();
            fieldRef = "maxLength:" + value;
            fields.add(fieldRef);
        }
        if (arraySchema.getMinItems() != null && arraySchema.getMinItems() != 0) {
            value = arraySchema.getMinItems().toString();
            fieldRef = "minLength:" + value;
            fields.add(fieldRef);
        }
        return fields;
    }

    private static AnnotationNode createAnnotationNode(String annotationReference, String annotFields) {
        MappingConstructorExpressionNode annotationBody = null;
        SimpleNameReferenceNode annotReference = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)annotationReference));
        ExpressionNode expressionNode = NodeParser.parseExpression((String)annotFields);
        if (expressionNode.kind() == SyntaxKind.MAPPING_CONSTRUCTOR) {
            annotationBody = (MappingConstructorExpressionNode)expressionNode;
        }
        return NodeFactory.createAnnotationNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.AT_TOKEN), (Node)annotReference, (MappingConstructorExpressionNode)annotationBody);
    }
}

