/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.document;

import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.openapi.core.generators.common.model.GenSrcFile;
import io.ballerina.openapi.core.generators.document.ClientDocCommentGenerator;
import io.ballerina.openapi.core.generators.document.ServiceDocCommentGenerator;
import io.ballerina.openapi.core.generators.document.TypesDocCommentGenerator;
import io.swagger.v3.oas.models.OpenAPI;

public class DocCommentGeneratorImp {
    private final OpenAPI openAPI;
    private SyntaxTree syntaxTree;
    private final GenSrcFile.GenFileType type;
    private final boolean isProxyService;

    public DocCommentGeneratorImp(OpenAPI openAPI, SyntaxTree syntaxTree, GenSrcFile.GenFileType type, boolean isProxyService) {
        this.openAPI = openAPI;
        this.syntaxTree = syntaxTree;
        this.type = type;
        this.isProxyService = isProxyService;
    }

    public SyntaxTree updateSyntaxTreeWithDocComments() {
        switch (this.type) {
            case GEN_CLIENT: {
                ClientDocCommentGenerator clientDocCommentGenerator = new ClientDocCommentGenerator(this.syntaxTree, this.openAPI, true);
                this.syntaxTree = clientDocCommentGenerator.updateSyntaxTreeWithDocComments();
                break;
            }
            case GEN_SERVICE: {
                ServiceDocCommentGenerator serviceDocCommentGenerator = new ServiceDocCommentGenerator(this.syntaxTree, this.openAPI, this.isProxyService);
                this.syntaxTree = serviceDocCommentGenerator.updateSyntaxTreeWithDocComments();
                break;
            }
            case GEN_SERVICE_TYPE: {
                break;
            }
            case GEN_TYPE: {
                TypesDocCommentGenerator typesDocCommentGenerator = new TypesDocCommentGenerator(this.syntaxTree, this.openAPI);
                this.syntaxTree = typesDocCommentGenerator.updateSyntaxTreeWithDocComments();
                break;
            }
            case TEST_SRC: {
                break;
            }
            case CONFIG_SRC: {
                break;
            }
            case UTIL_SRC: {
                break;
            }
        }
        return this.syntaxTree;
    }
}

