/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.core.generators.service;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ListenerDeclarationNode;
import io.ballerina.compiler.syntax.tree.LiteralValueToken;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.openapi.core.generators.common.GeneratorUtils;
import io.ballerina.openapi.core.generators.service.ListenerGenerator;
import io.ballerina.openapi.core.generators.service.diagnostic.ServiceDiagnostic;
import io.ballerina.openapi.core.generators.service.diagnostic.ServiceDiagnosticMessages;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.swagger.v3.oas.models.servers.Server;
import io.swagger.v3.oas.models.servers.ServerVariables;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class ListenerGeneratorImpl
implements ListenerGenerator {
    private String basePath = "/";
    private List<Diagnostic> diagnostics = new ArrayList<Diagnostic>();

    @Override
    public String getBasePath() {
        return this.basePath;
    }

    @Override
    public ListenerDeclarationNode getListenerDeclarationNodes(List<Server> servers) {
        String host = "localhost";
        int port = 9090;
        Server server = servers.get(0);
        if (!server.getUrl().isBlank() && !"/".equals(server.getUrl())) {
            ServerVariables variables = server.getVariables();
            try {
                String resolvedUrl = GeneratorUtils.buildUrl(server.getUrl(), variables);
                URL url = new URL(resolvedUrl);
                host = url.getHost();
                if (!url.getPath().isBlank()) {
                    this.basePath = url.getPath();
                }
                port = url.getPort();
                boolean isHttps = "https".equalsIgnoreCase(url.getProtocol());
                if (port < 0) {
                    port = isHttps ? 443 : 80;
                }
            }
            catch (MalformedURLException e) {
                this.diagnostics.add(new ServiceDiagnostic(ServiceDiagnosticMessages.OAS_SERVICE_109, server.getUrl()));
            }
        }
        return this.getListenerDeclarationNode(port, host, "ep0");
    }

    private ListenerDeclarationNode getListenerDeclarationNode(Integer port, String host, String ep) {
        IdentifierToken listenerKeyword = AbstractNodeFactory.createIdentifierToken((String)"listener", (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        IdentifierToken modulePrefix = AbstractNodeFactory.createIdentifierToken((String)"http", (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        IdentifierToken identifier = AbstractNodeFactory.createIdentifierToken((String)"Listener", (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList());
        QualifiedNameReferenceNode typeDescriptor = NodeFactory.createQualifiedNameReferenceNode((Token)modulePrefix, (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)identifier);
        IdentifierToken variableName = AbstractNodeFactory.createIdentifierToken((String)ep, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList());
        IdentifierToken newKeyword = AbstractNodeFactory.createIdentifierToken((String)"new");
        LiteralValueToken literalToken = AbstractNodeFactory.createLiteralValueToken((SyntaxKind)SyntaxKind.DECIMAL_INTEGER_LITERAL_TOKEN, (String)String.valueOf(port), (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        BasicLiteralNode expression = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.NUMERIC_LITERAL, (Token)literalToken);
        PositionalArgumentNode portNode = NodeFactory.createPositionalArgumentNode((ExpressionNode)expression);
        IdentifierToken name = AbstractNodeFactory.createIdentifierToken((String)"config");
        SimpleNameReferenceNode argumentName = NodeFactory.createSimpleNameReferenceNode((Token)name);
        IdentifierToken fieldName = AbstractNodeFactory.createIdentifierToken((String)"host");
        IdentifierToken literalHostToken = AbstractNodeFactory.createIdentifierToken((String)("\"" + host + "\""), (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE, (MinutiaeList)GeneratorUtils.SINGLE_WS_MINUTIAE);
        BasicLiteralNode valueExpr = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.STRING_LITERAL, (Token)literalHostToken);
        SpecificFieldNode hostNode = NodeFactory.createSpecificFieldNode(null, (Node)fieldName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)valueExpr);
        SeparatedNodeList fields = NodeFactory.createSeparatedNodeList((Node[])new Node[]{hostNode});
        MappingConstructorExpressionNode hostExpression = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)fields, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        NamedArgumentNode namedArgumentNode = NodeFactory.createNamedArgumentNode((SimpleNameReferenceNode)argumentName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)hostExpression);
        SeparatedNodeList arguments = NodeFactory.createSeparatedNodeList((Node[])new Node[]{portNode, AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN), namedArgumentNode});
        ParenthesizedArgList parenthesizedArgList = NodeFactory.createParenthesizedArgList((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)arguments, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        ImplicitNewExpressionNode initializer = NodeFactory.createImplicitNewExpressionNode((Token)newKeyword, (ParenthesizedArgList)parenthesizedArgList);
        return NodeFactory.createListenerDeclarationNode(null, null, (Token)listenerKeyword, (TypeDescriptorNode)typeDescriptor, (Token)variableName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (Node)initializer, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    public List<Diagnostic> getDiagnostics() {
        return this.diagnostics;
    }
}

